/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.parser;

import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.commandline.SearchPathSourceResolver;
import com.ibm.xltxe.rnm1.xylem.parser.ITypeHandler;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;

public class TypeParserUnitTester {
    public static void main(String[] args) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalAccessException, InstantiationException, IllegalArgumentException, InvocationTargetException {
        String[] typeStrings = new String[]{"{node}", "{| {node} {text} {comment}}", "{unstable node}", "{| {unstable node} {unstable text}}", "{, {unstable node} {unstable text}}", "{& {unstable node} {unstable text}}", "XDMSequence", "XDMItem", "{? {| {unstable element} {unstable attribute} {unstable comment} {unstable text} {unstable document-node} {unstable processing-instruction} {unstable atom xs:anyAtomicType}}}", "{element foo}", "{element myns:foo}", "{element myns:foo @xs:int}", "{attribute foo}", "{attribute myns:foo}", "{attribute myns:foo @xs:int}", "{| {element *} {text}}", "{, {element *} {text}}", "{& {element *} {text}}", "{| {unstable element *} {unstable text}}", "{, {unstable element *} {unstable text}}", "{& {unstable element *} {unstable text}}", "{& {unstable node} {unstable text}}[]"};
        Class<?> typeHandlerClazz = Class.forName("com.ibm.xltxe.rnm1.xtq.xslt.xylem.parser.TypeHandler");
        ITypeHandler typeHandlerInstance = (ITypeHandler)typeHandlerClazz.newInstance();
        ModuleSignature typeStore = new ModuleSignature();
        String typeString = "";
        for (int i = 0; i < typeStrings.length; ++i) {
            StringReader inputReader = new StringReader(typeStrings[i]);
            PushbackReader pbreader = new PushbackReader(inputReader);
            ParserSource parserSource = new ParserSource(pbreader);
            SearchPathSourceResolver sourceResolver = new SearchPathSourceResolver(null);
            Parser parser = new Parser(sourceResolver, parserSource);
            typeHandlerInstance.registerTypes(parser);
            try {
                System.out.println("@" + typeStrings[i]);
                if (i == -1) {
                    System.out.println("Debugger break point");
                }
                Type type2 = parser.parseTypeName(typeStore);
                System.out.println("Type class name: " + type2.getClass().getName());
                typeString = type2.prettyPrint();
                System.out.println("Pretty printed string: " + typeString);
                System.out.print("Reparse: ");
                if (TypeParserUnitTester.reparse(typeHandlerClazz, typeString, type2)) {
                    System.out.println("OK");
                } else {
                    System.out.println("ERROR");
                }
                System.out.flush();
                System.err.flush();
                continue;
            }
            catch (ParserException e) {
                e.printStackTrace();
                break;
            }
        }
        System.out.println("Done!");
    }

    protected static boolean reparse(Class<?> typeHandlerClazz, String typeString, Type origType) throws IllegalAccessException, InstantiationException {
        try {
            StringReader inputReader2 = new StringReader(typeString);
            PushbackReader pbreader2 = new PushbackReader(inputReader2);
            ParserSource parserSource2 = new ParserSource(pbreader2);
            SearchPathSourceResolver sourceResolver2 = new SearchPathSourceResolver(null);
            Parser parser2 = new Parser(sourceResolver2, parserSource2);
            ITypeHandler typeHandlerInstance2 = (ITypeHandler)typeHandlerClazz.newInstance();
            typeHandlerInstance2.registerTypes(parser2);
            ModuleSignature typeStore2 = new ModuleSignature();
            Type type2 = parser2.parseTypeName(typeStore2);
            if (type2 != null) {
                TypeEnvironment tenv = new TypeEnvironment(null);
                if (!type2.equals(origType, tenv)) {
                    System.out.print("(Error: Types not equal!) ");
                }
                return true;
            }
            return false;
        }
        catch (ParserException pe) {
            System.out.print("(Parse Error!) " + pe.getMessage());
            pe.printStackTrace();
            return false;
        }
    }
}

