/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGeneration;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.CompoundType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;

public abstract class AbstractDataType
extends CompoundType {
    public Constructor[] m_constructors;

    public AbstractDataType() {
    }

    protected AbstractDataType(String name2, Constructor[] constructors) {
        super(name2);
        if (constructors != null) {
            this.setConstructors(constructors);
        }
    }

    public String getImplementationName(FcgCodeGenHelper cgh) {
        return cgh.getClassName() + "$" + cgh.getSafeName(this.getName());
    }

    public String toString() {
        return this.getName();
    }

    public String debugToString() {
        String foo = "(" + this.getName();
        for (int i = 0; i < this.m_constructors.length; ++i) {
            Constructor c = this.m_constructors[i];
            foo = foo + " (" + c.m_name + ")";
        }
        return foo + ")";
    }

    public int getChildTypeCount() {
        int c = 0;
        for (int i = 0; i < this.m_constructors.length; ++i) {
            c += this.m_constructors[i].m_parameters.length;
        }
        return c;
    }

    public Type getChildType(int i) {
        for (int j = 0; j < this.m_constructors.length; ++j) {
            Constructor c = this.m_constructors[j];
            for (int k = 0; k < c.m_parameters.length; ++k) {
                if (i == 0) {
                    return c.m_parameters[k].getBindingType();
                }
                --i;
            }
        }
        return null;
    }

    public void setChildType(int i, Type t) {
        for (int j = 0; j < this.m_constructors.length; ++j) {
            Constructor c = this.m_constructors[j];
            for (int k = 0; k < c.m_parameters.length; ++k) {
                if (i == 0) {
                    c.m_parameters[k].setType(t);
                    return;
                }
                --i;
            }
        }
    }

    public void setConstructors(Constructor[] ctors) {
        if (this.m_constructors != null && this.m_constructors.length != 0) {
            throw new Error("Tried to overwrite existing (" + this.m_constructors.length + ") constructors in " + this.getName() + " (don't do that!)");
        }
        this.m_constructors = ctors;
        for (int i = 0; i < this.m_constructors.length; ++i) {
            this.m_constructors[i].m_adt = this;
        }
    }

    public Constructor getConstructor(String name2) {
        for (int i = 0; i < this.m_constructors.length; ++i) {
            if (!this.m_constructors[i].getName().equals(name2)) continue;
            return this.m_constructors[i];
        }
        return null;
    }

    public int getConstructorCount() {
        return this.m_constructors == null ? 0 : this.m_constructors.length;
    }

    public Constructor getConstructor(int index2) {
        return this.m_constructors[index2];
    }

    public abstract FcgVariable generateConstructorTypeDeconstructionCode(FcgCodeGenHelper var1, String var2, FcgInstructionList var3);

    public abstract void generateConstructorDeconstructionCode(FcgCodeGenHelper var1, String var2, CodeGenerationTracker var3, FcgVariable[] var4, Constructor var5, FcgInstructionList var6);

    public abstract CodeGenerationTracker generateConstructorDeconstructionCode(FcgCodeGenHelper var1, String var2, CodeGenerationTracker var3, Binding[] var4, Constructor var5, Instruction var6, Binding var7, FcgInstructionList var8);

    public abstract CodeGenerationTracker generateConstructorDeconstructionCodeForSome(FcgCodeGenHelper var1, FcgInstructionList var2, String var3, CodeGenerationTracker var4, Binding[] var5, Constructor var6, Instruction var7, Binding var8, boolean[] var9);

    public abstract FcgType generateConstructorConstructionCode(FcgCodeGenHelper var1, CodeGenerationTracker var2, Constructor var3, Instruction[] var4, NamedType var5, FcgInstructionList var6);

    public abstract void generateCode(FcgCodeGenHelper var1);

    public abstract void toString(PrettyPrinter var1, int var2);

    public void addComment(String comment2) {
    }

    @Override
    public boolean refersToType(Type t, ITypeStore ts, HashSet visited) {
        for (int j = 0; j < this.m_constructors.length; ++j) {
            Constructor c = this.m_constructors[j];
            for (int k = 0; k < c.m_parameters.length; ++k) {
                if (!c.m_parameters[k].getBindingType().refersToType(t, ts, visited)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Constructor
    implements Serializable {
        private static final long serialVersionUID = -18502971452733861L;
        protected String m_name;
        public Binding[] m_parameters;
        protected AbstractDataType m_adt;
        public String[] m_defaultValues;

        public Constructor(String name2, Binding[] parameters) {
            this.m_name = name2;
            for (Binding binding : parameters) {
                Type t = binding.getBindingType();
                if (t == null) continue;
                binding.setType(t.generalize());
            }
            this.m_parameters = parameters;
        }

        public void write(WriteObjectFileHelper wofh) throws IOException {
            wofh.writeString(this.m_name);
            wofh.writeTypeSpecificBindingSet(this.m_parameters);
            wofh.writeObject(this.m_adt);
            wofh.writeInt(this.m_defaultValues == null ? 0 : this.m_defaultValues.length);
            if (this.m_defaultValues != null) {
                for (int i = 0; i < this.m_defaultValues.length; ++i) {
                    wofh.writeBoolean(this.m_defaultValues[i] != null);
                    if (this.m_defaultValues[i] == null) continue;
                    wofh.writeString(this.m_defaultValues[i]);
                }
            }
        }

        public void read(ReadObjectFileHelper rofh) throws Exception {
            this.m_name = rofh.readString();
            this.m_parameters = rofh.readTypeSpecificBindingSet();
            this.m_adt = (AbstractDataType)rofh.readObject();
            int c = rofh.readInt();
            if (c > 0) {
                this.m_defaultValues = new String[c];
                for (int i = 0; i < this.m_defaultValues.length; ++i) {
                    if (!rofh.readBoolean()) continue;
                    this.m_defaultValues[i] = rofh.readString();
                }
            }
        }

        public String getName() {
            return this.m_name;
        }

        public Object[] getParameterNames() {
            Object[] paramNames = new Object[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                paramNames[i] = this.m_parameters[i].getName();
            }
            return paramNames;
        }

        public Type[] getParameterTypes() {
            Type[] paramTypes = new Type[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                paramTypes[i] = this.m_parameters[i].getBindingType();
            }
            return paramTypes;
        }

        public boolean isForkReleaseManaged(CodeGenerationTracker cgt) {
            boolean iFRM = false;
            for (int i = 0; i < this.m_parameters.length; ++i) {
                iFRM |= this.m_parameters[i].getBindingType().isForkReleaseManaged(cgt);
            }
            return iFRM;
        }

        public AbstractDataType getAbstractDataType() {
            return this.m_adt;
        }

        public int getIndex() {
            for (int i = 0; i < this.m_adt.m_constructors.length; ++i) {
                if (this.m_adt.m_constructors[i] != this) continue;
                return i;
            }
            return -1;
        }

        public int findBinding(Binding b) {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                if (this.m_parameters[i] != b) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            sb.append(this.m_name);
            sb.append("@");
            sb.append(this.m_adt);
            sb.append(" ");
            for (int i = 0; i < this.m_parameters.length; ++i) {
                sb.append(this.m_parameters[i]);
                if (i >= this.m_parameters.length - 1) continue;
                sb.append(" ");
            }
            sb.append(")");
            return sb.toString();
        }

        public void toString(PrettyPrinter pw, int indent) {
            pw.printFormOpen(this.m_name, indent);
            for (int i = 0; i < this.m_parameters.length; ++i) {
                pw.printIdentifier(this.m_parameters[i], indent + 1);
                pw.print("@");
                pw.print(this.m_parameters[i].getBindingType().prettyPrint());
            }
            pw.printFormClose(indent);
        }

        public String prettyPrint() {
            StringBuffer sb = new StringBuffer();
            Type[] parms = this.getParameterTypes();
            sb.append(this.m_adt.getModuleName());
            sb.append('.');
            sb.append(this.m_name);
            sb.append("(");
            for (int i = 0; i < parms.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(parms[i].prettyPrint());
            }
            sb.append(")");
            return sb.toString();
        }

        public String getConstructorQualifiedFieldName(int bindingIndex, CodeGeneration cg) {
            StringBuffer sb = new StringBuffer();
            sb.append("m_");
            sb.append(cg.getSafeName(this.getName()));
            sb.append("_");
            sb.append(Binding.generateVariableName(this.m_parameters[bindingIndex], cg));
            return sb.toString();
        }
    }
}

