/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.ConstructorDataType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractDataTypeLambda
extends AbstractDataType {
    private static final Logger s_logger = LoggerUtil.getLogger(AbstractDataTypeLambda.class);
    private static final String s_className = AbstractDataTypeLambda.class.getName();
    TypeVariable[] m_typeParameters;
    Map instantiatedADTs = new HashMap();

    public AbstractDataTypeLambda(String module, String name2, TypeVariable[] parms, AbstractDataType.Constructor[] ctors) {
        super(name2, ctors);
        this.m_typeParameters = parms;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "AbstractDataTypeLambda", "New generic ADT: " + module + "." + name2);
        }
    }

    public TypeVariable[] getTypeParameters() {
        return this.m_typeParameters;
    }

    @Override
    public NamedType getNamedType() {
        if (this.m_cachedNamedType == null) {
            this.m_cachedNamedType = new NamedType(this.getName(), this.getModuleName(), this.m_typeParameters);
        }
        return this.m_cachedNamedType;
    }

    @Override
    public NamedType instantiateNamedType() {
        Type[] newVars = new TypeVariable[this.m_typeParameters.length];
        for (int i = 0; i < newVars.length; ++i) {
            newVars[i] = new TypeVariable();
        }
        return new NamedType(this.getName(), this.getModuleName(), newVars);
    }

    public Map replaceParms(Type[] args) {
        if (args.length != this.m_typeParameters.length) {
            StringBuilder innerMessage = new StringBuilder("Expected " + this.m_typeParameters.length + " type arguments, " + "got " + args.length + ":");
            for (int i = 0; i < args.length; ++i) {
                innerMessage.append(args[i]);
                innerMessage.append('\n');
            }
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[0]);
            XylemError error2 = new XylemError(message);
            s_logger.logp(Level.SEVERE, s_className, "replaceParms", message, error2);
            throw error2;
        }
        HashMap<TypeVariable, Type> tmap = new HashMap<TypeVariable, Type>();
        for (int i = 0; i < args.length; ++i) {
            if (this.m_typeParameters[i].isFullySpecified() && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "replaceParms", "WARNING: replacing fully specified " + this.getName() + " parameter type " + this.m_typeParameters[i] + " with " + args[i]);
            }
            tmap.put(this.m_typeParameters[i], args[i]);
        }
        return tmap;
    }

    public AbstractDataType applyADT(AbstractTypeStore store, Type[] args) {
        String instantiationName = AbstractDataTypeLambda.generateInstantiationName(this.getName(), args);
        AbstractDataType adt = (AbstractDataType)this.instantiatedADTs.get(instantiationName);
        return adt != null ? adt : this.replaceADT(store, instantiationName, this.m_constructors, args);
    }

    public static String generateInstantiationName(String generic_name, Type[] args) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "generateInstantiationName", "Generating name for " + generic_name);
        }
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < args.length; ++k) {
            sb.append("$");
            sb.append(args[k].prettyPrint());
        }
        String name2 = generic_name + Integer.toString(sb.toString().hashCode()).replace('-', '_');
        return name2;
    }

    AbstractDataType replaceADT(AbstractTypeStore store, String instantiationName, AbstractDataType.Constructor[] generic_constructors, Type[] args) {
        Map tmap = this.replaceParms(args);
        AbstractDataType.Constructor[] ctors = new AbstractDataType.Constructor[generic_constructors.length];
        ConstructorDataType adt = new ConstructorDataType(instantiationName, new AbstractDataType.Constructor[0]);
        this.instantiatedADTs.put(instantiationName, adt);
        for (int i = 0; i < ctors.length; ++i) {
            ctors[i] = this.instantiateConstructor(AbstractDataTypeLambda.generateInstantiationName(generic_constructors[i].getName(), args), generic_constructors[i].m_parameters, tmap, store);
        }
        adt.m_constructors = null;
        adt.setConstructors(ctors);
        store.addAbstractDataType(adt);
        return adt;
    }

    AbstractDataType.Constructor instantiateConstructor(String ctorInstantiationName, Binding[] ctorParms, Map tmap, AbstractTypeStore store) {
        Binding[] bindings = new Binding[ctorParms.length];
        for (int k = 0; k < bindings.length; ++k) {
            Binding gbinding = ctorParms[k];
            Type t = gbinding.getBindingType().replaceType(tmap);
            bindings[k] = new Binding(gbinding.getName(), AbstractDataTypeLambda.instantiateSubtypes(t, store));
        }
        return new AbstractDataType.Constructor(ctorInstantiationName, bindings);
    }

    public static Type instantiateSubtypes(Type t, AbstractTypeStore store) {
        AbstractDataTypeLambda adtl;
        NamedType nt;
        if (t == null) {
            return null;
        }
        int c = t.getChildTypeCount();
        Type original = t;
        for (int i = 0; i < c; ++i) {
            Type oldType = t.getChildType(i);
            Type newType = AbstractDataTypeLambda.instantiateSubtypes(oldType, store);
            if (newType == oldType) continue;
            if (t == original) {
                t = original.duplicateType(new HashMap());
            }
            t.setChildType(i, newType);
        }
        if (t instanceof NamedType && (nt = (NamedType)t).getTypeParameters() != null && (adtl = store.getGenericADT(nt.getName())) != null) {
            return adtl.applyADT(store, nt.getTypeParameters()).getNamedType();
        }
        return t;
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeString(this.getName());
        wofh.writeTypes(this.m_typeParameters);
        int c = this.m_constructors.length;
        wofh.writeInt(c);
        for (int i = 0; i < c; ++i) {
            AbstractDataType.Constructor adtc = this.m_constructors[i];
            wofh.writeString(adtc.getName());
            wofh.writeTypeSpecificBindingSet(adtc.m_parameters);
        }
    }

    public static AbstractDataTypeLambda read_static(String module, ReadObjectFileHelper rofh) throws Exception {
        String name2 = rofh.readString();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "read_static", "Reading " + name2);
        }
        Type[] types2 = rofh.readTypes();
        TypeVariable[] parms = new TypeVariable[types2.length];
        System.arraycopy(types2, 0, parms, 0, types2.length);
        int c = rofh.readInt();
        AbstractDataType.Constructor[] constructors = new AbstractDataType.Constructor[c];
        for (int i = 0; i < c; ++i) {
            String ctorname = rofh.readString();
            Binding[] bindings = rofh.readTypeSpecificBindingSet();
            constructors[i] = new AbstractDataType.Constructor(ctorname, bindings);
        }
        return new AbstractDataTypeLambda(module, name2, parms, constructors);
    }

    public String prettyPrint() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("(\u039b (");
        for (i = 0; i < this.m_typeParameters.length; ++i) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(this.m_typeParameters[i].prettyPrint());
        }
        sb.append(")");
        for (i = 0; i < this.m_constructors.length; ++i) {
            sb.append(" (constructor ");
            sb.append(this.m_constructors[i].prettyPrint());
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public FcgType generateConstructorConstructionCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, AbstractDataType.Constructor constructor, Instruction[] values2, NamedType namedTypeReference, FcgInstructionList il) {
        throw new XylemError("ERR_SYSTEM", "not supported yet");
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        throw new XylemError("ERR_SYSTEM", "not supported yet");
    }

    @Override
    public void read(ReadObjectFileHelper rofh) throws Exception {
        throw new XylemError("ERR_SYSTEM", "not supported");
    }

    @Override
    public void generateCode(FcgCodeGenHelper cgh) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public FcgVariable generateConstructorTypeDeconstructionCode(FcgCodeGenHelper cgh, String x, FcgInstructionList il) {
        throw new XylemError("ERR_SYSTEM", "not supported yet");
    }

    @Override
    public CodeGenerationTracker generateConstructorDeconstructionCode(FcgCodeGenHelper cgh, String x, CodeGenerationTracker cgt, Binding[] m_bindings, AbstractDataType.Constructor m_constructor, Instruction match, Binding binding, FcgInstructionList il) {
        throw new XylemError("ERR_SYSTEM", "not supported yet");
    }

    @Override
    public void generateConstructorDeconstructionCode(FcgCodeGenHelper cgh, String x, CodeGenerationTracker cgt, FcgVariable[] bindings, AbstractDataType.Constructor constructor, FcgInstructionList il) {
        throw new XylemError("ERR_SYSTEM", "not supported yet");
    }

    @Override
    public CodeGenerationTracker generateConstructorDeconstructionCodeForSome(FcgCodeGenHelper cgh, FcgInstructionList il, String x, CodeGenerationTracker cgt, Binding[] bindings, AbstractDataType.Constructor constructor, Instruction toMatch, Binding toSkip, boolean[] whichBindings) {
        throw new XylemError("ERR_SYSTEM", "not supported yet");
    }
}

