/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgOperation;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.SingletonType;
import java.io.ObjectStreamException;
import java.math.BigInteger;

public final class BigIntegerType
extends SingletonType
implements INumericalType {
    private static final long serialVersionUID = 667048260768868471L;
    public static final BigIntegerType s_bigIntegerType = new BigIntegerType();
    private static String[] s_arithmeticMethodNames = new String[]{"add", "subtract", "multiply", "divide", "mod", null, null, null, null, null, "and", "or", "xor"};

    private BigIntegerType() {
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "java.math.BigInteger";
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper cgh) {
        return FcgType.BIG_INTEGER;
    }

    @Override
    public Class getJavaType(IntegerSettings is2) {
        return BigInteger.class;
    }

    @Override
    public Object evaluateOperation(IntegerSettings is2, Object x, Object y, int operation) {
        BigInteger x0 = (BigInteger)x;
        BigInteger y0 = (BigInteger)y;
        switch (operation) {
            case 0: {
                return x0.add(y0);
            }
            case 1: {
                return x0.subtract(y0);
            }
            case 2: {
                return x0.multiply(y0);
            }
            case 3: {
                return x0.divide(y0);
            }
            case 4: {
                return x0.remainder(y0);
            }
            case 10: {
                return x0.and(y0);
            }
            case 11: {
                return x0.or(y0);
            }
            case 12: {
                return x0.xor(y0);
            }
            case 16: {
                return x0.negate();
            }
            case 17: 
            case 18: {
                return x0;
            }
        }
        return IntType.s_intType.evaluateComparisonOperation(x, y, operation);
    }

    @Override
    public void generateLoadLiteralValue(FinalCodeGenerator fcg, Object value2) {
        fcg.loadLiteral(value2 != null ? (BigInteger)value2 : BigInteger.ZERO);
    }

    private Object readResolve() throws ObjectStreamException {
        return s_bigIntegerType;
    }

    @Override
    public String getDefaultValue() {
        return "new BigInteger(\"0\")";
    }

    @Override
    public FcgType generateCodeForOperation(FcgCodeGenHelper cgh, FcgInstructionList il, FcgOperation operation) {
        FcgType t = operation instanceof FcgBinOp ? il.binaryOperationExpr((FcgBinOp)operation) : il.unaryOperationExpr((FcgUnaryOp)operation);
        return t;
    }
}

