/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.IObjectFilePersistence;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.types.CompoundType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ClassType
extends CompoundType {
    public HashMap m_methods = new HashMap();
    protected HashMap m_fields = new HashMap();
    protected ArrayList m_constructorFields = new ArrayList();
    protected Type m_baseClass = null;
    protected ArrayList m_baseClassConstructorParameters = new ArrayList();

    public ClassType() {
    }

    public ClassType(String moduleName, String name2, Method[] methods, Field[] fields) {
        this(name2, methods, fields);
    }

    public ClassType(String name2, Method[] methods, Field[] fields) {
        super(name2);
        int i;
        for (i = 0; i < methods.length; ++i) {
            this.m_methods.put(methods[i].getName(), methods[i]);
        }
        for (i = 0; i < fields.length; ++i) {
            if (this.m_fields.containsKey(fields[i].getName())) {
                throw new IllegalArgumentException("Repeated field definition in class " + name2 + ": " + fields[i].getName());
            }
            this.m_fields.put(fields[i].getName(), fields[i]);
            if (!fields[i].isConstructorArg()) continue;
            this.m_constructorFields.add(fields[i]);
        }
    }

    public void setBaseClass(Type t) {
        this.m_baseClass = t;
    }

    public Type getBaseClass() {
        return this.m_baseClass;
    }

    public void setBaseClassConstructorParameters(List list) {
        this.m_baseClassConstructorParameters.clear();
        this.m_baseClassConstructorParameters.addAll(list);
    }

    public Field resolveField(String name2, TypeEnvironment tenv) {
        ClassType ct = this;
        while (true) {
            Field b;
            if ((b = (Field)ct.m_fields.get(name2)) != null) {
                return b;
            }
            if (ct.m_baseClass == null || !(ct.m_baseClass instanceof NamedType)) break;
            ct = (ClassType)((NamedType)ct.m_baseClass).resolveName(tenv);
        }
        return null;
    }

    public Method resolveMethod(String name2, TypeEnvironment tenv) {
        ClassType ct = this;
        while (true) {
            Method b;
            if ((b = (Method)ct.m_methods.get(name2)) != null) {
                return b;
            }
            if (ct.m_baseClass == null || !(ct.m_baseClass instanceof NamedType)) break;
            ct = (ClassType)((NamedType)ct.m_baseClass).resolveName(tenv);
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return this.getName();
    }

    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen("define-class", indent);
        pw.printToken(this.getName(), indent + 1);
        pw.printFormClose(indent);
    }

    @Override
    public void read(ReadObjectFileHelper rofh) throws Exception {
        Object f2;
        int i;
        this.setName(rofh.readString());
        if (rofh.readBoolean()) {
            this.m_baseClass = rofh.readType();
        }
        int c = rofh.readInt();
        for (i = 0; i < c; ++i) {
            Method m = new Method();
            m.read(rofh);
            this.m_methods.put(m.getName(), m);
        }
        c = rofh.readInt();
        for (i = 0; i < c; ++i) {
            f2 = new Field();
            ((Field)f2).read(rofh);
            this.m_fields.put(((Field)f2).getName(), f2);
            if (!((Field)f2).isConstructorArg()) continue;
            this.m_constructorFields.add(f2);
        }
        c = rofh.readInt();
        for (i = 0; i < c; ++i) {
            f2 = rofh.readString();
            this.m_baseClassConstructorParameters.add(f2);
        }
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeString(this.getName());
        wofh.writeBoolean(this.m_baseClass != null);
        if (this.m_baseClass != null) {
            wofh.writeType(this.m_baseClass);
        }
        wofh.writeInt(this.m_methods.size());
        for (Method m : this.m_methods.values()) {
            m.write(wofh);
        }
        wofh.writeInt(this.m_fields.size());
        for (Object f2 : this.m_constructorFields) {
            ((Field)f2).write(wofh);
        }
        for (Object f2 : this.m_fields.values()) {
            if (((Field)f2).isConstructorArg()) continue;
            ((Field)f2).write(wofh);
        }
        wofh.writeInt(this.m_baseClassConstructorParameters.size());
        for (Object f2 : this.m_baseClassConstructorParameters) {
            wofh.writeString((String)f2);
        }
    }

    @Override
    public boolean isForkReleaseManaged(CodeGenerationTracker cgt) {
        return false;
    }

    public static class Method
    implements IObjectFilePersistence {
        protected String m_name;
        public Binding[] m_parameters;
        protected ClassType m_adt;
        protected String m_function;
        protected Type m_returnType;

        public Method() {
        }

        public Method(String name2, String function2, Binding[] parameters, Type returnType) {
            this.m_name = name2;
            this.m_function = function2;
            this.m_parameters = parameters;
            this.m_returnType = returnType;
        }

        public String getName() {
            return this.m_name;
        }

        public Type getReturnType() {
            return this.m_returnType;
        }

        public String getFunction() {
            return this.m_function;
        }

        public void setFunction(String s) {
            this.m_function = s;
        }

        public ClassType getAbstractDataType() {
            return this.m_adt;
        }

        public void toString(PrettyPrinter pw, int indent) {
            pw.printFormOpen(this.m_name, indent);
            for (int i = 0; i < this.m_parameters.length; ++i) {
                pw.printIdentifier(this.m_parameters[i], indent + 1);
                pw.print("@");
                pw.print(this.m_parameters[i].getBindingType().prettyPrint());
            }
            pw.printFormClose(indent);
        }

        @Override
        public void write(WriteObjectFileHelper wofh) throws IOException {
            wofh.writeString(this.m_name);
            wofh.writeTypeSpecificBindingSet(this.m_parameters);
            wofh.writeType(this.m_returnType);
            wofh.writeString(this.m_function);
        }

        @Override
        public void read(ReadObjectFileHelper rofh) throws Exception {
            this.m_name = rofh.readString();
            this.m_parameters = rofh.readTypeSpecificBindingSet();
            this.m_returnType = rofh.readType();
            this.m_function = rofh.readString();
        }
    }

    public static class Field
    implements IObjectFilePersistence {
        protected String m_name;
        protected Type m_type;
        protected boolean m_mutable;
        protected boolean m_constructorArg;

        public Field() {
        }

        public Field(String name2, Type type2, boolean mutable, boolean constructorArg) {
            if (constructorArg && mutable) {
                throw new IllegalArgumentException("A class field cannot be both mutable and a constructor arg");
            }
            this.m_name = name2;
            this.m_type = type2;
            this.m_mutable = mutable;
            this.m_constructorArg = constructorArg;
        }

        public boolean isConstructorArg() {
            return this.m_constructorArg;
        }

        public void setConstructorArg(boolean constructorArg) {
            this.m_constructorArg = constructorArg;
        }

        public boolean isMutable() {
            return this.m_mutable;
        }

        public void setMutable(boolean mutable) {
            this.m_mutable = mutable;
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name2) {
            this.m_name = name2;
        }

        public Type getType() {
            return this.m_type;
        }

        public void setType(Type type2) {
            this.m_type = type2;
        }

        @Override
        public void write(WriteObjectFileHelper wofh) throws IOException {
            wofh.writeString(this.m_name);
            wofh.writeType(this.m_type);
            wofh.writeBoolean(this.m_mutable);
            wofh.writeBoolean(this.m_constructorArg);
        }

        @Override
        public void read(ReadObjectFileHelper rofh) throws Exception {
            this.m_name = rofh.readString();
            this.m_type = rofh.readType();
            this.m_mutable = rofh.readBoolean();
            this.m_constructorArg = rofh.readBoolean();
        }
    }
}

