/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgOperation;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.SingletonType;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public final class DecimalType
extends SingletonType
implements INumericalType {
    private static final long serialVersionUID = -8135514283342527595L;
    public static final DecimalType s_decimalType = new DecimalType();
    public static final int DECIMAL_PRECISION = 18;

    private DecimalType() {
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "java.math.BigDecimal";
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper cgh) {
        return FcgType.BIG_DECIMAL;
    }

    @Override
    public Class getJavaType(IntegerSettings is2) {
        return BigDecimal.class;
    }

    @Override
    public Object evaluateOperation(IntegerSettings is2, Object x, Object y, int operation) {
        BigDecimal x0 = (BigDecimal)x;
        BigDecimal y0 = (BigDecimal)y;
        switch (operation) {
            case 0: {
                return x0.add(y0);
            }
            case 1: {
                return x0.subtract(y0);
            }
            case 2: {
                return x0.multiply(y0);
            }
            case 3: {
                BigDecimal[] results = x0.divideAndRemainder(y0);
                return results[0].add(results[1].divide(y0, new MathContext(18, RoundingMode.HALF_UP))).stripTrailingZeros();
            }
            case 4: {
                return x0.remainder(y0);
            }
            case 9: {
                return x0.compareTo(y0) == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: 
            case 11: 
            case 12: {
                throw new UnsupportedOperationException("Bitwise operators not supported on BigDecimal");
            }
            case 16: {
                return x0.negate();
            }
            case 17: {
                return x0.setScale(0, 3);
            }
            case 18: {
                return x0.setScale(0, 2);
            }
        }
        return IntType.s_intType.evaluateComparisonOperation(x, y, operation);
    }

    @Override
    public FcgType generateCodeForOperation(FcgCodeGenHelper cgh, FcgInstructionList il, FcgOperation operation) {
        if (operation.equals(FcgBinOp.PLUS)) {
            return il.invokeInstanceMethod(FcgType.BIG_DECIMAL, "add", (FcgType)FcgType.BIG_DECIMAL, 1);
        }
        if (operation.equals(FcgBinOp.SUBTRACT)) {
            return il.invokeInstanceMethod(FcgType.BIG_DECIMAL, "subtract", (FcgType)FcgType.BIG_DECIMAL, 1);
        }
        if (operation.equals(FcgBinOp.MULTIPLY)) {
            return il.invokeInstanceMethod(FcgType.BIG_DECIMAL, "multiply", (FcgType)FcgType.BIG_DECIMAL, 1);
        }
        if (operation.equals(FcgBinOp.DIVIDE)) {
            FcgVariable divisor = il.defineVar(FcgType.BIG_DECIMAL, cgh.generateNewLocalVariableName(), true);
            il.loadVar(divisor);
            FcgClassReferenceType mathContextType = cgh.getClassReferenceType("java.math.MathContext");
            FcgClassReferenceType roundingModeType = cgh.getClassReferenceType("java.math.RoundingMode");
            il.invokeInstanceMethod(FcgType.BIG_DECIMAL, "divideAndRemainder", cgh.getArrayType(FcgType.BIG_DECIMAL), 1);
            FcgVariable results = il.defineVar(cgh.getArrayType(FcgType.BIG_DECIMAL), cgh.generateNewLocalVariableName(), true);
            il.loadVar(results);
            il.loadLiteral(0);
            il.loadArrayElement(FcgType.BIG_DECIMAL);
            il.loadVar(results);
            il.loadLiteral(1);
            il.loadArrayElement(FcgType.BIG_DECIMAL);
            il.loadVar(divisor);
            il.loadLiteral(18);
            il.loadClassField(roundingModeType, "HALF_UP", roundingModeType);
            il.createObjectExpr((FcgType)mathContextType, 2);
            il.invokeInstanceMethod(FcgType.BIG_DECIMAL, "divide", (FcgType)FcgType.BIG_DECIMAL, 2);
            il.invokeInstanceMethod(FcgType.BIG_DECIMAL, "add", (FcgType)FcgType.BIG_DECIMAL, 1);
            return il.invokeInstanceMethod(FcgType.BIG_DECIMAL, "stripTrailingZeros", (FcgType)FcgType.BIG_DECIMAL, 0);
        }
        if (operation.equals(FcgBinOp.MODULO)) {
            return il.invokeInstanceMethod(FcgType.BIG_DECIMAL, "remainder", (FcgType)FcgType.BIG_DECIMAL, 1);
        }
        if (operation.equals(FcgUnaryOp.NEGATIVE)) {
            return il.invokeInstanceMethod(FcgType.BIG_DECIMAL, "negate", (FcgType)FcgType.BIG_DECIMAL, 0);
        }
        if (operation.equals(FcgBinOp.LOGICAL_AND) || operation.equals(FcgBinOp.LOGICAL_OR) || operation.equals(FcgBinOp.LOGICAL_XOR)) {
            throw new UnsupportedOperationException("Bitwise operators not supported on BigDecimal");
        }
        il.invokeInstanceMethod(FcgType.BIG_DECIMAL, "compareTo", (FcgType)FcgType.INT, 1);
        il.loadLiteral(0);
        return il.binaryOperationExpr((FcgBinOp)operation);
    }

    @Override
    public void generateLoadLiteralValue(FinalCodeGenerator fcg, Object value2) {
        fcg.loadLiteral(value2 != null ? (BigDecimal)value2 : new BigDecimal(0));
    }

    private Object readResolve() throws ObjectStreamException {
        return s_decimalType;
    }

    @Override
    public String getDefaultValue() {
        return "new java.math.BigDecimal(0.0)";
    }
}

