/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import java.io.ObjectStreamException;

public final class DoubleType
extends PrimitiveNumericalType {
    private static final long serialVersionUID = -3363106463616654709L;
    public static final DoubleType s_doubleType = new DoubleType();
    private static short[] s_branchOpcode = new short[]{0, 0, 0, 0, 0, 158, 155, 156, 157, 154};

    private DoubleType() {
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper cgh) {
        return FcgType.DOUBLE;
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "double";
    }

    @Override
    public Class getJavaType(IntegerSettings is2) {
        return Double.TYPE;
    }

    @Override
    public Object evaluateOperation(IntegerSettings is2, Object x, Object y, int operation) {
        switch (operation) {
            case 0: {
                return new Double((Double)x + (Double)y);
            }
            case 1: {
                return new Double((Double)x - (Double)y);
            }
            case 2: {
                return new Double((Double)x * (Double)y);
            }
            case 3: {
                return new Double((Double)x / (Double)y);
            }
            case 4: {
                return new Double((Double)x % (Double)y);
            }
            case 5: {
                return (Double)x > (Double)y ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return (Double)x >= (Double)y ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return (Double)x < (Double)y ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return (Double)x <= (Double)y ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return ((Double)x).doubleValue() == ((Double)y).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return new Double(-((Double)x).doubleValue());
            }
            case 17: {
                return Math.floor((Double)x);
            }
            case 18: {
                return Math.ceil((Double)x);
            }
        }
        throw new UnsupportedOperationException("The " + PrimitiveNumericalType.getOperator(operation) + " operator is not supported on double.");
    }

    @Override
    public void generateLoadLiteralValue(FinalCodeGenerator fcg, Object value2) {
        fcg.loadLiteral(value2 != null ? (Double)value2 : 0.0);
    }

    private Object readResolve() throws ObjectStreamException {
        return s_doubleType;
    }

    @Override
    public String getDefaultValue() {
        return "0.0";
    }
}

