/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgOperation;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import java.io.ObjectStreamException;
import java.math.BigInteger;

public final class IntegerType
extends PrimitiveNumericalType {
    private static final long serialVersionUID = 3975236334493524777L;
    public static final IntegerType s_integerType = new IntegerType();

    private IntegerType() {
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper cgh) {
        if (cgh.getSettings().getArbitraryPrecision()) {
            return FcgType.BIG_INTEGER;
        }
        return FcgType.LONG;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "integer";
    }

    @Override
    public Class getJavaType(IntegerSettings is2) {
        if (is2.getArbitraryPrecision()) {
            return BigInteger.class;
        }
        return Long.TYPE;
    }

    @Override
    public Object evaluateOperation(IntegerSettings is2, Object x, Object y, int operation) {
        if (is2.getArbitraryPrecision()) {
            return BigIntegerType.s_bigIntegerType.evaluateOperation(is2, x, y, operation);
        }
        return LongType.s_longType.evaluateOperation(is2, x, y, operation);
    }

    @Override
    public FcgType generateCodeForOperation(FcgCodeGenHelper cgh, FcgInstructionList il, FcgOperation operation) {
        if (cgh.getSettings().getArbitraryPrecision()) {
            return BigIntegerType.s_bigIntegerType.generateCodeForOperation(cgh, il, operation);
        }
        return LongType.s_longType.generateCodeForOperation(cgh, il, operation);
    }

    @Override
    public void generateLoadLiteralValue(FinalCodeGenerator fcg, Object value2) {
        throw new RuntimeException("Not supported.");
    }

    private Object readResolve() throws ObjectStreamException {
        return s_integerType;
    }

    @Override
    public String getDefaultValue() {
        return "0";
    }

    public static Object convertToInteger(IntegerSettings is2, Long l) {
        if (is2.getArbitraryPrecision()) {
            return BigInteger.valueOf(l);
        }
        return l;
    }
}

