/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;

public class JavaArrayType
extends JavaObjectType {
    private static final long serialVersionUID = 1332408608454188820L;
    protected Type m_elementType;
    protected int m_dimensions;

    public JavaArrayType(Type elementType, int dimensions) {
        this.m_elementType = elementType;
        this.m_dimensions = dimensions;
    }

    @Override
    public Type expandTypeAliases(Module m) {
        return new JavaArrayType(this.m_elementType.expandTypeAliases(m), this.m_dimensions);
    }

    public void setElementType(Type t) {
        this.m_elementType = t;
    }

    @Override
    public Class getJavaType(IntegerSettings is2) {
        return Array.newInstance(this.getElementType().getJavaType(is2), new int[this.m_dimensions]).getClass();
    }

    @Override
    public boolean equals(Object arg0) {
        return arg0 != null && arg0 instanceof JavaArrayType && ((JavaArrayType)arg0).m_elementType.equals(this.m_elementType) && ((JavaArrayType)arg0).m_dimensions == this.m_dimensions;
    }

    @Override
    public Type duplicateType(Map typeMap) {
        Type t = (Type)typeMap.get(this);
        if (t != null) {
            return t;
        }
        return new JavaArrayType(this.m_elementType.duplicateType(typeMap), this.m_dimensions);
    }

    @Override
    public Type replaceType(Map typeMap) {
        Type t = (Type)typeMap.get(this);
        if (t != null) {
            return t;
        }
        return new JavaArrayType(this.m_elementType.replaceType(typeMap), this.m_dimensions);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_dimensions; ++i) {
            sb.append("[]");
        }
        return this.m_elementType.toString() + sb;
    }

    public Type getElementType() {
        return this.m_elementType;
    }

    @Override
    public Type resolveType(TypeEnvironment te) {
        Type type2 = this.m_elementType.resolveType(te);
        if (type2 == null) {
            return null;
        }
        return new JavaArrayType(type2, this.m_dimensions);
    }

    @Override
    public Type resolveTypeAsMuchAsPossible(TypeEnvironment tenv, Set knownTypeVars) {
        return new JavaArrayType(this.m_elementType.resolveTypeAsMuchAsPossible(tenv, knownTypeVars), this.m_dimensions);
    }

    @Override
    public boolean isFullySpecified() {
        return this.m_elementType.isFullySpecified();
    }

    @Override
    public String prettyPrint() {
        return "(java-array " + this.m_elementType.prettyPrint() + " " + this.m_dimensions + ")";
    }

    @Override
    public int hashCode() {
        return 100 * this.m_elementType.hashCode();
    }

    @Override
    public int getChildTypeCount() {
        return 1;
    }

    @Override
    public Type getChildType(int i) {
        return i == 0 ? this.m_elementType : null;
    }

    @Override
    public void setChildType(int i, Type t) {
        if (i == 0) {
            this.m_elementType = t;
        }
    }

    @Override
    public String getDefaultValue() {
        return "null";
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper cgh) {
        FcgType elemType = this.m_elementType.getFCGType(cgh);
        FcgType arraytype = cgh.getArrayType(elemType);
        return arraytype;
    }
}

