/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.xylem.IObjectFilePersistence;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class JavaClassInformation {
    protected boolean m_isInterface = false;
    protected HashSet m_baseClassNames = new HashSet();
    protected HashMap m_methods = new HashMap();
    protected HashMap m_fields = new HashMap();
    protected HashMap m_staticMethods = new HashMap();
    protected ArrayList m_constructors = new ArrayList();

    public void setInterface(boolean b) {
        this.m_isInterface = b;
    }

    public boolean isInterface() {
        return this.m_isInterface;
    }

    public Collection getMethods(String name2) {
        return (Collection)this.m_methods.get(name2);
    }

    public Collection getStaticMethods(String name2) {
        return (Collection)this.m_staticMethods.get(name2);
    }

    public Field getField(String name2) {
        return (Field)this.m_fields.get(name2);
    }

    public void read(ReadObjectFileHelper rofh) throws Exception {
        Method m;
        int j;
        int i;
        this.m_isInterface = rofh.readBoolean();
        int c = rofh.readInt();
        for (i = 0; i < c; ++i) {
            this.m_baseClassNames.add(rofh.readString());
        }
        c = rofh.readInt();
        for (i = 0; i < c; ++i) {
            Method m2 = new Method();
            m2.read(rofh);
            this.addConstructor(m2);
        }
        c = rofh.readInt();
        for (i = 0; i < c; ++i) {
            int c2 = rofh.readInt();
            for (j = 0; j < c2; ++j) {
                m = new Method();
                m.read(rofh);
                this.addMethod(m);
            }
        }
        c = rofh.readInt();
        for (i = 0; i < c; ++i) {
            int c2 = rofh.readInt();
            for (j = 0; j < c2; ++j) {
                m = new Method();
                m.read(rofh);
                this.addStaticMethod(m);
            }
        }
        c = rofh.readInt();
        for (i = 0; i < c; ++i) {
            Field f2 = new Field();
            f2.read(rofh);
            this.addField(f2);
        }
    }

    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeBoolean(this.m_isInterface);
        wofh.writeInt(this.m_baseClassNames.size());
        Iterator<Object> i = this.m_baseClassNames.iterator();
        while (i.hasNext()) {
            wofh.writeString((String)i.next());
        }
        wofh.writeInt(this.m_constructors.size());
        for (Method m : this.m_constructors) {
            m.write(wofh);
        }
        wofh.writeInt(this.m_methods.size());
        for (ArrayList al : this.m_methods.values()) {
            wofh.writeInt(al.size());
            for (Method m : al) {
                m.write(wofh);
            }
        }
        wofh.writeInt(this.m_staticMethods.size());
        for (ArrayList al : this.m_staticMethods.values()) {
            wofh.writeInt(al.size());
            for (Method m : al) {
                m.write(wofh);
            }
        }
        wofh.writeInt(this.m_fields.size());
        for (Field f2 : this.m_fields.values()) {
            f2.write(wofh);
        }
    }

    public void addMethod(Method m) {
        ArrayList<Method> list = (ArrayList<Method>)this.m_methods.get(m.getName());
        if (list == null) {
            list = new ArrayList<Method>();
            this.m_methods.put(m.getName(), list);
        }
        list.add(m);
    }

    public void addConstructor(Method m) {
        this.m_constructors.add(m);
    }

    public void addField(Field f2) {
        this.m_fields.put(f2.getName(), f2);
    }

    public void addStaticMethod(Method m) {
        ArrayList<Method> list = (ArrayList<Method>)this.m_staticMethods.get(m.getName());
        if (list == null) {
            list = new ArrayList<Method>();
            this.m_staticMethods.put(m.getName(), list);
        }
        list.add(m);
    }

    public void addBaseClassName(String s) {
        this.m_baseClassNames.add(s);
    }

    public Set getBaseClassNames() {
        return this.m_baseClassNames;
    }

    public static class Field
    implements IObjectFilePersistence {
        protected String m_name;
        protected Type m_returnType;
        protected Object m_constantObject;

        public Field() {
        }

        public Field(String name2, Type returnType, Object constantObject) {
            this.m_name = name2;
            this.m_returnType = returnType;
            this.m_constantObject = constantObject;
        }

        public String getName() {
            return this.m_name;
        }

        public Type getType() {
            return this.m_returnType;
        }

        public boolean isConstant() {
            return null != this.m_constantObject;
        }

        public Object getConstantObject() {
            return this.m_constantObject;
        }

        @Override
        public void write(WriteObjectFileHelper wofh) throws IOException {
            wofh.writeString(this.m_name);
            wofh.writeType(this.m_returnType);
            wofh.writeObject(this.m_constantObject);
        }

        @Override
        public void read(ReadObjectFileHelper rofh) throws Exception {
            this.m_name = rofh.readString();
            this.m_returnType = rofh.readType();
            this.m_constantObject = rofh.readObject();
        }
    }

    public static class Method
    implements IObjectFilePersistence {
        protected String m_name;
        protected Type[] m_parameterTypes;
        protected Type m_returnType;

        public Method() {
        }

        public Method(String name2, Type[] parameterTypes, Type returnType) {
            this.m_name = name2;
            this.m_parameterTypes = parameterTypes;
            this.m_returnType = returnType;
        }

        public String getName() {
            return this.m_name;
        }

        public Type getReturnType() {
            return this.m_returnType;
        }

        public Type[] getParameterTypes() {
            return this.m_parameterTypes;
        }

        @Override
        public void write(WriteObjectFileHelper wofh) throws IOException {
            wofh.writeString(this.m_name);
            wofh.writeTypes(this.m_parameterTypes);
            wofh.writeType(this.m_returnType);
        }

        @Override
        public void read(ReadObjectFileHelper rofh) throws Exception {
            this.m_name = rofh.readString();
            this.m_parameterTypes = rofh.readTypes();
            this.m_returnType = rofh.readType();
        }
    }
}

