/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgCodeGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.JavaClassImporter;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaObjectType
extends Type {
    private static final long serialVersionUID = -5224774453403727058L;
    public static final JavaObjectType s_javaBooleanType = new JavaObjectType(Boolean.class.getName());
    public static final JavaObjectType s_javaIntegerType = new JavaObjectType(Integer.class.getName());
    public static final JavaObjectType s_javaLongType = new JavaObjectType(Long.class.getName());
    public static final JavaObjectType s_javaObjectType = new JavaObjectType(Object.class.getName());
    public static final JavaObjectType s_javaStringType = new JavaObjectType(String.class.getName());
    public static final JavaObjectType s_javaHashMapType = new JavaObjectType(HashMap.class.getName());
    public static final JavaObjectType s_javaHashtableType = new JavaObjectType(Hashtable.class.getName());
    private static final Logger s_logger = LoggerUtil.getLogger(JavaObjectType.class);
    private static final String s_className = JavaObjectType.class.getName();
    protected String m_className;
    private static HashMap<String, Class<?>> s_primitiveMap = new HashMap();

    public JavaObjectType() {
    }

    @Override
    public Type expandTypeAliases(Module m) {
        return this;
    }

    public String getClassName() {
        return this.m_className;
    }

    public JavaObjectType(String className) {
        this.m_className = className;
    }

    public String toString() {
        return this.m_className;
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper cgh) {
        String className = this.getJavaType(cgh.getSettings()).getName();
        className = this.fixupInnerClassName(cgh, className);
        FcgClassReferenceType type2 = cgh.getClassReferenceType(className);
        return type2;
    }

    private String fixupInnerClassName(FcgCodeGen cg, String className) {
        int index2 = className.indexOf(36);
        if (index2 > 0) {
            String outerName = className.substring(0, index2);
            String innerName = this.fixupInnerClassName(cg, className.substring(index2 + 1, className.length()));
            FcgClassReferenceType type2 = cg.getInnerClassReferenceType(outerName, innerName);
            className = type2.getTypeName();
        }
        return className;
    }

    @Override
    public Class<?> getJavaType(IntegerSettings is2) {
        String className = this.getClassName();
        Class clazz = s_primitiveMap.get(className);
        while (clazz == null) {
            try {
                clazz = ObjectFactory.findProviderClass(className, ObjectFactory.findClassLoader(), true);
            }
            catch (ClassNotFoundException ex) {
                int index2 = className.lastIndexOf(46);
                if (index2 != -1) {
                    className = className.substring(0, index2) + "$" + className.substring(index2 + 1, className.length());
                    continue;
                }
                throw new XylemError("ERR_SYSTEM", "Could not find class for " + this.getClassName());
            }
        }
        return clazz;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 instanceof JavaObjectType) {
            return this.m_className.equals(((JavaObjectType)arg0).m_className);
        }
        return this.m_className.equals(arg0.toString());
    }

    public int hashCode() {
        return this.m_className.hashCode();
    }

    protected Object clone() throws CloneNotSupportedException {
        return this;
    }

    public JavaClassInformation getInformation(Module prog) {
        return this.getInformation(prog, false);
    }

    public JavaClassInformation getInformation(Module prog, boolean isUserClass) {
        try {
            return JavaClassImporter.retrieveJavaClassInformation(this.m_className, prog, isUserClass);
        }
        catch (Exception e) {
            FFDCUtil.log(e, this);
            s_logger.logrb(Level.WARNING, s_className, "getInformation", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "ERR_SYSTEM", new Object[]{"class " + this.m_className + " not found on classpath, assuming opaque"});
            return new JavaClassInformation();
        }
    }

    @Override
    public String prettyPrint() {
        return "(java " + this.m_className + ")";
    }

    @Override
    public Type duplicateType(Map typeMap) {
        return this;
    }

    @Override
    public String getDefaultValue() {
        return "null";
    }

    @Override
    public Object evaluateVariableFork(Object value2) {
        return XCIConstruction.evalForkIfNeeded(value2);
    }

    @Override
    public void evaluateVariableRelease(Function boundIn, Instruction boundAt, Object value2) {
        XCIConstruction.evalReleaseIfNeeded(value2);
    }

    @Override
    public boolean semanticallyEquals(Object arg0, boolean approximateSequenceType) {
        return this.equals(arg0);
    }

    static {
        s_primitiveMap.put("boolean", Boolean.TYPE);
        s_primitiveMap.put("byte", Byte.TYPE);
        s_primitiveMap.put("char", Character.TYPE);
        s_primitiveMap.put("short", Short.TYPE);
        s_primitiveMap.put("int", Integer.TYPE);
        s_primitiveMap.put("long", Long.TYPE);
        s_primitiveMap.put("float", Float.TYPE);
        s_primitiveMap.put("double", Double.TYPE);
    }
}

