/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGeneration;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.MixedModeLambdaArgumentFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.MixedModeLambdaResultFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.interpreter.Closure;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public final class LambdaType
extends Type
implements Serializable {
    private static final long serialVersionUID = -2099422424478242869L;
    protected Type[] m_elementTypes;
    protected Type m_returnType;
    protected boolean m_isPureType = true;

    public LambdaType(Type[] elementTypes, Type returnType, boolean isPureType) {
        this.m_elementTypes = elementTypes;
        this.m_returnType = returnType;
        this.m_isPureType = true;
    }

    @Override
    public Type expandTypeAliases(final Module m) {
        return new LambdaType(LambdaType.map(new Type.Mapping(){

            @Override
            public Type apply(Type t) {
                return t.expandTypeAliases(m);
            }
        }, this.m_elementTypes), this.m_returnType.expandTypeAliases(m), this.m_isPureType);
    }

    public Type[] getElementTypes() {
        return this.m_elementTypes;
    }

    public Type getReturnType() {
        return this.m_returnType;
    }

    public boolean isPure() {
        return this.m_isPureType;
    }

    public void setImpure() {
        this.m_isPureType = false;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof LambdaType)) {
            return false;
        }
        LambdaType tt = (LambdaType)arg0;
        tt = (LambdaType)arg0;
        if (tt.m_isPureType != this.m_isPureType) {
            return false;
        }
        return this.equalsExceptPurity(tt);
    }

    public boolean equalsExceptPurity(LambdaType tt) {
        if (tt.m_elementTypes.length != this.m_elementTypes.length) {
            return false;
        }
        for (int i = 0; i < this.m_elementTypes.length; ++i) {
            if (this.m_elementTypes[i].equals(tt.m_elementTypes[i])) continue;
            return false;
        }
        return this.m_returnType.equals(tt.m_returnType);
    }

    @Override
    public Type duplicateType(Map typeMap) {
        Type t = (Type)typeMap.get(this);
        if (t != null) {
            return t;
        }
        Type[] newTypes = new Type[this.m_elementTypes.length];
        for (int i = 0; i < newTypes.length; ++i) {
            newTypes[i] = this.m_elementTypes[i].duplicateType(typeMap);
        }
        return new LambdaType(newTypes, this.m_returnType.duplicateType(typeMap), this.m_isPureType);
    }

    @Override
    public Type replaceType(Map typeMap) {
        Type t = (Type)typeMap.get(this);
        if (t != null) {
            return t;
        }
        Type[] newTypes = new Type[this.m_elementTypes.length];
        for (int i = 0; i < newTypes.length; ++i) {
            newTypes[i] = this.m_elementTypes[i].replaceType(typeMap);
        }
        return new LambdaType(newTypes, this.m_returnType.replaceType(typeMap), this.m_isPureType);
    }

    public String toString() {
        String ans = "";
        for (int i = 0; i < this.m_elementTypes.length; ++i) {
            ans = ans + (i != 0 ? ", " : "") + this.m_elementTypes[i].toString();
        }
        return "(-> (" + ans + ") " + this.m_returnType + ")";
    }

    @Override
    public Type resolveType(TypeEnvironment te) {
        Type[] newTypes = new Type[this.m_elementTypes.length];
        for (int i = 0; i < newTypes.length; ++i) {
            newTypes[i] = this.m_elementTypes[i].resolveType(te);
            if (newTypes[i] != null) continue;
            return null;
        }
        Type returnType = this.m_returnType.resolveType(te);
        if (returnType == null) {
            return null;
        }
        return new LambdaType(newTypes, returnType, this.m_isPureType);
    }

    @Override
    public Type resolveTypeAsMuchAsPossible(TypeEnvironment tenv, Set knownTypeVars) {
        Type[] newTypes = new Type[this.m_elementTypes.length];
        for (int i = 0; i < newTypes.length; ++i) {
            newTypes[i] = this.m_elementTypes[i].resolveTypeAsMuchAsPossible(tenv, knownTypeVars);
        }
        Type returnType = this.m_returnType.resolveTypeAsMuchAsPossible(tenv, knownTypeVars);
        return new LambdaType(newTypes, returnType, this.m_isPureType);
    }

    @Override
    public boolean isFullySpecified() {
        for (int i = 0; i < this.m_elementTypes.length; ++i) {
            if (this.m_elementTypes[i].isFullySpecified()) continue;
            return false;
        }
        return this.m_returnType.isFullySpecified();
    }

    @Override
    public String prettyPrint() {
        StringBuffer sb = new StringBuffer();
        sb.append("(-> (");
        for (int i = 0; i < this.m_elementTypes.length; ++i) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(this.m_elementTypes[i].prettyPrint());
        }
        sb.append(") ");
        sb.append(this.m_returnType.prettyPrint());
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return 10 * this.m_elementTypes.length + this.m_returnType.hashCode();
    }

    @Override
    public int getChildTypeCount() {
        return this.m_elementTypes.length + 1;
    }

    @Override
    public Type getChildType(int i) {
        if (i == 0) {
            return this.m_returnType;
        }
        return this.m_elementTypes[i - 1];
    }

    @Override
    public void setChildType(int i, Type t) {
        if (i == 0) {
            this.m_returnType = t;
        } else {
            this.m_elementTypes[i - 1] = t;
        }
    }

    public void setReturnType(Type t) {
        this.setChildType(0, t);
    }

    public String generateLambdaTypeName(CodeGeneration cg) {
        StringBuffer sb = new StringBuffer("lambda");
        for (int i = 0; i < this.m_elementTypes.length; ++i) {
            sb.append("_");
            sb.append(this.m_elementTypes[i].genTypeStringForUniqueSignature());
        }
        sb.append("_");
        sb.append(this.m_returnType.genTypeStringForUniqueSignature());
        String name2 = ("lambda" + sb.toString().hashCode()).replace('-', '_');
        return name2;
    }

    public String getImplementationName(FcgCodeGenHelper cgh) {
        String name2 = this.generateLambdaTypeName(cgh);
        cgh.requestLambdaTypeGeneration(name2, this);
        return cgh.getClassName() + "$" + name2;
    }

    @Override
    public String getDefaultValue() {
        return "null";
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper cgh) {
        String name2 = this.getFcgName(cgh);
        FcgClassReferenceType t = cgh.getClassReferenceType(name2);
        return t;
    }

    public String getFcgName(FcgCodeGenHelper cgh) {
        String name2 = this.generateLambdaTypeName(null);
        cgh.requestLambdaTypeGeneration(name2, this);
        return cgh.getClassName() + "$" + name2;
    }

    @Override
    public void generateConvertI2C(FcgCodeGenHelper cgh, FcgInstructionList il, CodeGenerationTracker cgt, FcgVariable environment, FcgVariable typeStore) {
        MixedModeLambdaArgumentFunctionGenerationStyle gs = new MixedModeLambdaArgumentFunctionGenerationStyle(cgt.m_function, this);
        cgh.requestFunctionGeneration(gs);
        il.convertExpr(FcgType.OBJECT, cgh.getClassReferenceType(Closure.class.getName()));
        il.loadVar(environment);
        il.loadVar(typeStore);
        il.createObjectExpr((FcgType)gs.getLambdaI2CWrapperClass(cgh), 3);
    }

    @Override
    public void generateConvertC2I(FcgCodeGenHelper cgh, FcgInstructionList il, CodeGenerationTracker cgt, FcgVariable typeStore) {
        MixedModeLambdaResultFunctionGenerationStyle gs = new MixedModeLambdaResultFunctionGenerationStyle(cgt.m_function, this);
        cgh.requestFunctionGeneration(gs);
        il.convertExpr(FcgType.OBJECT, this.getFCGType(cgh));
        il.loadVar(typeStore);
        il.createObjectExpr((FcgType)gs.getLambdaC2IWrapperClass(cgh), 2);
    }

    @Override
    public boolean semanticallyEquals(Object arg0, boolean approximateSequenceType) {
        if (arg0 == null || !(arg0 instanceof LambdaType)) {
            return false;
        }
        LambdaType tt = (LambdaType)arg0;
        tt = (LambdaType)arg0;
        if (tt.m_isPureType != this.m_isPureType) {
            return false;
        }
        return this.equalsExceptPurity(tt);
    }

    public boolean semanticallyEqualsExceptPurity(LambdaType tt, boolean approximateSequenceType) {
        if (tt.m_elementTypes.length != this.m_elementTypes.length) {
            return false;
        }
        for (int i = 0; i < this.m_elementTypes.length; ++i) {
            if (this.m_elementTypes[i].semanticallyEquals(tt.m_elementTypes[i], approximateSequenceType)) continue;
            return false;
        }
        return this.m_returnType.equals(tt.m_returnType);
    }

    @Override
    public Type buildUnion(TypeEnvironment tenv, Type t2, Instruction baseError) throws TypeCheckException {
        if (t2 == null) {
            return this;
        }
        if (!(t2 instanceof LambdaType)) {
            if (t2 instanceof TypeVariable) {
                return super.buildUnion(tenv, t2, baseError);
            }
            throw new TypeCheckException("Typecheck exception, expecting LambdaType but instead found a " + t2.getClass().getSimpleName(), baseError);
        }
        LambdaType tt = (LambdaType)t2;
        if (tt.m_elementTypes.length != this.m_elementTypes.length) {
            throw new TypeCheckException("Typecheck exception, expecting LambdaType of length " + this.m_elementTypes.length + " but found tuple type of length " + tt.m_elementTypes.length, baseError);
        }
        Type[] newElemTypes = new Type[this.m_elementTypes.length];
        for (int i = 0; i < this.m_elementTypes.length; ++i) {
            Type xt1 = this.m_elementTypes[i];
            Type xt2 = tt.m_elementTypes[i];
            newElemTypes[i] = xt1.buildUnion(tenv, xt2, baseError);
        }
        LambdaType resultType = new LambdaType(newElemTypes, this.m_returnType, this.m_isPureType);
        return resultType;
    }

    @Override
    public Type factor() {
        Type xt1;
        int i;
        Type[] newElemTypes = null;
        int foundFactoredAt = -1;
        for (i = 0; i < this.m_elementTypes.length; ++i) {
            xt1 = this.m_elementTypes[i];
            Type t = xt1.factor();
            if (t != xt1 && newElemTypes == null) {
                newElemTypes = new Type[this.m_elementTypes.length];
                foundFactoredAt = i;
            }
            if (newElemTypes == null) continue;
            newElemTypes[i] = t;
        }
        if (foundFactoredAt > 0) {
            for (i = 0; i < foundFactoredAt; ++i) {
                newElemTypes[i] = xt1 = this.m_elementTypes[i];
            }
        }
        if (newElemTypes != null) {
            LambdaType resultType = new LambdaType(newElemTypes, this.m_returnType, this.m_isPureType);
            return resultType;
        }
        return this;
    }

    @Override
    public Type generalize() {
        Type xt1;
        int i;
        Type[] newElemTypes = null;
        int foundChangedAt = -1;
        for (i = 0; i < this.m_elementTypes.length; ++i) {
            xt1 = this.m_elementTypes[i];
            Type t = xt1.generalize();
            if (t != xt1 && newElemTypes == null) {
                newElemTypes = new Type[this.m_elementTypes.length];
                foundChangedAt = i;
            }
            if (newElemTypes == null) continue;
            newElemTypes[i] = t;
        }
        if (foundChangedAt > 0) {
            for (i = 0; i < foundChangedAt; ++i) {
                newElemTypes[i] = xt1 = this.m_elementTypes[i];
            }
        }
        if (newElemTypes != null) {
            LambdaType resultType = new LambdaType(newElemTypes, this.m_returnType, this.m_isPureType);
            return resultType;
        }
        return this;
    }
}

