/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgOperation;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import com.ibm.xltxe.rnm1.xylem.utils.OverflowException;
import java.io.ObjectStreamException;
import java.math.BigInteger;

public final class LongType
extends PrimitiveNumericalType {
    private static final long serialVersionUID = -2404025752571691365L;
    public static final LongType s_longType = new LongType();

    private LongType() {
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper cgh) {
        return FcgType.LONG;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "long";
    }

    @Override
    public Class getJavaType(IntegerSettings is2) {
        return Long.TYPE;
    }

    @Override
    public Object evaluateOperation(IntegerSettings is2, Object x, Object y, int operation) {
        Long result2;
        Long a = (Long)x;
        Long b = (Long)y;
        switch (operation) {
            case 0: {
                result2 = new Long(a + b);
                break;
            }
            case 1: {
                result2 = new Long(a - b);
                break;
            }
            case 2: {
                result2 = new Long(a * b);
                break;
            }
            case 3: {
                result2 = new Long(a / b);
                break;
            }
            case 4: {
                result2 = new Long(a % b);
                break;
            }
            case 10: {
                result2 = new Long(a & b);
                break;
            }
            case 11: {
                result2 = new Long(a | b);
                break;
            }
            case 12: {
                result2 = new Long(a ^ b);
                break;
            }
            case 16: {
                result2 = new Long(-a.longValue());
                break;
            }
            case 17: 
            case 18: {
                return a;
            }
            default: {
                return super.evaluateComparisonOperation(x, y, operation);
            }
        }
        if (is2.getOverflowDetection()) {
            switch (operation) {
                case 0: 
                case 1: {
                    int sigNum = Long.signum(a);
                    if (sigNum != Long.signum(operation == 1 ? -b.longValue() : b) || sigNum == Long.signum(result2)) break;
                    throw new OverflowException();
                }
                case 2: {
                    int leadingZeros = Long.numberOfLeadingZeros(Math.abs(a)) + Long.numberOfLeadingZeros(Math.abs(b));
                    if (leadingZeros >= 63 && (leadingZeros != 63 && leadingZeros != 64 || BigInteger.valueOf(a).multiply(BigInteger.valueOf(b)).equals(BigInteger.valueOf(result2)))) break;
                    throw new OverflowException();
                }
                case 3: {
                    if (a != Long.MIN_VALUE || b != -1L) break;
                    throw new OverflowException();
                }
                case 16: {
                    if (a != Long.MIN_VALUE) break;
                    throw new OverflowException();
                }
            }
        }
        return result2;
    }

    @Override
    public void generateLoadLiteralValue(FinalCodeGenerator fcg, Object value2) {
        fcg.loadLiteral(value2 != null ? (Long)value2 : 0L);
    }

    @Override
    public FcgType generateCodeForOperation(FcgCodeGenHelper cgh, FcgInstructionList il, FcgOperation operation) {
        boolean checkResult = cgh.getSettings().getOverflowDetection() && (operation == FcgBinOp.PLUS || operation == FcgBinOp.SUBTRACT || operation == FcgBinOp.MULTIPLY || operation == FcgBinOp.DIVIDE || operation == FcgUnaryOp.NEGATIVE);
        boolean binaryOp = operation instanceof FcgBinOp;
        FcgVariable a = null;
        FcgVariable b = null;
        if (checkResult) {
            if (binaryOp) {
                b = il.defineVar(FcgType.LONG, cgh.generateNewLocalVariableName(), true);
            }
            a = il.defineVar(FcgType.LONG, cgh.generateNewLocalVariableName(), true);
            il.loadVar(a);
            if (binaryOp) {
                il.loadVar(b);
            }
        }
        FcgType resultType = super.generateCodeForOperation(cgh, il, operation);
        if (checkResult) {
            FcgVariable result2 = il.defineVar(FcgType.LONG, cgh.generateNewLocalVariableName(), true);
            if (operation == FcgBinOp.PLUS || operation == FcgBinOp.SUBTRACT) {
                il.loadVar(a);
                il.invokeClassMethod(FcgType.LONG_OBJECT, "signum", (FcgType)FcgType.INT, new FcgType[]{FcgType.LONG});
                FcgVariable sigNum = il.defineVar(FcgType.INT, cgh.generateNewLocalVariableName(), true);
                il.loadVar(sigNum);
                il.loadVar(b);
                if (operation == FcgBinOp.SUBTRACT) {
                    il.unaryOperationExpr(FcgUnaryOp.NEGATIVE);
                }
                il.invokeClassMethod(FcgType.LONG_OBJECT, "signum", (FcgType)FcgType.INT, new FcgType[]{FcgType.LONG});
                il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                il.beginIf();
                il.loadVar(sigNum);
                il.loadVar(result2);
                il.invokeClassMethod(FcgType.LONG_OBJECT, "signum", (FcgType)FcgType.INT, new FcgType[]{FcgType.LONG});
                il.binaryOperationExpr(FcgBinOp.COMPARE_NE);
                il.beginIf();
                il.createObjectExpr((FcgType)FcgType.OVERFLOW_EXCEPTION, 0);
                il.throwObject();
                il.endIf();
                il.endIf();
            } else if (operation == FcgBinOp.MULTIPLY) {
                FcgClassReferenceType mathClass = cgh.getClassReferenceType(Math.class.getName());
                il.loadVar(a);
                il.invokeClassMethod(mathClass, "abs", (FcgType)FcgType.LONG, new FcgType[]{FcgType.LONG});
                il.invokeClassMethod(FcgType.LONG_OBJECT, "numberOfLeadingZeros", (FcgType)FcgType.INT, new FcgType[]{FcgType.LONG});
                il.loadVar(b);
                il.invokeClassMethod(mathClass, "abs", (FcgType)FcgType.LONG, new FcgType[]{FcgType.LONG});
                il.invokeClassMethod(FcgType.LONG_OBJECT, "numberOfLeadingZeros", (FcgType)FcgType.INT, new FcgType[]{FcgType.LONG});
                il.binaryOperationExpr(FcgBinOp.PLUS);
                FcgVariable leadingZeros = il.defineVar(FcgType.INT, cgh.generateNewLocalVariableName(), true);
                il.loadVar(leadingZeros);
                il.loadLiteral(63);
                il.binaryOperationExpr(FcgBinOp.COMPARE_LT);
                il.loadVar(leadingZeros);
                il.loadLiteral(63);
                il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                il.loadVar(leadingZeros);
                il.loadLiteral(64);
                il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                il.binaryOperationExpr(FcgBinOp.LOGICAL_OR);
                il.loadVar(a);
                il.invokeClassMethod(FcgType.BIG_INTEGER, "valueOf", (FcgType)FcgType.BIG_INTEGER, new FcgType[]{FcgType.LONG});
                il.loadVar(b);
                il.invokeClassMethod(FcgType.BIG_INTEGER, "valueOf", (FcgType)FcgType.BIG_INTEGER, new FcgType[]{FcgType.LONG});
                il.invokeInstanceMethod(FcgType.BIG_INTEGER, "multiply", (FcgType)FcgType.BIG_INTEGER, new FcgType[]{FcgType.BIG_INTEGER});
                il.loadVar(result2);
                il.invokeClassMethod(FcgType.BIG_INTEGER, "valueOf", (FcgType)FcgType.BIG_INTEGER, new FcgType[]{FcgType.LONG});
                il.binaryOperationExpr(FcgBinOp.COMPARE_NE);
                il.binaryOperationExpr(FcgBinOp.LOGICAL_AND);
                il.binaryOperationExpr(FcgBinOp.LOGICAL_OR);
                il.beginIf();
                il.createObjectExpr((FcgType)FcgType.OVERFLOW_EXCEPTION, 0);
                il.throwObject();
                il.endIf();
            } else if (operation == FcgBinOp.DIVIDE) {
                il.loadVar(a);
                il.loadLiteral(Long.MIN_VALUE);
                il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                il.loadVar(b);
                il.loadLiteral(-1);
                il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                il.binaryOperationExpr(FcgBinOp.LOGICAL_AND);
                il.beginIf();
                il.createObjectExpr((FcgType)FcgType.OVERFLOW_EXCEPTION, 0);
                il.throwObject();
                il.endIf();
            } else if (operation == FcgUnaryOp.NEGATIVE) {
                il.loadVar(a);
                il.loadLiteral(Long.MIN_VALUE);
                il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                il.beginIf();
                il.createObjectExpr((FcgType)FcgType.OVERFLOW_EXCEPTION, 0);
                il.throwObject();
                il.endIf();
            }
            return il.loadVar(result2);
        }
        return resultType;
    }

    private Object readResolve() throws ObjectStreamException {
        return s_longType;
    }

    @Override
    public String getDefaultValue() {
        return "0";
    }
}

