/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.MixedModeADOArgumentFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.MixedModeADOResultFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.interpreter.AbstractDataObject;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.Tuple;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.CompoundType;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xltxe.rnm1.xylem.types.TypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xml.xci.Cursor;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class NamedType
extends Type
implements Serializable {
    private static final long serialVersionUID = -2341260046084219919L;
    protected Type[] m_typeParameters;
    protected String m_name;
    protected String m_module;

    public NamedType(String name2) {
        this(name2, null, null);
    }

    public NamedType(String name2, String module, Type[] typeParameters) {
        this.m_typeParameters = typeParameters;
        this.m_name = name2;
        this.m_module = module;
    }

    public Type[] getTypeParameters() {
        return this.m_typeParameters;
    }

    public void setTypeParameters(Type[] params) {
        this.m_typeParameters = params;
    }

    public String getName() {
        return this.m_name;
    }

    public String getModule() {
        return this.m_module;
    }

    public CompoundType resolveName(TypeEnvironment tenv) {
        return tenv.getModule().lookupCompoundType(this.m_name);
    }

    public AbstractDataType resolveNameToADT(Module m) {
        CompoundType ct = m.lookupCompoundType(this.m_name);
        if (ct == null) {
            return null;
        }
        if (ct instanceof AbstractDataType) {
            return (AbstractDataType)ct;
        }
        return null;
    }

    public AbstractDataType resolveNameToADT(TypeEnvironment tenv) {
        return this.resolveNameToADT(tenv.getModule());
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof NamedType)) {
            return false;
        }
        NamedType tt = (NamedType)arg0;
        if (!tt.m_name.equals(this.m_name)) {
            return false;
        }
        int c = this.getChildTypeCount();
        if (tt.getChildTypeCount() != c) {
            return false;
        }
        for (int i = 0; i < c; ++i) {
            if (this.m_typeParameters[i].equals(tt.m_typeParameters[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type duplicateType(Map typeMap) {
        Type t = (Type)typeMap.get(this);
        if (t != null) {
            return t;
        }
        if (this.getChildTypeCount() > 0) {
            Type[] newTypes = new Type[this.m_typeParameters.length];
            for (int i = 0; i < newTypes.length; ++i) {
                newTypes[i] = this.m_typeParameters[i].duplicateType(typeMap);
            }
            return new NamedType(this.m_name, this.m_module, newTypes);
        }
        return new NamedType(this.m_name, this.m_module, null);
    }

    @Override
    public Type replaceType(Map typeMap) {
        Type t = (Type)typeMap.get(this);
        if (t != null) {
            return t;
        }
        if (this.getChildTypeCount() > 0) {
            Type[] newTypes = new Type[this.m_typeParameters.length];
            for (int i = 0; i < newTypes.length; ++i) {
                newTypes[i] = this.m_typeParameters[i].replaceType(typeMap);
            }
            return new NamedType(this.m_name, this.m_module, newTypes);
        }
        return new NamedType(this.m_name, this.m_module, null);
    }

    public String toString() {
        return this.m_name;
    }

    @Override
    public Type resolveType(TypeEnvironment te) {
        if (this.m_typeParameters == null) {
            return this;
        }
        Type[] newTypes = new Type[this.m_typeParameters.length];
        for (int i = 0; i < newTypes.length; ++i) {
            newTypes[i] = this.m_typeParameters[i].resolveType(te);
            if (newTypes[i] != null) continue;
            return null;
        }
        return new NamedType(this.m_name, this.m_module, newTypes);
    }

    @Override
    public Type expandTypeAliases(Module m) {
        TypeLambda tl = m.lookupTypeLambda(this.m_module, this.m_name);
        if (tl == null) {
            return this;
        }
        if (this.m_typeParameters == null) {
            return tl.apply(new Type[0]);
        }
        Type[] newTypes = new Type[this.m_typeParameters.length];
        for (int i = 0; i < newTypes.length; ++i) {
            newTypes[i] = this.m_typeParameters[i].expandTypeAliases(m);
        }
        return tl.apply(newTypes);
    }

    @Override
    public Type resolveTypeAsMuchAsPossible(TypeEnvironment tenv, Set knownTypeVars) {
        if (this.m_typeParameters == null) {
            return this;
        }
        Type[] newTypes = new Type[this.m_typeParameters.length];
        for (int i = 0; i < newTypes.length; ++i) {
            newTypes[i] = this.m_typeParameters[i].resolveTypeAsMuchAsPossible(tenv, knownTypeVars);
        }
        return new NamedType(this.m_name, this.m_module, newTypes);
    }

    @Override
    public boolean isFullySpecified() {
        if (this.m_typeParameters == null) {
            return true;
        }
        for (int i = 0; i < this.m_typeParameters.length; ++i) {
            if (this.m_typeParameters[i].isFullySpecified()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String prettyPrint() {
        if (this.getChildTypeCount() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            if (this.m_module != null && this.m_module.length() > 0) {
                sb.append(this.m_module + ".");
            }
            sb.append(this.m_name);
            for (int i = 0; i < this.m_typeParameters.length; ++i) {
                sb.append(' ');
                sb.append(this.m_typeParameters[i].prettyPrint());
            }
            sb.append(")");
            return sb.toString();
        }
        return this.m_name;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    @Override
    public int getChildTypeCount() {
        return this.m_typeParameters == null ? 0 : this.m_typeParameters.length;
    }

    @Override
    public Type getChildType(int i) {
        return this.m_typeParameters[i];
    }

    @Override
    public void setChildType(int i, Type t) {
        this.m_typeParameters[i] = t;
    }

    @Override
    public void unify(TypeEnvironment tenv, Type t2, Instruction errorBase) throws TypeCheckException {
        String name2 = ((NamedType)t2).m_name;
        if (!name2.equals(this.m_name)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Type " + name2 + " not compatible with " + this.m_name), errorBase);
        }
        super.unify(tenv, t2, errorBase);
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper cgh) {
        String name2 = cgh.getClassName() + "$" + cgh.getSafeName(this.toString());
        FcgClassReferenceType type2 = cgh.getClassReferenceType(name2);
        return type2;
    }

    @Override
    public void appendHolderVariableAssignment(FcgCodeGenHelper cgh, String varName, boolean objectless, Binding toSkip, CodeGenerationTracker cgt, FcgInstructionList il) {
        CompoundType ct = this.resolveName(cgt.m_typeEnvironment);
        ct.appendHolderVariableAssignment(cgh, varName, objectless, toSkip, cgt, il);
    }

    @Override
    public void appendHolderVariableDeclaration(FcgCodeGenHelper cgh, String varName, boolean objectless, Binding toSkip, CodeGenerationTracker cgt, FcgInstructionList il) {
        CompoundType ct = this.resolveName(cgt.m_typeEnvironment);
        ct.appendHolderVariableDeclaration(cgh, varName, objectless, toSkip, cgt, il);
    }

    @Override
    public void appendHolderVariableLoad(FcgCodeGenHelper cgh, String varName, boolean objectless, Binding toSkip, CodeGenerationTracker cgt, FcgInstructionList il) {
        CompoundType ct = this.resolveName(cgt.m_typeEnvironment);
        ct.appendHolderVariableLoad(cgh, varName, objectless, toSkip, cgt, il);
    }

    @Override
    public boolean refersToType(Type t, ITypeStore ts, HashSet visited) {
        if (visited.contains(t)) {
            return false;
        }
        visited.add(t);
        if (this.equals(t)) {
            return true;
        }
        CompoundType ct = ts.lookupCompoundType(this.m_name);
        return ct.refersToType(t, ts, visited);
    }

    @Override
    public String getDefaultValue() {
        return "null";
    }

    @Override
    public Object evaluateVariableFork(Object value2) {
        if (value2 instanceof IForkReleaseManaged) {
            return ((IForkReleaseManaged)value2).evaluateInstanceFork();
        }
        assert (!(value2 instanceof Cursor));
        return value2;
    }

    @Override
    public void evaluateVariableRelease(Function boundIn, Instruction boundAt, Object value2) {
        if (value2 instanceof IForkReleaseManaged) {
            ((IForkReleaseManaged)value2).release();
        } else if (value2 instanceof Cursor) {
            ((Cursor)value2).release();
        }
    }

    @Override
    public void generateObjectFork(FcgCodeGenHelper cgh, FcgInstructionList il, CodeGenerationTracker cgt, ValueGenStyle valueStyleRequest) {
        CompoundType ct = this.resolveName(cgt.m_typeEnvironment);
        ct.generateObjectFork(cgh, il, cgt);
    }

    @Override
    public void generateObjectRelease(FcgCodeGenHelper cgh, FcgInstructionList il, CodeGenerationTracker cgt) {
        CompoundType ct = this.resolveName(cgt.m_typeEnvironment);
        ct.generateObjectRelease(cgh, il, cgt);
    }

    @Override
    public boolean isForkReleaseManaged(CodeGenerationTracker cgt) {
        CompoundType ct = this.resolveName(cgt.m_typeEnvironment);
        return ct.isForkReleaseManaged(cgt);
    }

    @Override
    public void generateConvertI2C(FcgCodeGenHelper cgh, FcgInstructionList il, CodeGenerationTracker cgt, FcgVariable environment, FcgVariable typeStore) {
        boolean isTuple = this.getName().startsWith("tuple_");
        FcgClassReferenceType inputType = isTuple ? cgh.getClassReferenceType(Tuple.class.getName()) : cgh.getClassReferenceType(AbstractDataObject.class.getName());
        il.convertExpr(FcgType.OBJECT, inputType);
        AbstractDataType adt = cgt.getCurrentModule().getAbstractDataType(this.getName());
        MixedModeADOArgumentFunctionGenerationStyle gs = new MixedModeADOArgumentFunctionGenerationStyle(cgt.m_function, adt, isTuple);
        cgh.requestFunctionGeneration(gs);
        String convertMethod = gs.getConvertI2CMethodName(cgh);
        FcgClassReferenceType className = cgh.getClassReferenceType(adt.getImplementationName(cgh));
        FcgClassReferenceType clazz = cgh.getClassReferenceType(cgh.getClassName());
        il.loadVar(environment);
        il.loadVar(typeStore);
        il.invokeClassMethod(clazz, convertMethod, (FcgType)className, new FcgType[]{inputType, cgh.getClassReferenceType(Environment.class.getName()), cgh.getInterfaceType(ITypeStore.class.getName())});
    }

    @Override
    public void generateConvertC2I(FcgCodeGenHelper cgh, FcgInstructionList il, CodeGenerationTracker cgt, FcgVariable typeStore) {
        boolean isTuple = this.getName().startsWith("tuple_");
        AbstractDataType adt = cgt.getCurrentModule().getAbstractDataType(this.getName());
        MixedModeADOResultFunctionGenerationStyle gs = new MixedModeADOResultFunctionGenerationStyle(cgt.m_function, adt, isTuple);
        cgh.requestFunctionGeneration(gs);
        String convertMethod = gs.getConvertC2IMethodName(cgh);
        FcgClassReferenceType resultType = gs.getLazyADOClass(cgh);
        FcgClassReferenceType className = cgh.getClassReferenceType(adt.getImplementationName(cgh));
        il.convertExpr(FcgType.OBJECT, className);
        il.loadVar(typeStore);
        FcgClassReferenceType clazz = cgh.getClassReferenceType(cgh.getClassName());
        il.invokeClassMethod(clazz, convertMethod, (FcgType)resultType, new FcgType[]{className, cgh.getInterfaceType(ITypeStore.class.getName())});
    }

    @Override
    public boolean semanticallyEquals(Object arg0, boolean approximateSequenceType) {
        if (arg0 == null || !(arg0 instanceof NamedType)) {
            return this.equals(arg0);
        }
        NamedType tt = (NamedType)arg0;
        if (!tt.m_name.equals(this.m_name)) {
            return false;
        }
        int c = this.getChildTypeCount();
        if (tt.getChildTypeCount() != c) {
            return false;
        }
        for (int i = 0; i < c; ++i) {
            Type t1 = this.m_typeParameters[i];
            Type t2 = tt.m_typeParameters[i];
            if (t1 == t2) continue;
            if (!t1.isFullySpecified() || !t2.isFullySpecified()) {
                return false;
            }
            if (t1.semanticallyEquals(t2, approximateSequenceType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type buildUnion(TypeEnvironment tenv, Type t2, Instruction baseError) throws TypeCheckException {
        if (t2 == null || t2 == this) {
            return this;
        }
        if (!(t2 instanceof NamedType)) {
            if (t2 instanceof TypeVariable) {
                return super.buildUnion(tenv, t2, baseError);
            }
            throw new TypeCheckException("Typecheck exception, expecting NamedType but instead found a " + t2.getClass().getSimpleName(), baseError);
        }
        NamedType tt = (NamedType)t2;
        if (tt.m_typeParameters == null || this.m_typeParameters == null) {
            return this;
        }
        if (tt.m_typeParameters.length != this.m_typeParameters.length) {
            throw new TypeCheckException("Typecheck exception, expecting NamedType of length " + this.m_typeParameters.length + " but found tuple type of length " + tt.m_typeParameters.length, baseError);
        }
        Type[] newElemTypes = new Type[this.m_typeParameters.length];
        for (int i = 0; i < this.m_typeParameters.length; ++i) {
            Type xt1 = this.m_typeParameters[i];
            Type xt2 = tt.m_typeParameters[i];
            newElemTypes[i] = xt1.buildUnion(tenv, xt2, baseError);
        }
        NamedType resultType = new NamedType(this.m_name, this.m_module, newElemTypes);
        return resultType;
    }

    @Override
    public Type factor() {
        if (this.m_typeParameters != null) {
            Type xt1;
            int i;
            Type[] newElemTypes = null;
            int foundFactoredAt = -1;
            for (i = 0; i < this.m_typeParameters.length; ++i) {
                xt1 = this.m_typeParameters[i];
                Type t = xt1.factor();
                if (t != xt1 && newElemTypes == null) {
                    newElemTypes = new Type[this.m_typeParameters.length];
                    foundFactoredAt = i;
                }
                if (newElemTypes == null) continue;
                newElemTypes[i] = t;
            }
            if (foundFactoredAt > 0) {
                for (i = 0; i < foundFactoredAt; ++i) {
                    newElemTypes[i] = xt1 = this.m_typeParameters[i];
                }
            }
            if (newElemTypes != null) {
                NamedType resultType = new NamedType(this.m_name, this.m_module, newElemTypes);
                return resultType;
            }
        }
        return this;
    }

    @Override
    public Type generalize() {
        if (this.m_typeParameters != null) {
            Type xt1;
            int i;
            Type[] newElemTypes = null;
            int foundChangedAt = -1;
            for (i = 0; i < this.m_typeParameters.length; ++i) {
                xt1 = this.m_typeParameters[i];
                Type t = xt1.generalize();
                if (t != xt1 && newElemTypes == null) {
                    newElemTypes = new Type[this.m_typeParameters.length];
                    foundChangedAt = i;
                }
                if (newElemTypes == null) continue;
                newElemTypes[i] = t;
            }
            if (foundChangedAt > 0) {
                for (i = 0; i < foundChangedAt; ++i) {
                    newElemTypes[i] = xt1 = this.m_typeParameters[i];
                }
            }
            if (newElemTypes != null) {
                NamedType resultType = new NamedType(this.m_name, this.m_module, newElemTypes);
                return resultType;
            }
        }
        return this;
    }
}

