/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgOperation;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IPrimitiveType;
import com.ibm.xltxe.rnm1.xylem.types.SingletonType;

public abstract class PrimitiveNumericalType
extends SingletonType
implements IPrimitiveType,
INumericalType {
    private static final long serialVersionUID = -3024613341486006823L;
    private static final String[] s_operators = new String[]{"+", "-", "*", "/", "%", ">", ">=", "<", "<=", "==", "&", "|", "^", "<<", ">>", ">>>"};
    private static final String[] s_operatorString = new String[]{"+", "-", "*", "/", "%", "greater", "greater equal", "less", "less equal", "==", "&", "|", "^", "left shift", "right shift", "right shift unsigned"};
    private static final boolean[] s_isComparisonOperator = new boolean[]{false, false, false, false, false, true, true, true, true, true, false, false, false, false, false, false};

    public static int getOperatorSize() {
        return s_operators.length;
    }

    public static String getOperator(int i) {
        int len = PrimitiveNumericalType.getOperatorSize();
        if (i >= len || i < 0) {
            return null;
        }
        return s_operators[i];
    }

    public static String getOperatorString(int i) {
        int len = PrimitiveNumericalType.getOperatorSize();
        if (i >= len || i < 0) {
            return null;
        }
        return s_operators[i];
    }

    public static boolean isComparisonOperator(int i) {
        int len = s_isComparisonOperator.length;
        if (i >= len || i < 0) {
            return false;
        }
        return s_isComparisonOperator[i];
    }

    public final Object evaluateComparisonOperation(Object x, Object y, int operation) {
        return PrimitiveNumericalType.evaluateComparisonOperationHelper(x, y, operation);
    }

    public static final Object evaluateComparisonOperationHelper(Object x, Object y, int operation) {
        Comparable x0 = (Comparable)x;
        switch (operation) {
            case 5: {
                return x0.compareTo(y) > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return x0.compareTo(y) < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return x0.compareTo(y) >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return x0.compareTo(y) <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return x0.equals(y) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public FcgType generateCodeForOperation(FcgCodeGenHelper cgh, FcgInstructionList il, FcgOperation operation) {
        FcgType t = operation instanceof FcgBinOp ? il.binaryOperationExpr((FcgBinOp)operation) : il.unaryOperationExpr((FcgUnaryOp)operation);
        return t;
    }
}

