/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgField;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgInterfaceType;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.FcgXmlType;
import com.ibm.xltxe.rnm1.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.MixedModeStreamResultFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizedFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.ListStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.StringStream;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.ICollectionType;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xltxe.rnm1.xylem.types.IPrimitiveType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.xci.Cursor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class StreamType
extends Type
implements ICollectionType,
IConstructableAsStreamType,
Serializable {
    private static final long serialVersionUID = 7675041141206643421L;
    public static final boolean s_inlineResize = false;
    public static final boolean s_enableBCELBuffering = true;
    protected Type m_elementType;
    private static int s_reallocs = 0;

    public StreamType(Type elementType) {
        if (elementType instanceof StreamType) {
            throw new XylemError("ERR_SYSTEM", "can't create a stream type of a stream type");
        }
        this.m_elementType = elementType;
    }

    @Override
    public Type expandTypeAliases(Module m) {
        return this.m_elementType.expandTypeAliases(m).getStreamType();
    }

    public static StreamType makeStreamType(Type t) {
        if (t instanceof StreamType) {
            return (StreamType)t;
        }
        return t.getStreamType();
    }

    public static Type makeAtomicType(Type t) {
        if (t instanceof StreamType) {
            return ((StreamType)t).getElementType();
        }
        return t;
    }

    public boolean equals(Object arg0) {
        return arg0 != null && arg0 instanceof StreamType && ((StreamType)arg0).m_elementType.equals(this.m_elementType);
    }

    @Override
    public Type duplicateType(Map typeMap) {
        Type t = (Type)typeMap.get(this);
        if (t != null) {
            return t;
        }
        return this.m_elementType.duplicateType(typeMap).getStreamType();
    }

    @Override
    public Type replaceType(Map typeMap) {
        Type t = (Type)typeMap.get(this);
        if (t != null) {
            return t;
        }
        return this.m_elementType.replaceType(typeMap).getStreamType();
    }

    public String toString() {
        return this.m_elementType.toString() + "[]";
    }

    @Override
    public Class getJavaType(IntegerSettings is2) {
        return Array.newInstance(this.getElementType().getJavaType(is2), new int[1]).getClass();
    }

    @Override
    public Object createStream(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass().isArray()) {
            ListStream listStream = new ListStream();
            int length2 = Array.getLength(obj);
            for (int i = 0; i < length2; ++i) {
                Object element2 = Array.get(obj, i);
                Object tempstream = this.m_elementType.createStream(element2);
                listStream.append(tempstream, this.m_elementType);
                XCIConstruction.evalReleaseIfNeeded(tempstream);
            }
            return listStream;
        }
        if (obj instanceof String) {
            return new StringStream((String)obj);
        }
        if ((obj = this.m_elementType.createStream(obj)) instanceof IStream) {
            return obj;
        }
        return new ListStream(obj);
    }

    @Override
    public Type getElementType() {
        return this.m_elementType;
    }

    @Override
    public Type resolveType(TypeEnvironment te) {
        Type type2 = this.m_elementType.resolveType(te);
        if (type2 == null) {
            return null;
        }
        return type2.getStreamType();
    }

    @Override
    public FcgVariable generateLoopStart(FcgCodeGenHelper cgh, FcgInstructionList il, Instruction collection2, FcgType memberType, CodeGenerationTracker cgt) {
        il.comment("StreamType loop start");
        String collectionName = cgh.generateNewLocalVariableName();
        FcgType collectionType = cgt.generateConventionally(collection2, cgh, false, il, ValueGenStyle.DEFAULT);
        FcgVariable collectionVar = il.defineConstVar(collectionType, collectionName);
        il.loadLiteral(0);
        FcgVariable index2 = il.defineVar(FcgType.INT, collectionName + "_loopIndex", true);
        FcgVariable currentMember = il.defineVar(memberType, collectionName + "_currentMember", false);
        il.loadVar(index2);
        il.loadVar(collectionVar);
        il.unaryOperationExpr(FcgUnaryOp.LENGTH);
        il.binaryOperationExpr(FcgBinOp.COMPARE_LT);
        il.preIncrementAndLoadLocalVariable(index2);
        il.beginConditionalLoop(collectionName + "_loop", 2);
        il.loadVar(collectionVar);
        il.loadVar(index2);
        il.loadArrayElement(memberType);
        il.storeVar(currentMember);
        return currentMember;
    }

    @Override
    public void generateLoopEnd(FcgCodeGenHelper cgh, FcgInstructionList il, FcgVariable memberVar, CodeGenerationTracker cgt) {
        il.comment("StreamType loop end");
        il.endConditionalLoop();
    }

    private String generateBufferCache(FcgCodeGenHelper cgh, FcgInstructionList il) {
        FcgType streamFcgType = this.getFCGType(cgh);
        String key2 = streamFcgType.getTypeName() + "_buffer_cache";
        String cacheVar = (String)cgh.generationMemosGet(key2);
        if (cacheVar == null) {
            cacheVar = cgh.generateNewMemberVariableName("_buffer_cache");
            FcgClassGen classGen = cgh.getConstructorClassGen();
            FcgField v = classGen.newInstanceField(FcgAttrs.NONE, cgh.getArrayType(streamFcgType), cacheVar);
            FcgField v_next = classGen.newInstanceField(FcgAttrs.NONE, FcgType.INT, cacheVar + "_next");
            FcgField v_created = classGen.newInstanceField(FcgAttrs.NONE, FcgType.INT, cacheVar + "_created");
            FcgInstructionList constructorIL = cgh.getConstructorILB();
            cgh.startConstructorSegmentGeneration();
            constructorIL.loadThis();
            constructorIL.loadLiteral(10);
            constructorIL.createArrayExpr(streamFcgType, false);
            constructorIL.storeInstanceFieldStmt(classGen.getClassType(), v.getName(), v.getType());
            constructorIL.loadThis();
            constructorIL.loadLiteral(0);
            constructorIL.storeInstanceFieldStmt(classGen.getClassType(), v_next.getName(), v_next.getType());
            constructorIL.loadThis();
            constructorIL.loadLiteral(0);
            constructorIL.storeInstanceFieldStmt(classGen.getClassType(), v_created.getName(), v_next.getType());
            cgh.finishConstructorSegmentGeneration();
            cgh.generationMemosPut(key2, cacheVar);
        }
        return cacheVar;
    }

    public void generateCreateStream(String varName, int initialSize, FcgCodeGenHelper cgh, FcgInstructionList il) {
        FcgType streamFcgType = this.getFCGType(cgh);
        FcgType elementFcgType = this.getElementType().getFCGType(cgh);
        String cacheVar = this.generateBufferCache(cgh, il);
        FcgVariable stream2 = il.defineVar(streamFcgType, varName + "_stream", false);
        il.loadNull();
        FcgVariable original = il.defineVar(streamFcgType, varName + "_original", true);
        FcgType cacheType = cgh.getArrayType(streamFcgType);
        FcgClassReferenceType classType = cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar + "_next", FcgType.INT);
        cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar, cacheType);
        il.unaryOperationExpr(FcgUnaryOp.LENGTH);
        il.binaryOperationExpr(FcgBinOp.COMPARE_LT);
        il.beginIf();
        cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar + "_next", FcgType.INT);
        cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar + "_created", FcgType.INT);
        il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
        il.beginIf();
        if (cgh.getSettings().isBufferDiagnostics()) {
            // empty if block
        }
        cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar, cacheType);
        cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar + "_created", FcgType.INT);
        il.loadLiteral(1024);
        il.createArrayExpr(elementFcgType, false);
        il.storeArrayElemStmt();
        cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar + "_created", FcgType.INT);
        cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar + "_created", FcgType.INT);
        il.loadLiteral(1);
        il.binaryOperationExpr(FcgBinOp.PLUS);
        il.storeAtStmt();
        il.endIf();
        cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar, cacheType);
        cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar + "_next", FcgType.INT);
        il.loadArrayElement(streamFcgType);
        il.storeAndReloadVarExpr(stream2);
        il.storeVar(original);
        cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar + "_next", FcgType.INT);
        cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar + "_next", FcgType.INT);
        il.loadLiteral(1);
        il.binaryOperationExpr(FcgBinOp.PLUS);
        il.storeAtStmt();
        il.beginElse();
        if (cgh.getSettings().isBufferDiagnostics()) {
            // empty if block
        }
        il.loadLiteral(initialSize);
        il.createArrayExpr(elementFcgType, false);
        il.storeVar(stream2);
        il.endIf();
        il.loadLiteral(0);
        il.defineVar(FcgType.INT, varName + "_size", true);
    }

    @Override
    public void generateStreamParameterList(String varName, FcgCodeGenHelper cgh, ArrayList paramNames, ArrayList paramTypes, CodeGenerationTracker cgt) {
        paramTypes.add(this.getFCGType(cgh));
        paramNames.add(varName + "_stream");
        paramTypes.add(FcgType.INT);
        paramNames.add(varName + "_size");
    }

    @Override
    public void generateStreamFunctionSuffix(FcgCodeGenHelper cgh, FcgInstructionList il, String varName) {
        cgh.allocateThreadLocalVariable("stream_size", FcgType.INT);
        FcgClassReferenceType classType = cgh.loadThisVar(il);
        il.loadVar(il.findVar(varName + "_size"));
        il.storeInstanceFieldStmt(classType, cgh.generateThreadLocalVarReference("stream_size"), FcgType.INT);
    }

    @Override
    public void generateStreamFunctionCallSuffix(FcgCodeGenHelper cgh, FcgInstructionList il, String varName) {
        cgh.allocateThreadLocalVariable("stream_size", FcgType.INT);
        il.loadInstanceField(cgh.loadThisVar(il), cgh.generateThreadLocalVarReference("stream_size"), FcgType.INT);
        il.storeVar(il.findVar(varName + "_size"));
    }

    public static String generateStreamCallList(String varName) {
        StringBuffer sb = new StringBuffer();
        sb.append(varName);
        sb.append("_stream, ");
        sb.append(varName);
        sb.append("_size");
        return sb.toString();
    }

    public String generateGetStreamPart(String varName) {
        return varName + "_stream";
    }

    public void generateGrowStream(FcgCodeGenHelper cgh, FcgInstructionList il, String varName) {
        FcgVariable varName_size = il.findVar(varName + "_size");
        FcgVariable varName_stream = il.findVar(varName + "_stream");
        il.loadVar(varName_size);
        il.loadLiteral(2);
        il.binaryOperationExpr(FcgBinOp.MULTIPLY);
        il.binaryOperationExpr(FcgBinOp.PLUS);
        il.createArrayExpr(this.getElementType().getFCGType(cgh), false);
        FcgVariable stream2 = il.defineVar(this.getFCGType(cgh), varName + "_stream2", true);
        il.loadVar(varName_stream);
        il.loadLiteral(0);
        il.loadVar(stream2);
        il.loadLiteral(0);
        il.loadVar(varName_size);
        il.streamElemCopyStmt();
        il.loadVar(stream2);
        il.storeVar(varName_stream);
    }

    public void ensureCapacity(FcgCodeGenHelper cgh, FcgInstructionList il, String varName, FcgVariable requestedCapacity) {
        il.beginScopeBlock();
        il.comment(" StreamType.ensureCapacity(): ensure capacity of stream " + varName);
        il.loadVar(requestedCapacity);
        il.loadVar(il.findVar(varName + "_stream"));
        il.unaryOperationExpr(FcgUnaryOp.LENGTH);
        il.binaryOperationExpr(FcgBinOp.COMPARE_GT);
        il.beginIf();
        il.loadVar(requestedCapacity);
        il.loadLiteral(2);
        il.binaryOperationExpr(FcgBinOp.MULTIPLY);
        il.createArrayExpr(this.getElementType().getFCGType(cgh), false);
        FcgVariable stream2 = il.defineVar(this.getFCGType(cgh), varName + "_stream2", true);
        il.loadVar(il.findVar(varName + "_stream"));
        il.loadLiteral(0);
        il.loadVar(stream2);
        il.loadLiteral(0);
        il.loadVar(il.findVar(varName + "_size"));
        il.streamElemCopyStmt();
        il.loadVar(stream2);
        il.storeVar(il.findVar(varName + "_stream"));
        il.endIf();
        il.comment(" StreamType.ensureCapacity(): capacity of stream " + varName + " now ensured");
        il.endScopeBlock();
    }

    public void generateGrowStreamBy1(FcgCodeGenHelper cgh, FcgInstructionList il, String varName) {
        FcgVariable varName_stream = il.findVar(varName + "_stream");
        FcgVariable varName_size = il.findVar(varName + "_size");
        il.loadVar(varName_stream);
        il.unaryOperationExpr(FcgUnaryOp.LENGTH);
        il.loadVar(varName_size);
        il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
        il.beginIf();
        il.loadLiteral(1);
        this.generateGrowStream(cgh, il, varName);
        il.endIf();
    }

    @Override
    public void generateAddElementToStream(FcgCodeGenHelper cgh, FcgInstructionList il, String varName, Type elementTypeFIL, FcgType element2, CodeGenerationTracker cgt) {
        Type et = this.getElementType();
        if (et instanceof CharType && (element2 == FcgXmlType.CHARS || element2 == FcgXmlType.VOLATILE_CDATA)) {
            FcgVariable varName_stream = il.findVar(varName + "_stream");
            FcgVariable varName_size = il.findVar(varName + "_size");
            String varNameOfChars = cgh.generateNewLocalVariableName();
            FcgVariable varOfChars = il.defineVar(element2, varNameOfChars, true);
            il.loadVar(varOfChars);
            il.invokeInterfaceMethod((FcgInterfaceType)FcgType.CHARSEQUENCE, "length", (FcgType)FcgType.INT, 0);
            String varNameOfCharsLength = cgh.generateNewLocalVariableName();
            FcgVariable varOfCharsLength = il.defineVar(FcgType.INT, varNameOfCharsLength, true);
            il.loadVar(varOfCharsLength);
            il.loadVar(varName_size);
            il.binaryOperationExpr(FcgBinOp.PLUS);
            String varNameOfNewEnd = cgh.generateNewLocalVariableName();
            FcgVariable varOfNewEnd = il.defineVar(FcgType.INT, varNameOfNewEnd, true);
            il.loadVar(varOfNewEnd);
            il.loadVar(varName_stream);
            il.unaryOperationExpr(FcgUnaryOp.LENGTH);
            il.binaryOperationExpr(FcgBinOp.COMPARE_GTE);
            il.beginIf();
            il.loadVar(varOfCharsLength);
            this.generateGrowStream(cgh, il, varName);
            il.endIf();
            il.loadVar(varOfChars);
            il.loadVar(varName_stream);
            il.loadVar(varName_size);
            FcgType[] args = new FcgType[]{FcgType.CHAR_ARRAY, FcgType.INT};
            il.invokeInterfaceMethodStmt((FcgInterfaceType)element2, "toCharArray", (FcgType)FcgType.INT, args);
            il.loadVar(varOfNewEnd);
            il.storeVar(varName_size);
            return;
        }
        this.generateGrowStreamBy1(cgh, il, varName);
        if (et.isForkReleaseManaged(cgt)) {
            et.generateObjectFork(cgh, il, cgt, ValueGenStyle.DEFAULT_NO_PUSH);
        }
        String tempVar = cgh.generateNewLocalVariableName();
        FcgVariable temp = il.defineVar(element2, tempVar, true);
        FcgVariable varName_stream = il.findVar(varName + "_stream");
        FcgVariable varName_size = il.findVar(varName + "_size");
        il.loadVar(varName_stream);
        il.loadVar(varName_size);
        il.loadVar(temp);
        il.storeArrayElemStmt();
        il.incrementVarStmt(varName_size);
    }

    @Override
    public FcgType generateAddMultipleElementsToStream(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il, String varName, Type itemType, FcgType fcgTypeElement) {
        return this.generateAddMultipleElementsToStream(cgh, cgt, il, varName, itemType, fcgTypeElement, true);
    }

    @Override
    public FcgType generateAddMultipleElementsToStream(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il, String varName, Type itemType, FcgType fcgTypeElement, boolean entireStream) {
        FcgVariable lengthVar;
        String tempVar = cgh.generateNewLocalVariableName();
        if (entireStream) {
            FcgVariable multiStream = il.defineVar(this.getFCGType(cgh), tempVar + "_multiStream", true);
            il.loadVar(multiStream);
            il.unaryOperationExpr(FcgUnaryOp.LENGTH);
            lengthVar = il.defineVar(FcgType.INT, tempVar + "_multiStreamLength", true);
            il.loadVar(multiStream);
            il.loadLiteral(0);
        } else {
            lengthVar = il.defineVar(FcgType.INT, tempVar + "_multiStreamLength", true);
        }
        il.loadVar(il.findVar(varName + "_stream"));
        il.unaryOperationExpr(FcgUnaryOp.LENGTH);
        il.loadVar(il.findVar(varName + "_size"));
        il.loadVar(lengthVar);
        il.binaryOperationExpr(FcgBinOp.PLUS);
        il.binaryOperationExpr(FcgBinOp.COMPARE_LTE);
        il.beginIf();
        il.loadVar(lengthVar);
        this.generateGrowStream(cgh, il, varName);
        il.endIf();
        if (!this.getElementType().isForkReleaseManaged(cgt)) {
            FcgVariable varName_stream = il.findVar(varName + "_stream");
            il.loadVar(varName_stream);
            FcgVariable varName_size = il.findVar(varName + "_size");
            il.loadVar(varName_size);
            il.loadVar(lengthVar);
            il.streamElemCopyStmt();
            il.loadVar(varName_size);
            il.loadVar(lengthVar);
            il.binaryOperationExpr(FcgBinOp.PLUS);
            il.storeVar(varName_size);
        } else {
            il.comment("Due to fork requirement, can't use streamElemCopyStmt");
            FcgVariable sourceName_pos = il.defineVar(FcgType.INT, tempVar + "_sourcePos", true);
            FcgVariable sourceName_stream = il.defineVar(this.getFCGType(cgh), tempVar + "_source", true);
            FcgType elemType = this.getElementType().getFCGType(cgh);
            FcgVariable varName_stream = il.findVar(varName + "_stream");
            FcgVariable varName_size = il.findVar(varName + "_size");
            il.loadVar(lengthVar);
            il.loadLiteral(0);
            il.binaryOperationExpr(FcgBinOp.COMPARE_NE);
            il.beginConditionalLoop(tempVar + "_loop", 1);
            il.loadVar(varName_stream);
            il.loadVar(varName_size);
            il.loadVar(sourceName_stream);
            il.loadVar(sourceName_pos);
            il.loadArrayElement(elemType);
            this.getElementType().generateObjectFork(cgh, il, cgt, ValueGenStyle.DEFAULT_NO_PUSH);
            il.storeArrayElemStmt();
            il.incrementVarStmt(varName_size);
            il.incrementVarStmt(sourceName_pos);
            il.loadVar(lengthVar);
            il.loadLiteral(1);
            il.binaryOperationExpr(FcgBinOp.SUBTRACT);
            il.storeVar(lengthVar);
            il.endConditionalLoop();
        }
        return FcgType.VOID;
    }

    @Override
    public void generateCompactStream(String varName, FcgCodeGenHelper cgh, FcgInstructionList il) {
        FcgVariable varName_stream = il.findVar(varName + "_stream");
        FcgVariable varName_size = il.findVar(varName + "_size");
        FcgVariable varName_original = il.findVar(varName + "_original");
        il.loadVar(varName_stream);
        il.unaryOperationExpr(FcgUnaryOp.LENGTH);
        il.loadVar(varName_size);
        il.binaryOperationExpr(FcgBinOp.COMPARE_NE);
        il.loadVar(varName_original);
        il.loadVar(varName_stream);
        il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
        il.binaryOperationExpr(FcgBinOp.LOGICAL_OR);
        il.beginIf();
        FcgVariable varNameVar = il.findVar(varName);
        il.loadVar(varName_size);
        il.createArrayExpr(this.getElementType().getFCGType(cgh), false);
        il.storeVar(varNameVar);
        il.loadVar(varName_stream);
        il.loadLiteral(0);
        il.loadVar(varNameVar);
        il.loadLiteral(0);
        il.loadVar(varName_size);
        il.streamElemCopyStmt();
        il.beginElse();
        il.loadVar(varName_stream);
        il.storeVar(varNameVar);
        il.endIf();
        this.generateReleaseLastBuffer(varName, cgh, il);
    }

    private void generateReleaseLastBuffer(String varName, FcgCodeGenHelper cgh, FcgInstructionList il) {
        String cacheVar = this.generateBufferCache(cgh, il);
        FcgVariable varName_original = il.findVar(varName + "_original");
        il.loadVar(varName_original);
        il.loadNull();
        il.binaryOperationExpr(FcgBinOp.COMPARE_NE);
        il.beginIf();
        FcgClassReferenceType classType = cgh.loadThisVar(il);
        cgh.loadThisVar(il);
        il.loadInstanceField(classType, cacheVar + "_next", FcgType.INT);
        il.loadLiteral(1);
        il.binaryOperationExpr(FcgBinOp.SUBTRACT);
        il.storeInstanceFieldStmt(classType, cacheVar + "_next", FcgType.INT);
        il.endIf();
    }

    @Override
    public boolean isFullySpecified() {
        return this.m_elementType.isFullySpecified();
    }

    @Override
    public String prettyPrint() {
        return this.m_elementType.prettyPrint() + "[]";
    }

    public int hashCode() {
        return 10 * this.m_elementType.hashCode();
    }

    @Override
    public int getChildTypeCount() {
        return 1;
    }

    @Override
    public Type getChildType(int i) {
        return i == 0 ? this.m_elementType : null;
    }

    @Override
    public void setChildType(int i, Type t) {
        if (i == 0) {
            this.m_elementType = t;
        }
    }

    @Override
    public StreamType getStreamType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type resolveTypeAsMuchAsPossible(TypeEnvironment tenv, Set knownTypeVars) {
        return this.m_elementType.resolveTypeAsMuchAsPossible(tenv, knownTypeVars).getStreamType();
    }

    @Override
    public String getDefaultValue() {
        return "null";
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper cgh) {
        FcgType elemType = this.m_elementType.getFCGType(cgh);
        FcgType arrayType = cgh.getArrayType(elemType);
        return arrayType;
    }

    @Override
    public Object evaluateVariableFork(Object value2) {
        if (value2 instanceof IForkReleaseManaged) {
            return ((IForkReleaseManaged)value2).evaluateInstanceFork();
        }
        assert (!(value2 instanceof Cursor)) : "A Stream type should not be forking a cursor!";
        return value2;
    }

    @Override
    public void evaluateVariableRelease(Function boundIn, Instruction boundAt, Object value2) {
        if (value2 instanceof IForkReleaseManaged) {
            ((IForkReleaseManaged)value2).release();
        } else if (value2 instanceof Cursor) {
            ((Cursor)value2).release();
        } else if (value2 == null || !(value2 instanceof StringStream)) {
            // empty if block
        }
    }

    @Override
    public void generateObjectFork(FcgCodeGenHelper cgh, FcgInstructionList il, CodeGenerationTracker cgt, ValueGenStyle valueStyleRequest) {
        Type elementType = this.getElementType();
        if (!elementType.isForkReleaseManaged(cgt)) {
            super.generateObjectFork(cgh, il, cgt, valueStyleRequest);
            return;
        }
        il.comment("Start stream fork");
        String streamName = cgh.generateNewLocalVariableName("streamForkSource");
        FcgVariable streamNameVar = il.defineVar(this.getFCGType(cgh), streamName, true);
        il.loadVar(streamNameVar);
        il.loadNull();
        il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
        il.beginIf();
        il.beginElse();
        FcgType arraytype = il.loadVar(streamNameVar);
        il.unaryOperationExpr(FcgUnaryOp.LENGTH);
        String sizeName = cgh.generateNewLocalVariableName("streamForkSize");
        FcgVariable sizeNameVar = il.defineVar(FcgType.INT, sizeName, true);
        il.loadVar(sizeNameVar);
        FcgType memberType = elementType.getFCGType(cgh);
        il.createArrayExpr(memberType, false);
        String forkName = cgh.generateNewLocalVariableName("streamForkSink");
        FcgVariable forkNameVar = il.defineVar(this.getFCGType(cgh), forkName, true);
        String indexName = cgh.generateNewLocalVariableName("forkLoopIndex");
        il.loadLiteral(0);
        FcgVariable index2 = il.defineVar(FcgType.INT, indexName, true);
        il.loadVar(index2);
        il.loadVar(sizeNameVar);
        il.binaryOperationExpr(FcgBinOp.COMPARE_LT);
        il.preIncrementAndLoadLocalVariable(index2);
        il.beginConditionalLoop(indexName + "_loop", 2);
        il.loadVar(forkNameVar);
        il.loadVar(index2);
        il.loadVar(streamNameVar);
        il.loadVar(index2);
        il.loadArrayElement(memberType);
        elementType.generateObjectFork(cgh, il, cgt, ValueGenStyle.DEFAULT_NO_PUSH);
        il.storeArrayElemStmt();
        il.endConditionalLoop();
        il.loadVar(forkNameVar);
        il.storeVar(streamNameVar);
        il.endIf();
        il.loadVar(streamNameVar);
        il.comment("End stream fork");
    }

    public FcgVariable generateCopyStream(FcgVariable sourceVar, FcgVariable startVar, FcgVariable lengthVar, FcgVariable targetVar, FcgVariable targetStartVar, FcgCodeGenHelper cgh, FcgInstructionList il, CodeGenerationTracker cgt) {
        Type elementType = this.getElementType();
        FcgType elementFcgType = elementType.getFCGType(cgh);
        FcgType streamFcgType = cgh.getArrayType(elementFcgType);
        if (startVar == null) {
            il.loadLiteral(0);
            startVar = il.defineVar(FcgType.INT, cgh.generateNewLocalVariableName(), true);
        }
        if (lengthVar == null) {
            il.loadVar(sourceVar);
            il.unaryOperationExpr(FcgUnaryOp.LENGTH);
            il.loadVar(startVar);
            il.binaryOperationExpr(FcgBinOp.SUBTRACT);
            lengthVar = il.defineVar(FcgType.INT, cgh.generateNewLocalVariableName(), true);
        }
        if (targetVar == null) {
            il.loadVar(lengthVar);
            il.createArrayExpr(elementFcgType, false);
            targetVar = il.defineVar(streamFcgType, cgh.generateNewLocalVariableName(), true);
        }
        if (!elementType.isForkReleaseManaged(cgt)) {
            il.loadVar(sourceVar);
            il.loadVar(startVar);
            il.loadVar(targetVar);
            if (targetStartVar == null) {
                il.loadLiteral(0);
            } else {
                il.loadVar(targetStartVar);
            }
            il.loadVar(lengthVar);
            il.streamElemCopyStmt();
        } else {
            il.loadVar(startVar);
            il.loadVar(lengthVar);
            il.binaryOperationExpr(FcgBinOp.PLUS);
            FcgVariable stopVar = il.defineVar(FcgType.INT, cgh.generateNewLocalVariableName(), true);
            il.loadVar(startVar);
            FcgVariable indexVar = il.defineVar(FcgType.INT, cgh.generateNewLocalVariableName(), true);
            if (targetStartVar == null) {
                il.loadLiteral(0);
            } else {
                il.loadVar(targetStartVar);
            }
            FcgVariable targetIndexVar = il.defineVar(FcgType.INT, cgh.generateNewLocalVariableName(), true);
            il.loadVar(indexVar);
            il.loadVar(stopVar);
            il.binaryOperationExpr(FcgBinOp.COMPARE_LT);
            il.preIncrementAndLoadLocalVariable(indexVar);
            il.beginConditionalLoop(indexVar.getName() + "_loop", 2);
            il.loadVar(targetVar);
            il.loadVar(targetIndexVar);
            il.loadVar(sourceVar);
            il.loadVar(indexVar);
            il.loadArrayElement(elementFcgType);
            elementType.generateObjectFork(cgh, il, cgt, ValueGenStyle.DEFAULT_NO_PUSH);
            il.storeArrayElemStmt();
            il.incrementVarStmt(targetIndexVar);
            il.endConditionalLoop();
        }
        return targetVar;
    }

    @Override
    public void generateObjectRelease(FcgCodeGenHelper cgh, FcgInstructionList il, CodeGenerationTracker cgt) {
        Type elementType = this.getElementType();
        if (!elementType.isForkReleaseManaged(cgt)) {
            super.generateObjectRelease(cgh, il, cgt);
            return;
        }
        il.comment("Start stream release");
        String collectionName = cgh.generateNewLocalVariableName();
        String indexName = cgh.generateNewLocalVariableName("_loopIndex");
        String memberName = cgh.generateNewLocalVariableName("_currentMember");
        FcgType memberType = this.getElementType().getFCGType(cgh);
        FcgVariable collectionVar = il.defineVar(this.getFCGType(cgh), collectionName, true);
        il.loadVar(collectionVar);
        il.loadNull();
        il.binaryOperationExpr(FcgBinOp.COMPARE_NE);
        il.beginIf();
        il.loadLiteral(0);
        FcgVariable index2 = il.defineVar(FcgType.INT, indexName, true);
        il.loadVar(index2);
        il.loadVar(collectionVar);
        il.unaryOperationExpr(FcgUnaryOp.LENGTH);
        il.binaryOperationExpr(FcgBinOp.COMPARE_LT);
        il.preIncrementAndLoadLocalVariable(index2);
        il.beginConditionalLoop(collectionName + "_loop", 2);
        il.loadVar(collectionVar);
        il.loadVar(index2);
        il.loadArrayElement(memberType);
        elementType.generateObjectRelease(cgh, il, cgt);
        il.endConditionalLoop();
        il.endIf();
        il.comment("End stream release");
    }

    @Override
    public boolean isForkReleaseManaged(CodeGenerationTracker cgt) {
        return this.getElementType().isForkReleaseManaged(cgt);
    }

    @Override
    public void generateConvertI2C(FcgCodeGenHelper cgh, FcgInstructionList il, CodeGenerationTracker cgt, FcgVariable environment, FcgVariable typeStore) {
        FcgInterfaceType streamType = cgh.getInterfaceType(IStream.class.getName());
        il.convertExpr(FcgType.OBJECT, streamType);
        FcgType elementType = this.getElementType().getFCGType(cgh);
        FcgType arrayType = cgh.getArrayType(elementType);
        FcgClassGen classGen = cgh.getCurrentFcgClassGen();
        FcgType fcgRetType = arrayType;
        if (this.getElementType().equals(CharType.s_charType)) {
            il.invokeInterfaceMethod(streamType, "toCharArray", (FcgType)FcgType.CHAR_ARRAY, new FcgType[0]);
        } else {
            FcgVariable inputVar = il.defineVar(streamType, cgh.generateNewLocalVariableName(), true);
            il.loadVar(inputVar);
            il.invokeInterfaceMethod(streamType, "size", (FcgType)FcgType.INT, new FcgType[0]);
            FcgVariable streamSize = il.defineConstVar(FcgType.INT, cgh.generateNewLocalVariableName());
            il.loadVar(streamSize);
            il.createArrayExpr(elementType, false);
            FcgVariable arrayVar = il.defineVar(arrayType, cgh.generateNewLocalVariableName(), true);
            il.loadLiteral(0);
            FcgVariable loopVar = il.defineVar(FcgType.INT, cgh.generateNewLocalVariableName(), true);
            il.loadVar(loopVar);
            il.loadVar(streamSize);
            il.binaryOperationExpr(FcgBinOp.COMPARE_LT);
            il.preIncrementAndLoadLocalVariable(loopVar);
            il.beginConditionalLoop("conversionLoop", 2);
            il.loadVar(arrayVar);
            il.loadVar(loopVar);
            il.loadVar(inputVar);
            il.loadVar(loopVar);
            il.invokeInterfaceMethod(streamType, "get", (FcgType)FcgType.OBJECT, new FcgType[]{FcgType.INT});
            this.getElementType().generateConvertI2C(cgh, il, cgt, environment, typeStore);
            il.storeArrayElemStmt();
            il.endConditionalLoop();
            il.loadVar(arrayVar);
        }
    }

    @Override
    public void generateConvertC2I(FcgCodeGenHelper cgh, FcgInstructionList il, CodeGenerationTracker cgt, FcgVariable typeStore) {
        MixedModeStreamResultFunctionGenerationStyle gs = new MixedModeStreamResultFunctionGenerationStyle(cgt.m_function, this);
        cgh.requestFunctionGeneration(gs);
        il.loadVar(typeStore);
        il.createObjectExpr((FcgType)gs.getLazyListStreamClass(cgh), 2);
    }

    @Override
    public FunctionGenerationStyle getStreamFunctionGenerationStyle(Function f2) {
        return new StreamOptimizedFunctionGenerationStyle(f2);
    }

    @Override
    public boolean usableInStreamOptimizedGeneration(IConstructableAsStreamType aggregateType) {
        return aggregateType == this;
    }

    @Override
    public FcgType generateCodeForOperation(FcgCodeGenHelper cgh, FcgInstructionList il) {
        FcgType t = null;
        FcgClassReferenceType ArraysType = cgh.getClassReferenceType("java.util.Arrays");
        Type elemType = this.getElementType();
        if (elemType instanceof IPrimitiveType) {
            il.invokeClassMethod(ArraysType, "equals", (FcgType)FcgType.BOOLEAN, 2);
        } else {
            il.invokeClassMethod(ArraysType, "equals", (FcgType)FcgType.BOOLEAN, new FcgType[]{FcgType.OBJECT_ARRAY, FcgType.OBJECT_ARRAY});
        }
        return t;
    }

    @Override
    public CodeGenerationOptimizationStyle[] getPotentialStreamOptimizations() {
        return new CodeGenerationOptimizationStyle[]{StreamOptimizationStyle.s_streamOptimizationStyle};
    }

    @Override
    public boolean semanticallyEquals(Object arg0, boolean approximateSequenceType) {
        return arg0 != null && arg0 instanceof StreamType && ((StreamType)arg0).m_elementType.semanticallyEquals(this.m_elementType, approximateSequenceType);
    }

    @Override
    public Type buildUnion(TypeEnvironment tenv, Type t2, Instruction errorBase) throws TypeCheckException {
        if (t2 == null) {
            return this;
        }
        if (!(t2 instanceof StreamType)) {
            if (t2 instanceof TypeVariable) {
                return super.buildUnion(tenv, t2, errorBase);
            }
            throw new TypeCheckException("Typecheck exception, expecting StreamType but instead found a " + t2.getClass().getSimpleName(), errorBase);
        }
        Type elemType = this.m_elementType.buildUnion(tenv, ((StreamType)t2).m_elementType, errorBase);
        if (elemType != this.m_elementType) {
            return new StreamType(elemType);
        }
        return this;
    }

    @Override
    public Type factor() {
        Type elemType = this.m_elementType.factor();
        if (elemType != this.m_elementType) {
            return new StreamType(elemType);
        }
        return this;
    }

    @Override
    public Type generalize() {
        Type elemType = this.m_elementType.generalize();
        if (elemType != this.m_elementType) {
            return new StreamType(elemType);
        }
        return this;
    }
}

