/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgCodeGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TypeLambda
implements Serializable {
    private static final long serialVersionUID = -1987728404080393070L;
    private static final Logger s_logger = LoggerUtil.getLogger(TypeLambda.class);
    private static final String s_className = TypeLambda.class.getName();
    TypeVariable[] parms;
    Type body = null;
    AbstractDataType body_adt = null;

    public TypeLambda(TypeVariable[] parms, Type body) {
        this.parms = parms;
        this.body = body;
    }

    public TypeLambda(TypeVariable[] parms, AbstractDataType body_adt) {
        this.parms = parms;
        this.body_adt = body_adt;
    }

    public Type getBody() {
        return this.body;
    }

    public TypeVariable[] getParms() {
        return this.parms;
    }

    public Map replaceParms(Type[] args) {
        if (args.length != this.parms.length) {
            StringBuilder innerMessage = new StringBuilder("Expected " + this.parms.length + " type arguments, " + "got " + args.length + ":");
            for (int i = 0; i < args.length; ++i) {
                innerMessage.append(args[i]);
                innerMessage.append('\n');
            }
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[0]);
            XylemError error2 = new XylemError(message);
            s_logger.logp(Level.SEVERE, s_className, "replaceParms", message, error2);
            throw error2;
        }
        HashMap<TypeVariable, Type> tmap = new HashMap<TypeVariable, Type>();
        for (int i = 0; i < args.length; ++i) {
            tmap.put(this.parms[i], args[i]);
        }
        return tmap;
    }

    public Type apply(Type[] args) {
        Map tmap = this.replaceParms(args);
        return this.body.replaceType(tmap);
    }

    public Type replaceType(Map tmap) {
        for (int i = 0; i < this.parms.length; ++i) {
            if (tmap.get(this.parms[i]) == null) continue;
            throw new XylemError("ERR_SYSTEM", "TypeLambda.replaceType: tried to replace one of the \u039b's parameters, which makes no sense.");
        }
        return this.body.replaceType(tmap);
    }

    public String prettyPrint() {
        StringBuffer sb = new StringBuffer();
        sb.append("(\u039b (");
        for (int i = 0; i < this.parms.length; ++i) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(this.parms[i].prettyPrint());
        }
        sb.append(") ");
        sb.append(this.body.prettyPrint());
        sb.append(")");
        return sb.toString();
    }

    public String getDefaultValue() {
        throw new UnsupportedOperationException();
    }

    public FcgType getFCGType(FcgCodeGen cg) {
        throw new UnsupportedOperationException();
    }

    public Type expandTypeAliases(Module module) {
        return null;
    }
}

