/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.commandline.SearchPathSourceResolver;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.FlattenStreamOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VirtualDataTypeMap {
    private static final Logger s_logger = LoggerUtil.getLogger(VirtualDataTypeMap.class);
    private static final String s_className = VirtualDataTypeMap.class.getName();
    private HashMap m_mappings = new HashMap();
    private Collection m_importDirectives = new ArrayList();
    private FlattenStreamOptimizer streamFlattener = new FlattenStreamOptimizer();

    public void addVDTMapping(String adtName, ADTMapping m, boolean errorIfDuplicate) {
        Object o;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "addVDTMapping", "adding VDTmap from " + adtName);
        }
        if ((o = this.m_mappings.get(adtName)) == m) {
            return;
        }
        if (o != null && errorIfDuplicate && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "addVDTMapping", "vdtmap with name " + adtName + " already exists");
        }
        this.m_mappings.put(adtName, m);
    }

    public void addVDTMapping(String adtName, ADTMapping m) {
        this.addVDTMapping(adtName, m, true);
    }

    public boolean hasVDTMapping(String adtName) {
        return this.m_mappings.containsKey(adtName);
    }

    public Set vdtMappingNames() {
        return this.m_mappings.keySet();
    }

    public ADTMapping getVDTMapping(String adtName) {
        return (ADTMapping)this.m_mappings.get(adtName);
    }

    public void addVDT(Module mm, String adtName, Type targetType, LambdaInstruction adt_mapping, Map variantMappings) throws ParserException {
        if (this.hasVDTMapping(adtName)) {
            throw new ParserException("map-datatype already supplied for " + adtName);
        }
        ADTMapping adtm = new ADTMapping();
        this.addVDTMapping(adtName, adtm);
        adtm.m_targetType = targetType;
        Binding[] params = adt_mapping.getParameters();
        if (params.length != 1) {
            throw new ParserException("mapping function should have a single parameter");
        }
        TupleInstruction matchCode = new TupleInstruction(new Instruction[]{adt_mapping.getBody()});
        Function f2 = this.typecheckAndReduceVDTCode(mm, matchCode, params);
        adtm.m_matchVariable = f2.getParameters()[0];
        adtm.m_matchCode = f2.getBody();
        for (String variantName : variantMappings.keySet()) {
            LambdaInstruction[] variantMapping = (LambdaInstruction[])variantMappings.get(variantName);
            if (variantMapping.length != 2) {
                throw new ParserException("a variant mapping must have two functions to construct and deconstruct an object");
            }
            ConstructorMapping cm = new ConstructorMapping();
            f2 = this.typecheckAndReduceVDTCode(mm, variantMapping[0].getBody(), variantMapping[0].getParameters());
            cm.m_constructParameters = f2.getParameters();
            cm.m_constructCode = f2.getBody();
            Binding[] dcparms = variantMapping[1].getParameters();
            if (dcparms.length != 1) {
                throw new ParserException("deconstructor function should have a single parameter");
            }
            f2 = this.typecheckAndReduceVDTCode(mm, variantMapping[1].getBody(), variantMapping[1].getParameters());
            if (!(f2.getReturnType() instanceof TupleType)) {
                throw new ParserException("return type must be a tuple :" + f2.toString() + ":" + f2.getBody());
            }
            cm.m_deconstructVariable = f2.getParameters()[0];
            cm.m_deconstructCode = f2.getBody();
            adtm.m_constructors.put(variantName, cm);
        }
    }

    protected void applyFlattener(Function f2, Module mm) {
    }

    private Function typecheckAndReduceVDTCode(Module mm, Instruction toConvert, Binding[] bindings) throws ParserException {
        Function fakeFunc = new Function(OptimizerUtilities.generateIntermediateIdentifier(), bindings, toConvert);
        this.applyFlattener(fakeFunc, mm);
        try {
            fakeFunc.typeCheck(mm, null, new LinkedList<Function>());
        }
        catch (TypeCheckException tce) {
            throw new ParserException(tce.getMessage());
        }
        catch (NullPointerException tce) {
            throw new ParserException(tce.getMessage());
        }
        fakeFunc.standardizeTypes(true);
        fakeFunc.reduce();
        this.streamFlattener.optimizeFunction(fakeFunc);
        return fakeFunc;
    }

    public void addImportDirectives(Collection c) {
        this.m_importDirectives.addAll(c);
    }

    public Collection getImportDirectives() {
        return this.m_importDirectives;
    }

    public static void main(String[] args) {
        try {
            ParserSource ps = new ParserSource(new File(args[0]).toURL());
            Parser parser = new Parser(new SearchPathSourceResolver(new LinkedList()), ps, new ModuleSignatureStore(new LinkedList<URL>()));
            VirtualDataTypeMap vdtm = parser.parseVDTMap();
            System.out.println(vdtm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addAll(VirtualDataTypeMap m) {
        for (Map.Entry entry : m.m_mappings.entrySet()) {
            String name2 = (String)entry.getKey();
            ADTMapping map2 = (ADTMapping)entry.getValue();
            this.addVDTMapping(name2, map2);
        }
    }

    public Type getTargetType(String name2) {
        if (!this.hasVDTMapping(name2)) {
            return null;
        }
        return this.getVDTMapping((String)name2).m_targetType;
    }

    public HashMap getTypeMap() {
        HashMap<NamedType, Type> map2 = new HashMap<NamedType, Type>();
        for (String n2 : this.m_mappings.keySet()) {
            map2.put(new NamedType(n2), this.getTargetType(n2));
        }
        return map2;
    }

    public static class ConstructorMapping {
        public Instruction m_constructCode;
        public Binding[] m_constructParameters;
        public Instruction m_deconstructCode;
        public Binding m_deconstructVariable;
    }

    public static class ADTMapping {
        public HashMap m_constructors = new HashMap();
        public Instruction m_matchCode;
        public Binding m_matchVariable;
        public Type m_targetType;
    }
}

