/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ras;

import com.ibm.xml.ras.LoggerUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FFDCUtil {
    private static final Logger logger = LoggerUtil.getLogger(FFDCUtil.class);
    private static Object ffdcManager;
    private static Method ffdcLogMethod;
    private static final String FFDC_MANAGER_CLASSNAME = "com.ibm.ffdc.Manager";

    private static StackTraceElement getStackTraceElement(Object object2) {
        String string2 = object2 instanceof Class ? ((Class)object2).getName() : object2.getClass().getName();
        try {
            StackTraceElement[] stackTraceElementArray;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

                @Override
                public StackTraceElement[] run() {
                    return Thread.currentThread().getStackTrace();
                }
            })) {
                if (!string2.equals(stackTraceElement.getClassName())) continue;
                return stackTraceElement;
            }
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static void log(final Throwable throwable, final Object object2) {
        String string2;
        StackTraceElement stackTraceElement = FFDCUtil.getStackTraceElement(object2);
        String string3 = string2 = stackTraceElement != null ? stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() : object2.getClass().getName();
        if (ffdcLogMethod != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        ffdcLogMethod.invoke(ffdcManager, throwable, object2, string2, "100");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return null;
                }
            });
        } else {
            logger.logp(Level.WARNING, logger.getName(), "log", "An attempt was made to log a message to FFDC, but FFDC services are not currently available.\nReporter: " + object2 + "\n" + "Source: " + string2 + "\n" + "Message: " + throwable.getMessage(), throwable);
        }
    }

    public static Class<?> loadClassWithPrivilege(final String string2) {
        Class clazz = null;
        final ClassLoader classLoader = FFDCUtil.getClassLoader();
        if (classLoader == null) {
            logger.logp(Level.WARNING, logger.getName(), "loadClassWithPrivilege", "FFDC services will not be available because a class loader could not be retrieved.");
            return null;
        }
        try {
            clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    return classLoader.loadClass(string2);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            logger.logp(Level.WARNING, logger.getName(), "loadClassWithPrivilege", "FFDC services will not be available because the class com.ibm.ffdc.Manager could not be loaded using the current class loader.");
        }
        return clazz;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        if (classLoader == null) {
            classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return FFDCUtil.class.getClassLoader();
                }
            });
        }
        return classLoader;
    }

    static {
        try {
            Class<?> clazz = FFDCUtil.loadClassWithPrivilege(FFDC_MANAGER_CLASSNAME);
            Field field = clazz.getField("Ffdc");
            ffdcManager = field.get(null);
            ffdcLogMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Class[] classArray = new Class[]{Throwable.class, Object.class, String.class, String.class};
                    return ffdcManager.getClass().getMethod("log", classArray);
                }
            });
        }
        catch (Exception exception) {
            ffdcLogMethod = null;
            ffdcManager = null;
        }
    }
}

