/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.ras;

import com.ibm.xml.ras.Copyright;
import com.ibm.xml.ras.WsLoggerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class LoggerUtil
implements PropertyChangeListener {
    private static final String fgStaticClassName = LoggerUtil.class.getName();
    private static final String WsLoggerUtilClassName = LoggerUtil.class.getPackage().getName() + ".WsLoggerUtil";
    private static Logger myLogger = Logger.getLogger(fgStaticClassName);
    static boolean fgAnyTracingEnabled;
    private static final Properties fgProperties;
    private static final LoggerUtil fgSingleton;

    private static Object loadImplFromClass(String string2) {
        return LoggerUtil.loadImplFromClass(string2, false);
    }

    private static Object loadImplFromClass(String string2, Boolean bl) {
        ClassLoader classLoader = null;
        if (bl.booleanValue()) {
            classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        if (classLoader == null) {
            classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return LoggerUtil.class.getClassLoader();
                }
            });
        }
        try {
            Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string2.equals(fgStaticClassName)) {
                classNotFoundException.printStackTrace();
                throw new IllegalStateException(classNotFoundException);
            }
            if (bl.booleanValue()) {
                myLogger.logp(Level.WARNING, fgStaticClassName, "loadImplFromClass", classNotFoundException.getLocalizedMessage(), classNotFoundException);
                if (myLogger.isLoggable(Level.FINE)) {
                    myLogger.logp(Level.FINE, fgStaticClassName, "loadImplFromClass", "Unable to load " + string2 + ", attempting to fall back to " + fgStaticClassName);
                }
            }
            return LoggerUtil.loadImplFromClass(fgStaticClassName);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            throw new IllegalStateException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new IllegalStateException(illegalAccessException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (string2.equals(WsLoggerUtilClassName)) {
                if (bl.booleanValue()) {
                    myLogger.logp(Level.WARNING, fgStaticClassName, "loadImplFromClass", noClassDefFoundError.getLocalizedMessage(), noClassDefFoundError);
                }
                if (myLogger.isLoggable(Level.FINE)) {
                    myLogger.logp(Level.FINE, fgStaticClassName, "loadImplFromClass", "Unable to load " + WsLoggerUtil.class.getName() + ", attempting to fall back to " + fgStaticClassName);
                }
                return LoggerUtil.loadImplFromClass(fgStaticClassName);
            }
            throw new IllegalStateException(noClassDefFoundError);
        }
    }

    protected boolean anyTracingEnabled() {
        return fgAnyTracingEnabled;
    }

    protected void checkTracingEnabled(Logger logger) {
        if (!fgAnyTracingEnabled && logger.isLoggable(Level.FINE)) {
            fgAnyTracingEnabled = true;
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        Logger logger = Logger.getLogger(clazz.getName());
        fgSingleton.checkTracingEnabled(logger);
        return logger;
    }

    public static Logger getLogger(Class<?> clazz, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() > 0 && string2.charAt(0) != '.') {
            string2 = "." + string2;
        }
        Logger logger = Logger.getLogger(clazz.getName() + string2);
        fgSingleton.checkTracingEnabled(logger);
        return logger;
    }

    public static boolean isAnyTracingEnabled() {
        return fgSingleton.anyTracingEnabled();
    }

    public static void updateTracingEnabled(Logger logger) {
        fgSingleton.checkTracingEnabled(logger);
    }

    public static boolean isEntryLoggable(Logger logger) {
        return LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER);
    }

    public static boolean isFineLoggable(Logger logger) {
        return LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE);
    }

    public static boolean isFinerLoggable(Logger logger) {
        return LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER);
    }

    public static boolean isFinestLoggable(Logger logger) {
        return LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST);
    }

    public static String getUniqueString(Object object2) {
        if (object2 != null) {
            Class<?> clazz = object2.getClass();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(clazz.getName());
            stringBuilder.append('@');
            stringBuilder.append(Integer.toHexString(System.identityHashCode(object2)));
            return stringBuilder.toString();
        }
        return "null";
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    static {
        fgProperties = new Properties();
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader != null) {
                    return classLoader.getResourceAsStream("properties/xml-logging.properties");
                }
                return null;
            }
        });
        if (inputStream != null) {
            try {
                fgProperties.load(inputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new IllegalStateException(iOException);
            }
            String string2 = fgProperties.getProperty(LoggerUtil.class.getName());
            if (string2 != null) {
                if (myLogger.isLoggable(Level.FINE)) {
                    myLogger.logp(Level.FINE, fgStaticClassName, "static init", "Loading " + string2 + " as requested in properties/xml-logging.properties");
                }
                fgSingleton = (LoggerUtil)LoggerUtil.loadImplFromClass(string2, true);
            } else {
                if (myLogger.isLoggable(Level.FINE)) {
                    myLogger.logp(Level.FINE, fgStaticClassName, "static init", "No " + LoggerUtil.class.getName() + " property was found in properties/xml-logging.properties file, attempting to load " + WsLoggerUtilClassName);
                }
                fgSingleton = (LoggerUtil)LoggerUtil.loadImplFromClass(WsLoggerUtilClassName);
            }
        } else {
            if (myLogger.isLoggable(Level.FINE)) {
                myLogger.logp(Level.FINE, fgStaticClassName, "static init", "Attempting to load WsLoggerUtil.");
            }
            fgSingleton = (LoggerUtil)LoggerUtil.loadImplFromClass(WsLoggerUtilClassName);
        }
        if (myLogger.isLoggable(Level.FINE)) {
            myLogger.logp(Level.FINE, fgStaticClassName, "static init", "Logging framework using " + fgSingleton.getClass().getName());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LogManager.getLogManager().addPropertyChangeListener(fgSingleton);
                return null;
            }
        });
    }
}

