/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.TreeConstructionKind;
import com.ibm.xml.xci.XCIRegistry;
import com.ibm.xml.xci.dp.util.CDataCursorFactory;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.exec.GenericPreparer;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.internal.util.CursorFactoryRegistration;
import com.ibm.xml.xci.type.TypeRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionContext {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2011. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private CursorFactory simpleCursorFactory = null;
    private static CursorFactory staticSimpleCursorFactory = null;
    private final CursorFactory[] _factoryInstances;
    private final TypeRegistry _typeRegistry;
    private final XCIRegistry _xciRegistry;
    private final Preparer _preparerManager;
    private Preparer[] _preparers;
    private HashMap<String, Object> _userDatas;
    private RequestInfo _defaultRequestInfo;
    private long _documentIdentityPoolCounter = 0L;
    private final ClassLoader _classLoader;
    private final Map<String, Object> _options;
    private DOMErrorHandler _errorHandler;

    public SessionContext(TypeRegistry typeRegistry) {
        this(null, typeRegistry, null, false);
    }

    public SessionContext(TypeRegistry typeRegistry, ClassLoader classLoader) {
        this(null, typeRegistry, classLoader, false);
    }

    public SessionContext(RequestInfo requestInfo, TypeRegistry typeRegistry, ClassLoader classLoader) {
        this(requestInfo, typeRegistry, classLoader, false);
    }

    private SessionContext(RequestInfo requestInfo, TypeRegistry typeRegistry, ClassLoader classLoader, boolean bl) {
        this._defaultRequestInfo = requestInfo;
        this._typeRegistry = typeRegistry;
        this._classLoader = classLoader;
        this._xciRegistry = XCIRegistry.getInstance(classLoader, bl);
        int n2 = this._xciRegistry.getDataProviderCount();
        this._factoryInstances = new CursorFactory[n2];
        this._preparerManager = new GenericPreparer(this);
        this._preparers = new Preparer[n2];
        this._userDatas = null;
        this._options = null;
    }

    public SessionContext() {
        this((RequestInfo)null, (ClassLoader)null, null, false);
    }

    public SessionContext(ClassLoader classLoader) {
        this(null, classLoader, null, false);
    }

    public SessionContext(RequestInfo requestInfo, ClassLoader classLoader) {
        this(requestInfo, classLoader, null, false);
    }

    public SessionContext(RequestInfo requestInfo, ClassLoader classLoader, Map<String, Object> map2) {
        this(requestInfo, classLoader, map2, false);
    }

    private SessionContext(RequestInfo requestInfo, ClassLoader classLoader, Map<String, Object> map2, boolean bl) {
        this._defaultRequestInfo = requestInfo;
        this._typeRegistry = TypeRegistry.newTypeRegistry(map2);
        this._classLoader = classLoader;
        this._xciRegistry = XCIRegistry.getInstance(classLoader, bl);
        int n2 = this._xciRegistry.getDataProviderCount();
        this._factoryInstances = new CursorFactory[n2];
        this._preparerManager = new GenericPreparer(this);
        this._preparers = new Preparer[n2];
        this._userDatas = null;
        this._options = map2;
    }

    public Object getOption(String string2) {
        return this._options == null ? null : this._options.get(string2);
    }

    public CursorFactory getSimpleDataFactory() {
        if (this.simpleCursorFactory == null) {
            this.simpleCursorFactory = new CDataCursorFactory(this);
        }
        return this.simpleCursorFactory;
    }

    public static CursorFactory getStaticSimpleDataFactory() {
        if (staticSimpleCursorFactory == null) {
            staticSimpleCursorFactory = new CDataCursorFactory(null);
        }
        return staticSimpleCursorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor document(Source source, RequestInfo requestInfo) {
        String string2 = source.getSystemId();
        int n2 = this._xciRegistry.findBestScoreIndex(source != null ? source.getClass() : Source.class, requestInfo, string2, this._classLoader);
        CursorFactory cursorFactory = null;
        CursorFactory[] cursorFactoryArray = this._factoryInstances;
        synchronized (this._factoryInstances) {
            cursorFactory = this._factoryInstances[n2];
            if (cursorFactory == null) {
                this._factoryInstances[n2] = cursorFactory = this._xciRegistry.getCursorFactoryRegistration(n2).getFactoryInstance(this, this._classLoader);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return cursorFactory.document(source, requestInfo);
        }
    }

    public boolean documentIsBefore(long l, long l2) {
        return l < l2;
    }

    public synchronized long obtainUniqueDocumentIdentity() {
        return ++this._documentIdentityPoolCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursorFactory getCursorFactory(Class<?> clazz, RequestInfo requestInfo) {
        int n2 = this._xciRegistry.findBestScoreIndex(clazz, requestInfo, null, this._classLoader);
        if (n2 < 0) {
            return null;
        }
        CursorFactory[] cursorFactoryArray = this._factoryInstances;
        synchronized (this._factoryInstances) {
            if (this._factoryInstances[n2] == null) {
                this._factoryInstances[n2] = this._xciRegistry.getCursorFactoryRegistration(n2).getFactoryInstance(this, this._classLoader);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this._factoryInstances[n2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursorFactory getCursorFactory(int n2) {
        CursorFactory[] cursorFactoryArray = this._factoryInstances;
        synchronized (this._factoryInstances) {
            CursorFactory cursorFactory = this._factoryInstances[n2];
            if (cursorFactory == null) {
                this._factoryInstances[n2] = cursorFactory = this._xciRegistry.getCursorFactoryRegistration(n2).getFactoryInstance(this, this._classLoader);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return cursorFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursorFactory getCursorFactory(TreeConstructionKind treeConstructionKind, RequestInfo requestInfo) {
        int n2 = this._xciRegistry.findBestScoreIndex(treeConstructionKind, requestInfo, this._classLoader);
        if (n2 < 0) {
            return null;
        }
        CursorFactory[] cursorFactoryArray = this._factoryInstances;
        synchronized (this._factoryInstances) {
            if (this._factoryInstances[n2] == null) {
                this._factoryInstances[n2] = this._xciRegistry.getCursorFactoryRegistration(n2).getFactoryInstance(this, this._classLoader);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this._factoryInstances[n2];
        }
    }

    public CursorFactory setCursorFactory(int n2, CursorFactory cursorFactory) {
        CursorFactory cursorFactory2 = this._factoryInstances[n2];
        this._factoryInstances[n2] = cursorFactory;
        return cursorFactory2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor document(Result result2, RequestInfo requestInfo) {
        String string2 = result2 != null ? result2.getSystemId() : null;
        int n2 = this._xciRegistry.findBestScoreIndex(result2 != null ? result2.getClass() : Result.class, requestInfo, string2, this._classLoader);
        CursorFactory[] cursorFactoryArray = this._factoryInstances;
        synchronized (this._factoryInstances) {
            CursorFactory cursorFactory = this._factoryInstances[n2];
            if (cursorFactory == null) {
                this._factoryInstances[n2] = cursorFactory = this._xciRegistry.getCursorFactoryRegistration(n2).getFactoryInstance(this, this._classLoader);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return cursorFactory.document(result2, requestInfo);
        }
    }

    public TypeRegistry getTypeRegistry() {
        return this._typeRegistry;
    }

    public void printRegisteredDataProviderString() {
        this._xciRegistry.printRegisteredDataProviderString();
    }

    public Preparer getPreparer(int n2) {
        return this.getPreparer(n2, false);
    }

    public Preparer getPreparer(int n2, boolean bl) {
        CursorFactoryRegistration cursorFactoryRegistration = this._xciRegistry.getCursorFactoryRegistration(n2);
        if (bl && cursorFactoryRegistration.getPreparerClass() == null) {
            return null;
        }
        Preparer preparer = this.getPreparerFromRegistration(n2, cursorFactoryRegistration);
        return preparer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preparer getPreparerFromRegistration(int n2, CursorFactoryRegistration cursorFactoryRegistration) {
        Preparer[] preparerArray = this._preparers;
        synchronized (this._preparers) {
            Preparer preparer = this._preparers[n2];
            if (preparer == null) {
                this._preparers[n2] = preparer = cursorFactoryRegistration.getPreparerInstance(this);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return preparer;
        }
    }

    public Preparer getPreparer() {
        return this._preparerManager;
    }

    public Preparer getPreparer(RequestInfo requestInfo) {
        int n2 = this._xciRegistry.getDataProviderCount();
        String string2 = requestInfo.getLanguage();
        for (int i = 0; i < n2; ++i) {
            String[] stringArray;
            CursorFactoryRegistration cursorFactoryRegistration = this._xciRegistry.getCursorFactoryRegistration(i);
            if (cursorFactoryRegistration.getClassName() != null || null == (stringArray = cursorFactoryRegistration.getLanguages())) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                Preparer preparer;
                if (!string2.equals(stringArray[j]) || null == (preparer = this.getPreparerFromRegistration(i, cursorFactoryRegistration))) continue;
                return preparer;
            }
        }
        return null;
    }

    public int getDataProviderID(String string2) {
        return this._xciRegistry.getDataProviderID(string2);
    }

    public int getDataProviderCount() {
        return this._xciRegistry.getDataProviderCount();
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public synchronized Object getUserData(String string2) {
        if (this._userDatas == null) {
            return null;
        }
        return this._userDatas.get(string2);
    }

    public synchronized Object setUserData(String string2, Object object2) {
        if (this._userDatas == null) {
            if (object2 == null) {
                return null;
            }
            this._userDatas = new HashMap();
        }
        if (object2 != null) {
            return this._userDatas.put(string2, object2);
        }
        return this._userDatas.remove(string2);
    }

    public RequestInfo getDefaultRequestInfo() {
        return this._defaultRequestInfo;
    }

    public void setDefaultRequestInfo(RequestInfo requestInfo) {
        this._defaultRequestInfo = requestInfo;
    }

    public DOMErrorHandler getErrorHandler() {
        return this._errorHandler != null ? this._errorHandler : DefaultXCIErrorHandler.INSTANCE;
    }

    public void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        this._errorHandler = dOMErrorHandler;
    }

    public static final class DefaultXCIErrorHandler
    implements DOMErrorHandler {
        private static final Logger logger = LoggerUtil.getLogger(DefaultXCIErrorHandler.class);
        public static final DefaultXCIErrorHandler INSTANCE = new DefaultXCIErrorHandler();

        private DefaultXCIErrorHandler() {
        }

        public boolean handleError(DOMError dOMError) {
            String string2 = this.createErrorString(dOMError);
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "handleError", string2, (Exception)dOMError.getRelatedException());
            } else {
                System.err.println(string2);
            }
            if (dOMError.getSeverity() == 3) {
                throw new XCIDynamicErrorException(string2);
            }
            return true;
        }

        private String createErrorString(DOMError dOMError) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(this.severityString(dOMError.getSeverity()));
            stringBuilder.append(']');
            DOMLocator dOMLocator = dOMError.getLocation();
            if (dOMLocator != null) {
                stringBuilder.append("{URI=");
                stringBuilder.append(dOMLocator.getUri());
                stringBuilder.append(" : ");
                stringBuilder.append(dOMLocator.getLineNumber());
                stringBuilder.append(',');
                stringBuilder.append(dOMLocator.getColumnNumber());
                stringBuilder.append("} :");
            }
            if (dOMError.getRelatedException() != null) {
                stringBuilder.append(((Exception)dOMError.getRelatedException()).getLocalizedMessage());
            } else {
                stringBuilder.append(dOMError.getMessage());
            }
            return stringBuilder.toString();
        }

        private String severityString(short s) {
            switch (s) {
                case 1: {
                    return "warning";
                }
                case 2: {
                    return "error";
                }
            }
            return "fatal error";
        }
    }
}

