/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.Hints;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.TreeConstructionKind;
import com.ibm.xml.xci.Version;
import com.ibm.xml.xci.dp.util.InstrumentationHandler;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.util.CursorFactoryRegistration;
import com.ibm.xml.xci.internal.util.MasterCursorFactoryRegistration;
import com.ibm.xml.xci.internal.util.SDOCursorFactoryRegistration;
import com.ibm.xml.xci.res.XCIMessages;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XCIRegistry {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2011. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static XCIRegistry master = null;
    private final List<CursorFactoryRegistration> dataProviderFactories = new Vector<CursorFactoryRegistration>();
    private static final String REGISTRATION_PROPERTIES_FILENAME = XCIRegistry.class.getPackage().getName() + ".factories.properties";
    private static final String PROP_CLASS = "class";
    private static final Logger logger = LoggerUtil.getLogger(XCIRegistry.class);
    private static final HashSet<String> builtInAdapters = new HashSet();
    private static Class SDOClass = null;
    private static final String PROP_CONTENTTYPE = "contentType";
    private static final String PROP_OBJECTMATCH = "objectmatch";
    private static final String PROP_TREEMATCH = "treematch";
    private static final String PROP_FEATURESLIMIT = "featureslimit";
    private static final String PROP_HINTS = "hints";
    private static final String PROP_PRIORITY = "priority";
    private static final String PROP_PREPARER = "preparer";
    private static final String PROP_LANGUAGES = "languages";
    private static final String PROP_VERSIONSTRING = "versionstring";
    private static final Map<ClassLoader, WeakReference<XCIRegistry>> registryMap;
    private static final String SUFFIX = ".properties";
    private static final Cursor.Profile UPDATE_FEATURES;
    private static final boolean THROW_ON_LOAD_FAILURE = true;
    private static final boolean LOAD_AS_RESOURCE_BUNDLE = true;

    public static synchronized XCIRegistry getInstance() {
        return XCIRegistry.makeMaster();
    }

    private static synchronized XCIRegistry makeMaster() {
        if (master == null) {
            master = new XCIRegistry();
            XCIRegistry.registerSDOX();
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "makeMaster", "XML FeP Version Details:\n " + Version.getVersion() + " \n");
            }
        }
        return master;
    }

    static synchronized XCIRegistry getInstance(ClassLoader classLoader, boolean bl) {
        Object object2;
        CharSequence charSequence;
        Object object3;
        if (!bl && master == null) {
            master = XCIRegistry.makeMaster();
            if (master.getDataProviderCount() == 0) {
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_NOADAPTERS", null));
            }
            object3 = builtInAdapters.iterator();
            while (object3.hasNext()) {
                charSequence = object3.next();
                if (master.getDataProviderID((String)charSequence) != -1) continue;
                object2 = new IllegalArgumentException("Could not load the built-in adapter[" + (String)charSequence + SUFFIX + "]");
                FFDCUtil.log((Throwable)object2, XCIRegistry.class);
            }
        }
        if (classLoader == null || classLoader == XCIRegistry.class.getClassLoader()) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "getInstance(ClassLoader, boolean)", "Returning master registry.");
                object3 = new StringBuilder("Classloader: ");
                ((StringBuilder)object3).append(classLoader != null ? classLoader.getClass().getName() : "null");
                ((StringBuilder)object3).append("\n");
                for (int i = 0; i < XCIRegistry.master.dataProviderFactories.size(); ++i) {
                    ((StringBuilder)object3).append(XCIRegistry.master.dataProviderFactories.get(i).toString());
                    ((StringBuilder)object3).append("\n");
                }
                logger.logp(Level.FINEST, logger.getName(), "getInstance(ClassLoader, boolean)", ((StringBuilder)object3).toString());
            }
            return master;
        }
        if (registryMap.containsKey(classLoader) && (object3 = (XCIRegistry)registryMap.get(classLoader).get()) != null) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                charSequence = new StringBuilder("Returning previously configured registry for classloader: ");
                ((StringBuilder)charSequence).append(classLoader != null ? classLoader.getClass().getName() : "null");
                ((StringBuilder)charSequence).append("\n");
                for (int i = 0; i < ((XCIRegistry)object3).dataProviderFactories.size(); ++i) {
                    ((StringBuilder)charSequence).append(((XCIRegistry)object3).dataProviderFactories.get(i).toString());
                    ((StringBuilder)charSequence).append("\n");
                }
                logger.logp(Level.FINEST, logger.getName(), "getInstance(ClassLoader, boolean)", ((StringBuilder)charSequence).toString());
            }
            return object3;
        }
        object3 = new XCIRegistry(classLoader);
        if (((XCIRegistry)object3).getDataProviderCount() == 0) {
            registryMap.put(classLoader, new WeakReference<XCIRegistry>(master));
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                charSequence = new StringBuilder("ClassLoader found no artifacts.  Returning master registry for classloader: ");
                ((StringBuilder)charSequence).append(classLoader != null ? classLoader.getClass().getName() : "null");
                ((StringBuilder)charSequence).append("\n");
                for (int i = 0; i < XCIRegistry.master.dataProviderFactories.size(); ++i) {
                    ((StringBuilder)charSequence).append(XCIRegistry.master.dataProviderFactories.get(i).toString());
                    ((StringBuilder)charSequence).append("\n");
                }
                logger.logp(Level.FINEST, logger.getName(), "getInstance(ClassLoader, boolean)", ((StringBuilder)charSequence).toString());
            }
            return master;
        }
        for (int i = 0; i < master.getDataProviderCount(); ++i) {
            object2 = master.getCursorFactoryRegistration(i);
            if (!bl && ((CursorFactoryRegistration)object2).getClassName() != null && ((XCIRegistry)object3).getDataProviderID(((CursorFactoryRegistration)object2).getClassName()) < 0) {
                ((XCIRegistry)object3).registerDataProvider((CursorFactoryRegistration)object2);
                continue;
            }
            if (((CursorFactoryRegistration)object2).getClassName() != null || super.getPreparerID(((CursorFactoryRegistration)object2).getPreparerClass()) >= 0) continue;
            ((XCIRegistry)object3).registerDataProvider((CursorFactoryRegistration)object2);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder("Returning new registry for classloader: ");
            stringBuilder.append(classLoader != null ? classLoader.getClass().getName() : "null");
            stringBuilder.append("\n");
            for (int i = 0; i < ((XCIRegistry)object3).dataProviderFactories.size(); ++i) {
                stringBuilder.append(((XCIRegistry)object3).dataProviderFactories.get(i).toString());
                stringBuilder.append("\n");
            }
            logger.logp(Level.FINEST, logger.getName(), "getInstance(ClassLoader, boolean)", stringBuilder.toString());
        }
        registryMap.put(classLoader, new WeakReference<Object>(object3));
        return object3;
    }

    public static XCIRegistry newEmptyInstance() {
        return new XCIRegistry();
    }

    public XCIRegistry() {
        this(XCIRegistry.class.getClassLoader());
    }

    private XCIRegistry(ClassLoader classLoader) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "XCIRegistry", "ClassLoader: " + (classLoader == null ? "NULL, Use System ClassLoader: " + ClassLoader.getSystemClassLoader().getClass().getName() : classLoader.getClass().getName()));
        }
        try {
            String string2 = REGISTRATION_PROPERTIES_FILENAME.substring(0, REGISTRATION_PROPERTIES_FILENAME.length() - SUFFIX.length());
            string2 = string2.replace('.', '/').concat(SUFFIX);
            Enumeration<URL> enumeration = classLoader != null ? classLoader.getResources(string2) : ClassLoader.getSystemResources(string2);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                InputStream inputStream = uRL.openStream();
                if (inputStream != null) {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    Enumeration<Object> enumeration2 = properties.keys();
                    while (enumeration2.hasMoreElements()) {
                        String string3 = (String)enumeration2.nextElement();
                        String string4 = properties.getProperty(string3);
                        if (string4 == null || "".equals(string4)) {
                            if (!LoggerUtil.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) continue;
                            logger.logp(Level.FINER, logger.getName(), "XCIRegistry", "Warning: Missing classname for factory: " + string3 + ".  It will be ignored.\n");
                            continue;
                        }
                        if (this.getDataProviderID(string3) >= 0 || this.getPreparerID(string3) >= 0) continue;
                        this.registerFactoryFromProperties(string4, classLoader);
                    }
                    continue;
                }
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANNOT_OPEN_FACTORIES", null));
            }
        }
        catch (IOException iOException) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANNOT_OPEN_FACTORIES", null), iOException);
        }
    }

    private void registerFactoryFromProperties(String string2, ClassLoader classLoader) {
        Properties properties = null;
        try {
            properties = XCIRegistry.loadProperties(string2, classLoader);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XCIDynamicErrorException(illegalArgumentException);
        }
        if (null != properties) {
            String string3 = this.processClass(properties);
            String[] stringArray = this.processContentType(properties);
            String[] stringArray2 = this.processObjectClassNames(properties);
            Cursor.Profile profile = this.processFeaturesLimit(properties);
            String[] stringArray3 = this.processStringList(PROP_HINTS, properties);
            String[] stringArray4 = this.processStringList(PROP_LANGUAGES, properties);
            short s = this.processPriority(properties);
            Class<?> clazz = this.processPreparer(properties, classLoader);
            String string4 = this.processVersionString(properties);
            String[] stringArray5 = this.processTreeClassNames(properties);
            CursorFactoryRegistration cursorFactoryRegistration = classLoader == XCIRegistry.class.getClassLoader() ? new MasterCursorFactoryRegistration(string3, stringArray, stringArray2, profile, stringArray3, s, clazz, stringArray4, stringArray5, string4) : new CursorFactoryRegistration(string3, stringArray, stringArray2, profile, stringArray3, s, clazz, stringArray4, stringArray5, string4);
            this.registerDataProvider(cursorFactoryRegistration);
        }
    }

    void registerDataProvider(CursorFactoryRegistration cursorFactoryRegistration) {
        this.dataProviderFactories.add(cursorFactoryRegistration);
    }

    private Class<?> processPreparer(Properties properties, ClassLoader classLoader) {
        Class<?> clazz;
        String string2;
        block7: {
            string2 = properties.getProperty(PROP_PREPARER);
            if (string2 == null) {
                return null;
            }
            clazz = null;
            try {
                if (classLoader != null) {
                    clazz = classLoader.loadClass(string2);
                    break block7;
                }
                ClassLoader classLoader2 = null;
                try {
                    classLoader2 = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            return ClassLoader.getSystemClassLoader();
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                clazz = classLoader2 == null ? Class.forName(string2) : classLoader2.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null && LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "processPreparer", "Warning: Preparer class not found: " + string2 + " \n");
        }
        return clazz;
    }

    private String processClass(Properties properties) {
        String string2 = properties.getProperty(PROP_CLASS);
        return string2;
    }

    private short processPriority(Properties properties) {
        String string2 = properties.getProperty(PROP_PRIORITY);
        short s = string2 != null ? Short.parseShort(string2) : (short)0;
        return s;
    }

    private String[] processStringList(String string2, Properties properties) {
        String[] stringArray = null;
        String string3 = properties.getProperty(string2);
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|", false);
            int n2 = stringTokenizer.countTokens();
            stringArray = new String[n2];
            int n3 = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string4;
                stringArray[n3] = string4 = ((String)stringTokenizer.nextElement()).trim();
                ++n3;
            }
        }
        return stringArray;
    }

    private Cursor.Profile processFeaturesLimit(Properties properties) {
        Cursor.Profile profile = null;
        String string2 = properties.getProperty(PROP_FEATURESLIMIT);
        if (string2 == null) {
            return Cursor.RANDOM_ACCESS;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string3 = null;
            try {
                string3 = ((String)stringTokenizer.nextElement()).trim();
                Field field = Cursor.Profile.class.getField(string3);
                profile = profile == null ? (Cursor.Profile)field.get(null) : profile.union((Cursor.Profile)field.get(null));
            }
            catch (SecurityException securityException) {
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANNOT_PROCESS_FEATURELIST", new String[]{string3}), securityException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANNOT_PROCESS_FEATURELIST", new String[]{string3}), noSuchFieldException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANNOT_PROCESS_FEATURELIST", new String[]{string3}), illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANNOT_PROCESS_FEATURELIST", new String[]{string3}), illegalAccessException);
            }
            ++n2;
        }
        return profile;
    }

    private String[] processObjectClassNames(Properties properties) {
        return this.parseUnionListOfNames(properties.getProperty(PROP_OBJECTMATCH));
    }

    private String[] parseUnionListOfNames(String string2) {
        String[] stringArray;
        if (null != string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
            int n2 = stringTokenizer.countTokens();
            stringArray = new String[n2];
            int n3 = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string3;
                stringArray[n3] = string3 = ((String)stringTokenizer.nextElement()).trim();
                ++n3;
            }
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private String[] processTreeClassNames(Properties properties) {
        return this.parseUnionListOfNames(properties.getProperty(PROP_TREEMATCH));
    }

    private String[] processContentType(Properties properties) {
        String[] stringArray;
        String string2 = properties.getProperty(PROP_CONTENTTYPE);
        if (null != string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
            int n2 = stringTokenizer.countTokens();
            stringArray = new String[n2];
            int n3 = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string3;
                stringArray[n3] = string3 = ((String)stringTokenizer.nextElement()).trim();
                ++n3;
            }
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private String processVersionString(Properties properties) {
        String string2 = properties.getProperty(PROP_VERSIONSTRING);
        return string2;
    }

    int findBestScoreIndex(Class<?> clazz, RequestInfo requestInfo, String string2, ClassLoader classLoader) {
        int n2;
        int n3 = this.dataProviderFactories.size();
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            String[] stringArray;
            Class<?> clazz2;
            int n4;
            CursorFactoryRegistration cursorFactoryRegistration = this.dataProviderFactories.get(n2);
            if (cursorFactoryRegistration.getClassName() == null) continue;
            Class<?>[] classArray = cursorFactoryRegistration.getSourceClasses(classLoader);
            if (null != classArray) {
                boolean bl = false;
                for (n4 = 0; n4 < classArray.length; ++n4) {
                    clazz2 = classArray[n4];
                    if (null == clazz2 || null == clazz) continue;
                    if (clazz2.isAssignableFrom(clazz)) {
                        bl = true;
                        break;
                    }
                    if (clazz != Result.class && clazz != Source.class || !clazz.isAssignableFrom(clazz2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    nArray[n2] = -1;
                    continue;
                }
                int n5 = n2;
                nArray[n5] = nArray[n5] + 1;
            }
            if (null != string2 && null != (stringArray = cursorFactoryRegistration.getcontentType())) {
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    clazz2 = stringArray[n4];
                }
            }
            int n6 = n2;
            nArray[n6] = nArray[n6] + this.getScoreForRequest(cursorFactoryRegistration, requestInfo);
        }
        n2 = 0;
        int n7 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
            n7 = i;
        }
        return n7;
    }

    private int getScoreForRequest(CursorFactoryRegistration cursorFactoryRegistration, RequestInfo requestInfo) {
        String[] stringArray;
        Object object2;
        int n2 = 0;
        Cursor.Profile profile = cursorFactoryRegistration.getFeatureLimit();
        Cursor.Profile profile2 = requestInfo.getNeededFeatures();
        if (profile != null) {
            if (profile2.equals(profile)) {
                n2 += 2;
            } else if (profile2.containedIn(profile)) {
                ++n2;
            } else {
                object2 = profile2.difference(profile);
                if (((Cursor.Profile)object2).overlap(UPDATE_FEATURES)) {
                    n2 -= 2;
                }
            }
        }
        if ((object2 = requestInfo.getHints()) != null && (stringArray = cursorFactoryRegistration.getHints()) != null) {
            for (int i = 0; i < ((Object)object2).length; ++i) {
                Object object3 = object2[i];
                for (int j = 0; j < stringArray.length; ++j) {
                    String string2 = stringArray[j];
                    if (!((String)object3).equals(string2)) continue;
                    n2 += Hints.getWeight((String)object3);
                }
            }
        }
        return n2;
    }

    int findBestScoreIndex(TreeConstructionKind treeConstructionKind, RequestInfo requestInfo, ClassLoader classLoader) {
        int n2;
        Class<?> clazz = treeConstructionKind.getClass();
        int n3 = this.dataProviderFactories.size();
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            Class<?>[] classArray;
            CursorFactoryRegistration cursorFactoryRegistration = this.dataProviderFactories.get(n2);
            if (cursorFactoryRegistration.getClassName() == null || null == (classArray = cursorFactoryRegistration.getTreeConstructionKinds(classLoader))) continue;
            boolean bl = false;
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                if (null == clazz2 || null == clazz || !clazz2.isAssignableFrom(clazz)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                nArray[n2] = -1;
                continue;
            }
            int n4 = n2;
            nArray[n4] = nArray[n4] + 1;
        }
        n2 = 0;
        int n5 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
            n5 = i;
        }
        return n5;
    }

    CursorFactoryRegistration getCursorFactoryRegistration(int n2) {
        return this.dataProviderFactories.get(n2);
    }

    public int getDataProviderID(String string2) {
        int n2 = this.dataProviderFactories.size();
        for (int i = 0; i < n2; ++i) {
            CursorFactoryRegistration cursorFactoryRegistration = this.dataProviderFactories.get(i);
            if (cursorFactoryRegistration.getClassName() == null || !cursorFactoryRegistration.getClassName().equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private int getPreparerID(Class<?> clazz) {
        int n2 = this.dataProviderFactories.size();
        for (int i = 0; i < n2; ++i) {
            CursorFactoryRegistration cursorFactoryRegistration = this.dataProviderFactories.get(i);
            if (cursorFactoryRegistration.getClassName() != null || cursorFactoryRegistration.getPreparerClass() != clazz) continue;
            return i;
        }
        return -1;
    }

    private int getPreparerID(String string2) {
        int n2 = this.dataProviderFactories.size();
        for (int i = 0; i < n2; ++i) {
            CursorFactoryRegistration cursorFactoryRegistration = this.dataProviderFactories.get(i);
            if (cursorFactoryRegistration.getClassName() != null || !cursorFactoryRegistration.getPreparerClass().getName().equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public int getDataProviderCount() {
        return this.dataProviderFactories.size();
    }

    void printRegisteredDataProviderString() {
        for (int i = 0; i < this.dataProviderFactories.size(); ++i) {
            System.out.println(this.dataProviderFactories.get(i));
        }
    }

    int getNumRegisteredDataProviderFactories() {
        return this.dataProviderFactories.size();
    }

    private static void registerSDOX() {
        block8: {
            if (master.getDataProviderID("com.ibm.websphere.sdox.SDOCursorFactory") < 0) {
                try {
                    final Class<?> clazz = Class.forName("com.ibm.ws.bootstrap.ExtClassLoader");
                    final Method method = (Method)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                return clazz.getDeclaredMethod("getInstance", new Class[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, logger.getName(), "registerSDOX", "Could not find the getInstance method : " + noSuchMethodException.getMessage());
                                }
                                throw new XCIDynamicErrorException(noSuchMethodException);
                            }
                        }
                    });
                    final ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            try {
                                return (ClassLoader)method.invoke(null, null);
                            }
                            catch (Exception exception) {
                                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, logger.getName(), "registerSDOX", "Could not get instance of com.ibm.ws.bootstrap.ExtClassLoader: " + exception.getMessage());
                                }
                                throw new XCIDynamicErrorException(exception);
                            }
                        }
                    });
                    Class clazz2 = (Class)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                return classLoader.loadClass("com.ibm.websphere.sdox.SDOCursorFactory");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, logger.getName(), "registerSDOX", "Could not load class com.ibm.websphere.sdox.SDOCursorFactory using com.ibm.ws.bootstrap.ExtClassLoader: " + classNotFoundException.getMessage());
                                }
                                throw new XCIDynamicErrorException(classNotFoundException);
                            }
                        }
                    });
                    SDOCursorFactoryRegistration sDOCursorFactoryRegistration = new SDOCursorFactoryRegistration(clazz2, null, null, null, null, 1, Class.forName("com.ibm.xml.xci.spi.config.AxisPreparerDelegator"), null, null);
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, logger.getName(), "registerSDOX", "SDOCursoryFactory was successfully loaded with com.ibm.ws.bootstrap.ExtClassLoader.");
                    }
                    master.registerDataProvider(sDOCursorFactoryRegistration);
                    XCIRegistry.checkSDOXRelease(classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, logger.getName(), "registerSDOX", "Could not load the SDOCursorFactory using com.ibm.ws.bootstrap.ExtClassLoader", classNotFoundException);
                    }
                    break block8;
                }
                catch (Exception exception) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, logger.getName(), "registerSDOX", "Could not load the SDOCursorFactory using com.ibm.ws.bootstrap.ExtClassLoader", exception);
                    }
                    break block8;
                }
            }
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "registerSDOX", "SDOCursoryFactory is registered via properties file lookup.");
            }
            XCIRegistry.checkSDOXRelease(null);
        }
    }

    private static void checkSDOXRelease(final ClassLoader classLoader) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Class<?> clazz = null;
                try {
                    clazz = classLoader == null ? Class.forName("com.ibm.websphere.sdox.SDOCursorFactory") : Class.forName("com.ibm.websphere.sdox.SDOCursorFactory", true, classLoader);
                    Annotation[] annotationArray = clazz.getAnnotations();
                    boolean bl = false;
                    for (int i = 0; i < annotationArray.length; ++i) {
                        if (!"PostGM".equals(annotationArray[i].annotationType().getSimpleName())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        SDOClass = clazz;
                    }
                }
                catch (Exception exception) {
                    SDOClass = null;
                }
                return null;
            }
        });
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            if (SDOClass == null) {
                logger.logp(Level.FINE, logger.getName(), "registerSDOX", "Post GM 1.0 version of SDOCursorFactory. ");
            } else {
                logger.logp(Level.FINE, logger.getName(), "registerSDOX", "GM 1.0 version of SDOCursorFactory.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String string2, ClassLoader classLoader) {
        assert (string2 != null);
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith(SUFFIX)) {
            string2 = string2.substring(0, string2.length() - SUFFIX.length());
        }
        Properties properties = null;
        InputStream inputStream = null;
        try {
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            string2 = string2.replace('/', '.');
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, Locale.getDefault(), classLoader);
            properties = new Properties();
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                String string4 = resourceBundle.getString(string3);
                properties.put(string3, string4);
            }
        }
        catch (Exception exception) {
            properties = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (properties == null) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "loadProperties", "Warning: Could not load properties file: " + string2 + " using classloader: " + classLoader.getClass().getName());
            }
        } else if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, logger.getName(), "loadProperties", "Loaded properties file: " + string2 + " using classloader: " + classLoader.getClass().getName() + "\nProperties: " + properties.toString());
        }
        return properties;
    }

    public Class postGMSDORegistered() {
        return SDOClass;
    }

    static {
        builtInAdapters.add("com.ibm.xml.xci.adapters.dom.DOMCursorFactory");
        builtInAdapters.add("com.ibm.xml.xci.adapters.xlxp.XLXPCursorFactory");
        builtInAdapters.add("com.ibm.xml.xci.serializer.SerializerCursorFactory");
        builtInAdapters.add("com.ibm.xml.xci.dp.cache.dom.CacheCursorFactory");
        builtInAdapters.add("com.ibm.xltxe.rnm1.xtq.xci.dtm.ref.DTMManagerDefault");
        registryMap = Collections.synchronizedMap(new WeakHashMap());
        InstrumentationHandler.getExternalLogger();
        UPDATE_FEATURES = Cursor.RANDOM_UPDATE.difference(Cursor.RANDOM_ACCESS);
    }
}

