/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.Predicate;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.adapters.dom.DOMDocumentInfo;
import com.ibm.xml.xci.adapters.dom.DOMUtils;
import com.ibm.xml.xci.adapters.dom.NodeVectorLazy;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.serialize.SerializedCData;
import com.ibm.xml.xci.dp.util.EmptyCData;
import com.ibm.xml.xci.dp.util.StringCDataBuilder;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.errors.XCIIllegalContextItemException;
import com.ibm.xml.xci.errors.XCIIllegalMutationException;
import com.ibm.xml.xci.internal.values.QNameCDataAbstract;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.ElementPSVI;
import com.ibm.xml.xml4j.api.s1.xs.ItemPSVI;
import com.ibm.xml.xml4j.api.s1.xs.ShortList;
import com.ibm.xml.xml4j.api.s1.xs.StringList;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSException;
import com.ibm.xml.xml4j.api.s1.xs.XSModel;
import com.ibm.xml.xml4j.api.s1.xs.XSNotationDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.dom.AttrNSImpl;
import com.ibm.xml.xml4j.internal.s1.dom.ElementNSImpl;
import com.ibm.xml.xml4j.internal.s1.dom.PSVIAttrNSImpl;
import com.ibm.xml.xml4j.internal.s1.dom.PSVIElementNSImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class DOMAdapter {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger s_logger = LoggerUtil.getLogger(DOMAdapter.class);
    private static final String s_className = DOMAdapter.class.getName();
    protected static final Cursor.Profile FEATURES = Cursor.RANDOM_UPDATE.union(Cursor.Profile.SET_PSVI).union(Cursor.Profile.ALWAYS_VALID).union(Cursor.Profile.XSPSVINFO);
    private static final String DTD_TYPE_NAMESPACE = "http://www.w3.org/TR/REC-xml";
    private static final String DEBUG_PROPERTY = DOMAdapter.class.getCanonicalName();
    private static final boolean USE_STACK_DISCIPLINE_DOMCURSOR;
    private static final boolean USE_ALPHABETICAL_ATTRIBUTE_ORDER;
    private static final boolean USE_REVERSE_ALPHABETICAL_ATTRIBUTE_ORDER;
    protected Document fDocument;
    protected Node fRoot;
    protected HashMap<String, Object> fIDREFAttributes;
    protected HashMap<String, Node> fIDAttributes;
    private DOMDocumentInfo fDocumentInfo;
    private long fDocumentIdentity;
    private boolean fHasPSVI = false;
    private static final VolatileCData EMPTY_RESULT;

    public static DOMAdapter makeAdapter(CursorFactory cursorFactory, Node node2, RequestInfo requestInfo, DOMErrorHandler dOMErrorHandler) {
        return new DOMAdapter(cursorFactory, node2, requestInfo, dOMErrorHandler);
    }

    public static DOMCursor makeCursor(CursorFactory cursorFactory, Node node2, RequestInfo requestInfo, DOMErrorHandler dOMErrorHandler) {
        DOMAdapter dOMAdapter = DOMAdapter.makeAdapter(cursorFactory, node2, requestInfo, dOMErrorHandler);
        dOMAdapter.getClass();
        return dOMAdapter.new DOMCursor(node2, requestInfo.getProfile(), cursorFactory);
    }

    public DOMAdapter(CursorFactory cursorFactory, Node node2, RequestInfo requestInfo, DOMErrorHandler dOMErrorHandler) {
        Map<String, Object> map2 = requestInfo.getParameters();
        TypeRegistry typeRegistry = cursorFactory.getSessionContext().getTypeRegistry();
        this.fDocument = (Document)(node2.getNodeType() == 9 ? node2 : node2.getOwnerDocument());
        this.fHasPSVI = this.fDocument.getImplementation().hasFeature("psvi", "3.0");
        this.fDocumentInfo = map2 != null && (map2.containsKey("http://xml.ibm.com/xci/mutation/document-uri") || map2.containsKey("http://xml.ibm.com/xci/mutation/base-uri")) ? new DOMDocumentInfo(this.fDocument, typeRegistry, (String)map2.get("http://xml.ibm.com/xci/mutation/document-uri")) : new DOMDocumentInfo(this.fDocument, typeRegistry);
        this.fDocumentInfo.setErrorHandler(dOMErrorHandler);
        this.fDocumentIdentity = cursorFactory.getSessionContext().obtainUniqueDocumentIdentity();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "DOMAdapter", "Created new DOMAdapter instance with document identity " + this.fDocumentIdentity + " for node '" + node2.toString() + "' with base URI '" + node2.getBaseURI() + "' using RequestInfo options '" + requestInfo.getEncoding() + "'");
        }
    }

    protected DOMAdapter(DOMAdapter dOMAdapter, Cursor.Profile profile) {
        this.fDocument = dOMAdapter.fDocument;
        this.fIDREFAttributes = dOMAdapter.fIDREFAttributes;
        this.fIDAttributes = dOMAdapter.fIDAttributes;
        this.fHasPSVI = dOMAdapter.fHasPSVI;
        this.fDocumentInfo = dOMAdapter.fDocumentInfo;
    }

    protected static Node getRoot(Node node2) {
        Node node3;
        Node node4 = node2;
        Node node5 = node3 = node2.getNodeType() == 2 ? ((Attr)node4).getOwnerElement() : node4.getParentNode();
        while (node3 != null) {
            node4 = node3;
            node3 = node4.getParentNode();
        }
        return node4;
    }

    protected static boolean isNamespace(Node node2) {
        if (null == node2 || node2.getNodeType() != 2) {
            return false;
        }
        return "xmlns".equals(node2.getPrefix()) || "xmlns".equals(node2.getNodeName());
    }

    protected static final boolean isText(short s) {
        return s == 3 || s == 4;
    }

    static boolean isValidXDMNodeKind(short s) {
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static String getVolatileCDataStringValue(VolatileCData volatileCData) {
        String string2;
        if (volatileCData.isEmptySequence()) {
            string2 = "";
        } else {
            string2 = volatileCData.getString(1);
            if (volatileCData.hasItemAt(2)) {
                StringBuilder stringBuilder = new StringBuilder(string2);
                int n2 = 2;
                do {
                    stringBuilder.append(' ');
                    stringBuilder.append(volatileCData.getString(n2));
                } while (volatileCData.hasItemAt(++n2));
                string2 = stringBuilder.toString();
            }
        }
        return string2;
    }

    static short compareDocumentPosition(Node node2, Node node3) {
        int n2 = 0;
        if (node3 instanceof NamespaceNodeImpl) {
            n2 = node3.compareDocumentPosition(node2);
            if ((n2 & 6) != 0) {
                n2 = (short)(n2 ^ 6);
            }
        } else {
            boolean bl = false;
            if (node2.getNodeType() == 2 && node3.getNodeType() == 2) {
                Element element2;
                Element element3;
                boolean bl2;
                boolean bl3 = DOMAdapter.isNamespace(node2);
                if (bl3 ^ (bl2 = DOMAdapter.isNamespace(node3))) {
                    Element element4;
                    Element element5 = ((Attr)node2).getOwnerElement();
                    if (element5 != null && (element4 = ((Attr)node3).getOwnerElement()) != null && element5.isSameNode(element4)) {
                        bl = true;
                        n2 = bl3 ? 4 : 2;
                    }
                } else if ((USE_ALPHABETICAL_ATTRIBUTE_ORDER || USE_REVERSE_ALPHABETICAL_ATTRIBUTE_ORDER) && !bl3 && (element3 = ((Attr)node2).getOwnerElement()) != null && (element2 = ((Attr)node3).getOwnerElement()) != null && element3.isSameNode(element2)) {
                    bl = true;
                    int n3 = node2.getNodeName().compareTo(node3.getNodeName());
                    if (n3 < 0) {
                        n2 = USE_ALPHABETICAL_ATTRIBUTE_ORDER ? 4 : 2;
                    } else if (n3 > 0) {
                        int n4 = n2 = USE_REVERSE_ALPHABETICAL_ATTRIBUTE_ORDER ? 2 : 4;
                    }
                }
            }
            if (!bl) {
                n2 = node2.compareDocumentPosition(node3);
            }
        }
        return (short)n2;
    }

    static {
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(DEBUG_PROPERTY);
            }
        });
        USE_STACK_DISCIPLINE_DOMCURSOR = "stack".equals(string2);
        USE_ALPHABETICAL_ATTRIBUTE_ORDER = "ascendingorder".equals(string2);
        USE_REVERSE_ALPHABETICAL_ATTRIBUTE_ORDER = "descendingorder".equals(string2);
        EMPTY_RESULT = new EmptyCData(TypeRegistry.XSANYSIMPLETYPE);
    }

    private static class AttributePSVIForSimpleUrType
    extends ItemPSVIForUrTypes
    implements AttributePSVI {
        private String fValue;

        private AttributePSVIForSimpleUrType() {
        }

        public void setValue(String string2) {
            this.fValue = string2;
        }

        public XSTypeDefinition getTypeDefinition() {
            return TypeRegistry.XSANYSIMPLETYPE;
        }

        public XSAttributeDeclaration getAttributeDeclaration() {
            return null;
        }

        public XSNotationDeclaration getNotation() {
            return null;
        }

        public XSModel getSchemaInformation() {
            return null;
        }

        public Object getActualNormalizedValue() throws XSException {
            return this.fValue;
        }

        public short getActualNormalizedValueType() throws XSException {
            return 1;
        }

        public StringList getErrorCodes() {
            return null;
        }

        public StringList getErrorMessages() {
            return null;
        }

        public boolean getIsSchemaSpecified() {
            return false;
        }

        public ShortList getItemValueTypes() throws XSException {
            return null;
        }

        public XSSimpleTypeDefinition getMemberTypeDefinition() {
            return null;
        }

        public String getSchemaDefault() {
            return null;
        }

        public String getSchemaNormalizedValue() {
            return this.fValue;
        }

        public String getValidationContext() {
            return null;
        }
    }

    private static class ElementPSVIForUrType
    extends ItemPSVIForUrTypes
    implements ElementPSVI {
        public static ElementPSVIForUrType INSTANCE = new ElementPSVIForUrType();

        private ElementPSVIForUrType() {
        }

        public XSTypeDefinition getTypeDefinition() {
            return TypeRegistry.XSANYTYPE;
        }

        public XSElementDeclaration getElementDeclaration() {
            return null;
        }

        public boolean getNil() {
            return false;
        }
    }

    private static abstract class ItemPSVIForUrTypes
    implements ItemPSVI {
        private ItemPSVIForUrTypes() {
        }

        public XSNotationDeclaration getNotation() {
            return null;
        }

        public XSModel getSchemaInformation() {
            return null;
        }

        public Object getActualNormalizedValue() throws XSException {
            return null;
        }

        public short getActualNormalizedValueType() throws XSException {
            return 45;
        }

        public StringList getErrorCodes() {
            return null;
        }

        public StringList getErrorMessages() {
            return null;
        }

        public boolean getIsSchemaSpecified() {
            return false;
        }

        public ShortList getItemValueTypes() throws XSException {
            return null;
        }

        public XSSimpleTypeDefinition getMemberTypeDefinition() {
            return null;
        }

        public String getSchemaDefault() {
            return null;
        }

        public String getSchemaNormalizedValue() {
            return null;
        }

        public String getValidationContext() {
            return null;
        }

        public short getValidationAttempted() {
            return 1;
        }

        public short getValidity() {
            return 0;
        }
    }

    public class DOMSequence
    extends DOMCursor {
        NodeVectorLazy _nodes;
        int _position;
        boolean _needsCloneBeforeMutate;
        static final int DEFAULT_STACK_SIZE = 32;
        protected DOMCursor populatingXCI;
        int[] populatingXCIRefCount;

        public DOMSequence(DOMCursor dOMCursor, boolean bl, boolean bl2) {
            super(dOMCursor.fNode, Cursor.Profile.SEQUENCE, dOMCursor.factory());
            this._needsCloneBeforeMutate = false;
            assert (this.factory != null);
            this._nodes = new NodeVectorLazy();
            if (bl) {
                this.checkListBeforeMutate();
                this._nodes.setLazy(true);
                this._nodes.addElement(dOMCursor.fNode);
                this.populatingXCI = bl2 ? dOMCursor : (DOMCursor)dOMCursor.fork(false);
                this.populatingXCIRefCount = new int[1];
                this.populatingXCIRefCount[0] = 1;
            } else {
                boolean bl3;
                this.checkListBeforeMutate();
                boolean bl4 = dOMCursor.contextIsOrdered(true);
                boolean bl5 = this._nodes.addElement(dOMCursor.fNode);
                boolean bl6 = bl3 = bl5 && bl4;
                while (dOMCursor.toNext()) {
                    this.checkListBeforeMutate();
                    this._nodes.addElement(dOMCursor.fNode, bl3);
                }
                this._nodes.setLazy(false);
            }
        }

        public DOMSequence(DOMCursor dOMCursor, boolean bl) {
            super(dOMCursor.fNode, Cursor.Profile.SEQUENCE, dOMCursor.factory());
            this._needsCloneBeforeMutate = false;
            assert (this.factory != null);
            this._nodes = new NodeVectorLazy();
            if (bl) {
                this.checkListBeforeMutate();
                this._nodes.addElement(dOMCursor.fNode);
                this._nodes.setLazy(false);
            } else {
                boolean bl2;
                this.checkListBeforeMutate();
                boolean bl3 = dOMCursor.contextIsOrdered(true);
                boolean bl4 = this._nodes.addElement(dOMCursor.fNode);
                boolean bl5 = bl2 = bl4 && bl3;
                while (dOMCursor.toNext()) {
                    this.checkListBeforeMutate();
                    this._nodes.addElement(dOMCursor.fNode, bl2);
                }
                this._nodes.setLazy(false);
            }
        }

        public DOMSequence(DOMSequence dOMSequence) {
            super(dOMSequence.fNode, Cursor.Profile.SEQUENCE, dOMSequence.factory());
            this._needsCloneBeforeMutate = false;
            assert (this.factory != null);
            this._needsCloneBeforeMutate = true;
            dOMSequence._needsCloneBeforeMutate = true;
            this._nodes = dOMSequence._nodes;
            DOMCursor dOMCursor = dOMSequence.populatingXCI;
            if (dOMCursor != null) {
                this.populatingXCI = dOMCursor;
                this.populatingXCIRefCount = dOMSequence.populatingXCIRefCount;
                this.populatingXCIRefCount[0] = this.populatingXCIRefCount[0] + 1;
            } else {
                this.populatingXCI = null;
                this.populatingXCIRefCount = null;
            }
            this._position = dOMSequence._position;
        }

        void checkListBeforeMutate() {
            if (this._needsCloneBeforeMutate) {
                if (this._nodes == null) {
                    this._nodes = new NodeVectorLazy();
                    this._nodes.addElement(this.fNode);
                } else {
                    this._nodes = new NodeVectorLazy(this._nodes);
                }
                this._needsCloneBeforeMutate = false;
            } else if (this._nodes == null) {
                this._nodes = new NodeVectorLazy();
                this._nodes.addElement(this.fNode);
            }
        }

        public Cursor sequenceConcat(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            if (cursor2 == null) {
                DOMSequence dOMSequence;
                Cursor cursor3 = dOMSequence = bl3 ? this : this.fork(bl, profile, profile2);
                if (bl) {
                    dOMSequence.toSelf();
                }
                return dOMSequence;
            }
            if (cursor2 instanceof DOMCursor && this.itemIsSameDocument(cursor2)) {
                Cursor cursor4 = DOMSequence.ownTheCursor(this, bl, bl3);
                if (cursor4 instanceof DOMSequence) {
                    DOMSequence dOMSequence = (DOMSequence)cursor4;
                    DOMCursor dOMCursor = (DOMCursor)DOMSequence.ownTheCursorIfMightMove(cursor2, bl2, bl4);
                    assert (dOMCursor.fNode != null);
                    this.checkListBeforeMutate();
                    if (dOMSequence._nodes.isLazy()) {
                        dOMSequence.fullyPopulate();
                    }
                    if (bl2) {
                        dOMSequence._nodes.addElement(dOMCursor.fNode);
                    } else {
                        boolean bl5;
                        boolean bl6 = dOMCursor.contextIsOrdered(true);
                        boolean bl7 = dOMSequence._nodes.addElement(dOMCursor.fNode);
                        boolean bl8 = bl5 = bl6 && bl7;
                        while (dOMCursor.toNext()) {
                            dOMSequence._nodes.addElement(dOMCursor.fNode, bl5);
                        }
                    }
                    dOMSequence._nodes.setLazy(false);
                    DOMSequence.ownedCleanupIfMightMove(dOMCursor, bl2, true);
                    return dOMSequence;
                }
                bl3 = true;
            }
            return super.sequenceConcat(cursor2, profile, profile2, bl, bl2, bl3, bl4);
        }

        public VolatileCData serialize(Map map2) {
            return super.serialize(map2);
        }

        public boolean contextIsLive() {
            return false;
        }

        public boolean contextIsOrdered(boolean bl) {
            if (this._nodes == null) {
                return super.contextIsOrdered(bl);
            }
            if (this._nodes.isLazy()) {
                boolean bl2 = this._nodes.isForwardOrderedAndUnique();
                if (bl2) {
                    if (this.populatingXCI.toNext()) {
                        this._nodes.addElement(this.populatingXCI.fNode);
                        return this._nodes.isForwardOrderedAndUnique() && this.populatingXCI.contextIsOrdered(bl);
                    }
                    this.releasePopulatingXCI();
                    this._nodes.setLazy(false);
                    return true;
                }
                return false;
            }
            return this._nodes.isForwardOrderedAndUnique();
        }

        public boolean contextIsSingleDoc() {
            if (this._nodes == null) {
                return super.contextIsSingleDoc();
            }
            if (this.populatingXCI != null) {
                return this.populatingXCI.contextIsNodesOnly();
            }
            Node node2 = this._nodes.elementAt(0);
            Node node3 = DOMAdapter.getRoot(node2);
            for (int i = 1; i < this._nodes.size(); ++i) {
                Node node4;
                Node node5 = this._nodes.elementAt(i);
                if (node2 == node5 || (node4 = DOMAdapter.getRoot(node5)) == node3 || node4.isSameNode(node3)) continue;
                return false;
            }
            return true;
        }

        public boolean contextIsSingleton() {
            if (this._nodes == null) {
                return super.contextIsSingleton();
            }
            if (this._nodes.isLazy()) {
                if (this._nodes.size() > 1) {
                    return false;
                }
                if (this.populatingXCI.toNext()) {
                    this._nodes.addElement(this.populatingXCI.fNode);
                } else {
                    this.releasePopulatingXCI();
                    this._nodes.setLazy(false);
                }
            }
            return this._nodes == null || this._nodes.size() == 1;
        }

        public long contextSize() {
            if (this._nodes == null) {
                return super.contextSize();
            }
            if (this._nodes.isLazy()) {
                this.fullyPopulate();
            }
            return this._nodes.size();
        }

        private void fullyPopulate() {
            if (this.populatingXCI.toNext()) {
                boolean bl;
                boolean bl2 = this.populatingXCI.contextIsOrdered(true);
                boolean bl3 = this._nodes.addElement(this.populatingXCI.fNode);
                boolean bl4 = bl = bl3 && bl2;
                while (this.populatingXCI.toNext()) {
                    this._nodes.addElement(this.populatingXCI.fNode, bl);
                }
            }
            this.populatingXCI.release();
            this.populatingXCI = null;
            this._nodes.setLazy(false);
            this.populatingXCIRefCount[0] = 0;
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (!bl) {
                return new DOMSequence(this);
            }
            if (Cursor.Profile.MINIMAL_NAVIGATION.containedIn(profile)) {
                assert (bl);
                DOMCursor dOMCursor = new DOMCursor(this.fNode, profile, this.factory());
                return dOMCursor;
            }
            DOMCursor dOMCursor = new DOMCursor(this.fNode, profile, this.factory());
            return dOMCursor;
        }

        public void release() {
            this._nodes = null;
            this.releasePopulatingXCI();
            super.release();
        }

        void releasePopulatingXCI() {
            if (this.populatingXCI != null) {
                this.populatingXCIRefCount[0] = this.populatingXCIRefCount[0] - 1;
                if (this.populatingXCIRefCount[0] == 0) {
                    this.populatingXCI.release();
                }
                this.populatingXCI = null;
            }
        }

        public boolean toNext() {
            if (this._nodes == null) {
                return this.fContextSequenceMode == 0 || super.toNext();
            }
            if (this._nodes.isLazy()) {
                if (this.populatingXCI.toNext()) {
                    this._nodes.addElement(this.populatingXCI.fNode);
                } else {
                    this.populatingXCI.release();
                    this.populatingXCI = null;
                    this._nodes.setLazy(false);
                    this.populatingXCIRefCount[0] = 0;
                }
            }
            if (this._position + 1 < this._nodes.size()) {
                ++this._position;
                this.fNode = this._nodes.elementAt(this._position);
                return true;
            }
            return false;
        }

        private boolean cancelExistingSequence() {
            this._nodes = null;
            this.releasePopulatingXCI();
            this._position = 0;
            return true;
        }

        public boolean toSelf() {
            if (super.toSelf()) {
                return this.cancelExistingSequence();
            }
            return false;
        }

        public boolean toRoot() {
            if (super.toRoot()) {
                return this.cancelExistingSequence();
            }
            return false;
        }

        public boolean toPosition(long l) {
            if (this._nodes == null) {
                return super.toPosition(l);
            }
            if (this._nodes.isLazy() && --l >= 0L) {
                boolean bl = true;
                boolean bl2 = this.populatingXCI.contextIsOrdered(true);
                int n2 = this._position;
                while ((long)n2 < l) {
                    if (this.populatingXCI.toNext()) {
                        Node node2 = this.populatingXCI.fNode;
                        if (bl) {
                            bl2 = this._nodes.addElement(node2) && bl2;
                            bl = false;
                        } else {
                            this._nodes.addElement(node2, bl2);
                        }
                    } else {
                        this.populatingXCI.release();
                        this.populatingXCI = null;
                        this._nodes.setLazy(false);
                        this.populatingXCIRefCount[0] = 0;
                        break;
                    }
                    ++n2;
                }
            }
            if (l >= 0L && l < (long)this._nodes.size()) {
                this._position = (int)l;
                this.fNode = this._nodes.elementAt(this._position);
                return true;
            }
            return false;
        }

        public boolean toPrevious() {
            if (this._position - 1 > 0) {
                --this._position;
                return true;
            }
            return false;
        }

        public boolean toAttributes(NodeTest nodeTest) {
            if (super.toAttributes(nodeTest)) {
                return this.cancelExistingSequence();
            }
            return false;
        }

        public boolean toChildren(NodeTest nodeTest) {
            if (super.toChildren(nodeTest)) {
                return this.cancelExistingSequence();
            }
            return false;
        }

        public boolean toDescendants(NodeTest nodeTest) {
            if (super.toDescendants(nodeTest)) {
                return this.cancelExistingSequence();
            }
            return false;
        }

        public boolean toFollowingSibling() {
            if (super.toFollowingSibling()) {
                return this.cancelExistingSequence();
            }
            return false;
        }

        public boolean toIdrefs(VolatileCData volatileCData) {
            if (super.toIdrefs(volatileCData)) {
                return this.cancelExistingSequence();
            }
            return false;
        }

        public boolean toIds(VolatileCData volatileCData) {
            if (super.toIds(volatileCData)) {
                return this.cancelExistingSequence();
            }
            return false;
        }

        public boolean toNamespaceDecls() {
            if (super.toNamespaceDecls()) {
                return this.cancelExistingSequence();
            }
            return false;
        }

        public boolean toParent() {
            if (super.toParent()) {
                return this.cancelExistingSequence();
            }
            return false;
        }

        public boolean toPrecedingSibling() {
            if (super.toPrecedingSibling()) {
                return this.cancelExistingSequence();
            }
            return false;
        }

        public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
            if (this._nodes == null) {
                super.documentOrder(profile, profile2, bl);
            }
            if (this.contextIsOrdered(true)) {
                return bl ? this : (DOMSequence)this.fork(false);
            }
            if (this._nodes.isLazy()) {
                this.fullyPopulate();
            }
            DOMSequence dOMSequence = null;
            dOMSequence = bl ? this : new DOMSequence(this);
            dOMSequence.checkListBeforeMutate();
            dOMSequence._nodes.sortAndEliminateDups();
            dOMSequence._position = 0;
            dOMSequence.fNode = dOMSequence._nodes.elementAt(0);
            return dOMSequence;
        }

        public void setDocumentOrdered(boolean bl) {
            this._nodes.setForwardOrderedAndUnique(bl);
        }

        protected int getInitialPosition() {
            return 0;
        }
    }

    public static class NamespaceNodeImpl
    implements Node,
    Attr {
        String m_value;
        String m_qname;
        String m_prefix;
        Node m_ownerElement;
        HashMap<String, Object> m_userData;
        private static final short COMPARE_MASK = -25;

        public NamespaceNodeImpl(String string2, String string3, Node node2) {
            this.m_prefix = string2;
            this.m_qname = string2.length() == 0 ? "xmlns" : "xmlns:" + string2;
            this.m_value = string3;
            this.m_ownerElement = node2;
        }

        public Node appendChild(Node node2) throws DOMException {
            throw XCIErrorHelper.createDOMException((short)7);
        }

        public Node cloneNode(boolean bl) {
            return new NamespaceNodeImpl(this.m_qname, this.m_value, null);
        }

        public short compareDocumentPosition(Node node2) throws DOMException {
            if (this.isSameNode(node2)) {
                return 0;
            }
            if (this.m_ownerElement.isSameNode(node2)) {
                return 10;
            }
            if (node2.getNodeType() == 1 || node2.getNodeType() == 9 || node2.getNodeType() == 11) {
                short s = this.m_ownerElement.compareDocumentPosition(node2);
                return (short)(s & 0xFFFFFFEF);
            }
            if (node2.getNodeType() == 2) {
                Attr attr2 = (Attr)node2;
                Element element2 = attr2.getOwnerElement();
                if (element2 == null) {
                    return this.m_ownerElement.compareDocumentPosition(node2);
                }
                if (this.m_ownerElement.isSameNode(element2)) {
                    if (node2 instanceof NamespaceNodeImpl) {
                        int n2 = this.getLocalName().compareTo(node2.getLocalName());
                        if (n2 < 0) {
                            return 36;
                        }
                        if (n2 > 0) {
                            return 34;
                        }
                        return 0;
                    }
                    return 4;
                }
                short s = this.m_ownerElement.compareDocumentPosition(element2);
                return (short)(s & 0xFFFFFFE7);
            }
            short s = this.m_ownerElement.compareDocumentPosition(node2);
            return (short)(s & 0xFFFFFFE7);
        }

        public NamedNodeMap getAttributes() {
            return null;
        }

        public String getBaseURI() {
            return null;
        }

        public NodeList getChildNodes() {
            return null;
        }

        public Object getFeature(String string2, String string3) {
            return null;
        }

        public Node getFirstChild() {
            return null;
        }

        public Node getLastChild() {
            return null;
        }

        public String getLocalName() {
            return this.m_prefix;
        }

        public String getNamespaceURI() {
            return "http://www.w3.org/2000/xmlns/";
        }

        public Node getNextSibling() {
            return null;
        }

        public String getNodeName() {
            return this.m_qname;
        }

        public short getNodeType() {
            return 2;
        }

        public String getNodeValue() throws DOMException {
            return this.m_value;
        }

        public Document getOwnerDocument() {
            return this.m_ownerElement.getOwnerDocument();
        }

        public Node getParentNode() {
            return this.m_ownerElement;
        }

        public String getPrefix() {
            if (this.m_qname == null) {
                return null;
            }
            int n2 = this.m_qname.indexOf(":");
            if (n2 == -1) {
                return null;
            }
            return this.m_qname.substring(0, n2);
        }

        public Node getPreviousSibling() {
            return null;
        }

        public String getTextContent() throws DOMException {
            return this.m_value;
        }

        public Object getUserData(String string2) {
            if (this.m_userData == null) {
                return null;
            }
            return this.m_userData.get(string2);
        }

        public boolean hasAttributes() {
            return false;
        }

        public boolean hasChildNodes() {
            return false;
        }

        public Node insertBefore(Node node2, Node node3) throws DOMException {
            throw XCIErrorHelper.createDOMException((short)7);
        }

        public boolean isDefaultNamespace(String string2) {
            return this.m_ownerElement.isDefaultNamespace(string2);
        }

        public boolean isEqualNode(Node node2) {
            if (this.getNodeType() != node2.getNodeType()) {
                return false;
            }
            if (!(this.compareStrings(this.getNodeName(), node2.getNodeName()) && this.compareStrings(this.getLocalName(), node2.getLocalName()) && this.compareStrings(this.getNamespaceURI(), node2.getNamespaceURI()) && this.compareStrings(this.getPrefix(), node2.getPrefix()) && this.compareStrings(this.getNodeValue(), node2.getNodeValue()))) {
                return false;
            }
            if (node2.getAttributes() != null) {
                return false;
            }
            return node2.getChildNodes() == null;
        }

        private boolean compareStrings(String string2, String string3) {
            if (string2 == null && string3 == null) {
                return true;
            }
            if (string2 == null || string3 == null) {
                return false;
            }
            return string2.equals(string3);
        }

        public boolean isSameNode(Node node2) {
            Attr attr2;
            Element element2;
            return node2.getNodeType() == 2 && (element2 = (attr2 = (Attr)node2).getOwnerElement()) != null && this.m_ownerElement.isSameNode(element2) && this.m_qname.equals(attr2.getNodeName()) && this.m_value.equals(attr2.getNodeValue());
        }

        public boolean isSupported(String string2, String string3) {
            return false;
        }

        public String lookupNamespaceURI(String string2) {
            return this.m_ownerElement.lookupNamespaceURI(string2);
        }

        public String lookupPrefix(String string2) {
            return this.m_ownerElement.lookupPrefix(string2);
        }

        public void normalize() {
        }

        public Node removeChild(Node node2) throws DOMException {
            throw XCIErrorHelper.createDOMException((short)7);
        }

        public Node replaceChild(Node node2, Node node3) throws DOMException {
            throw XCIErrorHelper.createDOMException((short)7);
        }

        public void setNodeValue(String string2) throws DOMException {
            throw XCIErrorHelper.createDOMException((short)7);
        }

        public void setPrefix(String string2) throws DOMException {
            throw XCIErrorHelper.createDOMException((short)7);
        }

        public void setTextContent(String string2) throws DOMException {
            throw XCIErrorHelper.createDOMException((short)7);
        }

        public Object setUserData(String string2, Object object2, UserDataHandler userDataHandler) {
            if (this.m_userData == null) {
                this.m_userData = new HashMap();
            }
            Object object3 = null;
            object3 = object2 == null ? this.m_userData.remove(string2) : this.m_userData.put(string2, object2);
            return object3;
        }

        public String getName() {
            return this.m_qname;
        }

        public Element getOwnerElement() {
            return (Element)this.m_ownerElement;
        }

        public TypeInfo getSchemaTypeInfo() {
            return null;
        }

        public boolean getSpecified() {
            return false;
        }

        public String getValue() {
            return this.m_value;
        }

        public boolean isId() {
            return false;
        }

        public void setValue(String string2) throws DOMException {
        }

        public String toString() {
            return this.m_qname + "=\"" + this.m_value + '\"';
        }
    }

    private static final class NamespacesAccumulator
    extends InScopeNSTracker {
        private ArrayList<String> fResult = new ArrayList();

        private NamespacesAccumulator() {
        }

        protected SearchState testNewFoundInScopePrefix(String string2, String string3) {
            if (string3 != null && string3.length() != 0) {
                this.fResult.add(string2);
                this.fResult.add(string3);
            }
            return SearchState.CONTINUE;
        }

        public Object result() {
            return this.fResult;
        }
    }

    private static final class PrefixAccumulatorForURITester
    extends InScopeNSTracker {
        private String fURI;
        private ArrayList<String> fResult = new ArrayList();

        public PrefixAccumulatorForURITester(String string2) {
            this.fURI = string2;
        }

        protected SearchState testNewFoundInScopePrefix(String string2, String string3) {
            if (this.fURI.equals(string3)) {
                this.fResult.add(string2);
            }
            return SearchState.CONTINUE;
        }

        public Object result() {
            return this.fResult;
        }
    }

    private static final class URITester
    extends InScopeNSTracker {
        private String fURI;
        private String fResult;

        public URITester(String string2) {
            this.fURI = string2;
        }

        protected SearchState testNewFoundInScopePrefix(String string2, String string3) {
            if (this.fURI.equals(string3)) {
                this.fResult = string2;
                return SearchState.HALT;
            }
            return SearchState.CONTINUE;
        }

        public Object result() {
            return this.fResult;
        }
    }

    private static abstract class InScopeNSTracker
    extends NSTester {
        private HashSet<String> fPrefixesDeclared = new HashSet();

        private InScopeNSTracker() {
        }

        public final SearchState test(String string2, String string3) {
            String string4;
            String string5 = string3 == null ? "" : string3;
            String string6 = string4 = string2 == null ? "" : string2;
            if (!this.fPrefixesDeclared.contains(string4)) {
                this.fPrefixesDeclared.add(string4);
                return this.testNewFoundInScopePrefix(string4, string5);
            }
            return SearchState.CONTINUE;
        }

        protected abstract SearchState testNewFoundInScopePrefix(String var1, String var2);
    }

    private static final class PrefixTester
    extends NSTester {
        private String fPrefix;
        private boolean fIsDefaultNS;
        private String fResult;

        public PrefixTester(String string2) {
            this.fPrefix = string2;
            this.fIsDefaultNS = string2.length() == 0;
        }

        public SearchState test(String string2, String string3) {
            if (this.fIsDefaultNS && (string2 == null || string2.length() == 0) || !this.fIsDefaultNS && this.fPrefix.equals(string2)) {
                this.fResult = string3 == null ? "" : string3;
                return SearchState.HALT;
            }
            this.fResult = null;
            return SearchState.CONTINUE;
        }

        public Object result() {
            return this.fResult;
        }
    }

    private static abstract class NSTester {
        private NSTester() {
        }

        public abstract SearchState test(String var1, String var2);

        public abstract Object result();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SearchState {
        CONTINUE,
        HALT;

    }

    private static class Counter {
        private long count = 0L;

        private Counter() {
        }

        public long increment() {
            return ++this.count;
        }

        public long decrement() {
            return --this.count;
        }
    }

    public class DOMCursorWithStackDiscipline
    extends DOMCursor {
        static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
        private static final int MAX_DEPTH = 16;
        private int fDepth;
        final Node[] fNodeStack;
        final NodeTest[] fNodeTestStack;
        final NamedNodeMap[] fAttributesStack;
        final ArrayList<Node>[] fNodesFoundStack;
        final short[] fContextSequenceModeStack;
        final int[] fSequenceIndexStack;
        final long[] fPositionStack;
        final long[] fSizeStack;

        public DOMCursorWithStackDiscipline(DOMCursor dOMCursor, Cursor.Profile profile, boolean bl) {
            super(dOMCursor, bl);
            this.fNodeStack = new Node[16];
            this.fNodeTestStack = new NodeTest[16];
            this.fAttributesStack = new NamedNodeMap[16];
            this.fNodesFoundStack = new ArrayList[16];
            this.fContextSequenceModeStack = new short[16];
            this.fSequenceIndexStack = new int[16];
            this.fPositionStack = new long[16];
            this.fSizeStack = new long[16];
            this._push();
        }

        private void _pop() {
            --this.fDepth;
            this.fNode = this.fNodeStack[this.fDepth];
            this.fTest = this.fNodeTestStack[this.fDepth];
            this.fContextSequenceMode = this.fContextSequenceModeStack[this.fDepth];
            this.fPosition = this.fPositionStack[this.fDepth];
            this.fSize = this.fSizeStack[this.fDepth];
            switch (this.fContextSequenceMode) {
                case 4: 
                case 8: {
                    this.fNodesFound = this.fNodesFoundStack[this.fDepth];
                    this.fSequenceIndex = this.fSequenceIndexStack[this.fDepth];
                    break;
                }
                case 5: 
                case 9: {
                    this.fAttributes = this.fAttributesStack[this.fDepth];
                    this.fSequenceIndex = this.fSequenceIndexStack[this.fDepth];
                    break;
                }
                case 6: 
                case 7: {
                    this.fSequenceIndex = this.fSequenceIndexStack[this.fDepth];
                }
            }
        }

        private void _push() {
            this.fNodeStack[this.fDepth] = this.fNode;
            this.fNodeTestStack[this.fDepth] = this.fTest;
            this.fContextSequenceModeStack[this.fDepth] = this.fContextSequenceMode;
            this.fPositionStack[this.fDepth] = this.fPosition;
            this.fSizeStack[this.fDepth] = this.fSize;
            switch (this.fContextSequenceMode) {
                case 4: 
                case 8: {
                    this.fNodesFoundStack[this.fDepth] = this.fNodesFound;
                    this.fSequenceIndexStack[this.fDepth] = this.fSequenceIndex;
                    break;
                }
                case 5: 
                case 9: {
                    this.fAttributesStack[this.fDepth] = this.fAttributes;
                    this.fSequenceIndexStack[this.fDepth] = this.fSequenceIndex;
                    break;
                }
                case 6: 
                case 7: {
                    this.fSequenceIndexStack[this.fDepth] = this.fSequenceIndex;
                }
            }
            ++this.fDepth;
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (this.fDepth == 16 || Cursor.Profile.MINIMAL_NAVIGATION.containedIn(profile)) {
                DOMCursor dOMCursor = new DOMCursor(this, bl);
                return dOMCursor;
            }
            this._push();
            return this;
        }

        public void release() {
            this._pop();
            super.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DOMCursor
    extends AbstractCursor
    implements NodeList {
        static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
        private static final short CURSOR_RELEASED = -1;
        protected static final short CONTEXT_SEQUENCE_UNNAVIGATED = 0;
        protected static final short CONTEXT_SEQUENCE_SELF = 1;
        protected static final short CONTEXT_SEQUENCE_SIBLINGS = 2;
        protected static final short CONTEXT_SEQUENCE_PRECEDING_SIBLINGS = 3;
        protected static final short CONTEXT_SEQUENCE_ATTRIBUTES = 4;
        protected static final short CONTEXT_SEQUENCE_IDS_IDREFS = 5;
        protected static final short CONTEXT_SEQUENCE_DESCENDANTS = 6;
        protected static final short CONTEXT_SEQUENCE_DESCENDANTS_OR_SELF = 7;
        protected static final short CONTEXT_SEQUENCE_NAMESPACE_DECLS = 8;
        protected static final short CONTEXT_SEQUENCE_NAMESPACES = 9;
        protected Node fNode;
        protected long fPosition;
        protected long fSize;
        protected short fContextSequenceMode;
        protected NodeTest fTest;
        protected NamedNodeMap fAttributes;
        protected ArrayList<Node> fNodesFound;
        protected int fSequenceIndex;
        private boolean isElementWithId;
        protected ItemNameClass fNodeName;

        protected DOMCursor(Node node2, Cursor.Profile profile, CursorFactory cursorFactory) {
            super(cursorFactory);
            this.fContextSequenceMode = 0;
            this.isElementWithId = false;
            assert (this.factory() != null);
            this.makeSingleton(node2);
            assert (this.itemKind() > 0) : "Cannot create DOMCursror into non-infoset node!";
        }

        public DOMCursor(DOMCursor dOMCursor, boolean bl) {
            super(dOMCursor.factory());
            this.fContextSequenceMode = 0;
            this.isElementWithId = false;
            assert (this.factory() != null);
            this.fNode = dOMCursor.fNode;
            if (!bl) {
                short s = dOMCursor.fContextSequenceMode;
                this.fPosition = dOMCursor.fPosition;
                this.fSize = dOMCursor.fSize;
                this.fTest = dOMCursor.fTest;
                this.fContextSequenceMode = s;
                switch (s) {
                    case 4: 
                    case 8: {
                        this.fAttributes = dOMCursor.fAttributes;
                        this.fSequenceIndex = dOMCursor.fSequenceIndex;
                        break;
                    }
                    case 5: {
                        this.fNodesFound = dOMCursor.fNodesFound;
                        this.fSequenceIndex = dOMCursor.fSequenceIndex;
                        break;
                    }
                    case 9: {
                        this.fNodesFound = dOMCursor.fNodesFound;
                        this.fSequenceIndex = dOMCursor.fSequenceIndex;
                        break;
                    }
                    case 6: 
                    case 7: {
                        this.fSequenceIndex = dOMCursor.fSequenceIndex;
                    }
                }
            }
            assert (this.itemKind() > 0) : "Cannot create DOMCursror into non-infoset node!";
        }

        private void makeSingleton(Node node2) {
            this.fNode = node2;
            this.fPosition = 1L;
            this.fSize = 1L;
            this.fContextSequenceMode = 1;
            this.clearUnusedFields();
            assert (node2 != null) : "Setting context node to null";
        }

        private void clearUnusedFields() {
            switch (this.fContextSequenceMode) {
                case 4: 
                case 8: {
                    this.fNodesFound = null;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    this.fAttributes = null;
                    this.fNodesFound = null;
                    break;
                }
                case 5: 
                case 9: {
                    this.fAttributes = null;
                }
            }
        }

        private void addNode(Cursor.Area area, Node node2) {
            block13: {
                short s = this.itemKind();
                boolean bl = Cursor.Area.FOLLOWING_SIBLING.equals(area);
                boolean bl2 = Cursor.Area.FIRST_CHILD.equals(area);
                boolean bl3 = Cursor.Area.LAST_CHILD.equals(area);
                switch (s) {
                    case 9: {
                        if (!bl) break;
                        throw this.createBadMutationCombination();
                    }
                    case 3: 
                    case 7: 
                    case 8: {
                        if (!bl2 && !bl3) break;
                        throw this.createBadMutationCombination();
                    }
                    case 2: 
                    case 4: {
                        throw this.createBadContextItemException();
                    }
                }
                try {
                    if (Cursor.Area.LAST_CHILD.equals(area)) {
                        this.fNode.appendChild(node2);
                        break block13;
                    }
                    if (Cursor.Area.FIRST_CHILD.equals(area)) {
                        this.fNode.insertBefore(node2, this.fNode.getFirstChild());
                        break block13;
                    }
                    if (Cursor.Area.FOLLOWING_SIBLING.equals(area)) {
                        boolean bl4 = DOMAdapter.isText(this.fNode.getNodeType());
                        Node node3 = this.fNode.getNextSibling();
                        Node node4 = this.fNode.getParentNode();
                        if (bl4) {
                            if (node3 == null) {
                                node3 = this.nextSiblingThroughAncestorEntityRefs(this.fNode);
                            }
                            Node node5 = node3 = node3 == null ? null : this.siblingOrSelf(node3, null, bl4);
                            if (node3 != null) {
                                node4 = node3.getParentNode();
                            }
                        }
                        node4.insertBefore(node2, node3);
                        break block13;
                    }
                    throw this.createBadArgumentException("where");
                }
                catch (DOMException dOMException) {
                    throw this.createInternalException(dOMException);
                }
            }
        }

        @Override
        public int getLength() {
            return (int)this.contextSize();
        }

        @Override
        public Node item(int n2) {
            return this.toPosition(n2 + 1) ? this.fNode : null;
        }

        @Override
        public Cursor.Profile profileLimit() {
            return this.futureProfile();
        }

        @Override
        public Cursor.Profile futureProfile() {
            return FEATURES;
        }

        @Override
        public Cursor.Profile profile() {
            return FEATURES;
        }

        @Override
        public short itemKind() {
            short s = this.fNode.getNodeType();
            short s2 = s == 2 && DOMAdapter.isNamespace(this.fNode) ? (short)4 : (s == 4 ? (short)3 : (s == 11 ? (short)9 : (short)s));
            assert (DOMAdapter.isValidXDMNodeKind(s2)) : "Invalid XDM node kind";
            return s2;
        }

        @Override
        public boolean itemNilled() {
            if (this.fNode.getNodeType() == 1 && this.fNode instanceof ElementPSVI) {
                ElementPSVI elementPSVI = (ElementPSVI)((Object)this.fNode);
                return elementPSVI.getNil();
            }
            return false;
        }

        @Override
        public VolatileCData itemName() {
            short s = this.fNode.getNodeType();
            switch (s) {
                case 1: 
                case 2: 
                case 7: {
                    if (this.fNodeName == null) {
                        this.fNodeName = new ItemNameClass();
                    }
                    this.fNodeName.setNodeKind(s);
                    return this.fNodeName;
                }
            }
            return EMPTY_RESULT;
        }

        @Override
        public XSTypeDefinition itemXSType() {
            short s = this.itemKind();
            XSTypeDefinition xSTypeDefinition = null;
            if (this.fNode instanceof ItemPSVI && s != 4) {
                ItemPSVI itemPSVI = (ItemPSVI)((Object)this.fNode);
                short s2 = itemPSVI.getValidity();
                short s3 = itemPSVI.getValidationAttempted();
                XSTypeDefinition xSTypeDefinition2 = itemPSVI.getTypeDefinition();
                if (s2 == 1 || s3 == 1) {
                    xSTypeDefinition = s == 1 ? TypeRegistry.XSANYTYPE : TypeRegistry.XSANYSIMPLETYPE;
                } else if (s2 == 2 && s3 == 2) {
                    xSTypeDefinition = xSTypeDefinition2;
                }
            }
            if (xSTypeDefinition == null) {
                switch (s) {
                    case 1: {
                        xSTypeDefinition = TypeRegistry.XSUNTYPED;
                        break;
                    }
                    case 2: 
                    case 3: {
                        xSTypeDefinition = TypeRegistry.XSUNTYPEDATOMIC;
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            return xSTypeDefinition;
        }

        @Override
        public ItemPSVI itemXSPSVInfo() {
            if (this.fNode instanceof ItemPSVI && !DOMAdapter.isNamespace(this.fNode)) {
                return (ItemPSVI)((Object)this.fNode);
            }
            return null;
        }

        @Override
        public ExtendedNamespaceContext itemNamespaceContext() {
            return this.itemNamespaceContext(false);
        }

        @Override
        public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
            NodeNamespaceContext nodeNamespaceContext;
            Node node2 = this.fNode;
            short s = node2.getNodeType();
            if (s == 1) {
                nodeNamespaceContext = new NodeNamespaceContext(node2);
            } else if (bl) {
                if (s == 2) {
                    node2 = ((Attr)node2).getOwnerElement();
                } else if ((node2 = this.getParentThroughEntityRefs(node2)) != null && node2.getNodeType() != 1) {
                    node2 = null;
                }
                nodeNamespaceContext = node2 != null ? new NodeNamespaceContext(node2) : null;
            } else {
                nodeNamespaceContext = null;
            }
            return nodeNamespaceContext;
        }

        @Override
        public VolatileCData itemValue() {
            XSTypeDefinition xSTypeDefinition;
            String string2;
            CData cData = null;
            short s = this.itemKind();
            String string3 = string2 = s == 3 ? ((Text)this.fNode).getWholeText() : this.fNode.getTextContent();
            if (this.fNode instanceof ItemPSVI) {
                xSTypeDefinition = this.itemXSType();
                if (s == 1 && xSTypeDefinition.getTypeCategory() == 15 && ((XSComplexTypeDefinition)xSTypeDefinition).getContentType() == 2) {
                    throw new XCIIllegalContextItemException("ER_ELEMCONTENT_VALUE", new String[0]);
                }
                cData = this.createCData((ItemPSVI)((Object)this.fNode), string2);
            }
            if (cData == null) {
                xSTypeDefinition = s == 3 || s == 1 || s == 2 || s == 9 ? TypeRegistry.XSUNTYPEDATOMIC : TypeRegistry.XSSTRING;
                cData = string2 == null ? null : this.factory.data((CharSequence)string2, (XSSimpleTypeDefinition)xSTypeDefinition, false);
            }
            return cData;
        }

        @Override
        protected Chars itemSValue() {
            String string2;
            short s = this.fNode.getNodeType();
            String string3 = string2 = DOMAdapter.isText(s) ? ((Text)this.fNode).getWholeText() : this.fNode.getTextContent();
            if (this.factory == null) {
                System.out.println("DEBUG");
            }
            return string2 == null ? null : new StringChars(string2);
        }

        @Override
        public String itemBaseUri() {
            return this.itemBaseURI();
        }

        @Override
        public String itemBaseURI() {
            Node node2;
            switch (this.fNode.getNodeType()) {
                case 2: {
                    if (DOMAdapter.isNamespace(this.fNode)) {
                        node2 = null;
                        break;
                    }
                    node2 = ((Attr)this.fNode).getOwnerElement();
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    node2 = this.getParentThroughEntityRefs(this.fNode);
                    break;
                }
                default: {
                    node2 = this.fNode;
                }
            }
            String string2 = null;
            if (node2 != null && (string2 = node2.getBaseURI()) == null) {
                string2 = this.fNode.getNodeType() != 9 ? this.fNode.getOwnerDocument().getDocumentURI() : ((Document)this.fNode).getDocumentURI();
            }
            return string2;
        }

        @Override
        public DocumentInfo itemDocumentInfo() {
            return DOMAdapter.this.fDocumentInfo;
        }

        @Override
        public long itemDocumentIdentity() {
            return DOMAdapter.this.fDocumentIdentity;
        }

        @Override
        public boolean itemIsID() {
            return this.nodeIsID(this.fNode);
        }

        private boolean nodeIsID(Node node2) {
            switch (node2.getNodeType()) {
                case 2: {
                    if (((Attr)node2).isId() || "xml:id".equals(node2.getNodeName())) {
                        return true;
                    }
                }
                case 1: {
                    if (!(node2 instanceof ItemPSVI)) break;
                    ItemPSVI itemPSVI = (ItemPSVI)((Object)node2);
                    short s = itemPSVI.getActualNormalizedValueType();
                    if (s == 27) {
                        return true;
                    }
                    if (s != 44 && s != 43) break;
                    ShortList shortList = itemPSVI.getItemValueTypes();
                    return shortList.getLength() == 1 && shortList.item(0) == 27;
                }
            }
            return false;
        }

        @Override
        public boolean itemIsIDREFS() {
            return this.nodeIsIDREF(this.fNode);
        }

        private boolean nodeIsIDREF(Node node2) {
            switch (node2.getNodeType()) {
                case 2: {
                    String string2;
                    Object object2 = ((Attr)node2).getSchemaTypeInfo();
                    if (object2 != null && DOMAdapter.DTD_TYPE_NAMESPACE.equals(object2.getTypeNamespace()) && ("IDREF".equals(string2 = object2.getTypeName()) || "IDREFS".equals(string2))) {
                        return true;
                    }
                }
                case 1: {
                    if (!(node2 instanceof ItemPSVI)) break;
                    Object object2 = (ItemPSVI)((Object)node2);
                    short s = object2.getActualNormalizedValueType();
                    if (s == 28) {
                        return true;
                    }
                    if (s != 44 && s != 43) break;
                    return object2.getItemValueTypes().contains((short)28);
                }
            }
            return false;
        }

        private boolean isNodeKindOKForSequenceMode() {
            short s = this.itemKind();
            switch (this.fContextSequenceMode) {
                case 4: {
                    return s == 2;
                }
                case 8: 
                case 9: {
                    return s == 4;
                }
                case 5: {
                    return s == 1 || s == 2;
                }
                case 1: {
                    return true;
                }
                case 7: {
                    if (this.fPosition == 1L) {
                        return true;
                    }
                }
                case 2: 
                case 3: 
                case 6: {
                    return s == 1 || s == 3 || s == 8 || s == 7;
                }
            }
            return false;
        }

        @Override
        public boolean toNext() {
            boolean bl = false;
            switch (this.fContextSequenceMode) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl2 = DOMAdapter.isText(this.fNode.getNodeType());
                    Node node2 = this.fNode.getNextSibling();
                    if (node2 == null) {
                        node2 = this.nextSiblingThroughAncestorEntityRefs(this.fNode);
                    }
                    Node node3 = node2 == null ? null : this.siblingOrSelf(node2, this.fTest, bl2);
                    boolean bl3 = bl = node3 != null;
                    if (!bl) break;
                    this.fNode = node3;
                    break;
                }
                case 3: {
                    Node node4 = this.fNode.getPreviousSibling();
                    if (node4 == null) {
                        node4 = this.previousSiblingThroughAncestorEntityRefs(this.fNode, false);
                    }
                    Node node5 = node4 == null ? null : this.previousSiblingOrSelf(node4, this.fTest);
                    boolean bl4 = bl = node5 != null;
                    if (!bl) break;
                    this.fNode = node5;
                    break;
                }
                case 4: 
                case 8: {
                    int n2 = this.nextAttribute(this.fSequenceIndex + 1, this.fTest, this.fAttributes, this.fContextSequenceMode == 8);
                    boolean bl5 = bl = n2 >= 0;
                    if (!bl) break;
                    this.fNode = this.fAttributes.item(n2);
                    this.fSequenceIndex = n2;
                    break;
                }
                case 5: 
                case 9: {
                    boolean bl6 = bl = this.fNodesFound.size() > this.fSequenceIndex + 1;
                    if (!bl) break;
                    ++this.fSequenceIndex;
                    this.fNode = this.fNodesFound.get(this.fSequenceIndex);
                    break;
                }
                case 6: 
                case 7: {
                    Node node6;
                    int n3 = this.fSequenceIndex;
                    Node node7 = node6 = this.fNode;
                    while ((node7 = this.nextDescendantNode(node7)) != null) {
                        this.fNode = node7;
                        if (this.fTest != null && !this.fTest.test(this)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.fNode = node6;
                        this.fSequenceIndex = n3;
                        break;
                    }
                    this.fNode = node7;
                    break;
                }
            }
            if (bl) {
                ++this.fPosition;
                assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                assert (this.isNodeKindOKForSequenceMode()) : "Unexpected node kind for sequence mode";
            }
            return bl;
        }

        @Override
        public boolean toPrevious() {
            if (this.fPosition == 1L) {
                return false;
            }
            boolean bl = false;
            switch (this.fContextSequenceMode) {
                case 1: {
                    break;
                }
                case 2: {
                    Node node2 = this.fNode.getPreviousSibling();
                    if (node2 == null) {
                        node2 = this.previousSiblingThroughAncestorEntityRefs(this.fNode, false);
                    }
                    Node node3 = node2 == null ? null : this.previousSiblingOrSelf(node2, this.fTest);
                    boolean bl2 = bl = node3 != null;
                    if (!bl) break;
                    this.fNode = node3;
                    break;
                }
                case 3: {
                    boolean bl3 = DOMAdapter.isText(this.fNode.getNodeType());
                    Node node4 = this.fNode.getNextSibling();
                    if (node4 == null) {
                        node4 = this.nextSiblingThroughAncestorEntityRefs(this.fNode);
                    }
                    Node node5 = node4 == null ? null : this.siblingOrSelf(node4, this.fTest, bl3);
                    boolean bl4 = bl = node5 != null;
                    if (!bl) break;
                    this.fNode = node5;
                    break;
                }
                case 4: 
                case 8: {
                    int n2 = this.previousAttribute(this.fSequenceIndex - 1, this.fTest, this.fAttributes, this.fContextSequenceMode == 8);
                    boolean bl5 = bl = n2 >= 0;
                    if (!bl) break;
                    this.fNode = this.fAttributes.item(n2);
                    this.fSequenceIndex = n2;
                    break;
                }
                case 5: 
                case 9: {
                    boolean bl6 = bl = this.fSequenceIndex > 0;
                    if (!bl) break;
                    --this.fSequenceIndex;
                    this.fNode = this.fNodesFound.get(this.fSequenceIndex);
                    break;
                }
                case 6: 
                case 7: {
                    Node node6;
                    int n3 = this.fSequenceIndex;
                    Node node7 = node6 = this.fNode;
                    while ((node7 = this.previousDescendantNode(node7)) != null) {
                        this.fNode = node7;
                        if (this.fTest != null && !this.fTest.test(this)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.fNode = node6;
                        this.fSequenceIndex = n3;
                        break;
                    }
                    this.fNode = node7;
                    break;
                }
            }
            if (bl) {
                assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                --this.fPosition;
                assert (this.fPosition > 0L) : "Position after toPrevious must be greater than zero";
                assert (this.isNodeKindOKForSequenceMode()) : "Unexpected node kind for sequence mode";
            }
            return bl;
        }

        @Override
        public boolean toPosition(long l) {
            boolean bl;
            if (this.fPosition == l) {
                return true;
            }
            if (l < 1L || this.fSize != -1L && l > this.fSize) {
                return false;
            }
            ContextPosition contextPosition = new ContextPosition();
            boolean bl2 = bl = l > this.fPosition;
            while (bl ? this.toNext() : this.toPrevious()) {
                if (this.fPosition != l) continue;
                return true;
            }
            contextPosition.restorePosition();
            return false;
        }

        @Override
        public void toLast() {
            boolean bl = false;
            long l = this.fPosition;
            switch (this.fContextSequenceMode) {
                case 1: {
                    break;
                }
                case 2: {
                    do {
                        boolean bl2 = DOMAdapter.isText(this.fNode.getNodeType());
                        Node node2 = this.fNode.getNextSibling();
                        if (node2 == null) {
                            node2 = this.nextSiblingThroughAncestorEntityRefs(this.fNode);
                        }
                        Node node3 = node2 == null ? null : this.siblingOrSelf(node2, this.fTest, bl2);
                        boolean bl3 = bl = node3 != null;
                        if (!bl) continue;
                        this.fNode = node3;
                        ++this.fPosition;
                    } while (bl);
                    break;
                }
                case 3: {
                    do {
                        Node node4;
                        if ((node4 = this.fNode.getPreviousSibling()) == null) {
                            node4 = this.previousSiblingThroughAncestorEntityRefs(this.fNode, false);
                        }
                        Node node5 = node4 == null ? null : this.previousSiblingOrSelf(node4, this.fTest);
                        boolean bl4 = bl = node5 != null;
                        if (!bl) continue;
                        this.fNode = node5;
                        ++this.fPosition;
                    } while (bl);
                    break;
                }
                case 4: 
                case 8: {
                    do {
                        int n2 = this.nextAttribute(this.fSequenceIndex + 1, this.fTest, this.fAttributes, this.fContextSequenceMode == 8);
                        boolean bl5 = bl = n2 >= 0;
                        if (!bl) continue;
                        this.fNode = this.fAttributes.item(n2);
                        this.fSequenceIndex = n2;
                        ++this.fPosition;
                    } while (bl);
                    break;
                }
                case 5: 
                case 9: {
                    do {
                        boolean bl6 = bl = this.fNodesFound.size() > this.fSequenceIndex + 1;
                        if (!bl) continue;
                        ++this.fSequenceIndex;
                        this.fNode = this.fNodesFound.get(this.fSequenceIndex);
                        ++this.fPosition;
                    } while (bl);
                    break;
                }
                case 6: 
                case 7: {
                    do {
                        Node node6;
                        int n3 = this.fSequenceIndex;
                        Node node7 = node6 = this.fNode;
                        while ((node7 = this.nextDescendantNode(node7)) != null) {
                            this.fNode = node7;
                            if (this.fTest != null && !this.fTest.test(this)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            this.fNode = node6;
                            this.fSequenceIndex = n3;
                            continue;
                        }
                        this.fNode = node7;
                        ++this.fPosition;
                    } while (bl);
                }
            }
            if (l != this.fPosition) {
                assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                assert (this.fSize == -1L || this.fPosition <= this.fSize) : "Position after toNext must not be greater than fSize";
                assert (this.isNodeKindOKForSequenceMode()) : "Unexpected node kind for sequence mode";
            }
        }

        @Override
        public long contextPosition() {
            return this.fPosition;
        }

        @Override
        public long contextSize() {
            if (this.fSize == -1L) {
                this.fSize = this.fPosition;
                block0 : switch (this.fContextSequenceMode) {
                    case 2: {
                        Node node2 = this.fNode;
                        while (true) {
                            boolean bl = DOMAdapter.isText(node2.getNodeType());
                            Node node3 = node2.getNextSibling();
                            if (node3 == null) {
                                node3 = this.nextSiblingThroughAncestorEntityRefs(node2);
                            }
                            Node node4 = node2 = node3 == null ? null : this.siblingOrSelf(node3, this.fTest, bl);
                            if (node2 == null) break block0;
                            ++this.fSize;
                        }
                    }
                    case 3: {
                        Node node5 = this.fNode;
                        while (true) {
                            Node node6;
                            if ((node6 = node5.getPreviousSibling()) == null) {
                                node6 = this.previousSiblingThroughAncestorEntityRefs(node5, false);
                            }
                            Node node7 = node5 = node6 == null ? null : this.previousSiblingOrSelf(node6, this.fTest);
                            if (node5 == null) break block0;
                            ++this.fSize;
                        }
                    }
                    case 4: 
                    case 8: {
                        if (this.fSequenceIndex == -1) break;
                        int n2 = this.fSequenceIndex + 1;
                        while ((n2 = this.nextAttribute(n2, this.fTest, this.fAttributes, this.fContextSequenceMode == 8)) >= 0) {
                            if (n2 == -1) continue;
                            ++this.fSize;
                            ++n2;
                        }
                        break;
                    }
                    case 6: 
                    case 7: {
                        ContextPosition contextPosition = new ContextPosition();
                        while (this.toNext()) {
                        }
                        this.fSize = this.fPosition;
                        contextPosition.restorePosition();
                        break;
                    }
                }
            }
            return this.fSize;
        }

        @Override
        public boolean contextIsAtomsOnly() {
            return false;
        }

        @Override
        public boolean contextIsNodesOnly() {
            return true;
        }

        @Override
        public boolean contextIsSingleDoc() {
            return true;
        }

        @Override
        public boolean contextIsSingleton() {
            if (this.fSize != -1L) {
                return this.fSize == 1L;
            }
            if (this.fPosition == 1L) {
                ContextPosition contextPosition = new ContextPosition();
                boolean bl = this.toNext();
                contextPosition.restorePosition();
                return !bl;
            }
            return false;
        }

        @Override
        public boolean toSelf() {
            this.makeSingleton(this.fNode);
            assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
            return true;
        }

        @Override
        public boolean toAttributes(NodeTest nodeTest) {
            if (this.fNode.getNodeType() == 1 && this.fNode.hasAttributes()) {
                long l = this.fPosition;
                this.fAttributes = this.fNode.getAttributes();
                this.fPosition = 0L;
                int n2 = this.nextAttribute(0, nodeTest, this.fAttributes, false);
                if (n2 >= 0) {
                    this.fPosition = 1L;
                    this.fSize = -1L;
                    this.fSequenceIndex = n2;
                    this.fContextSequenceMode = (short)4;
                    this.fNode = this.fAttributes.item(this.fSequenceIndex);
                    this.fTest = nodeTest;
                    this.clearUnusedFields();
                    assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                    return true;
                }
                this.fAttributes = null;
                this.fPosition = l;
            }
            return false;
        }

        protected boolean toNamespaces(NodeTest nodeTest) {
            ExtendedNamespaceContext extendedNamespaceContext = this.itemNamespaceContext();
            if (extendedNamespaceContext != null) {
                Node node2 = this.fNode;
                Iterator<String> iterator = ((NodeNamespaceContext)extendedNamespaceContext).getInScopeNamespaces();
                long l = this.fPosition;
                this.fPosition = 0L;
                ArrayList<Node> arrayList = new ArrayList<Node>();
                while (iterator.hasNext()) {
                    String string2 = iterator.next();
                    String string3 = iterator.next();
                    NamespaceNodeImpl namespaceNodeImpl = new NamespaceNodeImpl(string2, string3, node2);
                    if (nodeTest == null) {
                        arrayList.add(namespaceNodeImpl);
                        continue;
                    }
                    ++this.fPosition;
                    this.fNode = namespaceNodeImpl;
                    if (nodeTest.test(this)) {
                        arrayList.add(namespaceNodeImpl);
                        continue;
                    }
                    --this.fPosition;
                }
                if (arrayList.size() > 0) {
                    this.fPosition = 1L;
                    this.fSequenceIndex = 0;
                    DOMUtils.quicksort(arrayList, 0, arrayList.size() - 1);
                    this.fNodesFound = arrayList;
                    this.fNode = this.fNodesFound.get(0);
                    this.fSize = arrayList.size();
                    this.fContextSequenceMode = (short)9;
                    this.clearUnusedFields();
                    assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                    return true;
                }
                this.fPosition = l;
                this.fNode = node2;
            }
            return false;
        }

        @Override
        public boolean toNamespaceDecls() {
            return this.toNamespaceDecls(null);
        }

        protected boolean toNamespaceDecls(NodeTest nodeTest) {
            if (this.fNode.getNodeType() == 1 && this.fNode.hasAttributes()) {
                long l = this.fPosition;
                this.fAttributes = this.fNode.getAttributes();
                this.fPosition = 0L;
                int n2 = this.nextAttribute(0, nodeTest, this.fAttributes, true);
                if (n2 >= 0) {
                    this.fPosition = 1L;
                    this.fSize = -1L;
                    this.fSequenceIndex = n2;
                    this.fContextSequenceMode = (short)8;
                    this.fNode = this.fAttributes.item(this.fSequenceIndex);
                    this.fTest = nodeTest;
                    this.clearUnusedFields();
                    assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                    return true;
                }
                this.fAttributes = null;
                this.fPosition = l;
            }
            return false;
        }

        @Override
        public boolean toChildren(NodeTest nodeTest) {
            short s = this.fNode.getNodeType();
            if ((s == 1 || s == 9 || s == 11 || s == 5) && this.fNode.hasChildNodes()) {
                long l = this.fPosition;
                this.fPosition = 1L;
                Node node2 = this.siblingOrSelf(this.fNode.getFirstChild(), nodeTest, false);
                if (node2 != null && node2.getNodeType() == 10) {
                    node2 = this.siblingOrSelf(node2.getNextSibling(), nodeTest, false);
                }
                if (node2 != null) {
                    this.fNode = node2;
                    this.fPosition = 1L;
                    this.fSize = -1L;
                    this.fContextSequenceMode = (short)2;
                    this.fTest = nodeTest;
                    this.clearUnusedFields();
                    assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                    return true;
                }
                this.fPosition = l;
            }
            return false;
        }

        public boolean toDescendants(NodeTest nodeTest) {
            Node node2;
            boolean bl = false;
            Node node3 = node2 = this.fNode;
            int n2 = this.fSequenceIndex;
            this.fSequenceIndex = 0;
            while ((node3 = this.nextDescendantNode(node3)) != null) {
                this.fNode = node3;
                if (nodeTest != null && !nodeTest.test(this)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.fNode = node2;
                this.fSequenceIndex = n2;
            } else {
                this.fContextSequenceMode = (short)6;
                this.fTest = nodeTest;
                this.fPosition = 1L;
                this.fSize = -1L;
                assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                this.clearUnusedFields();
            }
            return bl;
        }

        protected boolean toDescendantsOrSelf(NodeTest nodeTest) {
            if (nodeTest == null || nodeTest.test(this)) {
                this.fContextSequenceMode = (short)7;
                this.fTest = nodeTest;
                this.fPosition = 1L;
                this.fSize = -1L;
                this.fSequenceIndex = 0;
                this.clearUnusedFields();
                assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                return true;
            }
            return this.toDescendants(nodeTest);
        }

        @Override
        public boolean toParent() {
            Node node2;
            Node node3 = node2 = this.fNode.getNodeType() == 2 ? ((Attr)this.fNode).getOwnerElement() : this.getParentThroughEntityRefs(this.fNode);
            if (node2 != null) {
                this.fTest = null;
                this.makeSingleton(node2);
                assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                return true;
            }
            return false;
        }

        private Node getParentThroughEntityRefs(Node node2) {
            Node node3 = node2;
            while ((node3 = node3.getParentNode()) != null && node3.getNodeType() == 5) {
            }
            return node3;
        }

        @Override
        public boolean toRoot() {
            this.makeSingleton(this.getRoot());
            assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
            return true;
        }

        private Node getRoot() {
            if (DOMAdapter.this.fRoot == null) {
                Node node2;
                DOMAdapter.this.fRoot = node2 = DOMAdapter.getRoot(this.fNode);
            }
            return DOMAdapter.this.fRoot;
        }

        private Node nextDescendantNode(Node node2) {
            int n2 = this.fSequenceIndex;
            Node node3 = node2;
            Node node4 = null;
            short s = node3.getNodeType();
            boolean bl = DOMAdapter.isText(s);
            do {
                if ((s == 1 || s == 9 || s == 11 || s == 5) && node3.hasChildNodes()) {
                    node4 = node3.getFirstChild();
                    ++n2;
                }
                while (node4 == null && n2 > 0) {
                    node4 = node3.getNextSibling();
                    if (node4 != null) continue;
                    node3 = node3.getParentNode();
                    --n2;
                    if (!bl || node3.getNodeType() == 5) continue;
                    bl = false;
                }
                if (node4 == null || (s = node4.getNodeType()) != 5 && s != 10 && (!bl || !DOMAdapter.isText(s))) continue;
                node3 = node4;
                node4 = null;
            } while (node4 == null && n2 > 0);
            if (node4 != null) {
                this.fSequenceIndex = n2;
            }
            return node4;
        }

        private Node previousDescendantNode(Node node2) {
            Node node3;
            int n2 = this.fSequenceIndex;
            Node node4 = node2;
            Node node5 = null;
            short s = -1;
            do {
                if ((node3 = node4.getPreviousSibling()) != null) {
                    while (node3.hasChildNodes()) {
                        node3 = node3.getLastChild();
                        ++n2;
                    }
                    node5 = node3;
                } else {
                    node5 = node4.getParentNode();
                    --n2;
                }
                if (node5 == null || (s = (short)node5.getNodeType()) != 5 && s != 10) continue;
                node4 = node5;
                node5 = null;
            } while (node5 == null && n2 > 0);
            if (node5 != null) {
                this.fSequenceIndex = n2;
                if (DOMAdapter.isText(s)) {
                    node3 = node5;
                    while (node3 != null && DOMAdapter.isText(node3.getNodeType())) {
                        node5 = node3;
                        node3 = (node3 = node5.getPreviousSibling()) == null ? this.previousSiblingThroughAncestorEntityRefs(node5, true) : node3;
                    }
                }
            }
            return node5;
        }

        public boolean toPrecedingSibling() {
            Node node2;
            Node node3 = this.fNode.getPreviousSibling();
            if (node3 == null && (node2 = this.fNode.getParentNode()) != null && node2.getNodeType() == 5) {
                node3 = node2.getPreviousSibling();
            }
            if (node3 != null && node3.getNodeType() == 5) {
                node3 = node3.getLastChild();
            }
            if ((node2 = this.precedingSibling(node3, this.fTest)) != null) {
                this.makeSingleton(node2);
                assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                return true;
            }
            return false;
        }

        @Override
        public boolean toFollowingSiblings(NodeTest nodeTest) {
            boolean bl = DOMAdapter.isText(this.fNode.getNodeType());
            Node node2 = this.fNode.getNextSibling();
            if (node2 == null) {
                node2 = this.nextSiblingThroughAncestorEntityRefs(this.fNode);
            }
            Node node3 = node2 = node2 == null ? null : this.siblingOrSelf(node2, nodeTest, bl);
            if (node2 != null) {
                this.fContextSequenceMode = (short)2;
                this.fPosition = 1L;
                this.fSize = -1L;
                this.fNode = node2;
                this.fTest = nodeTest;
                this.clearUnusedFields();
                assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                return true;
            }
            return false;
        }

        @Override
        public boolean toPrecedingSiblings(NodeTest nodeTest) {
            Node node2 = this.fNode.getPreviousSibling();
            if (node2 == null) {
                node2 = this.previousSiblingThroughAncestorEntityRefs(this.fNode, false);
            }
            Node node3 = node2 = node2 == null ? null : this.previousSiblingOrSelf(node2, nodeTest);
            if (node2 != null) {
                this.fContextSequenceMode = (short)3;
                this.fPosition = 1L;
                this.fSize = -1L;
                this.fNode = node2;
                this.fTest = nodeTest;
                this.clearUnusedFields();
                assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                return true;
            }
            return false;
        }

        public boolean toFollowingSibling() {
            Node node2;
            boolean bl = DOMAdapter.isText(this.fNode.getNodeType());
            Node node3 = this.fNode.getNextSibling();
            if (node3 == null && (node2 = this.fNode.getParentNode()) != null && node2.getNodeType() == 5) {
                node3 = node2.getNextSibling();
            }
            if (node3 != null && node3.getNodeType() == 5) {
                node3 = node3.getFirstChild();
            }
            if ((node2 = this.siblingOrSelf(node3, this.fTest, bl)) != null) {
                this.makeSingleton(node2);
                assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                return true;
            }
            return false;
        }

        @Override
        public boolean toIds(VolatileCData volatileCData) {
            return this.toIds(volatileCData, false);
        }

        @Override
        public boolean toIds(VolatileCData volatileCData, boolean bl) {
            this.isElementWithId = bl;
            ArrayList<Node> arrayList = this.getElementsByIds(volatileCData);
            if (arrayList != null) {
                int n2 = arrayList.size();
                Node node2 = arrayList.get(0);
                if (n2 > 1) {
                    this.fContextSequenceMode = (short)5;
                    this.fNode = node2;
                    this.fNodesFound = arrayList;
                    this.fTest = null;
                    this.fSize = n2;
                    this.fSequenceIndex = 0;
                    this.fPosition = 1L;
                    this.clearUnusedFields();
                } else {
                    this.makeSingleton(node2);
                }
                assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                return true;
            }
            return false;
        }

        @Override
        public boolean toIdrefs(VolatileCData volatileCData) {
            ArrayList<Node> arrayList = this.getNodesByIdrefs(volatileCData);
            if (arrayList != null) {
                int n2 = arrayList.size();
                Node node2 = arrayList.get(0);
                if (n2 > 1) {
                    this.fContextSequenceMode = (short)5;
                    this.fNode = node2;
                    this.fNodesFound = arrayList;
                    this.fTest = null;
                    this.fSize = n2;
                    this.fPosition = 1L;
                    this.clearUnusedFields();
                } else {
                    this.makeSingleton(node2);
                }
                assert (DOMAdapter.isValidXDMNodeKind(this.itemKind())) : "Invalid XDM node kind";
                return true;
            }
            return false;
        }

        @Override
        public void release() {
            this.fNode = null;
            this.fPosition = 0L;
            this.fContextSequenceMode = (short)-1;
            this.fTest = null;
            this.fAttributes = null;
            this.fNodesFound = null;
            this.fSequenceIndex = -1;
            super.release();
        }

        @Override
        public boolean itemIsSameDocument(Cursor cursor2) {
            Cursor cursor3 = cursor2.unwrap();
            if (cursor3 instanceof DOMCursor) {
                Node node2;
                Node node3 = ((DOMCursor)cursor3).getRoot();
                return node3 == (node2 = this.getRoot()) || node3.isSameNode(node2);
            }
            return false;
        }

        @Override
        public boolean itemIsSameNode(Cursor cursor2) {
            Cursor cursor3 = cursor2.unwrap();
            if (cursor3 instanceof DOMCursor) {
                Node node2 = ((DOMCursor)cursor3).fNode;
                if (node2 == this.fNode) {
                    return true;
                }
                return this.fNode instanceof NamespaceNodeImpl ? this.fNode.isSameNode(node2) : node2.isSameNode(this.fNode);
            }
            return false;
        }

        @Override
        public boolean contextIsOrdered(boolean bl) {
            return this.fContextSequenceMode != 3 && this.fContextSequenceMode != 5 && (!USE_ALPHABETICAL_ATTRIBUTE_ORDER && !USE_REVERSE_ALPHABETICAL_ATTRIBUTE_ORDER || this.fContextSequenceMode != 4);
        }

        @Override
        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (profile.containedIn(FEATURES)) {
                DOMCursor dOMCursor = new DOMCursor(this, bl);
                return dOMCursor;
            }
            throw new RuntimeException(XCIMessages.createXCIMessage("ER_MISSINGFEATURES", new String[]{profile.toString()}));
        }

        protected DOMCursor duplicate(boolean bl) {
            return new DOMCursor(this, bl);
        }

        @Override
        public Class<?> exportAsClass(String string2) {
            if ("expdom2".equals(string2) || "expdom1".equals(string2)) {
                return Node.class;
            }
            if ("domNodeList2".equals(string2)) {
                return NodeList.class;
            }
            return null;
        }

        @Override
        public Object exportAs(String string2, boolean bl) {
            if ("domNodeList2".equals(string2)) {
                if (bl) {
                    return this;
                }
                return (NodeList)((Object)this.fork(false));
            }
            if ("expdom2".equals(string2) || "expdom1".equals(string2) || Node.class.getName().equals(string2)) {
                Node node2 = this.fNode;
                if (bl) {
                    this.release();
                }
                return node2;
            }
            return super.exportAs(string2, bl);
        }

        public boolean copyToDOMResult(DOMResult dOMResult, Map map2, boolean bl, boolean bl2) {
            boolean bl3;
            if (bl && this.fContextSequenceMode == 1 && dOMResult.getNode() == null) {
                dOMResult.setNode(this.fNode);
                bl3 = true;
            } else {
                bl3 = super.copyToDOMResult(dOMResult, map2, bl, bl2);
            }
            if (bl2) {
                this.release();
            }
            return bl3;
        }

        @Override
        public boolean isWrapped() {
            return false;
        }

        @Override
        public boolean openMutation(Cursor.Area area) {
            return true;
        }

        @Override
        public void closeMutation() {
        }

        @Override
        public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
            if (volatileCData2 == null) {
                throw this.createBadArgumentException("value", "null");
            }
            Attr attr2 = this.addAttribute(volatileCData, DOMAdapter.getVolatileCDataStringValue(volatileCData2));
            if (attr2 instanceof AttrNSImpl) {
                ((AttrNSImpl)attr2).setType(volatileCData2.getXSTypeDefinition());
            }
        }

        private Attr addAttribute(VolatileCData volatileCData, String string2) {
            String string3;
            String string4;
            String string5;
            if (this.itemKind() != 1) {
                throw this.createBadContextItemException("addAttribute");
            }
            if (volatileCData == null) {
                throw this.createBadArgumentException("name", "null");
            }
            try {
                string5 = volatileCData.getQNameNamespaceURI(1);
                string4 = volatileCData.getQNamePrefix(1);
                string3 = volatileCData.getQNameLocalPart(1);
            }
            catch (XCIDynamicErrorException xCIDynamicErrorException) {
                throw this.createBadArgumentException("name", volatileCData.toString());
            }
            String string6 = string4 == null || string4.length() == 0 ? string3 : string4 + ":" + string3;
            try {
                Attr attr2 = DOMAdapter.this.fDocument.createAttributeNS(string5, string6);
                attr2.setNodeValue(string2);
                ((Element)this.fNode).setAttributeNodeNS(attr2);
                return attr2;
            }
            catch (DOMException dOMException) {
                throw this.createInternalException(dOMException);
            }
        }

        @Override
        public void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
            String string2;
            if (this.itemKind() != 1) {
                throw this.createBadContextItemException("addNamespaceNode");
            }
            if (volatileCData == null) {
                throw this.createBadArgumentException("prefix", "null");
            }
            if (volatileCData2 == null) {
                throw this.createBadArgumentException("uri", "null");
            }
            String string3 = volatileCData.isEmptySequence() ? "xmlns" : ((string2 = volatileCData.getString(1)).length() == 0 ? "xmlns" : "xmlns:" + string2);
            string2 = DOMAdapter.getVolatileCDataStringValue(volatileCData2);
            try {
                ((Element)this.fNode).setAttributeNS("http://www.w3.org/2000/xmlns/", string3, string2);
            }
            catch (DOMException dOMException) {
                throw this.createInternalException(dOMException);
            }
        }

        @Override
        public void addComment(Cursor.Area area, VolatileCData volatileCData) {
            String string2 = DOMAdapter.getVolatileCDataStringValue(volatileCData);
            this.addNode(area, DOMAdapter.this.fDocument.createComment(string2));
        }

        @Override
        public void addCopy(Cursor.Area area, Cursor cursor2) {
            Cursor cursor3 = this.fork(false, Copier.TARGET_FEATURES, Copier.TARGET_FEATURES);
            Cursor cursor4 = cursor2.fork(false, Copier.SOURCE_FEATURES, Copier.SOURCE_FEATURES);
            Copier.copy(cursor4, cursor3, area, 17);
        }

        @Override
        public Cursor addItemDeepCopy(Cursor.Area area, Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3) {
            return null;
        }

        private Node doDOMCopyTree(Node node2, boolean bl) {
            Node node3 = this.fNode.getOwnerDocument().importNode(node2, true);
            if (!bl) {
                this.clearPSVI(node3);
            }
            return node3;
        }

        private void clearPSVI(Node node2) {
            Object object2 = node2;
            AttributePSVIForSimpleUrType attributePSVIForSimpleUrType = null;
            do {
                Object object3;
                if (object2.getNodeType() == 1) {
                    if (object2 instanceof PSVIElementNSImpl) {
                        ((PSVIElementNSImpl)object2).setPSVI(ElementPSVIForUrType.INSTANCE);
                    }
                    object3 = object2.getAttributes();
                    int n2 = object3.getLength();
                    for (int i = 0; i < n2; ++i) {
                        Node node3 = object3.item(i);
                        if (!(node3 instanceof PSVIAttrNSImpl)) continue;
                        if (attributePSVIForSimpleUrType == null) {
                            attributePSVIForSimpleUrType = new AttributePSVIForSimpleUrType();
                        }
                        attributePSVIForSimpleUrType.setValue(node3.getNodeValue());
                        ((PSVIAttrNSImpl)node3).setPSVI(attributePSVIForSimpleUrType);
                    }
                }
                if (object2.hasChildNodes()) {
                    object2 = object2.getFirstChild();
                    continue;
                }
                object3 = null;
                while (object2 != node2 && object3 == null) {
                    object3 = object2.getNextSibling();
                    if (object3 == null) {
                        object2 = object2.getParentNode();
                        continue;
                    }
                    object2 = object3;
                }
            } while (object2 != node2);
        }

        @Override
        public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
            String string2;
            String string3;
            String string4;
            if (volatileCData == null) {
                throw this.createBadArgumentException("name", "null");
            }
            try {
                string4 = volatileCData.getQNameNamespaceURI(1);
                string3 = volatileCData.getQNamePrefix(1);
                string2 = volatileCData.getQNameLocalPart(1);
            }
            catch (XCIDynamicErrorException xCIDynamicErrorException) {
                throw this.createBadArgumentException("name", volatileCData.toString());
            }
            String string5 = string3 == null || string3.length() == 0 ? string2 : string3 + ":" + volatileCData.getQNameLocalPart(1);
            Element element2 = DOMAdapter.this.fDocument.createElementNS(string4, string5);
            if (element2 instanceof ElementNSImpl) {
                ((ElementNSImpl)element2).setType(xSTypeDefinition);
            }
            this.addNode(area, element2);
        }

        @Override
        public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
            String string2 = volatileCData.getQNameLocalPart(1);
            String string3 = volatileCData2 != null ? DOMAdapter.getVolatileCDataStringValue(volatileCData2) : null;
            this.addNode(area, DOMAdapter.this.fDocument.createProcessingInstruction(string2, string3));
        }

        @Override
        public void addText(Cursor.Area area, VolatileCData volatileCData) {
            if (volatileCData == null) {
                throw this.createBadArgumentException("value", "null");
            }
            String string2 = DOMAdapter.getVolatileCDataStringValue(volatileCData);
            this.addNode(area, DOMAdapter.this.fDocument.createTextNode(string2));
        }

        @Override
        public boolean removeAttribute(VolatileCData volatileCData) {
            String string2;
            String string3;
            if (this.itemKind() != 1) {
                throw this.createBadContextItemException("removeAttribute");
            }
            if (volatileCData == null) {
                throw this.createBadArgumentException("name", "null");
            }
            Element element2 = (Element)this.fNode;
            try {
                string3 = volatileCData.getQNameLocalPart(1);
                string2 = volatileCData.getQNameNamespaceURI(1);
                if (string2 != null && string2.length() == 0) {
                    string2 = null;
                }
            }
            catch (XCIDynamicErrorException xCIDynamicErrorException) {
                throw this.createBadArgumentException("name", volatileCData.toString());
            }
            try {
                if (!element2.hasAttributeNS(string2, string3)) {
                    return false;
                }
                element2.removeAttributeNS(string2, string3);
            }
            catch (DOMException dOMException) {
                throw this.createInternalException(dOMException);
            }
            return true;
        }

        private XCIIllegalContextItemException createBadContextItemException() {
            return new XCIIllegalContextItemException(XCIMessages.createXCIMessage("ER_ILLEGAL_CONTEXT_ITEM", new String[]{this.getNodeKindString(this.itemKind())}));
        }

        private XCIIllegalContextItemException createBadContextItemException(String string2) {
            return new XCIIllegalContextItemException(XCIMessages.createXCIMessage("ER_ILLEGAL_CONTEXT_ITEM_FOR_OP", new String[]{string2, this.getNodeKindString(this.itemKind())}));
        }

        private XCIIllegalArgumentException createBadArgumentException(String string2) {
            return new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_ILLEGAL_ARGS_WITHOUT_VALUE", new String[]{string2}));
        }

        private XCIIllegalArgumentException createBadArgumentException(String string2, String string3) {
            return new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_ILLEGAL_ARGS", new String[]{string3, string2}));
        }

        private XCIDynamicErrorException createInternalException(Exception exception) {
            return new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_ADAPTER_INTERNAL_ERR", new String[]{exception.getMessage()}));
        }

        private XCIIllegalMutationException createBadMutationCombination() {
            return new XCIIllegalMutationException(XCIMessages.createXCIMessage("ER_ILLEGAL_MUTATION_RELATIVE_TO_AREA", new String[]{this.getNodeKindString(this.itemKind())}));
        }

        @Override
        public boolean removeSubtree(Cursor.Area area) {
            Node node2;
            Node node3;
            boolean bl;
            short s = this.itemKind();
            boolean bl2 = Cursor.Area.SELF.equals(area);
            switch (s) {
                case 2: 
                case 4: {
                    throw this.createBadContextItemException("removeSubtree");
                }
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (bl2) {
                node3 = this.fNode;
            } else if (Cursor.Area.FIRST_CHILD.equals(area)) {
                node2 = this.fNode.getFirstChild();
                if (node2 != null && (node2 = this.siblingOrSelf(this.fNode.getFirstChild(), null, false)) != null && node2.getNodeType() == 10) {
                    node2 = this.siblingOrSelf(node2.getNextSibling(), null, false);
                }
                node3 = node2;
            } else if (Cursor.Area.LAST_CHILD.equals(area)) {
                node2 = null;
                Node node4 = this.fNode.getFirstChild();
                boolean bl3 = false;
                while (node4 != null) {
                    if ((node4 = this.siblingOrSelf(node4, null, bl3)) == null) continue;
                    bl3 = DOMAdapter.isText(node4.getNodeType());
                    node2 = node4;
                    node4 = node4.getNextSibling();
                }
                node3 = node2 != null && node2.getNodeType() != 10 ? node2 : null;
            } else if (Cursor.Area.FOLLOWING_SIBLING.equals(area)) {
                node2 = this.fNode.getNextSibling();
                if (node2 == null) {
                    node2 = this.nextSiblingThroughAncestorEntityRefs(this.fNode);
                }
                node3 = node2 = node2 == null ? null : this.siblingOrSelf(node2, null, bl);
            } else {
                throw this.createBadArgumentException("where");
            }
            if (node3 != null) {
                node2 = node3.getParentNode();
                if (node2 == null || node2.getNodeType() == 5 && this.getParentThroughEntityRefs(node2) == null) {
                    return false;
                }
                if (!DOMAdapter.isText(node3.getNodeType())) {
                    try {
                        node2.removeChild(node3);
                    }
                    catch (DOMException dOMException) {
                        throw this.createInternalException(dOMException);
                    }
                } else {
                    this.removeTextNode((Text)node3, bl2);
                }
                return true;
            }
            return false;
        }

        private final void removeTextNode(Text text2, boolean bl) {
            boolean bl2;
            Node node2;
            Node node3 = text2;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            arrayList.add(text2);
            do {
                bl2 = false;
                node2 = node3.getNextSibling();
                if (node2 != null && node2.getNodeType() == 5) {
                    node3 = this.nextSiblingThroughEntityRefs(node2);
                }
                if (node2 == null) {
                    node2 = this.nextSiblingThroughAncestorEntityRefs(node3);
                }
                if (node2 == null || !DOMAdapter.isText(node2.getNodeType())) continue;
                arrayList.add(node2);
                bl2 = true;
            } while ((node3 = node2) != null && bl2);
            if (bl && arrayList.size() != 1) {
                text2.setData(text2.getWholeText());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Node node4 = (Node)arrayList.get(i);
                Node node5 = node4.getParentNode();
                if (node5 == null) continue;
                node5.removeChild(node4);
            }
        }

        @Override
        public void setItemValue(VolatileCData volatileCData) {
            if (volatileCData == null) {
                throw this.createBadArgumentException("null", "value");
            }
            switch (this.itemKind()) {
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    this.fNode.setNodeValue(DOMAdapter.getVolatileCDataStringValue(volatileCData));
                    break;
                }
                default: {
                    throw this.createBadContextItemException("setItemValue");
                }
            }
        }

        @Override
        public void setItemPSVI(ItemPSVI itemPSVI) {
            switch (this.itemKind()) {
                case 2: {
                    if (!(itemPSVI instanceof AttributePSVI)) {
                        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_WRONG_ATTRIBUTE_TYPE", null));
                    }
                    AttributePSVI attributePSVI = (AttributePSVI)itemPSVI;
                    if (!(this.fNode instanceof PSVIAttrNSImpl)) {
                        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_WRONG_ATTRIBUTE_CLASS", null));
                    }
                    PSVIAttrNSImpl pSVIAttrNSImpl = (PSVIAttrNSImpl)this.fNode;
                    pSVIAttrNSImpl.setPSVI(attributePSVI);
                    break;
                }
                case 1: {
                    if (!(itemPSVI instanceof ElementPSVI)) {
                        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_WRONG_ELEMENT_TYPE", null));
                    }
                    ElementPSVI elementPSVI = (ElementPSVI)itemPSVI;
                    if (!(this.fNode instanceof PSVIElementNSImpl)) {
                        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_WRONG_ELEMENT_CLASS", null));
                    }
                    PSVIElementNSImpl pSVIElementNSImpl = (PSVIElementNSImpl)this.fNode;
                    pSVIElementNSImpl.setPSVI(elementPSVI);
                    break;
                }
                default: {
                    throw this.createBadContextItemException("setItemPSVI");
                }
            }
        }

        @Override
        public boolean itemIsBeforeNode(Cursor cursor2) {
            if (!this.itemIsSameDocument(cursor2)) {
                return this.factory().getSessionContext().documentIsBefore(this.itemDocumentIdentity(), cursor2.itemDocumentIdentity());
            }
            Cursor cursor3 = cursor2.unwrap();
            if (cursor3 instanceof DOMCursor) {
                Node node2 = this.fNode;
                Node node3 = ((DOMCursor)cursor3).fNode;
                if (cursor3 == node2) {
                    return false;
                }
                return (DOMAdapter.compareDocumentPosition(node2, node3) & 4) != 0;
            }
            throw new RuntimeException(XCIMessages.createXCIMessage("ER_MIXED_DATA_MODEL", new String[]{cursor3.getClass().getName()}));
        }

        @Override
        public Cursor sequenceConcat(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            if (cursor2 == null) {
                Cursor cursor3 = DOMCursor.ownTheCursor(this, bl, bl3);
                return cursor3;
            }
            if (cursor2 instanceof DOMCursor && this.itemIsSameDocument(cursor2)) {
                DOMCursor dOMCursor = (DOMCursor)DOMCursor.ownTheCursorIfMightMove(this, bl, bl3);
                Cursor cursor4 = new DOMSequence(dOMCursor, bl);
                DOMCursor.ownedCleanupIfMightMove(dOMCursor, bl, bl3);
                cursor4 = cursor4.sequenceConcat(cursor2, profile, profile2, bl, bl2, true, bl4);
                return cursor4;
            }
            Cursor cursor5 = AbstractCursor.defaultSequenceConcatWithMultidoc(this, cursor2, profile, profile2, bl, bl2, bl3, bl4);
            return cursor5;
        }

        protected CData string(Node node2) {
            StringCDataBuilder stringCDataBuilder = new StringCDataBuilder(TypeRegistry.XSSTRING);
            this.string(stringCDataBuilder, node2);
            return stringCDataBuilder.toCData();
        }

        private void string(StringCDataBuilder stringCDataBuilder, Node node2) {
            if (node2.getNodeType() == 3) {
                stringCDataBuilder.append(this.factory().data((CharSequence)node2.getNodeValue(), TypeRegistry.XSSTRING, false));
            }
            NodeList nodeList = node2.getChildNodes();
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                this.string(stringCDataBuilder, nodeList.item(i));
            }
        }

        Node siblingOrSelf(Node node2, Predicate predicate2, boolean bl) {
            Node node3 = this.fNode;
            long l = this.fPosition;
            do {
                Node node4;
                short s;
                if ((s = node2.getNodeType()) == 5) {
                    node2 = this.nextSiblingThroughEntityRefs(node2);
                    continue;
                }
                if (DOMAdapter.isText(s)) {
                    if (bl) {
                        node4 = node2.getNextSibling();
                        node2 = node4 == null ? this.nextSiblingThroughAncestorEntityRefs(node2) : node4;
                        continue;
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                if (s != 10) {
                    this.fNode = node2;
                    ++this.fPosition;
                    if (predicate2 == null || predicate2.test(this)) break;
                }
                Node node5 = node2 = (node4 = node2.getNextSibling()) == null ? this.nextSiblingThroughAncestorEntityRefs(node2) : node4;
            } while (node2 != null);
            this.fNode = node3;
            this.fPosition = l;
            return node2;
        }

        Node previousSiblingOrSelf(Node node2, Predicate predicate2) {
            Node node3 = this.fNode;
            long l = this.fPosition;
            do {
                Node node4;
                short s;
                if ((s = node2.getNodeType()) == 5) {
                    node2 = this.previousSiblingThroughEntityRefs(node2);
                    continue;
                }
                if (DOMAdapter.isText(s)) {
                    node4 = node2;
                    while (node4 != null && DOMAdapter.isText(node4.getNodeType())) {
                        node2 = node4;
                        node4 = (node4 = node2.getPreviousSibling()) == null ? this.previousSiblingThroughAncestorEntityRefs(node2, false) : node4;
                    }
                }
                if (s != 10) {
                    this.fNode = node2;
                    ++this.fPosition;
                    if (predicate2 == null || predicate2.test(this)) break;
                }
                Node node5 = node2 = (node4 = node2.getPreviousSibling()) == null ? this.previousSiblingThroughAncestorEntityRefs(node2, false) : node4;
            } while (node2 != null);
            this.fNode = node3;
            this.fPosition = l;
            return node2;
        }

        Node nextSiblingThroughAncestorEntityRefs(Node node2) {
            Node node3 = null;
            for (Node node4 = node2.getParentNode(); node3 == null && node4 != null && node4.getNodeType() == 5; node4 = node4.getParentNode()) {
                node3 = node4.getNextSibling();
            }
            return node3;
        }

        Node previousSiblingThroughAncestorEntityRefs(Node node2, boolean bl) {
            int n2 = 0;
            if (bl) {
                n2 = this.fSequenceIndex;
            }
            Node node3 = null;
            Node node4 = node2.getParentNode();
            while (node3 == null && node4 != null && node4.getNodeType() == 5) {
                node3 = node4.getPreviousSibling();
                if ((node4 = node4.getParentNode()) == null) continue;
                --n2;
            }
            if (bl) {
                this.fSequenceIndex = n2;
            }
            return node3;
        }

        Node nextSiblingThroughEntityRefs(Node node2) {
            while (node2 != null && node2.getNodeType() == 5) {
                Node node3 = node2.getFirstChild();
                if (node3 == null && (node3 = node2.getNextSibling()) == null) {
                    node3 = this.nextSiblingThroughAncestorEntityRefs(node2);
                }
                node2 = node3;
            }
            return node2;
        }

        Node previousSiblingThroughEntityRefs(Node node2) {
            while (node2 != null && node2.getNodeType() == 5) {
                Node node3 = node2.getFirstChild();
                if (node3 == null && (node3 = node2.getPreviousSibling()) == null) {
                    node3 = this.previousSiblingThroughAncestorEntityRefs(node2, false);
                }
                node2 = node3;
            }
            return node2;
        }

        Node precedingSibling(Node node2, Predicate predicate2) {
            if (node2 == null) {
                return null;
            }
            if (predicate2 == null) {
                return node2;
            }
            Node node3 = this.fNode;
            long l = this.fPosition;
            do {
                this.fNode = node2;
                --this.fPosition;
            } while (!predicate2.test(this) && (node2 = node2.getPreviousSibling()) != null);
            this.fNode = node3;
            this.fPosition = l;
            return node2;
        }

        protected boolean simpleTest(Node node2, Predicate predicate2) {
            if (null == predicate2) {
                return true;
            }
            Node node3 = this.fNode;
            this.fNode = node2;
            boolean bl = predicate2.test(this);
            this.fNode = node3;
            return bl;
        }

        int nextAttribute(int n2, Predicate predicate2, NamedNodeMap namedNodeMap, boolean bl) {
            if (namedNodeMap.getLength() > n2) {
                Node node2 = this.fNode;
                long l = this.fPosition;
                do {
                    this.fNode = namedNodeMap.item(n2);
                    ++this.fPosition;
                } while ((bl != ("xmlns".equals(this.fNode.getPrefix()) || "xmlns".equals(this.fNode.getNodeName())) || predicate2 != null && !predicate2.test(this)) && ++n2 < namedNodeMap.getLength());
                this.fNode = node2;
                this.fPosition = l;
            }
            return n2 < namedNodeMap.getLength() ? n2 : -1;
        }

        int previousAttribute(int n2, Predicate predicate2, NamedNodeMap namedNodeMap, boolean bl) {
            if (0 < n2) {
                Node node2 = this.fNode;
                long l = this.fPosition;
                do {
                    this.fNode = namedNodeMap.item(n2);
                    --this.fPosition;
                } while ((bl != ("xmlns".equals(this.fNode.getPrefix()) || "xmlns".equals(this.fNode.getNodeName())) || predicate2 != null && !predicate2.test(this)) && --n2 >= 0);
                this.fNode = node2;
                this.fPosition = l;
            }
            if (n2 >= 0) {
                return n2;
            }
            return -1;
        }

        private void cacheIdrefNodes(Node node2, String string2) {
            Node node3;
            if (node2.getNodeType() == 9) {
                Document document2 = (Document)node2;
                node3 = document2.getDocumentElement();
            } else {
                node3 = node2.getNodeType() == 11 ? node2 : node2.getOwnerDocument().getDocumentElement();
            }
            if (string2.equals("CACHEIDREFS")) {
                this.handleIdrefsElementNodes(node3);
            } else if (string2.equals("CACHEIDS")) {
                this.handleIdsElementNodes(node3);
            }
        }

        private void handleIdsElementNodes(Node node2) {
            if (node2 != null) {
                Object object2;
                if (node2.getNodeType() == 1) {
                    if (this.nodeIsID(node2)) {
                        object2 = (ElementPSVI)((Object)node2);
                        if (this.isElementWithId) {
                            this.setIDAttribute(object2.getSchemaNormalizedValue(), node2.getParentNode());
                        } else {
                            this.setIDAttribute(object2.getSchemaNormalizedValue(), node2);
                        }
                    }
                    if (node2.hasAttributes()) {
                        this.handleIdsAttributeNodes(node2.getAttributes());
                    }
                }
                if (node2.hasChildNodes()) {
                    object2 = node2.getChildNodes();
                    int n2 = object2.getLength();
                    for (int i = 0; i < n2; ++i) {
                        Node node3 = object2.item(i);
                        short s = node3.getNodeType();
                        if (s != 1) continue;
                        this.handleIdsElementNodes(node3);
                    }
                }
            }
        }

        private void handleIdrefsElementNodes(Node node2) {
            if (node2 != null) {
                Object object2;
                if (node2.getNodeType() == 1) {
                    if (this.nodeIsIDREF(node2)) {
                        object2 = (ElementPSVI)((Object)node2);
                        this.setIDREFAttribute(object2.getSchemaNormalizedValue(), node2);
                    }
                    if (node2.hasAttributes()) {
                        this.handleIdrefsAttributeNodes(node2.getAttributes());
                    }
                }
                if (node2.hasChildNodes()) {
                    object2 = node2.getChildNodes();
                    int n2 = object2.getLength();
                    for (int i = 0; i < n2; ++i) {
                        Node node3 = object2.item(i);
                        short s = node3.getNodeType();
                        if (s != 1) continue;
                        this.handleIdrefsElementNodes(node3);
                    }
                }
            }
        }

        private void handleIdsAttributeNodes(NamedNodeMap namedNodeMap) {
            if (namedNodeMap != null) {
                int n2 = namedNodeMap.getLength();
                for (int i = 0; i < n2; ++i) {
                    String string2;
                    Node node2 = namedNodeMap.item(i);
                    if (!this.nodeIsID(node2)) continue;
                    if (node2 instanceof ItemPSVI) {
                        string2 = ((ItemPSVI)((Object)node2)).getSchemaNormalizedValue();
                        if (string2 == null) {
                            string2 = node2.getNodeValue();
                        }
                    } else {
                        string2 = node2.getNodeValue();
                    }
                    this.setIDAttribute(string2, ((Attr)node2).getOwnerElement());
                }
            }
        }

        private void handleIdrefsAttributeNodes(NamedNodeMap namedNodeMap) {
            if (namedNodeMap != null) {
                int n2 = namedNodeMap.getLength();
                for (int i = 0; i < n2; ++i) {
                    String string2;
                    Node node2 = namedNodeMap.item(i);
                    if (!this.nodeIsIDREF(node2)) continue;
                    if (node2 instanceof ItemPSVI) {
                        string2 = ((ItemPSVI)((Object)node2)).getSchemaNormalizedValue();
                        if (string2 == null) {
                            string2 = node2.getNodeValue();
                        }
                    } else {
                        string2 = node2.getNodeValue();
                    }
                    this.setIDREFAttribute(string2, node2);
                }
            }
        }

        private void setIDAttribute(String string2, Node node2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.setIDAttributeHelper(stringTokenizer.nextToken(), node2, DOMAdapter.this.fIDAttributes);
            }
        }

        private void setIDREFAttribute(String string2, Node node2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.setIDREFAttributeHelper(stringTokenizer.nextToken(), node2, DOMAdapter.this.fIDREFAttributes);
            }
        }

        private void setIDAttributeHelper(String string2, Node node2, HashMap<String, Node> hashMap) {
            Node node3 = hashMap.get(string2);
            if (node3 == null) {
                hashMap.put(string2, node2);
            }
        }

        private void setIDREFAttributeHelper(String string2, Node node2, HashMap<String, Object> hashMap) {
            Object object2 = hashMap.get(string2);
            if (object2 == null) {
                hashMap.put(string2, node2);
            } else if (object2 instanceof Node) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                arrayList.add((Node)object2);
                arrayList.add(node2);
                hashMap.put(string2, arrayList);
            } else if (object2 instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)object2;
                arrayList.add(node2);
                hashMap.put(string2, arrayList);
            }
        }

        private Node getElementById(String string2) {
            return DOMAdapter.this.fIDAttributes.get(string2);
        }

        private Object getNodesByIdref(String string2) {
            return DOMAdapter.this.fIDREFAttributes.get(string2);
        }

        private String getNodeKindString(short s) {
            if (s == 9) {
                return "DOCUMENT_KIND";
            }
            if (s == 1) {
                return "ELEMENT_KIND";
            }
            if (s == 2) {
                return "ATTRIBUTE_KIND";
            }
            if (s == 4) {
                return "NAMESPACE_DECL_KIND";
            }
            if (s == 8) {
                return "COMMENT_KIND";
            }
            if (s == 7) {
                return "PROCESSING_INSTRUCTION_KIND";
            }
            if (s == 3) {
                return "TEXT_KIND";
            }
            return "";
        }

        private ArrayList<Node> getElementsByIds(VolatileCData volatileCData) {
            if (DOMAdapter.this.fIDAttributes == null) {
                DOMAdapter.this.fIDAttributes = new HashMap();
                this.cacheIdrefNodes(this.fNode, "CACHEIDS");
            }
            ArrayList<Node> arrayList = null;
            int n2 = volatileCData.getSize();
            for (int i = 1; i <= n2; ++i) {
                Node node2 = this.getElementById(volatileCData.getString(i));
                if (node2 == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Node>();
                }
                arrayList.add(node2);
            }
            return arrayList;
        }

        private ArrayList<Node> getNodesByIdrefs(VolatileCData volatileCData) {
            if (DOMAdapter.this.fIDREFAttributes == null) {
                DOMAdapter.this.fIDREFAttributes = new HashMap();
                this.cacheIdrefNodes(this.fNode, "CACHEIDREFS");
            }
            ArrayList<Node> arrayList = null;
            int n2 = volatileCData.getSize();
            for (int i = 1; i <= n2; ++i) {
                Object object2 = this.getNodesByIdref(volatileCData.getString(i));
                if (object2 == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Node>();
                }
                if (object2 instanceof Node) {
                    arrayList.add((Node)object2);
                    continue;
                }
                arrayList.addAll((ArrayList)object2);
            }
            return arrayList;
        }

        public String toString() {
            if (this.fNode == null) {
                return "NULL";
            }
            switch (this.fNode.getNodeType()) {
                case 2: {
                    return this.fNode.getNodeName() + "=" + this.fNode.getNodeValue();
                }
            }
            return this.fNode.toString();
        }

        public VolatileCData serialize(Map map2) {
            DOMCursor dOMCursor = this;
            SerializedCData serializedCData = new SerializedCData(dOMCursor, map2);
            return serializedCData;
        }

        @Deprecated
        public Node getNode() {
            return this.fNode;
        }

        @Override
        public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
            if (this.contextIsOrdered(true)) {
                return bl ? this : this.fork(false, profile, profile2);
            }
            DOMSequence dOMSequence = new DOMSequence(this, false);
            if (bl) {
                this.release();
            }
            Cursor cursor2 = dOMSequence.documentOrder(profile, profile2, true);
            return cursor2;
        }

        @Override
        public void addAttribute(VolatileCData volatileCData, Chars chars) {
            if (chars == null) {
                throw this.createBadArgumentException("value", "null");
            }
            this.addAttribute(volatileCData, StringChars.toString(chars));
        }

        @Override
        public void addComment(Cursor.Area area, Chars chars) {
            this.addNode(area, DOMAdapter.this.fDocument.createComment(StringChars.toString(chars)));
        }

        @Override
        public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, Chars chars) {
            String string2 = volatileCData.getQNameLocalPart(1);
            String string3 = chars != null ? StringChars.toString(chars) : null;
            this.addNode(area, DOMAdapter.this.fDocument.createProcessingInstruction(string2, string3));
        }

        @Override
        public void addText(Cursor.Area area, Chars chars) {
            if (chars == null) {
                throw this.createBadArgumentException("value", "null");
            }
            this.addNode(area, DOMAdapter.this.fDocument.createTextNode(StringChars.toString(chars)));
        }

        @Override
        public void setItemBaseURI(String string2) {
            DOMAdapter.this.fDocument.setDocumentURI(string2);
        }

        @Override
        public boolean contextIsLive() {
            return true;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class NodeNamespaceContext
        implements ExtendedNamespaceContext {
            private Node fNode;

            public NodeNamespaceContext(Node node2) {
                this.fNode = node2;
            }

            @Override
            public String getNamespaceURI(String string2) {
                if (string2 == null) {
                    throw new IllegalArgumentException();
                }
                if (string2.equals("xml")) {
                    return "http://www.w3.org/XML/1998/namespace";
                }
                PrefixTester prefixTester = new PrefixTester(string2);
                this.namespaceSearch(prefixTester);
                return (String)((NSTester)prefixTester).result();
            }

            @Override
            public String getPrefix(String string2) {
                if (string2 == null) {
                    throw new IllegalArgumentException();
                }
                if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
                    return "xml";
                }
                URITester uRITester = new URITester(string2);
                this.namespaceSearch(uRITester);
                return (String)((NSTester)uRITester).result();
            }

            public Iterator getPrefixes(String string2) {
                if (string2 == null) {
                    throw new IllegalArgumentException();
                }
                if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("xml");
                    return arrayList.iterator();
                }
                PrefixAccumulatorForURITester prefixAccumulatorForURITester = new PrefixAccumulatorForURITester(string2);
                this.namespaceSearch(prefixAccumulatorForURITester);
                return ((List)((NSTester)prefixAccumulatorForURITester).result()).iterator();
            }

            @Override
            public Iterator<String> getInScopeNamespaces() {
                NamespacesAccumulator namespacesAccumulator = new NamespacesAccumulator();
                this.namespaceSearch(namespacesAccumulator);
                return ((List)((NSTester)namespacesAccumulator).result()).iterator();
            }

            private void namespaceSearch(NSTester nSTester) {
                for (Node node2 = this.fNode; node2 != null; node2 = node2.getParentNode()) {
                    if (node2.getNodeType() != 1) continue;
                    if (nSTester.test(node2.getPrefix(), node2.getNamespaceURI()) == SearchState.HALT) {
                        return;
                    }
                    if (node2 instanceof ItemPSVI && this.testItemValue((ItemPSVI)((Object)node2), nSTester) == SearchState.HALT) {
                        return;
                    }
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    if (namedNodeMap != null) {
                        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                            String string2;
                            Attr attr2 = (Attr)namedNodeMap.item(i);
                            String string3 = attr2.getName();
                            if (DOMAdapter.isNamespace(attr2)) {
                                String string4 = string2 = string3.equals("xmlns") ? "" : attr2.getLocalName();
                                if (nSTester.test(string2, attr2.getNodeValue()) == SearchState.HALT) {
                                    return;
                                }
                            } else {
                                string2 = attr2.getPrefix();
                                String string5 = attr2.getNamespaceURI();
                                if (string2 != null && string5 != null && nSTester.test(string2, string5) == SearchState.HALT) {
                                    return;
                                }
                            }
                            if (!(attr2 instanceof ItemPSVI) || this.testItemValue((ItemPSVI)((Object)node2), nSTester) != SearchState.HALT) continue;
                            return;
                        }
                    }
                    nSTester.test("xml", "http://www.w3.org/XML/1998/namespace");
                }
            }

            private SearchState testItemValue(ItemPSVI itemPSVI, NSTester nSTester) {
                switch (itemPSVI.getActualNormalizedValueType()) {
                    case 45: {
                        return null;
                    }
                    case 19: {
                        CData cData = DOMCursor.this.createCData(itemPSVI, null);
                        return nSTester.test(cData.getQNamePrefix(1), cData.getQNameNamespaceURI(1));
                    }
                    case 43: 
                    case 44: {
                        CData cData = DOMCursor.this.createCData(itemPSVI, null);
                        for (int i = 1; i <= cData.getSize(); ++i) {
                            CData cData2 = cData.itemAt(i);
                            if (cData2.getXSTypeDefinition().getBuiltInKind() != 19 || nSTester.test(cData2.getQNamePrefix(1), cData2.getQNameNamespaceURI(1)) != SearchState.HALT) continue;
                            return SearchState.HALT;
                        }
                        break;
                    }
                }
                return SearchState.CONTINUE;
            }

            @Override
            public ExtendedNamespaceContext constantENS(boolean bl) {
                return this;
            }
        }

        private class ItemNameClass
        extends QNameCDataAbstract {
            private int fContextNodeKind;

            private ItemNameClass() {
            }

            public void setNodeKind(int n2) {
                this.fContextNodeKind = n2;
            }

            public boolean isConstant() {
                return false;
            }

            public CData constant(boolean bl) {
                return DOMCursor.this.factory.data((CharSequence)this.getQNameNamespaceURI(1), this.getQNameLocalPart(1), this.getQNamePrefix(1));
            }

            public CharSequence getOriginalLexicalValue() {
                return null;
            }

            public QName getQName(int n2, NamespaceContext namespaceContext) {
                if (n2 != 1) {
                    throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
                }
                return this.getQName();
            }

            protected QName getQName() {
                String string2 = this.getQNameLocalPart(1);
                String string3 = this.getQNamePrefix(1);
                String string4 = this.getQNameNamespaceURI(1);
                return new QName(string4, string2, string3);
            }

            public String getQNameLocalPart(int n2) {
                if (n2 != 1) {
                    throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
                }
                Node node2 = DOMCursor.this.fNode;
                String string2 = "";
                switch (this.fContextNodeKind) {
                    case 1: {
                        string2 = node2.getLocalName();
                        if (string2 != null) break;
                        string2 = node2.getNodeName();
                        break;
                    }
                    case 2: {
                        string2 = node2.getLocalName();
                        if (string2 == null) {
                            string2 = node2.getNodeName();
                        }
                        if (!string2.equals("xmlns") || !node2.getNodeName().equals("xmlns")) break;
                        string2 = "";
                        break;
                    }
                    case 7: {
                        string2 = ((ProcessingInstruction)node2).getTarget();
                    }
                }
                return string2;
            }

            public String getQNameNamespaceURI(int n2) {
                if (n2 != 1) {
                    throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
                }
                Node node2 = DOMCursor.this.fNode;
                String string2 = "";
                switch (this.fContextNodeKind) {
                    case 1: {
                        string2 = node2.getNamespaceURI();
                        break;
                    }
                    case 2: {
                        String string3 = node2.getNodeName();
                        if (string3.startsWith("xmlns:") || string3.equals("xmlns")) break;
                        string2 = node2.getNamespaceURI();
                        break;
                    }
                }
                return string2 == null ? "" : string2;
            }

            public String getQNamePrefix(int n2) {
                if (n2 != 1) {
                    throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
                }
                Node node2 = DOMCursor.this.fNode;
                String string2 = null;
                switch (this.fContextNodeKind) {
                    case 1: {
                        string2 = node2.getPrefix();
                        break;
                    }
                    case 2: {
                        string2 = node2.getPrefix();
                        if (!"xmlns".equals(string2)) break;
                        string2 = "";
                    }
                }
                return string2 == null ? "" : string2;
            }

            public String getString(int n2) {
                if (n2 != 1) {
                    throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
                }
                String string2 = this.getQNameLocalPart(1);
                String string3 = this.getQNamePrefix(1);
                return string3.length() == 0 ? string2 : string3 + ':' + string2;
            }
        }

        private class ContextPosition {
            private long fSavedPosition;
            private int fSavedSequenceIndex;
            private Node fSavedNode;

            public ContextPosition() {
                this.fSavedPosition = DOMCursor.this.fPosition;
                this.fSavedSequenceIndex = DOMCursor.this.fSequenceIndex;
                this.fSavedNode = DOMCursor.this.fNode;
            }

            public void restorePosition() {
                DOMCursor.this.fPosition = this.fSavedPosition;
                DOMCursor.this.fSequenceIndex = this.fSavedSequenceIndex;
                DOMCursor.this.fNode = this.fSavedNode;
            }
        }
    }
}

