/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.dom;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.adapters.dom.DOMAdapter;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.StaticContext;
import com.ibm.xml.xci.res.XCIMessages;
import java.util.Map;
import javax.xml.transform.Result;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DOMAxisExecutable
implements Executable {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\n\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected NodeTest fTest;

    private DOMAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
        this.fTest = nodeTest;
    }

    public static Executable newInstance(Axis axis, NodeTest nodeTest, StaticContext staticContext) {
        switch (axis) {
            case SELF: {
                return new DOMSelfAxisExecutable(nodeTest, staticContext);
            }
            case CHILD: {
                return new DOMChildAxisExecutable(nodeTest, staticContext);
            }
            case PARENT: {
                return new DOMParentAxisExecutable(nodeTest, staticContext);
            }
            case ATTRIBUTE: {
                return new DOMAttributeAxisExecutable(nodeTest, staticContext);
            }
            case DESCENDANT: {
                return new DOMDescendantAxisExecutable(nodeTest, staticContext);
            }
            case DESCENDANTORSELF: {
                return new DOMDescendantOrSelfAxisExecutable(nodeTest, staticContext);
            }
            case FOLLOWINGSIBLING: {
                return new DOMFollowingSiblingAxisExecutable(nodeTest, staticContext);
            }
            case PRECEDINGSIBLING: {
                return new DOMPrecedingSiblingAxisExecutable(nodeTest, staticContext);
            }
            case NAMESPACEDECLS: 
            case NAMESPACEWITHINELEMENT: {
                return new DOMNamespaceDeclsAxisExecutable(nodeTest, staticContext);
            }
            case NAMESPACE: {
                return new DOMNamespaceAxisExecutable(nodeTest, staticContext);
            }
        }
        return null;
    }

    @Override
    public void execute(Cursor cursor2, Cursor.Area area, Cursor cursor3, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
        if (cursor3 == null) {
            throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_ILLEGAL_ARGS", new String[]{"null", "result"}));
        }
        Cursor cursor4 = this.execute(cursor2, dynamicContext, profile, cursorArray);
        if (cursor4 != null) {
            cursor3.addCopy(area, cursor4);
            cursor4.release();
        }
    }

    @Override
    public final Cursor execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
        DOMAdapter.DOMCursor dOMCursor = (DOMAdapter.DOMCursor)cursor2.unwrap();
        DOMAdapter.DOMCursor dOMCursor2 = dOMCursor.duplicate(true);
        Cursor cursor3 = this.toFirst(dOMCursor2);
        if (cursor3 != null) {
            CursorFactory cursorFactory = cursor3.factory();
            Cursor cursor4 = cursorFactory.proxy(cursor3, profile, false, null, null);
            return cursor4;
        }
        dOMCursor2.release();
        return null;
    }

    @Override
    public void execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray, Result result2) {
        Cursor cursor3 = this.execute(cursor2, dynamicContext, profile, cursorArray);
        cursor3.copyToResult(result2, null, false, true);
    }

    protected abstract Cursor toFirst(DOMAdapter.DOMCursor var1);

    @Override
    public Map<String, Object> getProperties() {
        return null;
    }

    private static class DOMNamespaceAxisExecutable
    extends DOMAxisExecutable {
        public DOMNamespaceAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(DOMAdapter.DOMCursor dOMCursor) {
            return dOMCursor.toNamespaces(this.fTest) ? dOMCursor : null;
        }
    }

    private static class DOMNamespaceDeclsAxisExecutable
    extends DOMAxisExecutable {
        public DOMNamespaceDeclsAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(DOMAdapter.DOMCursor dOMCursor) {
            return dOMCursor.toNamespaceDecls(this.fTest) ? dOMCursor : null;
        }
    }

    private static class DOMDescendantOrSelfAxisExecutable
    extends DOMAxisExecutable {
        public DOMDescendantOrSelfAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(DOMAdapter.DOMCursor dOMCursor) {
            NodeTest nodeTest = this.fTest;
            return dOMCursor.toDescendantsOrSelf(nodeTest) ? dOMCursor : null;
        }
    }

    private static class DOMDescendantAxisExecutable
    extends DOMAxisExecutable {
        public DOMDescendantAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(DOMAdapter.DOMCursor dOMCursor) {
            return dOMCursor.toDescendants(this.fTest) ? dOMCursor : null;
        }
    }

    private static class DOMPrecedingSiblingAxisExecutable
    extends DOMAxisExecutable {
        public DOMPrecedingSiblingAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(DOMAdapter.DOMCursor dOMCursor) {
            return dOMCursor.toPrecedingSiblings(this.fTest) ? dOMCursor : null;
        }
    }

    private static class DOMFollowingSiblingAxisExecutable
    extends DOMAxisExecutable {
        public DOMFollowingSiblingAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(DOMAdapter.DOMCursor dOMCursor) {
            return dOMCursor.toFollowingSiblings(this.fTest) ? dOMCursor : null;
        }
    }

    private static class DOMAttributeAxisExecutable
    extends DOMAxisExecutable {
        public DOMAttributeAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(DOMAdapter.DOMCursor dOMCursor) {
            return dOMCursor.toAttributes(this.fTest) ? dOMCursor : null;
        }
    }

    private static class DOMParentAxisExecutable
    extends DOMAxisExecutable {
        public DOMParentAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(DOMAdapter.DOMCursor dOMCursor) {
            if (dOMCursor.toParent() && (this.fTest == null || this.fTest.test(dOMCursor))) {
                return dOMCursor;
            }
            return null;
        }
    }

    private static class DOMChildAxisExecutable
    extends DOMAxisExecutable {
        public DOMChildAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(DOMAdapter.DOMCursor dOMCursor) {
            Node node2 = dOMCursor.fNode;
            short s = node2.getNodeType();
            boolean bl = false;
            if ((s == 1 || s == 9 || s == 11 || s == 5) && node2.hasChildNodes()) {
                Node node3 = dOMCursor.siblingOrSelf(node2.getFirstChild(), this.fTest, false);
                if (node3 != null && node3.getNodeType() == 10) {
                    node3 = dOMCursor.siblingOrSelf(node3.getNextSibling(), this.fTest, false);
                }
                if (node3 != null) {
                    dOMCursor.fNode = node3;
                    dOMCursor.fPosition = 1L;
                    dOMCursor.fSize = -1L;
                    dOMCursor.fContextSequenceMode = (short)2;
                    dOMCursor.fTest = this.fTest;
                    dOMCursor.fAttributes = null;
                    dOMCursor.fNodesFound = null;
                    assert (DOMAdapter.isValidXDMNodeKind(dOMCursor.itemKind())) : "Invalid XDM node kind";
                    return dOMCursor;
                }
                return null;
            }
            return null;
        }
    }

    private static class DOMSelfAxisExecutable
    extends DOMAxisExecutable {
        public DOMSelfAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(DOMAdapter.DOMCursor dOMCursor) {
            NodeTest nodeTest = this.fTest;
            if (dOMCursor.toSelf() && (nodeTest == null || nodeTest.test(dOMCursor))) {
                return dOMCursor;
            }
            return null;
        }
    }
}

