/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.DefaultResult;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.adapters.dom.DOMAdapter;
import com.ibm.xml.xci.adapters.dom.DOMUtils;
import com.ibm.xml.xci.dp.base.AbstractCursorFactory;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.errors.DynamicErrorException;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.dom.AttrNSImpl;
import com.ibm.xml.xml4j.internal.s1.dom.ElementNSImpl;
import com.ibm.xml.xml4j.internal.s1.impl.Version;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class DOMCursorFactory
extends AbstractCursorFactory {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\n\n\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger s_logger = LoggerUtil.getLogger(DOMCursorFactory.class);
    private static final String s_className = DOMCursorFactory.class.getName();

    public DOMCursorFactory(SessionContext sessionContext) {
        super(sessionContext);
    }

    public Cursor document(Source source, RequestInfo requestInfo) {
        DOMAdapter.DOMCursor dOMCursor;
        if (source == null) {
            DOMAdapter.DOMCursor dOMCursor2;
            DocumentFragment documentFragment = DOMUtils.makeDocumentFragment(requestInfo, this.getSessionContext());
            dOMCursor = dOMCursor2 = DOMAdapter.makeCursor(this, documentFragment, requestInfo, this.getErrorHandler(requestInfo));
        } else if (source instanceof DOMSource) {
            DOMAdapter.DOMCursor dOMCursor3;
            DOMSource dOMSource = (DOMSource)source;
            dOMCursor = dOMCursor3 = DOMAdapter.makeCursor(this, dOMSource.getNode(), requestInfo, this.getErrorHandler(requestInfo));
        } else {
            Object object2;
            StreamSource streamSource = (StreamSource)source;
            InputSource inputSource = new InputSource(source.getSystemId());
            Reader reader = streamSource.getReader();
            if (reader != null) {
                inputSource.setCharacterStream(reader);
            } else {
                object2 = streamSource.getInputStream();
                if (object2 != null) {
                    inputSource.setByteStream((InputStream)object2);
                }
            }
            inputSource.setPublicId(streamSource.getPublicId());
            inputSource.setEncoding(requestInfo.getEncoding());
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                object2 = source.getSystemId() != null ? "'" + source.getSystemId() + "' " : "";
                object2 = (String)object2 + "from " + source.toString();
                s_logger.logp(Level.FINE, s_className, "document", "Parsing document " + (String)object2 + " using " + Version.getVersion());
            }
            object2 = DOMUtils.parse(inputSource, requestInfo, this.getSessionContext());
            DOMSource dOMSource = new DOMSource((Node)object2);
            return this.document(dOMSource, requestInfo);
        }
        return this.proxy(dOMCursor, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    public Cursor document(Result result2, RequestInfo requestInfo) {
        DOMAdapter.DOMCursor dOMCursor = null;
        if (result2 instanceof DOMResult) {
            DOMResult dOMResult = (DOMResult)result2;
            Node node2 = dOMResult.getNode();
            Node node3 = dOMResult.getNextSibling();
            if (node2 == null) {
                if (node3 != null) {
                    throw new DynamicErrorException("[XX0000]", null, new IllegalArgumentException("A DOMResult object specified a next sibling but did not specify a node.  If a next sibling is specified, a node must also be supplied."));
                }
                node2 = DOMUtils.makeDocumentFragment(requestInfo, this.getSessionContext());
                dOMResult.setNode(node2);
            }
            dOMCursor = DOMAdapter.makeCursor(this, node2, requestInfo, this.getErrorHandler(requestInfo));
        } else if (result2 == null || result2 instanceof DefaultResult) {
            DocumentFragment documentFragment = DOMUtils.makeDocumentFragment(requestInfo, this.getSessionContext());
            dOMCursor = DOMAdapter.makeCursor(this, documentFragment, requestInfo, this.getErrorHandler(requestInfo));
        } else {
            return super.document(result2, requestInfo);
        }
        return this.proxy(dOMCursor, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    public Cursor element(VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition, RequestInfo requestInfo) {
        String string2 = volatileCData.getQNameNamespaceURI(1);
        String string3 = volatileCData.getString(1);
        Element element2 = DOMUtils.makeDocument(requestInfo, this.getSessionContext()).createElementNS(string2, string3);
        if (element2 instanceof ElementNSImpl) {
            ((ElementNSImpl)element2).setType(xSTypeDefinition);
        }
        DOMAdapter.DOMCursor dOMCursor = DOMAdapter.makeCursor(this, element2, requestInfo, this.getErrorHandler(requestInfo));
        return this.proxy(dOMCursor, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    public Cursor text(VolatileCData volatileCData, RequestInfo requestInfo) {
        String string2 = DOMAdapter.getVolatileCDataStringValue(volatileCData);
        Text text2 = DOMUtils.makeDocument(requestInfo, this.getSessionContext()).createTextNode(string2);
        DOMAdapter.DOMCursor dOMCursor = DOMAdapter.makeCursor(this, text2, requestInfo, this.getErrorHandler(requestInfo));
        return this.proxy(dOMCursor, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), null);
    }

    public Cursor comment(VolatileCData volatileCData, RequestInfo requestInfo) {
        String string2 = DOMAdapter.getVolatileCDataStringValue(volatileCData);
        Comment comment2 = DOMUtils.makeDocument(requestInfo, this.getSessionContext()).createComment(string2);
        DOMAdapter.DOMCursor dOMCursor = DOMAdapter.makeCursor(this, comment2, requestInfo, this.getErrorHandler(requestInfo));
        return this.proxy(dOMCursor, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    public Cursor processingInstruction(VolatileCData volatileCData, VolatileCData volatileCData2, RequestInfo requestInfo) {
        String string2 = volatileCData.getString(1);
        String string3 = DOMAdapter.getVolatileCDataStringValue(volatileCData2);
        ProcessingInstruction processingInstruction = DOMUtils.makeDocument(requestInfo, this.getSessionContext()).createProcessingInstruction(string2, string3);
        DOMAdapter.DOMCursor dOMCursor = DOMAdapter.makeCursor(this, processingInstruction, requestInfo, this.getErrorHandler(requestInfo));
        return this.proxy(dOMCursor, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    public Cursor attribute(VolatileCData volatileCData, VolatileCData volatileCData2, RequestInfo requestInfo) {
        Attr attr2 = this.attribute(volatileCData, DOMAdapter.getVolatileCDataStringValue(volatileCData2), requestInfo);
        if (attr2 instanceof AttrNSImpl) {
            ((AttrNSImpl)attr2).setType(volatileCData2.getXSTypeDefinition());
        }
        DOMAdapter.DOMCursor dOMCursor = DOMAdapter.makeCursor(this, attr2, requestInfo, this.getErrorHandler(requestInfo));
        return this.proxy(dOMCursor, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    public Cursor namespace(VolatileCData volatileCData, VolatileCData volatileCData2, RequestInfo requestInfo) {
        Object object2;
        String string2 = volatileCData.isEmptySequence() ? "xmlns" : (((String)(object2 = volatileCData.getString(1))).length() == 0 ? "xmlns" : "xmlns:" + (String)object2);
        object2 = DOMUtils.makeDocument(requestInfo, this.getSessionContext()).createAttributeNS("http://www.w3.org/2000/xmlns/", string2);
        String string3 = DOMAdapter.getVolatileCDataStringValue(volatileCData2);
        object2.setNodeValue(string3);
        DOMAdapter.DOMCursor dOMCursor = DOMAdapter.makeCursor(this, (Node)object2, requestInfo, this.getErrorHandler(requestInfo));
        return this.proxy(dOMCursor, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    public Cursor attribute(VolatileCData volatileCData, Chars chars, RequestInfo requestInfo) {
        Attr attr2 = this.attribute(volatileCData, StringChars.toString(chars), requestInfo);
        DOMAdapter.DOMCursor dOMCursor = DOMAdapter.makeCursor(this, attr2, requestInfo, this.getErrorHandler(requestInfo));
        return this.proxy(dOMCursor, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    private Attr attribute(VolatileCData volatileCData, String string2, RequestInfo requestInfo) {
        String string3 = volatileCData.getQNameNamespaceURI(1);
        String string4 = volatileCData.getString(1);
        Attr attr2 = DOMUtils.makeDocument(requestInfo, this.getSessionContext()).createAttributeNS(string3, string4);
        attr2.setNodeValue(string2);
        return attr2;
    }

    public Cursor comment(Chars chars, RequestInfo requestInfo) {
        Comment comment2 = DOMUtils.makeDocument(requestInfo, this.getSessionContext()).createComment(StringChars.toString(chars));
        DOMAdapter.DOMCursor dOMCursor = DOMAdapter.makeCursor(this, comment2, requestInfo, this.getErrorHandler(requestInfo));
        return this.proxy(dOMCursor, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    public Cursor processingInstruction(VolatileCData volatileCData, Chars chars, RequestInfo requestInfo) {
        String string2 = volatileCData.getString(1);
        ProcessingInstruction processingInstruction = DOMUtils.makeDocument(requestInfo, this.getSessionContext()).createProcessingInstruction(string2, StringChars.toString(chars));
        DOMAdapter.DOMCursor dOMCursor = DOMAdapter.makeCursor(this, processingInstruction, requestInfo, this.getErrorHandler(requestInfo));
        return this.proxy(dOMCursor, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    public Cursor text(Chars chars, RequestInfo requestInfo) {
        Text text2 = DOMUtils.makeDocument(requestInfo, this.getSessionContext()).createTextNode(StringChars.toString(chars));
        DOMAdapter.DOMCursor dOMCursor = DOMAdapter.makeCursor(this, text2, requestInfo, this.getErrorHandler(requestInfo));
        return this.proxy(dOMCursor, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), null);
    }
}

