/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.adapters.xlxp.XLXPCursorFactory;
import com.ibm.xml.xci.adapters.xlxp.mediator.OffsetData;
import com.ibm.xml.xci.adapters.xlxp.msg.XLXPXCIAdapterMessageProvider;
import com.ibm.xml.xci.adapters.xlxp.scanner.Scanner;
import com.ibm.xml.xci.adapters.xlxp.util.XLXPResourceManager;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XLXPCursor
extends AbstractCursor
implements XLXPResourceManager.Referent {
    private static final Logger logger = LoggerUtil.getLogger(XLXPCursor.class);
    private static final byte ATTRIBUTE_SEQUENCE = 0;
    private static final byte NODE_SEQUENCE = 1;
    private static final byte ATTRIBUTE_SELF = 2;
    private static final byte NODE_SELF = 3;
    private static final byte NAMESPACE_SEQUENCE = 4;
    private static final byte NAMESPACE_SELF = 5;
    private static final Cursor.Profile XLXP_PROFILE_LIMIT = Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION.union(Cursor.Profile.TO_SELF);
    private Cursor.Profile currentProfile;
    private Cursor.Profile profileLimit;
    private final Scanner scanner;
    private byte state;
    private int attrIdx;
    private int nsdeclIdx;
    private VolatileCData fItemName;
    private XSTypeDefinition xstype;
    private XSTypeDefinition simpleContainingElementTypeDefinition;
    private int cursorDepth;
    public final boolean isFragment;
    private Object sharedReferencedObject;

    private XLXPCursor(XLXPCursorFactory xLXPCursorFactory, Scanner scanner, boolean bl) {
        super(xLXPCursorFactory);
        this.scanner = scanner;
        this.isFragment = bl;
        this.setProfile(XLXP_PROFILE_LIMIT, XLXP_PROFILE_LIMIT);
        this.state = 1;
        this.cursorDepth = 1;
    }

    public XLXPCursor(XLXPCursorFactory xLXPCursorFactory, Scanner scanner) {
        this(xLXPCursorFactory, scanner, false);
    }

    public void setProfile(Cursor.Profile profile, Cursor.Profile profile2) {
        if (profile2.containedIn(XLXP_PROFILE_LIMIT)) {
            this.profileLimit = profile2;
        }
        if (profile.containedIn(this.profileLimit)) {
            this.currentProfile = profile;
        }
    }

    protected void reset() {
        this.fItemName = null;
        this.xstype = null;
    }

    public boolean atEndOfElement() {
        return this.scanner.currentEvent() == 4;
    }

    public void registerReferrer() {
        this.scanner.registerReferrer();
    }

    @Override
    public Cursor.Profile profile() {
        return this.currentProfile;
    }

    @Override
    @Deprecated
    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public Cursor.Profile futureProfile() {
        return this.profileLimit;
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        assert (bl) : "Trying to call XLXPCursor's fork with mustNavigate set to false !";
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "fork", "forking the XLXPCursor");
        }
        ++this.cursorDepth;
        return this;
    }

    public XLXPCursor lazyFork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        Scanner scanner;
        assert (bl) : "Trying to call XLXPCursor's fork with mustNavigate set to false !";
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "lazyFork", "forking the XLXPCursor lazily");
        }
        if ((scanner = this.scanner.createSubtreeScanner()) == null) {
            ++this.cursorDepth;
            return this;
        }
        XLXPCursorFactory xLXPCursorFactory = (XLXPCursorFactory)this.factory;
        XLXPCursor xLXPCursor = new XLXPCursor(xLXPCursorFactory, scanner, true);
        xLXPCursorFactory.resourcesManager.registerChild(xLXPCursor, this.sharedReferencedObject);
        return xLXPCursor;
    }

    @Override
    public void release() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "release", "releasing the XLXPCursor.  depth = " + this.cursorDepth);
        }
        switch (this.scanner.currentEvent()) {
            case 4: {
                this.simpleContainingElementTypeDefinition = null;
                break;
            }
            case 18: {
                this.simpleContainingElementTypeDefinition = null;
                break;
            }
        }
        if (this.cursorDepth <= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Called XLXPCursor.release too many times.");
            stringBuilder.append("\nStack Trace = ");
            stringBuilder.append(XCIErrorHelper.getStackTrace(10));
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "release", stringBuilder.toString());
            }
            XCIDynamicErrorException xCIDynamicErrorException = XCIErrorHelper.createInternalException("Called XLXPCursor.release too many times");
            FFDCUtil.log(xCIDynamicErrorException, this);
            throw xCIDynamicErrorException;
        }
        if (this.cursorDepth > 0) {
            --this.cursorDepth;
        }
        if (this.cursorDepth == 0) {
            this.scanner.manualRelease();
            this.sharedReferencedObject = null;
        }
        this.state = 1;
        this.reset();
    }

    @Override
    public DocumentInfo itemDocumentInfo() {
        return this.scanner.documentInfo();
    }

    public OffsetData.AddCharsHelper createAddCharsHelper() {
        return this.scanner.createAddCharsHelper();
    }

    public OffsetData createOffsetData() {
        return this.scanner.createOffsetData();
    }

    public void saveStartPosition(OffsetData offsetData) {
        this.scanner.saveStartPosition(offsetData);
    }

    public void saveEndPosition(OffsetData offsetData) {
        this.scanner.saveEndPosition(offsetData);
    }

    @Override
    public short itemKind() {
        switch (this.scanner.currentEvent()) {
            case 1: {
                return 9;
            }
            case 2: 
            case 3: {
                switch (this.state) {
                    case 0: 
                    case 2: {
                        return 2;
                    }
                    case 4: 
                    case 5: {
                        return 4;
                    }
                }
                return 1;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                return 3;
            }
            case 10: {
                return 7;
            }
            case 11: {
                return 8;
            }
            case 4: 
            case 14: 
            case 18: {
                return -1;
            }
            case 16: 
            case 17: {
                return -1;
            }
        }
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(XLXPXCIAdapterMessageProvider.createMessage(null, 4, this.scanner.currentEvent(), "itemKind()"));
        FFDCUtil.log(xCIDynamicErrorException, this);
        throw xCIDynamicErrorException;
    }

    @Override
    public VolatileCData itemName() {
        if (this.fItemName == null) {
            switch (this.state) {
                case 0: 
                case 2: {
                    this.fItemName = this.scanner.itemAttributeName(this.attrIdx);
                    break;
                }
                case 4: 
                case 5: {
                    this.fItemName = this.scanner.itemNamespaceName(this.nsdeclIdx);
                    break;
                }
                default: {
                    this.fItemName = this.scanner.itemName();
                }
            }
        }
        return this.fItemName;
    }

    @Override
    public ExtendedNamespaceContext itemNamespaceContext() {
        return this.scanner.nscontext();
    }

    @Override
    public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
        return this.scanner.nscontext();
    }

    private XSTypeDefinition itemActualXSType() {
        if (this.xstype == null) {
            switch (this.scanner.currentEvent()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: 
                case 15: {
                    if (this.simpleContainingElementTypeDefinition != null) {
                        this.xstype = this.simpleContainingElementTypeDefinition;
                        break;
                    }
                }
                default: {
                    return this.itemXSType();
                }
            }
        }
        return this.xstype;
    }

    @Override
    public XSTypeDefinition itemXSType() {
        Object object2;
        if (this.xstype == null) {
            switch (this.scanner.currentEvent()) {
                case 2: 
                case 3: {
                    if (this.state == 2 || this.state == 0) {
                        object2 = this.scanner.getAttributeDeclaration(this.attrIdx);
                        this.xstype = object2 == null ? TypeRegistry.XSUNTYPEDATOMIC : object2.getTypeDefinition();
                        break;
                    }
                    if (this.state == 5 || this.state == 4) {
                        this.xstype = null;
                        break;
                    }
                    this.xstype = this.scanner.getTypeDefinition();
                    if (this.xstype != null) break;
                    this.xstype = TypeRegistry.XSUNTYPED;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: 
                case 15: {
                    this.xstype = TypeRegistry.XSUNTYPEDATOMIC;
                    break;
                }
                case 1: 
                case 10: 
                case 11: {
                    this.xstype = null;
                    break;
                }
                default: {
                    XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(XLXPXCIAdapterMessageProvider.createMessage(null, 4, this.scanner.currentEvent(), "itemXSType()"));
                    FFDCUtil.log(xCIDynamicErrorException, this);
                    throw xCIDynamicErrorException;
                }
            }
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            object2 = this.itemName();
            String string2 = object2.isEmpty() ? "" : object2.getString(1);
            String string3 = this.xstype == null ? "null" : TypeHelper.prettyPrint(this.xstype);
            logger.logp(Level.FINER, logger.getName(), "itemXSType", "Returning the type {" + string3 + "} for itemName {" + string2 + "}");
        }
        return this.xstype;
    }

    @Override
    public XSElementDeclaration itemXSElementDeclaration() {
        int n2 = this.scanner.currentEvent();
        if (!(n2 != 2 && n2 != 3 || this.state != 3 && this.state != 1)) {
            return this.scanner.getElementDeclaration();
        }
        return null;
    }

    @Override
    public XSAttributeDeclaration itemXSAttributeDeclaration() {
        int n2 = this.scanner.currentEvent();
        if (!(n2 != 2 && n2 != 3 || this.state != 2 && this.state != 0)) {
            return this.scanner.getAttributeDeclaration(this.attrIdx);
        }
        return null;
    }

    @Override
    public VolatileCData itemValue() {
        switch (this.scanner.currentEvent()) {
            case 10: 
            case 11: {
                return this.scanner.contentAsStringValue();
            }
            case 5: 
            case 6: 
            case 7: {
                return this.scanner.leafElementValue((XSSimpleTypeDefinition)this.itemActualXSType(), true);
            }
            case 8: 
            case 9: {
                return this.scanner.leafElementValue((XSSimpleTypeDefinition)this.itemActualXSType(), false);
            }
            case 2: 
            case 3: {
                if (this.state == 0 || this.state == 2) {
                    return this.scanner.attributeValue(this.attrIdx, (XSSimpleTypeDefinition)this.itemXSType());
                }
                if (this.state == 4 || this.state == 5) {
                    return this.scanner.nsDeclValue(this.nsdeclIdx, TypeRegistry.XSSTRING);
                }
                return this.scanner.elementTypedValue();
            }
            case 1: {
                return this.scanner.documentTextValue(TypeRegistry.XSUNTYPEDATOMIC);
            }
        }
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(XLXPXCIAdapterMessageProvider.createMessage(null, 4, this.scanner.currentEvent(), "itemValue()"));
        FFDCUtil.log(xCIDynamicErrorException, this);
        throw xCIDynamicErrorException;
    }

    @Override
    public VolatileCData itemTypedValue() {
        switch (this.scanner.currentEvent()) {
            case 5: 
            case 6: 
            case 7: {
                return this.scanner.leafElementValue(TypeRegistry.XSUNTYPEDATOMIC, true);
            }
            case 8: 
            case 9: {
                return this.scanner.leafElementValue(TypeRegistry.XSUNTYPEDATOMIC, false);
            }
        }
        return this.itemValue();
    }

    @Override
    protected Chars itemSValue() {
        switch (this.scanner.currentEvent()) {
            case 10: 
            case 11: {
                return this.scanner.contentAsStringValue();
            }
            case 5: 
            case 6: 
            case 7: {
                return this.scanner.leafElementValue(TypeRegistry.XSSTRING, true);
            }
            case 8: 
            case 9: {
                return this.scanner.leafElementValue(TypeRegistry.XSSTRING, false);
            }
            case 2: 
            case 3: {
                if (this.state == 0 || this.state == 2) {
                    return this.scanner.attributeValue(this.attrIdx, TypeRegistry.XSSTRING);
                }
                if (this.state == 4 || this.state == 5) {
                    return this.scanner.nsDeclValue(this.nsdeclIdx, TypeRegistry.XSSTRING);
                }
                return this.scanner.elementSValue();
            }
            case 1: {
                return this.scanner.documentTextValue(TypeRegistry.XSSTRING);
            }
        }
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(XLXPXCIAdapterMessageProvider.createMessage(null, 4, this.scanner.currentEvent(), "itemSValue()"));
        FFDCUtil.log(xCIDynamicErrorException, this);
        throw xCIDynamicErrorException;
    }

    @Override
    public boolean itemNilled() {
        switch (this.scanner.currentEvent()) {
            case 2: {
                return this.scanner.nilled();
            }
            case 3: {
                return this.scanner.leafNilled();
            }
        }
        return false;
    }

    @Override
    public boolean toAttributes(NodeTest nodeTest) {
        if (this.state != 1 && this.state != 3) {
            return false;
        }
        switch (this.scanner.currentEvent()) {
            case 2: 
            case 3: {
                if (this.scanner.attributeCount() <= 0) break;
                this.state = 0;
                this.attrIdx = 0;
                this.reset();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean toNamespaceDecls() {
        if (this.state != 1 && this.state != 3) {
            return false;
        }
        switch (this.scanner.currentEvent()) {
            case 2: 
            case 3: {
                if (this.scanner.nsDeclCount() <= 0) break;
                this.state = (byte)4;
                this.nsdeclIdx = 0;
                this.reset();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean toChildren(NodeTest nodeTest) {
        int n2 = this.scanner.currentEvent();
        if (n2 == 1 || n2 == 2) {
            if (this.state != 1 && this.state != 3) {
                return false;
            }
            XSTypeDefinition xSTypeDefinition = this.scanner.getTypeDefinition();
            int n3 = this.scanner.nextScannerEvent();
            if (n3 == 4 || n3 == 18) {
                return false;
            }
            if (xSTypeDefinition != null) {
                if (xSTypeDefinition.getTypeCategory() == 16) {
                    this.simpleContainingElementTypeDefinition = xSTypeDefinition;
                } else if (xSTypeDefinition.getTypeCategory() == 15 && ((XSComplexTypeDefinition)xSTypeDefinition).getContentType() == 1) {
                    this.simpleContainingElementTypeDefinition = ((XSComplexTypeDefinition)xSTypeDefinition).getSimpleType();
                }
            }
            this.state = 1;
            this.reset();
            return true;
        }
        return false;
    }

    @Override
    public boolean toNext() {
        switch (this.state) {
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
            case 0: {
                if (this.scanner.attributeCount() > this.attrIdx + 1) {
                    ++this.attrIdx;
                    this.reset();
                    return true;
                }
                return false;
            }
            case 4: {
                if (this.scanner.nsDeclCount() > this.nsdeclIdx + 1) {
                    ++this.nsdeclIdx;
                    this.reset();
                    return true;
                }
                return false;
            }
            case 1: {
                if (!this.scanner.toNextElementNode()) {
                    return false;
                }
                this.reset();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean toSelf() {
        switch (this.state) {
            case 0: 
            case 2: {
                this.state = (byte)2;
                break;
            }
            case 4: 
            case 5: {
                this.state = (byte)5;
                break;
            }
            case 1: 
            case 3: {
                this.state = (byte)3;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean allowFastSerialization(Map<String, Object> map2) {
        if (!this.scanner.fastSerializationAllowed()) {
            return false;
        }
        if (map2 != null && map2.size() > 0) {
            Object object2 = map2.get("{http://ibm.com/xml/xci/serializer}fast-ser");
            if (object2 != null) {
                return (Boolean)object2 != false;
            }
            int n2 = map2.size();
            if (n2 > 3) {
                return false;
            }
            for (String string2 : map2.keySet()) {
                Object object3;
                if ("omit-xml-declaration".equals(string2) || ("encoding".equals(string2) ? (object3 = (String)map2.get(string2)) != null && ((String)object3).equalsIgnoreCase("UTF-8") : "discard-default-attr".equals(string2) && (object3 = (Boolean)map2.get(string2)) != null && ((Boolean)object3).booleanValue())) continue;
                return false;
            }
        }
        return true;
    }

    public void loadRemainingBuffers(OffsetData offsetData) {
        this.scanner.loadRemainingBuffers(offsetData);
    }

    @Override
    public Cursor.ItemValueOrigin itemAttributeValueOrigin() {
        if (this.itemKind() == 2) {
            return this.scanner.itemAttributeValueOrigin(this.attrIdx);
        }
        return null;
    }

    public OffsetData makeSubtreeOffsetData() {
        return this.scanner.makeSubtreeOffsetData();
    }

    @Override
    public XLXPResourceManager.Resource getResource() {
        return this.scanner;
    }

    @Override
    public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        return this;
    }

    @Override
    public boolean contextIsLive() {
        return true;
    }

    @Override
    public boolean contextIsAtomsOnly() {
        return false;
    }

    @Override
    public boolean contextIsNodesOnly() {
        return true;
    }

    @Override
    public CharSequence sequenceConstructSimpleContent(CharSequence charSequence, boolean bl, boolean bl2) {
        assert (bl2) : "Trying to call XLXPCursor's sequenceConstructSimpleContent with release set to false !";
        if (bl) {
            VolatileCData volatileCData = this.itemTypedValue();
            if (volatileCData.isEmptySequence()) {
                return "";
            }
            if (volatileCData.getSize() == 1) {
                if (volatileCData.getXSTypeDefinition().getBuiltInKind() == 50) {
                    return volatileCData;
                }
                return volatileCData.getString(1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(volatileCData.getString(1));
            for (int i = 2; i <= volatileCData.getSize(); ++i) {
                stringBuilder.append(charSequence);
                stringBuilder.append(volatileCData.getString(i));
            }
            return stringBuilder;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        bl3 = this.itemKind() == 3;
        boolean bl4 = this.atomizeItem(this, charSequence, stringBuilder);
        while (!bl4) {
            if (!this.toNext()) {
                return "";
            }
            bl4 = this.atomizeItem(this, charSequence, stringBuilder);
            bl3 = this.itemKind() == 3;
        }
        boolean bl5 = false;
        while (this.toNext()) {
            int n2 = stringBuilder.length();
            bl4 = this.atomizeItem(this, charSequence, stringBuilder);
            boolean bl6 = bl5 = this.itemKind() == 3;
            while (!bl4) {
                if (this.toNext()) {
                    return stringBuilder;
                }
                bl4 = this.atomizeItem(this, charSequence, stringBuilder);
                bl5 = this.itemKind() == 3;
            }
            if (!bl3 || !bl5) {
                stringBuilder.insert(n2, charSequence);
            }
            bl3 = bl5;
        }
        this.release();
        return stringBuilder;
    }

    private boolean atomizeItem(Cursor cursor2, CharSequence charSequence, StringBuilder stringBuilder) {
        VolatileCData volatileCData = cursor2.itemTypedValue();
        if (cursor2.itemKind() == 3 && volatileCData.isEmpty()) {
            return false;
        }
        if (volatileCData.isEmptySequence()) {
            return true;
        }
        stringBuilder.append(volatileCData.getString(1));
        for (int i = 2; i <= volatileCData.getSize(); ++i) {
            stringBuilder.append(charSequence);
            stringBuilder.append(volatileCData.getString(i));
        }
        return true;
    }

    @Override
    public void setSharedDocumentObject(Object object2) {
        this.sharedReferencedObject = object2;
    }
}

