/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.DefaultResult;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.XCIOutputInputStream;
import com.ibm.xml.xci.adapters.xlxp.XLXPCursor;
import com.ibm.xml.xci.adapters.xlxp.mediator.XLXPCacheMediator;
import com.ibm.xml.xci.adapters.xlxp.msg.XLXPXCIAdapterMessageProvider;
import com.ibm.xml.xci.adapters.xlxp.scanner.Scanner;
import com.ibm.xml.xci.adapters.xlxp.util.XLXPResourceManager;
import com.ibm.xml.xci.dp.base.AbstractCursorFactory;
import com.ibm.xml.xci.dp.cache.CacheFactory;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.util.RequestInfoUtil;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.serializer.Serialize;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.Version;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferOutputInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XLXPCursorFactory
extends AbstractCursorFactory {
    private static final Logger logger = LoggerUtil.getLogger(XLXPCursorFactory.class);
    public final XLXPResourceManager resourcesManager = new XLXPResourceManager();

    public XLXPCursorFactory(SessionContext sessionContext) {
        super(sessionContext);
    }

    private Cursor document(InputSource inputSource, RequestInfo requestInfo) throws IOException {
        SessionContext sessionContext = this.getSessionContext();
        Scanner scanner = this.resourcesManager.setupScanner(inputSource, requestInfo, this.getErrorHandler(requestInfo), sessionContext);
        XLXPCursor xLXPCursor = new XLXPCursor(this, scanner);
        this.resourcesManager.registerDocument(xLXPCursor);
        xLXPCursor.setProfile(requestInfo.getNeededFeatures(), requestInfo.getNeededFeatures());
        boolean bl = RequestInfoUtil.hasHint(requestInfo, "CACHE");
        boolean bl2 = RequestInfoUtil.hasHint(requestInfo, "LAZY");
        boolean bl3 = RequestInfoUtil.hasHint(requestInfo, "FAST_SERIALIZATION");
        if (bl && bl2 || bl3) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "document", "making an optimal object cache for this document call.");
            }
            return this.makeOptimalCache(xLXPCursor, requestInfo, bl3);
        }
        if (bl) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "document", "making a regular object cache for this document call.");
            }
            return CacheFactory.make(xLXPCursor, requestInfo);
        }
        return this.proxy(xLXPCursor, requestInfo.getNeededFeatures(), false, requestInfo.getParameters(), requestInfo.getHints());
    }

    private Cursor makeOptimalCache(Cursor cursor2, RequestInfo requestInfo, boolean bl) {
        XLXPCacheMediator xLXPCacheMediator = new XLXPCacheMediator(cursor2, requestInfo.getNeededFeatures(), bl);
        Map<String, Object> map2 = requestInfo.getParameters();
        if (map2 != null && MiscHelpers.getBoolean("SDOX_WRAPPER", map2, false)) {
            return CacheFactory.makeDummyCache(xLXPCacheMediator);
        }
        return CacheFactory.make(xLXPCacheMediator, requestInfo);
    }

    protected Cursor document(InputStream inputStream, RequestInfo requestInfo) {
        try {
            return this.document(new InputSource(inputStream), requestInfo);
        }
        catch (IOException iOException) {
            FFDCUtil.log(iOException, this);
            throw new XCIDynamicErrorException(iOException);
        }
    }

    protected Cursor document(Reader reader, RequestInfo requestInfo) {
        try {
            return this.document(new InputSource(reader), requestInfo);
        }
        catch (IOException iOException) {
            FFDCUtil.log(iOException, this);
            throw new XCIDynamicErrorException(iOException);
        }
    }

    protected Cursor document(Writer writer, RequestInfo requestInfo) {
        return this.proxy(Serialize.getTargetCursor((CursorFactory)this, writer, requestInfo.getParameters()), requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    protected Cursor document(OutputStream outputStream, RequestInfo requestInfo) {
        return this.proxy(Serialize.getTargetCursor((CursorFactory)this, outputStream, requestInfo.getParameters()), requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    public String getMediaType() {
        return "text/xml";
    }

    public Cursor document(Source source, RequestInfo requestInfo) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, logger.getName(), "document", "document call in XLXPCursorFactory with a Source obj");
        }
        if (source == null) {
            return this.document(requestInfo);
        }
        if (source instanceof StreamSource) {
            InputSource inputSource;
            StreamSource streamSource = (StreamSource)source;
            String string2 = source.getSystemId();
            Reader reader = streamSource.getReader();
            if (reader != null) {
                inputSource = new InputSource(reader);
                inputSource.setSystemId(string2);
            } else {
                InputStream inputStream = streamSource.getInputStream();
                if (inputStream != null) {
                    inputSource = new InputSource(inputStream);
                    inputSource.setSystemId(string2);
                } else if (string2 != null) {
                    inputSource = new InputSource(string2);
                } else {
                    throw new XCIIllegalArgumentException(XLXPXCIAdapterMessageProvider.createMessage(null, 0));
                }
            }
            inputSource.setPublicId(streamSource.getPublicId());
            inputSource.setEncoding(requestInfo.getEncoding());
            try {
                return this.document(inputSource, requestInfo);
            }
            catch (IOException iOException) {
                FFDCUtil.log(iOException, this);
                throw new XCIDynamicErrorException(iOException);
            }
        }
        throw new XCIIllegalArgumentException(XLXPXCIAdapterMessageProvider.createMessage(null, 1, source.getClass().getName()));
    }

    public Cursor document(Result result2, RequestInfo requestInfo) {
        Object object2;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, logger.getName(), "document", "document call in XLXPCursorFactory with a Result obj");
        }
        if (result2 instanceof StreamResult) {
            object2 = (StreamResult)result2;
            if (((StreamResult)object2).getOutputStream() != null) {
                return this.document(((StreamResult)object2).getOutputStream(), requestInfo);
            }
            if (((StreamResult)object2).getWriter() != null) {
                return this.document(((StreamResult)object2).getWriter(), requestInfo);
            }
        } else if (result2 == null || result2 instanceof DefaultResult) {
            return super.document(requestInfo);
        }
        object2 = XCIErrorHelper.createInternalException("XLXPCursorFactory.document could not be completed");
        FFDCUtil.log((Throwable)object2, this);
        throw object2;
    }

    public XCIOutputInputStream createOutputInputStream() {
        return new OutInStream();
    }

    public static String getXLXPVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("XLXP - Scanner version: ");
        stringBuilder.append(Version.getVersion());
        stringBuilder.append(", Time Stamp: ");
        stringBuilder.append(Version.getBuildTimeStamp());
        stringBuilder.append("\nRuntime version: ");
        stringBuilder.append(com.ibm.xml.xlxp.internal.s1.runtime.Version.getVersion());
        stringBuilder.append(", Time Stamp: ");
        stringBuilder.append(com.ibm.xml.xlxp.internal.s1.runtime.Version.getBuildTimeStamp());
        return stringBuilder.toString();
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class OutInStream
    extends DataBufferOutputInputStream
    implements XCIOutputInputStream {
        private OutInStream() {
        }
    }
}

