/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.mediator;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class MutationMap {
    private CacheManager mapCacheManager;
    private static final Logger logger = LoggerUtil.getLogger(MutationMap.class);
    private static final int MAP_INITIAL_CAPACITY = 100;
    ArrayList<DOMCachedNode> listMutations = new ArrayList(100);

    public MutationMap() {
        this.listMutations.clear();
    }

    public int addParent(DOMCachedNode dOMCachedNode) {
        if (dOMCachedNode.getBuiltParent() == null) {
            return -1;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addParent", "adding the parent of node: " + dOMCachedNode.toStringLazy() + " to the map");
        }
        int n2 = this.addNode(dOMCachedNode.getBuiltParent());
        if (dOMCachedNode.isMutationMapQueued()) {
            int n3 = this.size();
            for (int i = n2 + 1; i < n3; ++i) {
                if (this.listMutations.get(i) != dOMCachedNode) continue;
                this.listMutations.remove(i);
                if (!LoggerUtil.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) break;
                logger.logp(Level.FINER, logger.getName(), "addParent", "removed node from the list");
                break;
            }
        }
        dOMCachedNode.getBuiltParent().setState(BitMaskHelper.stateSet(dOMCachedNode.getBuiltParent().getState(), 0x200000));
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "addParent", "After add parent:\n" + this.describeMap(true));
        }
        return n2;
    }

    public int addNode(DOMCachedNode dOMCachedNode) {
        boolean bl = LoggerUtil.isAnyTracingEnabled();
        if (bl && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addNode", "pushing a new item into the mutation map:" + dOMCachedNode.toStringLazy());
        }
        if (dOMCachedNode.isMutationMapQueued()) {
            return -1;
        }
        if (this.listMutations.size() == 0) {
            return this.internalAddNode(0, dOMCachedNode);
        }
        int n2 = 0;
        int n3 = this.listMutations.size() - 1;
        int n4 = -1;
        DOMCachedNode dOMCachedNode2 = dOMCachedNode;
        DOMCachedNode dOMCachedNode3 = this.listMutations.get(n3);
        if (dOMCachedNode3 == dOMCachedNode2) {
            return n3;
        }
        if (dOMCachedNode3.itemIsBeforeNode(dOMCachedNode2)) {
            return this.internalAddNode(n3 + 1, dOMCachedNode);
        }
        dOMCachedNode3 = null;
        n4 = -1;
        do {
            int n5;
            if ((n5 = (n2 + n3) / 2) == n4) {
                ++n5;
                ++n2;
            }
            if ((dOMCachedNode3 = this.listMutations.get(n5)) == dOMCachedNode2) {
                return n5;
            }
            if (dOMCachedNode3.itemIsBeforeNode(dOMCachedNode2)) {
                n4 = n5;
                n2 = n5;
                continue;
            }
            n3 = n5;
        } while (n2 < n3);
        if (bl && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "pushItem", "pushing the new item into index" + (n4 + 1));
        }
        return this.internalAddNode(n4 + 1, dOMCachedNode);
    }

    private int internalAddNode(int n2, DOMCachedNode dOMCachedNode) {
        if (this.mapCacheManager == null) {
            this.mapCacheManager = dOMCachedNode.getCache();
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "internalAddNode", "associated this MutationMap with a CacheManager:\n " + this.describeMap(false));
            }
        } else if (this.mapCacheManager != dOMCachedNode.getCache()) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "internalAddNode", "blocked an incoming node that did not belong to this mutation map! \n" + this.describeMap(false));
            }
            return -1;
        }
        this.listMutations.add(n2, dOMCachedNode);
        dOMCachedNode.setState(BitMaskHelper.stateSet(dOMCachedNode.getState(), 0x200000));
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "internalAddNode", "After insertion:\n" + this.describeMap(true));
        }
        return n2;
    }

    public String describeMap(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MutationMap:");
        stringBuilder.append(LoggerUtil.getUniqueString(this));
        stringBuilder.append('\n');
        stringBuilder.append("Associated CacheManager:");
        stringBuilder.append(this.mapCacheManager);
        if (bl) {
            int n2 = this.size();
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append("\nItem[");
                stringBuilder.append(i);
                stringBuilder.append("]:");
                stringBuilder.append(this.listMutations.get(i).toStringLazy());
            }
        }
        return stringBuilder.toString();
    }

    public int size() {
        return this.listMutations.size();
    }

    public Iterator<DOMCachedNode> getMutationList() {
        return this.listMutations.iterator();
    }

    public void release() {
    }

    protected boolean sanityCheck(StringBuilder stringBuilder) {
        int n2 = this.size() - 1;
        for (int i = 0; i < n2; ++i) {
            DOMCachedNode dOMCachedNode;
            DOMCachedNode dOMCachedNode2 = this.listMutations.get(i);
            if (dOMCachedNode2.itemIsBeforeNode(dOMCachedNode = this.listMutations.get(i + 1))) continue;
            stringBuilder.append("The document order for node [" + dOMCachedNode2.toStringLazy() + "] was supposed to be before node [" + dOMCachedNode.toStringLazy() + "]");
            return false;
        }
        return true;
    }
}

