/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.mediator;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.adapters.xlxp.XLXPCursor;
import com.ibm.xml.xci.adapters.xlxp.mediator.MutationMap;
import com.ibm.xml.xci.adapters.xlxp.mediator.OffsetData;
import com.ibm.xml.xci.adapters.xlxp.mediator.XLXPCacheDataFactory;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.InternalNodeData;
import com.ibm.xml.xci.dp.cache.dom.InternalNodeDataFactory;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingDataFactory;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.dp.util.copy.SerializerCDataDelegate;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XLXPCacheMediator
extends StreamingCursorMediator {
    private static final boolean DISABLE_NESTED_SKIPPING = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("com.ibm.xml.xci.adapters.xlxp.XLXPCacheMediator.disableNestedSkipping");
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    });
    private static final Logger logger = LoggerUtil.getLogger(XLXPCacheMediator.class);
    protected final XLXPCursor adapter;
    protected final ItemCopier fullCopier;
    protected final ItemCopier subtreeCopier;
    final boolean fastSerialization;
    private MutationMap mutMap;
    private final OffsetData.AddCharsHelper addCharsHelper;

    public XLXPCacheMediator(Cursor cursor2, Cursor.Profile profile) {
        this(cursor2, profile, false);
    }

    public XLXPCacheMediator(Cursor cursor2, Cursor.Profile profile, boolean bl) {
        super(cursor2, profile);
        this.fastSerialization = bl;
        this.adapter = (XLXPCursor)cursor2;
        this.fullCopier = new ByteCopier(true);
        this.subtreeCopier = new ByteCopier(false);
        this.addCharsHelper = this.adapter.createAddCharsHelper();
        this.adapter.registerReferrer();
    }

    public void reportMutation(DOMCachedNode dOMCachedNode, boolean bl) {
        if (!this.fastSerialization) {
            return;
        }
        if (this.mutMap == null) {
            this.mutMap = new MutationMap();
        }
        if (dOMCachedNode.itemKind() != 1 && dOMCachedNode.itemKind() != 9) {
            dOMCachedNode = dOMCachedNode.getCachedParent();
            bl = false;
        }
        if (dOMCachedNode == null) {
            return;
        }
        if (bl) {
            this.mutMap.addParent(dOMCachedNode);
        } else {
            this.mutMap.addNode(dOMCachedNode);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.mutMap.sanityCheck(stringBuilder)) {
                logger.logp(Level.FINEST, logger.getName(), "reportMutation", "Mutation Map is corrupt: " + stringBuilder.toString());
            } else {
                logger.logp(Level.FINEST, logger.getName(), "reportMutation", "Mutation Map is in-order");
            }
        }
    }

    public int copyNode(DOMCachedNode dOMCachedNode, Cursor.Area area, AddContentInterface addContentInterface, boolean bl) {
        int n2;
        InternalNodeData internalNodeData = dOMCachedNode.getInternalNodeData();
        if (internalNodeData == null || !(internalNodeData instanceof XLXPCacheDataFactory.OffsetNodeData)) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "copyNode", "UserData was either null or not an instance of OffsetUserData for node : " + dOMCachedNode.toStringLazy());
            }
            return 3;
        }
        XLXPCacheDataFactory.OffsetNodeData offsetNodeData = (XLXPCacheDataFactory.OffsetNodeData)((Object)internalNodeData);
        OffsetData offsetData = offsetNodeData.getOffsetData();
        if (offsetData == null || !offsetData.startPositionKnown()) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "copyNode", "OffsetData was either null or start position was not known for node : " + dOMCachedNode.toStringLazy());
            }
            return 3;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "copyNode", "node: " + dOMCachedNode.toStringLazy() + " | full? " + bl);
        }
        if (!offsetData.endPositionKnown() && !bl) {
            dOMCachedNode.getCachedFollowingSibling();
            offsetNodeData = (XLXPCacheDataFactory.OffsetNodeData)((Object)internalNodeData);
            offsetData = offsetNodeData.getOffsetData();
            assert (offsetData.endPositionKnown());
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "copyNode", "After resolving sibling, offset is: " + offsetData);
            }
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "copyNode", "check point 1: offset.endPositionKnown? " + offsetData.endPositionKnown());
        }
        if (offsetData.endPositionKnown()) {
            n2 = 1;
        } else {
            XLXPCursor xLXPCursor = offsetNodeData.getXLXPCursor();
            xLXPCursor.loadRemainingBuffers(offsetData);
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "copyNode", "After loading all buffers, offset: " + offsetData);
            }
            n2 = 2;
        }
        if (addContentInterface.isOptimizedForDirectWrites(Chars.UTF8_String)) {
            if (this.mutMap != null) {
                if (!this.addMutatedContent(dOMCachedNode, addContentInterface, area, offsetData, true)) {
                    n2 = 3;
                }
            } else {
                offsetData.addContentAsBytes(addContentInterface, area);
            }
        } else if (this.mutMap != null) {
            if (!this.addMutatedContent(dOMCachedNode, addContentInterface, area, offsetData, false)) {
                n2 = 3;
            }
        } else {
            this.addCharsHelper.addContentAsChars(addContentInterface, area, offsetData);
        }
        return n2;
    }

    private boolean addMutatedContent(DOMCachedNode dOMCachedNode, AddContentInterface addContentInterface, Cursor.Area area, OffsetData offsetData, boolean bl) {
        OffsetData offsetData2;
        boolean bl2;
        block26: {
            boolean bl3;
            InternalNodeData internalNodeData;
            DOMCachedNode dOMCachedNode2;
            bl2 = LoggerUtil.isAnyTracingEnabled();
            if (bl2 && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "addMutatedContent", "Entering with node:" + dOMCachedNode.toStringLazy() + " and with rootData:" + offsetData);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, logger.getName(), "addMutatedContent", this.mutMap.describeMap(true));
                }
            }
            Iterator<DOMCachedNode> iterator = this.mutMap.getMutationList();
            while (iterator.hasNext()) {
                dOMCachedNode2 = iterator.next();
                internalNodeData = dOMCachedNode2.getInternalNodeData();
                if (!BitMaskHelper.stateContains(dOMCachedNode2.getState(), 0x10000000) && internalNodeData instanceof XLXPCacheDataFactory.OffsetNodeData) continue;
                if (bl2 && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, logger.getName(), "addMutatedContent", "Exit 0: Found an invalid node in the mutation map: " + dOMCachedNode2.toStringLazy());
                }
                return false;
            }
            iterator = this.mutMap.getMutationList();
            DOMCachedNode dOMCachedNode3 = dOMCachedNode2 = iterator.hasNext() ? iterator.next() : null;
            assert (dOMCachedNode2 != null) : "Node inside the mutation map was null!";
            internalNodeData = dOMCachedNode2.getInternalNodeData();
            if (internalNodeData != null && !(internalNodeData instanceof XLXPCacheDataFactory.OffsetNodeData)) {
                if (bl2 && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, logger.getName(), "addMutatedContent", "Exit 1: Mutation map corruption - the first node in the map does not have an OffsetNodeData!");
                }
                return false;
            }
            XLXPCacheDataFactory.OffsetNodeData offsetNodeData = (XLXPCacheDataFactory.OffsetNodeData)((Object)internalNodeData);
            OffsetData offsetData3 = offsetNodeData != null ? offsetNodeData.getOffsetData() : null;
            boolean bl4 = bl3 = dOMCachedNode.getBuiltParent() == dOMCachedNode.getCache().getBuiltRootNode();
            if (offsetData3 == null || !bl3 || dOMCachedNode2 == dOMCachedNode) {
                if (bl2 && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "addMutatedContent", "Exit 2:  myMutatedOffset: " + offsetData3 + " | isTopLevel: " + bl3 + " | myMutatedNode: " + dOMCachedNode2.toStringLazy());
                }
                return false;
            }
            if (dOMCachedNode2.itemKind() == 9) {
                Copier.copy(dOMCachedNode2.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), (Cursor)((Object)addContentInterface), area);
                addContentInterface.flushContent();
                return true;
            }
            offsetData2 = this.adapter.createOffsetData();
            offsetData2.copyStartPosition(offsetData);
            CacheManager cacheManager = dOMCachedNode.getCache();
            do {
                offsetData2.copyEndPositionFromStartPosition(offsetData3);
                if (offsetData2.endPositionFollowsStartPosition()) {
                    if (bl2 && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, logger.getName(), "addMutatedContent", "[1]Serializing offset: " + offsetData2);
                    }
                    if (bl) {
                        offsetData2.addContentAsBytes(addContentInterface, area);
                    } else {
                        this.addCharsHelper.addContentAsChars(addContentInterface, area, offsetData2);
                    }
                }
                if (bl2 && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "addMutatedContent", "Serializing mutated node: " + dOMCachedNode2.toStringLazy());
                }
                Copier.copy(dOMCachedNode2.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), (Cursor)((Object)addContentInterface), area);
                addContentInterface.flushContent();
                if (!offsetData3.endPositionKnown()) {
                    dOMCachedNode2.getCachedFollowingSibling();
                    offsetNodeData = (XLXPCacheDataFactory.OffsetNodeData)((Object)dOMCachedNode2.getInternalNodeData());
                    offsetData3 = offsetNodeData.getOffsetData();
                    assert (offsetData3.endPositionKnown());
                }
                offsetData2.copyStartPositionFromEndPosition(offsetData3);
                do {
                    DOMCachedNode dOMCachedNode4 = dOMCachedNode2 = iterator.hasNext() ? iterator.next() : null;
                    if (dOMCachedNode2 == null) break;
                    if (!bl2 || !logger.isLoggable(Level.FINEST)) continue;
                    boolean bl5 = dOMCachedNode2.isParentChainMutationMapQueue(true);
                    boolean bl6 = dOMCachedNode2.getCache() != cacheManager;
                    boolean bl7 = BitMaskHelper.stateContains(dOMCachedNode2.getState(), 0x10000000);
                    logger.logp(Level.FINEST, logger.getName(), "addMutatedContent", "Checking mutated node: " + dOMCachedNode2.toStringLazy() + "\nparentChainQueued: " + bl5 + " | wrongCacheManager: " + bl6 + " | mutMapDirty: " + bl7);
                } while (dOMCachedNode2.isParentChainMutationMapQueue(true) || dOMCachedNode2.getCache() != cacheManager || BitMaskHelper.stateContains(dOMCachedNode2.getState(), 0x10000000));
                if (dOMCachedNode2 == null) break block26;
                internalNodeData = dOMCachedNode2.getInternalNodeData();
                if (internalNodeData != null && !(internalNodeData instanceof XLXPCacheDataFactory.OffsetNodeData)) {
                    if (bl2 && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, logger.getName(), "addMutatedContent", "Skip 1: Mutation map corruption - an internal node in the map does not have an OffsetNodeData! \nNode: " + dOMCachedNode2.toStringLazy());
                    }
                    offsetNodeData = null;
                    continue;
                }
                offsetNodeData = (XLXPCacheDataFactory.OffsetNodeData)((Object)internalNodeData);
            } while ((offsetData3 = offsetNodeData != null ? offsetNodeData.getOffsetData() : null) != null);
            if (bl2 && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "addMutatedContent", "Finishing off the document with regular copier, since we found a bad offset from node: " + dOMCachedNode2.toStringLazy());
            }
            Copier.copy(dOMCachedNode2.fork(false, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), (Cursor)((Object)addContentInterface), area);
            addContentInterface.flushContent();
            return true;
        }
        offsetData2.copyEndPosition(offsetData);
        if (offsetData2.endPositionFollowsStartPosition()) {
            if (bl2 && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "addMutatedContent", "[2]Serializing offset: " + offsetData2);
            }
            if (bl) {
                offsetData2.addContentAsBytes(addContentInterface, area);
            } else {
                this.addCharsHelper.addContentAsChars(addContentInterface, area, offsetData2);
            }
        }
        return true;
    }

    protected boolean isFullCopyOrSer(DOMCachedNode dOMCachedNode) {
        return dOMCachedNode == dOMCachedNode.getBuiltRoot() || dOMCachedNode.getBuiltParent() == dOMCachedNode.getBuiltRoot();
    }

    public boolean buildChildren(DOMCachedNode dOMCachedNode, NodeTest nodeTest) {
        if (super.buildChildren(dOMCachedNode, nodeTest)) {
            return true;
        }
        InternalNodeData internalNodeData = dOMCachedNode.getInternalNodeData();
        if (internalNodeData == null || !(internalNodeData instanceof XLXPCacheDataFactory.OffsetNodeData)) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "buildChildren", "Parent's internal data was either null or not an instance of OffsetUserData for node : " + dOMCachedNode.toStringLazy() + "\nStack trace=" + XCIErrorHelper.getStackTrace(15));
            }
            return false;
        }
        XLXPCacheDataFactory.OffsetNodeData offsetNodeData = (XLXPCacheDataFactory.OffsetNodeData)((Object)internalNodeData);
        XLXPCursor xLXPCursor = offsetNodeData.getXLXPCursor();
        if (xLXPCursor.isFragment) {
            return false;
        }
        OffsetData offsetData = offsetNodeData.getOffsetData();
        if (offsetData != null) {
            xLXPCursor.saveEndPosition(offsetData);
        }
        return false;
    }

    private boolean isFragmentAllowed(XLXPCursor xLXPCursor, DOMCachedNode dOMCachedNode) {
        return !xLXPCursor.isFragment || BitMaskHelper.stateContains(dOMCachedNode.getState(), 16) && !DISABLE_NESTED_SKIPPING;
    }

    public boolean buildNext(DOMCachedNode dOMCachedNode) {
        int n2 = dOMCachedNode.getState();
        InternalNodeData internalNodeData = dOMCachedNode.getInternalNodeData();
        if (!(internalNodeData instanceof StreamingDataFactory.XCIData)) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "buildNext", "Previous node's internal data was not compatible!\npreviousNode=" + dOMCachedNode.toStringLazy() + "\nCache manager = " + dOMCachedNode.getCache() + " | Mediator (default) = " + dOMCachedNode.getCache().mediator() + " | Mediator (for node) = " + dOMCachedNode.getMediatorData());
            }
            return false;
        }
        XLXPCursor xLXPCursor = (XLXPCursor)((StreamingDataFactory.XCIData)((Object)internalNodeData)).getXCI();
        if (dOMCachedNode.itemKind() != 1 || !this.isFragmentAllowed(xLXPCursor, dOMCachedNode) || LazyLoadingHelper.isFirstChildBuilt(n2)) {
            this.visitSubtree(dOMCachedNode, n2, (n2 & 0x800) != 2048);
            return this.doBuildNext(dOMCachedNode);
        }
        if (xLXPCursor.atEndOfElement()) {
            return this.doBuildNext(dOMCachedNode);
        }
        this.visitNamespaceAndAttributes(dOMCachedNode);
        n2 = dOMCachedNode.getState();
        XLXPCursor xLXPCursor2 = xLXPCursor.lazyFork(true, Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION);
        if (xLXPCursor2 == xLXPCursor) {
            this.visitSubtree(dOMCachedNode, n2, (n2 & 0x800) != 2048);
            return this.doBuildNext(dOMCachedNode);
        }
        return this.doBuildNext(dOMCachedNode, xLXPCursor, xLXPCursor2);
    }

    private void visitSubtreeWithSkip(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "visitSubtreeWithSkip", "Attempting to skip the partially traversed tree for node: " + dOMCachedNode.toStringLazy());
        }
        if (LazyLoadingHelper.isSubtreeBuilt(dOMCachedNode.getState())) {
            return;
        }
        this.visitNamespaceAndAttributes(dOMCachedNode);
        for (DOMCachedNode dOMCachedNode2 = dOMCachedNode.getCachedFirstChild(); dOMCachedNode2 != null; dOMCachedNode2 = dOMCachedNode2.getCachedFollowingSibling()) {
        }
        dOMCachedNode.setState(LazyLoadingHelper.markChildrenResolved(dOMCachedNode.getState()));
    }

    private void visitNamespaceAndAttributes(DOMCachedNode dOMCachedNode) {
        int n2 = dOMCachedNode.getState();
        boolean bl = (n2 & 0x800) != 2048;
        this.visitNamespaceNodes(dOMCachedNode, n2, bl);
        n2 = dOMCachedNode.getState();
        bl = (n2 & 1) != 1;
        this.visitAttributes(dOMCachedNode, n2, bl);
    }

    protected boolean doBuildNext(DOMCachedNode dOMCachedNode, Cursor cursor2, Cursor cursor3) {
        InternalNodeData internalNodeData = dOMCachedNode.getInternalNodeData();
        if (internalNodeData == null || !(internalNodeData instanceof XLXPCacheDataFactory.OffsetNodeData)) {
            return false;
        }
        OffsetData offsetData = ((XLXPCacheDataFactory.OffsetNodeData)((Object)internalNodeData)).getOffsetData();
        if (offsetData != null) {
            ((XLXPCursor)cursor2).saveEndPosition(offsetData);
        }
        if (cursor2.toNext()) {
            DOMCachedNode dOMCachedNode2 = this.makeNode(cursor2, dOMCachedNode.getCache(), dOMCachedNode.getCachedParent(), dOMCachedNode);
            InternalNodeData internalNodeData2 = dOMCachedNode2.getInternalNodeData();
            if (internalNodeData2 == null || !(internalNodeData2 instanceof StreamingDataFactory.XCIData)) {
                return true;
            }
            ((StreamingDataFactory.XCIData)((Object)dOMCachedNode2.getInternalNodeData())).setXCI(cursor2);
            this.restorePreviousCursorContext(dOMCachedNode, (XLXPCursor)cursor3);
            return true;
        }
        cursor2.release();
        this.restorePreviousCursorContext(dOMCachedNode, (XLXPCursor)cursor3);
        if (cursor2 == this.source) {
            // empty if block
        }
        return false;
    }

    private void restorePreviousCursorContext(DOMCachedNode dOMCachedNode, XLXPCursor xLXPCursor) {
        dOMCachedNode.setState(dOMCachedNode.getState() | 0x2000000);
        InternalNodeData internalNodeData = dOMCachedNode.getInternalNodeData();
        XLXPCacheDataFactory.XPParentSubtreeData xPParentSubtreeData = XLXPCacheDataFactory.INSTANCE.createSkippedData(internalNodeData);
        int n2 = dOMCachedNode.getNodeID();
        dOMCachedNode.setInternalNodeData(xPParentSubtreeData);
        dOMCachedNode.buildSubtreeID(n2);
        xPParentSubtreeData.setXCI(xLXPCursor);
        xPParentSubtreeData.setSubtreeOffsetData(xLXPCursor.makeSubtreeOffsetData());
    }

    public boolean doBuildNext(DOMCachedNode dOMCachedNode) {
        InternalNodeData internalNodeData = dOMCachedNode.getInternalNodeData();
        if (internalNodeData == null || !(internalNodeData instanceof XLXPCacheDataFactory.OffsetNodeData)) {
            return false;
        }
        XLXPCacheDataFactory.OffsetNodeData offsetNodeData = (XLXPCacheDataFactory.OffsetNodeData)((Object)internalNodeData);
        XLXPCursor xLXPCursor = offsetNodeData.getXLXPCursor();
        OffsetData offsetData = offsetNodeData.getOffsetData();
        if (offsetData != null) {
            xLXPCursor.saveEndPosition(offsetData);
        }
        return super.doBuildNext(dOMCachedNode);
    }

    protected DOMCachedNode makeNode(Cursor cursor2, CacheManager cacheManager, DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        DOMCachedNode dOMCachedNode3 = super.makeNode(cursor2, cacheManager, dOMCachedNode, dOMCachedNode2);
        InternalNodeData internalNodeData = dOMCachedNode3.getInternalNodeData();
        if (internalNodeData == null || !(internalNodeData instanceof XLXPCacheDataFactory.OffsetNodeData) || dOMCachedNode3.itemKind() != 1) {
            return dOMCachedNode3;
        }
        XLXPCursor xLXPCursor = (XLXPCursor)cursor2;
        OffsetData offsetData = xLXPCursor.createOffsetData();
        ((XLXPCacheDataFactory.OffsetNodeData)((Object)internalNodeData)).setOffsetData(offsetData);
        xLXPCursor.saveStartPosition(offsetData);
        return dOMCachedNode3;
    }

    public VolatileCData serialize(Cursor cursor2, Map map2) {
        if (this.fastSerialization) {
            XLXPCursor xLXPCursor;
            DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
            InternalNodeData internalNodeData = dOMCachedNode.getInternalNodeData();
            XLXPCursor xLXPCursor2 = xLXPCursor = internalNodeData != null && internalNodeData instanceof StreamingDataFactory.XCIData ? (XLXPCursor)((StreamingDataFactory.XCIData)((Object)internalNodeData)).getXCI() : null;
            if (xLXPCursor != null && xLXPCursor.allowFastSerialization(map2)) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "serialize", "About to provide fast serialization");
                }
                return new SerializerCDataDelegate(cursor2.fork(false), map2, this.isFullCopyOrSer(dOMCachedNode) ? this.fullCopier : this.subtreeCopier);
            }
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "serialize", "Could NOT (or didnt want to) provide fast serialization");
        }
        return super.serialize(cursor2, map2);
    }

    public boolean fastSerializationEnabled() {
        return this.fastSerialization;
    }

    public ItemCopier getItemCopier(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "getItemCopier", "requesting a new itemCopier for node: " + dOMCachedNode.toStringLazy() + " | isFullCopyOrSet?" + this.isFullCopyOrSer(dOMCachedNode));
        }
        return this.isFullCopyOrSer(dOMCachedNode) ? this.fullCopier : this.subtreeCopier;
    }

    public InternalNodeDataFactory getUserDataFactory() {
        return XLXPCacheDataFactory.INSTANCE;
    }

    public void processParameters(Map map2) {
        super.processParameters(map2);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    protected final class ByteCopier
    implements ItemCopier {
        private final boolean full;

        protected ByteCopier(boolean bl) {
            this.full = bl;
        }

        public int copyNode(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
            short s;
            Cursor cursor4;
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                String string2 = null;
                if (cursor2.unwrap() instanceof DOMCachedNode) {
                    cursor4 = (DOMCachedNode)cursor2.unwrap();
                    string2 = ((DOMCachedNode)cursor4).toStringLazy();
                }
                logger.logp(Level.FINER, logger.getName(), "copyNode", "copyNode from XLXPCacheMediator for source: " + string2);
            }
            if ((s = cursor2.itemKind()) != 4 && s != 2) {
                cursor4 = cursor2.unwrap();
                if (!(cursor4 instanceof DOMCachedNode)) {
                    return 3;
                }
                DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
                return XLXPCacheMediator.this.copyNode(dOMCachedNode, area, (AddContentInterface)((Object)cursor3), this.full);
            }
            return 3;
        }

        public Cursor.Profile sourceProfile() {
            return Copier.SOURCE_FEATURES;
        }

        public Cursor.Profile targetProfile(Cursor.Area area) {
            return Copier.TARGET_FEATURES;
        }
    }
}

