/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.scanner;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.adapters.xlxp.mediator.OffsetData;
import com.ibm.xml.xci.adapters.xlxp.scanner.OffsetDataImpl;
import com.ibm.xml.xci.adapters.xlxp.scanner.Scanner;
import com.ibm.xml.xci.adapters.xlxp.scanner.XCIScanner;
import com.ibm.xml.xci.adapters.xlxp.util.XLXPResourceManager;
import com.ibm.xml.xci.adapters.xlxp.util.XLXPSharedResources;
import com.ibm.xml.xci.spi.config.XMLAttachmentUnmarshaller;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class DelegatingSubtreeScanner
implements Scanner {
    private static final Logger logger = LoggerUtil.getLogger(DelegatingSubtreeScanner.class);
    private XCIScanner delegate;
    private XLXPSharedResources sharedResources;
    private final XCIScanner.XCIScannerFragment subtreeInfo;
    private final int features;
    private final boolean isXML10;
    private final boolean lineBreaksNormalized;
    private final XMLString subtreeContent;
    private final XMLAttachmentUnmarshaller fMTOMAU;

    public DelegatingSubtreeScanner(XLXPSharedResources xLXPSharedResources, XCIScanner.XCIScannerFragment xCIScannerFragment, XMLString xMLString, int n2, boolean bl, boolean bl2, XMLAttachmentUnmarshaller xMLAttachmentUnmarshaller) {
        this.sharedResources = xLXPSharedResources;
        this.subtreeInfo = xCIScannerFragment;
        this.subtreeContent = xMLString;
        this.features = n2;
        this.isXML10 = bl;
        this.lineBreaksNormalized = bl2;
        this.fMTOMAU = xMLAttachmentUnmarshaller;
        this.delegate = null;
    }

    private void activate() {
        if (this.delegate != null) {
            return;
        }
        this.delegate = this.sharedResources.getResourceManager().getScanner(this.features, this.sharedResources, this.sharedResources.supportsLargeDocuments(), this.fMTOMAU);
        this.delegate.setupDelegate();
        ParsedEntity parsedEntity = this.sharedResources.getEntityFactory().createParsedEntityFromXMLString(this.subtreeContent, null, this.isXML10);
        this.subtreeContent.unregister();
        parsedEntity.lineBreaksNormalized = this.lineBreaksNormalized;
        parsedEntity.isFragment = true;
        this.delegate.loadFragment(this.subtreeInfo, parsedEntity);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            String string2 = this.subtreeInfo.getElementName();
            logger.logp(Level.FINER, logger.getName(), "activate", "activated a new scanner to parse the subtree of:" + string2);
        }
    }

    public VolatileCData itemName() {
        return this.delegate.itemName();
    }

    public VolatileCData itemAttributeName(int n2) {
        return this.delegate.itemAttributeName(n2);
    }

    public VolatileCData itemNamespaceName(int n2) {
        return this.delegate.itemNamespaceName(n2);
    }

    public int attributeCount() {
        return this.delegate.attributeCount();
    }

    public Cursor.ItemValueOrigin itemAttributeValueOrigin(int n2) {
        return this.delegate.itemAttributeValueOrigin(n2);
    }

    public int currentEvent() {
        this.activate();
        return this.delegate.currentEvent();
    }

    public DocumentInfo documentInfo() {
        return this.delegate.documentInfo();
    }

    public XSAttributeDeclaration getAttributeDeclaration(int n2) {
        return this.delegate.getAttributeDeclaration(n2);
    }

    public XSElementDeclaration getElementDeclaration() {
        return this.delegate.getElementDeclaration();
    }

    public OffsetData.AddCharsHelper createAddCharsHelper() {
        return OffsetDataImpl.createAddCharsHelper();
    }

    public OffsetData createOffsetData() {
        return new OffsetDataImpl();
    }

    public void saveStartPosition(OffsetData offsetData) {
        this.delegate.saveStartPosition(offsetData);
    }

    public void saveEndPosition(OffsetData offsetData) {
        this.delegate.saveEndPosition(offsetData);
    }

    public XSTypeDefinition getTypeDefinition() {
        return this.delegate.getTypeDefinition();
    }

    public boolean leafNilled() {
        return this.delegate.leafNilled();
    }

    public void loadRemainingBuffers(OffsetData offsetData) {
        this.activate();
        this.delegate.loadRemainingBuffers(offsetData);
    }

    public int nextScannerEvent() {
        return this.delegate.nextScannerEvent();
    }

    public boolean nilled() {
        return this.delegate.nilled();
    }

    public int nsDeclCount() {
        return this.delegate.nsDeclCount();
    }

    public ExtendedNamespaceContext nscontext() {
        return this.delegate.nscontext();
    }

    public void registerReferrer() {
        this.delegate.registerReferrer();
    }

    public Scanner createSubtreeScanner() {
        return this.delegate.createSubtreeScanner();
    }

    public boolean fastSerializationAllowed() {
        this.activate();
        return this.delegate.fastSerializationAllowed();
    }

    public OffsetData makeSubtreeOffsetData() {
        OffsetDataImpl offsetDataImpl = new OffsetDataImpl();
        offsetDataImpl.setStartPosition(this.subtreeContent.firstBuffer, this.subtreeContent.startOffset);
        offsetDataImpl.setEndPosition(this.subtreeContent.lastBuffer != null ? this.subtreeContent.lastBuffer : this.subtreeContent.firstBuffer, this.subtreeContent.endOffset);
        return offsetDataImpl;
    }

    public boolean toNextElementNode() {
        return this.delegate.toNextElementNode();
    }

    public VolatileCData contentAsStringValue() {
        return this.delegate.contentAsStringValue();
    }

    public VolatileCData leafElementValue(XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        return this.delegate.leafElementValue(xSSimpleTypeDefinition, bl);
    }

    public VolatileCData attributeValue(int n2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return this.delegate.attributeValue(n2, xSSimpleTypeDefinition);
    }

    public VolatileCData nsDeclValue(int n2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return this.delegate.nsDeclValue(n2, xSSimpleTypeDefinition);
    }

    public VolatileCData elementTypedValue() {
        return this.delegate.elementTypedValue();
    }

    public VolatileCData elementSValue() {
        return this.delegate.elementSValue();
    }

    public VolatileCData documentTextValue(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return this.delegate.documentTextValue(xSSimpleTypeDefinition);
    }

    public void describe(StringBuilder stringBuilder) {
        if (this.delegate == null) {
            stringBuilder.append("delegating scanner with non-activated scanner");
            return;
        }
        stringBuilder.append("delegating scanner with ACTIVATED scanner. Delegate Scanner details: ");
        this.delegate.describe(stringBuilder);
    }

    public short getDocumentReferenceIndex() {
        return this.sharedResources.getDocumentReferenceIndex();
    }

    public void setDocumentReferenceIndex(short s) {
        this.sharedResources.setDocumentReferenceIndex(s);
    }

    public void manualRelease() {
        assert (this.delegate != null);
        this.delegate.manualRelease();
    }

    public void recycle() {
        if (this.delegate == null) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "recycle", "Throwing out the following non-activated delegative scanner:  " + this.toString());
            }
            this.subtreeContent.unregister();
            this.subtreeInfo.reset();
        } else {
            this.delegate.recycle();
        }
    }

    public XLXPResourceManager.DocumentResources getDocumentResources() {
        return this.sharedResources;
    }
}

