/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.scanner;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.adapters.xlxp.mediator.OffsetData;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionHandler;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.UTF8Support;
import java.io.CharConversionException;
import java.util.ConcurrentModificationException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class OffsetDataImpl
implements OffsetData {
    private static final Logger logger = LoggerUtil.getLogger(OffsetDataImpl.class);
    private int startOffset;
    private int endOffset;
    private DataBuffer firstBuffer;
    private DataBuffer lastBuffer;

    OffsetDataImpl() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, logger.getName(), "init", "Created new OffsetDataImpl: " + LoggerUtil.getUniqueString(this));
        }
    }

    static OffsetData.AddCharsHelper createAddCharsHelper() {
        return new AddCharsHandler();
    }

    void setStartPosition(DataBuffer dataBuffer, int n2) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setStartPosition", "Changing firstBuffer from " + this.firstBuffer + " to " + dataBuffer + " and startOffset from " + this.startOffset + " to " + n2 + ".  This is " + LoggerUtil.getUniqueString(this));
        }
        this.firstBuffer = dataBuffer;
        this.startOffset = n2;
    }

    void setEndPosition(DataBuffer dataBuffer, int n2) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setEndPosition", "Changing lastBuffer from " + this.lastBuffer + " to " + dataBuffer + " and endOffset from " + this.endOffset + " to " + n2 + ".  This is " + LoggerUtil.getUniqueString(this));
        }
        this.lastBuffer = dataBuffer;
        this.endOffset = n2;
    }

    void addContentAsChars(CharConversionHandler charConversionHandler) {
        try {
            this.firstBuffer.convertToChars(this.startOffset, this.firstBuffer.lengthToEndPosition(this.startOffset, this.lastBuffer, this.endOffset), 0, charConversionHandler);
        }
        catch (CharConversionException charConversionException) {
            XCIDynamicErrorException xCIDynamicErrorException = XCIErrorHelper.createInternalException(charConversionException);
            FFDCUtil.log(xCIDynamicErrorException, this);
            throw xCIDynamicErrorException;
        }
    }

    public void addContentAsBytes(AddContentInterface addContentInterface, Cursor.Area area) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "addContentAsBytes", this.toString());
        }
        if (this.firstBuffer == this.lastBuffer) {
            addContentInterface.addContent(area, this.firstBuffer.bytes, this.startOffset, this.endOffset - this.startOffset);
        } else {
            DataBuffer dataBuffer = this.firstBuffer;
            addContentInterface.addContent(area, dataBuffer.bytes, this.startOffset, dataBuffer.endOffset - this.startOffset);
            dataBuffer = dataBuffer.next;
            while (dataBuffer != this.lastBuffer) {
                if (dataBuffer == null) {
                    return;
                }
                addContentInterface.addContent(area, dataBuffer.bytes, dataBuffer.startOffset, dataBuffer.endOffset - dataBuffer.startOffset);
                dataBuffer = dataBuffer.next;
            }
            addContentInterface.addContent(area, dataBuffer.bytes, dataBuffer.startOffset, this.endOffset - dataBuffer.startOffset);
        }
    }

    public void copyEndPosition(OffsetData offsetData) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "copyEndPosition", "Changing lastBuffer from " + this.lastBuffer + " to " + ((OffsetDataImpl)offsetData).lastBuffer + " and endOffset from " + this.endOffset + " to " + ((OffsetDataImpl)offsetData).endOffset + ".  This is " + LoggerUtil.getUniqueString(this));
        }
        this.lastBuffer = ((OffsetDataImpl)offsetData).lastBuffer;
        this.endOffset = ((OffsetDataImpl)offsetData).endOffset;
    }

    public void copyEndPositionFromStartPosition(OffsetData offsetData) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "copyEndPositionFromStartPosition", "Changing lastBuffer from " + this.lastBuffer + " to " + ((OffsetDataImpl)offsetData).firstBuffer + " and endOffset from " + this.endOffset + " to " + ((OffsetDataImpl)offsetData).startOffset + ".  This is " + LoggerUtil.getUniqueString(this));
        }
        this.lastBuffer = ((OffsetDataImpl)offsetData).firstBuffer;
        this.endOffset = ((OffsetDataImpl)offsetData).startOffset;
    }

    public void copyStartPosition(OffsetData offsetData) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "copyStartPosition", "Changing firstBuffer from " + this.firstBuffer + " to " + ((OffsetDataImpl)offsetData).firstBuffer + " and startOffset from " + this.startOffset + " to " + ((OffsetDataImpl)offsetData).startOffset + ".  This is " + LoggerUtil.getUniqueString(this));
        }
        this.firstBuffer = ((OffsetDataImpl)offsetData).firstBuffer;
        this.startOffset = ((OffsetDataImpl)offsetData).startOffset;
    }

    public void copyStartPositionFromEndPosition(OffsetData offsetData) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "copyStartPositionFromEndPosition", "Changing firstBuffer from " + this.firstBuffer + " to " + ((OffsetDataImpl)offsetData).lastBuffer + " and startOffset from " + this.startOffset + " to " + ((OffsetDataImpl)offsetData).endOffset + ".  This is " + LoggerUtil.getUniqueString(this));
        }
        this.firstBuffer = ((OffsetDataImpl)offsetData).lastBuffer;
        this.startOffset = ((OffsetDataImpl)offsetData).endOffset;
    }

    public boolean endPositionFollowsStartPosition() {
        return this.firstBuffer != this.lastBuffer || this.startOffset <= this.endOffset;
    }

    public boolean endPositionKnown() {
        return this.lastBuffer != null;
    }

    public boolean positionKnown() {
        return this.firstBuffer != null && this.lastBuffer != null;
    }

    public boolean startPositionKnown() {
        return this.firstBuffer != null;
    }

    public String toString() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ID: ");
            stringBuilder.append(LoggerUtil.getUniqueString(this));
            stringBuilder.append(" | firstBuffer:");
            stringBuilder.append(this.firstBuffer);
            stringBuilder.append(" | lastBuffer:");
            stringBuilder.append(this.lastBuffer);
            stringBuilder.append(" | startOffset:");
            stringBuilder.append(this.startOffset);
            stringBuilder.append(" | endOffset:");
            stringBuilder.append(this.endOffset);
            stringBuilder.append('\n');
            stringBuilder.append("Contents:");
            if (this.firstBuffer == this.lastBuffer) {
                stringBuilder.append(UTF8Support.toString(this.firstBuffer, this.startOffset, this.endOffset - this.startOffset, 0));
            } else {
                stringBuilder.append(UTF8Support.toString(this.firstBuffer, this.startOffset, this.firstBuffer.endOffset - this.startOffset, 0));
                DataBuffer dataBuffer = this.firstBuffer.next;
                while (dataBuffer != this.lastBuffer && dataBuffer != null) {
                    stringBuilder.append(UTF8Support.toString(dataBuffer, dataBuffer.startOffset, dataBuffer.endOffset - dataBuffer.startOffset, 0));
                    dataBuffer = dataBuffer.next;
                }
                if (this.lastBuffer != null) {
                    stringBuilder.append(UTF8Support.toString(this.lastBuffer, this.lastBuffer.startOffset, this.endOffset - this.lastBuffer.startOffset, 0));
                }
            }
            return stringBuilder.toString();
        }
        catch (CharConversionException charConversionException) {
            return LoggerUtil.getUniqueString(this);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class AddCharsHandler
    implements OffsetData.AddCharsHelper,
    CharConversionHandler {
        public boolean active;
        public AddContentInterface target;
        public Cursor.Area where;

        private AddCharsHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addContentAsChars(AddContentInterface addContentInterface, Cursor.Area area, OffsetData offsetData) {
            if (this.active) {
                throw new ConcurrentModificationException("addContentAsChars");
            }
            this.active = true;
            this.target = addContentInterface;
            this.where = area;
            try {
                ((OffsetDataImpl)offsetData).addContentAsChars(this);
            }
            finally {
                this.active = false;
                this.target = null;
                this.where = null;
            }
        }

        public void receiveChar(char c) {
            if (!this.active) {
                throw new ConcurrentModificationException("receiveChar");
            }
            this.target.addContent(this.where, new char[]{c}, 0, 1);
        }

        public void receiveChars(char[] cArray, int n2, int n3, boolean bl) {
            if (!this.active) {
                throw new ConcurrentModificationException("receiveChars");
            }
            this.target.addContent(this.where, cArray, n2, n3);
        }
    }
}

