/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.scanner;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.adapters.xlxp.mediator.OffsetData;
import com.ibm.xml.xci.adapters.xlxp.scanner.DelegatingSubtreeScanner;
import com.ibm.xml.xci.adapters.xlxp.scanner.OffsetDataImpl;
import com.ibm.xml.xci.adapters.xlxp.scanner.Scanner;
import com.ibm.xml.xci.adapters.xlxp.util.XLXPResourceManager;
import com.ibm.xml.xci.adapters.xlxp.util.XLXPSharedResources;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.errors.XCIIllegalContextItemException;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.spi.config.AttachmentContent;
import com.ibm.xml.xci.spi.config.XMLAttachmentUnmarshaller;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.xlxp.cdata.XLXPCDataFactory;
import com.ibm.xml.xlxp.internal.s1.api.util.SimplePositionHelper;
import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.XDecimal;
import com.ibm.xml.xlxp.internal.s1.grammar.Attribute;
import com.ibm.xml.xlxp.internal.s1.grammar.Grammar;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.DTDScanner;
import com.ibm.xml.xlxp.internal.s1.scan.DTDSupport;
import com.ibm.xml.xlxp.internal.s1.scan.DocumentScanner;
import com.ibm.xml.xlxp.internal.s1.scan.msg.MessageProvider;
import com.ibm.xml.xlxp.internal.s1.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DTDGrammar;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DelegatingDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DelegatingParsedEntityFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DocumentPosition;
import com.ibm.xml.xlxp.internal.s1.scan.util.EntityDeclPool;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.PositionHelper;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolTable;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.util.Base64;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.Location;
import org.w3c.dom.DOMErrorHandler;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XCIScanner
extends VMContext
implements Scanner,
ExtendedNamespaceContext,
Location,
XLXPCDataFactory.Helper {
    private static final Logger logger = LoggerUtil.getLogger(XCIScanner.class);
    private XCIDTDScanner fDTDScanner;
    private XCIDTDGrammarSupport fDTDGrammarSupport;
    private final DelegatingParsedEntityFactory fDelegatingParsedEntityFactory;
    private final DelegatingDataBufferFactory fDelegatingBufferFactory;
    private XLXPSharedResources sharedResources;
    private XLXPCDataFactory cdataFactory;
    private PositionHelper fPositionHelper;
    private DocumentPosition fDocumentPosition;
    private XCIScannerReferrer fBufferReferrer;
    private boolean fProcessingText = false;
    private boolean fExposeEncoding;
    private final int features;
    private XMLAttachmentUnmarshaller fMTOMAU;
    private String fMTOMID;

    public XCIScanner(XLXPSharedResources xLXPSharedResources, int n2) {
        super((DataBufferFactory)new DelegatingDataBufferFactory(xLXPSharedResources.getBufferFactory()), new SymbolTable(), n2);
        this.sharedResources = xLXPSharedResources;
        this.fDelegatingBufferFactory = (DelegatingDataBufferFactory)this.fBufferFactory;
        this.fDelegatingParsedEntityFactory = new DelegatingParsedEntityFactory(xLXPSharedResources.getEntityFactory());
        this.setDTDSupport(new XCIDTDSupport(this));
        this.features = n2;
    }

    public void setAttachmentUnmarshaller(XMLAttachmentUnmarshaller xMLAttachmentUnmarshaller) {
        this.fMTOMAU = xMLAttachmentUnmarshaller;
        this.mtomEnabled = xMLAttachmentUnmarshaller != null;
    }

    public void addUnparsedEntity(String string2, String string3, String string4, String string5) {
        this.sharedResources.getDocumentInfo().addUnparsedEntity(string2, string3, string4, string5);
    }

    public int features() {
        return this.features;
    }

    public void setGrammar(Grammar grammar) {
        this.setIR(grammar);
    }

    public VMContext getSchemaProcessor() {
        return this;
    }

    public void setupDocument(InputSource inputSource, TypeRegistry typeRegistry, DOMErrorHandler dOMErrorHandler, boolean bl) throws IOException {
        this.cdataFactory = new XLXPCDataFactory();
        this.sharedResources.getDocumentInfo().initialize(typeRegistry, dOMErrorHandler);
        this.fExposeEncoding = bl;
        if (this.fDTDSupport == null) {
            this.setDTDSupport(new XCIDTDSupport(this));
        } else if (this.fDTDSupport instanceof XCIDTDSupport) {
            if (((XCIDTDSupport)this.fDTDSupport).getScanner() != this) {
                this.setDTDSupport(new XCIDTDSupport(this));
            }
        } else if (this.fDTDSupport instanceof XCIDTDScanner) {
            if (this.fDTDScanner != this.fDTDSupport || this.fDTDScanner.getScanner() != this) {
                this.setDTDSupport(new XCIDTDSupport(this));
            }
        } else if (this.fDTDSupport instanceof XCIDTDGrammarSupport) {
            if (this.fDTDGrammarSupport != this.fDTDSupport || this.fDTDGrammarSupport.getScanner() != this) {
                this.setDTDSupport(new XCIDTDSupport(this));
            }
            this.setDTDSupport(new XCIDTDSupport(this));
        } else {
            this.setDTDSupport(new XCIDTDSupport(this));
        }
        ParsedEntity parsedEntity = this.sharedResources.getEntityFactory().createParsedEntity(inputSource);
        this.setDocumentEntity(parsedEntity);
        this.sharedResources.getDocumentInfo().setPublicId(inputSource.getPublicId());
        this.sharedResources.getDocumentInfo().setSystemId(inputSource.getSystemId());
        this.nextEvent();
        assert (this.currentEvent() == 1);
    }

    void setupDelegate() {
        this.cdataFactory = new XLXPCDataFactory();
    }

    public void setSharedResources(XLXPSharedResources xLXPSharedResources) {
        this.sharedResources = xLXPSharedResources;
        this.setBufferFactory(xLXPSharedResources.getBufferFactory());
        this.setParsedEntityFactory(xLXPSharedResources.getEntityFactory());
    }

    public XLXPSharedResources getSharedResources() {
        return this.sharedResources;
    }

    private void setBufferFactory(DataBufferFactory dataBufferFactory) {
        this.fDelegatingBufferFactory.factory = dataBufferFactory;
    }

    private void setParsedEntityFactory(ParsedEntityFactory parsedEntityFactory) {
        this.fDelegatingParsedEntityFactory.factory = parsedEntityFactory;
    }

    @Override
    public int currentEvent() {
        return this.fCurrentEvent;
    }

    @Override
    public int nextScannerEvent() {
        int n2 = this.fCurrentEvent;
        int n3 = this.nextEvent();
        if (!this.mtomEnabled) {
            return n3;
        }
        if (n3 == 4) {
            return n3;
        }
        if ((n3 == 2 || n3 == 3) && "Include".equals(this.elementQName.localName) && "http://www.w3.org/2004/08/xop/include".equals(this.elementQName.nsURI)) {
            for (int i = 0; i < this.attributeCount(); ++i) {
                QName qName = this.attributeName(i);
                if (!"href".equals(qName.localName) || !"".equals(qName.nsURI)) continue;
                this.fMTOMID = this.attributeValue(i).toString();
                if (n3 == 2) {
                    this.skipCurrentSubtree();
                }
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER) && n2 != 2) {
                    logger.logp(Level.FINER, logger.getName(), "nextScannerEvent", "Saw event " + n2 + " before <xop:Include> with content ID: " + this.fMTOMID);
                }
                this.fCurrentEvent = 5;
                return 5;
            }
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER) && n2 == 5 && this.fMTOMID != null) {
            logger.logp(Level.FINER, logger.getName(), "nextScannerEvent", "Saw event " + n3 + " after <xop:Include> with content ID: " + this.fMTOMID);
        }
        this.fMTOMID = null;
        return n3;
    }

    @Override
    public OffsetData.AddCharsHelper createAddCharsHelper() {
        return OffsetDataImpl.createAddCharsHelper();
    }

    @Override
    public OffsetData createOffsetData() {
        return new OffsetDataImpl();
    }

    @Override
    public void saveStartPosition(OffsetData offsetData) {
        ((OffsetDataImpl)offsetData).setStartPosition(this.getCurrentStartDataBuffer(), this.getCurrentStartOffset());
    }

    @Override
    public void saveEndPosition(OffsetData offsetData) {
        ((OffsetDataImpl)offsetData).setEndPosition(this.getCurrentEndDataBuffer(), this.getCurrentEndOffset());
    }

    private DataBuffer getCurrentStartDataBuffer() {
        return this.fCurrentEventFirstBuffer;
    }

    private int getCurrentStartOffset() {
        return this.fCurrentEventStartOffset;
    }

    private DataBuffer getCurrentEndDataBuffer() {
        return this.fCurrentEntity.buffer;
    }

    private int getCurrentEndOffset() {
        return this.fCurrentEntity.offset;
    }

    @Override
    public void loadRemainingBuffers(OffsetData offsetData) {
        Object object2;
        boolean bl;
        boolean bl2 = LoggerUtil.isAnyTracingEnabled();
        ParsedEntity parsedEntity = this.fCurrentEntity;
        if (bl2 && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "loadRemainingBuffers", "About to load remaining document data.");
        }
        parsedEntity.setMark();
        while (bl = parsedEntity.loadMore() != 0) {
        }
        CharConversionError charConversionError = parsedEntity.error;
        if (charConversionError != null) {
            object2 = charConversionError.formatErrorMessage();
            if (bl2 && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "loadMore", "Loading failed, error string=" + (String)object2);
            }
        }
        parsedEntity.resetToMark();
        if (charConversionError != null) {
            parsedEntity.buffer.next = null;
        }
        if (offsetData != null) {
            object2 = parsedEntity.buffer;
            while (((DataBuffer)object2).next != null) {
                object2 = ((DataBuffer)object2).next;
            }
            ((OffsetDataImpl)offsetData).setEndPosition((DataBuffer)object2, ((DataBuffer)object2).endOffset);
        }
    }

    @Override
    public XSElementDeclaration getElementDeclaration() {
        if (this.ir == null) {
            return null;
        }
        return this.eDecl == null ? null : this.eDecl.xsElementDeclaration;
    }

    @Override
    public XSTypeDefinition getTypeDefinition() {
        if (this.ir == null) {
            return null;
        }
        if (this.eType == null) {
            return null;
        }
        switch (this.fCurrentEvent) {
            case 2: 
            case 3: 
            case 4: {
                return this.eType.xsTypeDefinition;
            }
        }
        return null;
    }

    @Override
    public XSAttributeDeclaration getAttributeDeclaration(int n2) {
        if (this.ir == null || this.eType == null) {
            return null;
        }
        return this.aDecls[n2] != null ? this.aDecls[n2].xsAttributeDeclaration : null;
    }

    @Override
    public Cursor.ItemValueOrigin itemAttributeValueOrigin(int n2) {
        if (this.attributeSpecified(n2)) {
            return Cursor.ItemValueOrigin.SPECIFIED;
        }
        if (this.attributeSchemaDefaulted(n2)) {
            return Cursor.ItemValueOrigin.XSDDEFAULTED;
        }
        return Cursor.ItemValueOrigin.DTDDEFAULTED;
    }

    private boolean attributeSchemaDefaulted(int n2) {
        if (this.ir == null || this.eType == null) {
            return false;
        }
        if (this.eType.hasVC != null) {
            return n2 >= this.firstSchemaDefaultIndex;
        }
        return false;
    }

    private VolatileCData getFixedAttrValue(int n2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        Attribute attribute2 = this.aDecls[n2];
        ValidatedInfo validatedInfo = attribute2.vcValue;
        switch (validatedInfo.typeValidator.builtInKind) {
            case 4: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 42: {
                return this.getXMLStringCData(((XDecimal)validatedInfo.actualValue).rawData, xSSimpleTypeDefinition, n2);
            }
            case 1: 
            case 2: {
                return this.getXMLStringCData((XMLString)validatedInfo.actualValue, xSSimpleTypeDefinition, n2);
            }
        }
        return new StringCData(validatedInfo.actualValue.toString(), xSSimpleTypeDefinition);
    }

    @Override
    public final boolean produceStartDocumentEvent() {
        boolean bl = super.produceStartDocumentEvent();
        this.sharedResources.getDocumentInfo().setXMLVersion(this.fIsXML10);
        this.sharedResources.getDocumentInfo().setXMLEncoding(this.fExposeEncoding && this.encName.length != 0 ? this.encName.toString() : null);
        return bl;
    }

    @Override
    public boolean produceDoctypeEvent() {
        super.produceDoctypeEvent();
        return true;
    }

    @Override
    public boolean produceStartEntityEvent() {
        super.produceStartEntityEvent();
        return !this.fProcessingText;
    }

    @Override
    public boolean produceEndEntityEvent() {
        super.produceEndEntityEvent();
        return !this.fProcessingText;
    }

    @Override
    public boolean produceEntityReferenceEvent() {
        super.produceEntityReferenceEvent();
        return true;
    }

    private void updateCurrentPosition() {
        if (this.fDocumentPosition == null) {
            this.fDocumentPosition = new DocumentPosition();
            this.fPositionHelper = new SimplePositionHelper();
        }
        this.fPositionHelper.setCurrentExternalEntity(this.fCurrentEntity);
        this.fPositionHelper.getCurrentPosition(this.fDocumentPosition);
    }

    @Override
    public boolean produceFatalErrorEvent() {
        super.produceFatalErrorEvent();
        this.updateCurrentPosition();
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(this.getErrorMessage());
        xCIDynamicErrorException.setSourceLocation(XCIErrorHelper.locationTransformer(this));
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "produceFatalErrorEvent", "Producing an error message: " + xCIDynamicErrorException.getMessage() + "\n Stack Trace: " + XCIErrorHelper.getStackTrace(30));
        }
        this.documentInfo().getErrorHandler().handleError(new XCIErrorHelper.XCIErrorImpl(xCIDynamicErrorException, 3));
        throw xCIDynamicErrorException;
    }

    @Override
    public boolean produceRecoverableErrorEvent() {
        this.updateCurrentPosition();
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(this.getErrorMessage());
        xCIDynamicErrorException.setSourceLocation(XCIErrorHelper.locationTransformer(this));
        boolean bl = this.documentInfo().getErrorHandler().handleError(new XCIErrorHelper.XCIErrorImpl(xCIDynamicErrorException, 2));
        if (!bl) {
            throw xCIDynamicErrorException;
        }
        int n2 = this.fCurrentEvent;
        super.produceRecoverableErrorEvent();
        this.fCurrentEvent = n2;
        return true;
    }

    @Override
    public boolean produceWarningEvent() {
        this.updateCurrentPosition();
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(this.getErrorMessage());
        xCIDynamicErrorException.setSourceLocation(XCIErrorHelper.locationTransformer(this));
        boolean bl = this.documentInfo().getErrorHandler().handleError(new XCIErrorHelper.XCIErrorImpl(xCIDynamicErrorException, 1));
        if (!bl) {
            throw xCIDynamicErrorException;
        }
        int n2 = this.fCurrentEvent;
        super.produceWarningEvent();
        this.fCurrentEvent = n2;
        return true;
    }

    protected String getErrorMessage() {
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(this.errorURI);
        return messageProvider.createMessage(null, this.errorCode, this.errorParamStrings);
    }

    @Override
    public void registerReferrer() {
        this.fBufferReferrer = new XCIScannerReferrer(this.getCurrentStartDataBuffer());
    }

    void unregisterReferrer() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "unregisterReferrer", "unregistering the buffer referrer for this scanner.  Is document referenced? " + this.sharedResources.isDocumentReferenced());
        }
        if (this.fBufferReferrer != null) {
            this.fBufferReferrer.removeReferencesAndUnregister();
            this.fBufferReferrer = null;
        }
    }

    private final boolean isMarkupNext() {
        boolean bl = true;
        switch (this.fCurrentEntity.checkForMarkup()) {
            case 0: {
                bl = this.fCurrentEntity.isFragment && this.fCurrentEntity.atEndOfEntity();
                break;
            }
            case 4: {
                this.fCurrentEntity.setMark();
                this.fCurrentEntity.skipTwoBytes();
                if (this.fCurrentEntity.currentByte() == 91) {
                    bl = false;
                }
                this.fCurrentEntity.resetToMark();
            }
        }
        return bl;
    }

    @Override
    public ExtendedNamespaceContext nscontext() {
        return this;
    }

    @Override
    public boolean nilled() {
        return this.nilled;
    }

    @Override
    public boolean leafNilled() {
        return this.leafNilled;
    }

    @Override
    public DocumentInfo documentInfo() {
        return this.sharedResources.getDocumentInfo();
    }

    private void skipCurrentSubtree() {
        int n2 = 1;
        block4: while (n2 != 0 || this.currentEvent() != 4) {
            switch (this.nextEvent()) {
                case 2: {
                    ++n2;
                    continue block4;
                }
                case 4: {
                    --n2;
                    continue block4;
                }
            }
        }
        assert (this.currentEvent() == 4);
    }

    @Override
    public boolean toNextElementNode() {
        if (this.currentEvent() == 2) {
            this.skipCurrentSubtree();
        } else if (this.currentEvent() == 18) {
            return false;
        }
        boolean bl = this.isTextEvent();
        do {
            this.nextScannerEvent();
        } while (bl && this.isTextEvent());
        switch (this.currentEvent()) {
            case 4: 
            case 18: {
                return false;
            }
        }
        return true;
    }

    @Override
    public VolatileCData itemName() {
        switch (this.currentEvent()) {
            case 2: 
            case 3: {
                return this.cdataFactory.createXLXPQNameCData(this.elementQName);
            }
            case 10: {
                return this.sharedResources.createQNameCData(this.piTarget.toString());
            }
        }
        return this.sharedResources.createQNameCData(null);
    }

    @Override
    public VolatileCData itemAttributeName(int n2) {
        switch (this.currentEvent()) {
            case 2: 
            case 3: {
                return this.cdataFactory.createXLXPQNameCData(this.attributeName(n2));
            }
            case 10: {
                return this.sharedResources.createQNameCData(this.piTarget.toString());
            }
        }
        return this.sharedResources.createQNameCData(null);
    }

    @Override
    public VolatileCData itemNamespaceName(int n2) {
        switch (this.currentEvent()) {
            case 2: 
            case 3: {
                String string2 = this.nsDeclPrefix(n2);
                if (string2 != null && string2.length() > 0) {
                    return this.cdataFactory.createNamespaceCData(string2);
                }
                return this.cdataFactory.createNamespaceCData("");
            }
            case 10: {
                return this.sharedResources.createQNameCData(this.piTarget.toString());
            }
        }
        return this.sharedResources.createQNameCData(null);
    }

    @Override
    public VolatileCData contentAsStringValue() {
        return this.getXMLStringCData(this.content, TypeRegistry.XSSTRING, -1);
    }

    private String getMTOMText() {
        AttachmentContent attachmentContent = this.fMTOMAU.resolveAttachment(this.fMTOMID, null);
        return attachmentContent == null ? "" : Base64.encode(attachmentContent.getContent());
    }

    @Override
    public VolatileCData leafElementValue(XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) {
        if (this.fMTOMID != null) {
            return this.sharedResources.createMTOMCData(this.fMTOMAU, this.fMTOMID, xSSimpleTypeDefinition);
        }
        if (bl && this.isMarkupNext()) {
            return this.getXMLStringCData(this.content, xSSimpleTypeDefinition, -1);
        }
        return this.sharedResources.createCDataFromType(this.getText(), xSSimpleTypeDefinition);
    }

    @Override
    public VolatileCData attributeValue(int n2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        if (!this.attributeSchemaDefaulted(n2)) {
            return this.getXMLStringCData(this.attributeValue(n2), xSSimpleTypeDefinition, n2);
        }
        return this.getFixedAttrValue(n2, xSSimpleTypeDefinition);
    }

    @Override
    public VolatileCData nsDeclValue(int n2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        String string2 = this.nsDeclURI(n2);
        return new StringCData(string2, xSSimpleTypeDefinition);
    }

    private String getText() {
        assert (this.isTextEvent());
        StringBuilder stringBuilder = new StringBuilder();
        this.fProcessingText = true;
        while (true) {
            switch (this.currentEvent()) {
                case 5: 
                case 6: 
                case 7: {
                    if (this.fMTOMID != null) {
                        stringBuilder.append(this.getMTOMText());
                        this.fMTOMID = null;
                        break;
                    }
                    stringBuilder.append(this.content.toString());
                    break;
                }
                case 8: 
                case 9: {
                    int n2 = this.singleCh;
                    if (n2 < 65536) {
                        stringBuilder.append((char)n2);
                        break;
                    }
                    int n3 = n2 - 65536;
                    stringBuilder.append((char)(55296 + (n3 >> 10)));
                    stringBuilder.append((char)(56320 + (n3 & 0x3FF)));
                }
            }
            if (this.isMarkupNext()) break;
            this.nextScannerEvent();
        }
        this.fProcessingText = false;
        return stringBuilder.toString();
    }

    protected String getElementText() {
        assert (this.currentEvent() == 2);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 1;
        while (n2 != 0) {
            switch (this.nextScannerEvent()) {
                case 5: 
                case 6: 
                case 7: {
                    if (this.fMTOMID != null) {
                        stringBuilder.append(this.getMTOMText());
                        this.fMTOMID = null;
                        break;
                    }
                    stringBuilder.append(this.content.toString());
                    break;
                }
                case 8: 
                case 9: {
                    int n3 = this.singleCh;
                    if (n3 < 65536) {
                        stringBuilder.append((char)n3);
                        break;
                    }
                    int n4 = n3 - 65536;
                    stringBuilder.append((char)(55296 + (n4 >> 10)));
                    stringBuilder.append((char)(56320 + (n4 & 0x3FF)));
                    break;
                }
                case 2: {
                    ++n2;
                    break;
                }
                case 4: {
                    --n2;
                    break;
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public VolatileCData elementTypedValue() {
        XSTypeDefinition xSTypeDefinition = this.getTypeDefinition();
        XSSimpleTypeDefinition xSSimpleTypeDefinition = TypeRegistry.XSUNTYPEDATOMIC;
        if (xSTypeDefinition != null) {
            if (xSTypeDefinition.getTypeCategory() == 16) {
                xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSTypeDefinition;
            } else {
                short s = ((XSComplexTypeDefinition)xSTypeDefinition).getContentType();
                if (s == 1) {
                    xSSimpleTypeDefinition = ((XSComplexTypeDefinition)xSTypeDefinition).getSimpleType();
                } else {
                    if (s == 2) {
                        throw new XCIIllegalContextItemException("ER_ELEMCONTENT_VALUE", null);
                    }
                    if (s == 0) {
                        return null;
                    }
                }
            }
        }
        if (xSSimpleTypeDefinition != TypeRegistry.XSUNTYPEDATOMIC) {
            XMLString xMLString = this.getSimpleElementText();
            if (xMLString == null) {
                return null;
            }
            if (this.fMTOMID != null) {
                return this.sharedResources.createMTOMCData(this.fMTOMAU, this.fMTOMID, xSSimpleTypeDefinition);
            }
            return this.getXMLStringCData(xMLString, xSSimpleTypeDefinition, -1);
        }
        return this.sharedResources.createCDataFromType(this.getElementText(), TypeRegistry.XSUNTYPEDATOMIC);
    }

    @Override
    public VolatileCData elementSValue() {
        if (this.currentEvent() == 3) {
            if (this.elementValue != null) {
                return this.getXMLStringCData(this.content, TypeRegistry.XSSTRING, -1);
            }
            return this.sharedResources.createCDataFromType("", TypeRegistry.XSSTRING);
        }
        return this.sharedResources.createCDataFromType(this.getElementText(), TypeRegistry.XSSTRING);
    }

    protected XMLString getSimpleElementText() {
        assert (this.currentEvent() == 2);
        int n2 = 1;
        int n3 = 1;
        block4: while (n3 != 0) {
            switch (this.nextScannerEvent()) {
                case 2: {
                    n2 = ++n3;
                    continue block4;
                }
                case 4: {
                    --n3;
                    continue block4;
                }
            }
        }
        if (n2 == 1) {
            return this.getElementString();
        }
        return null;
    }

    private boolean isTextEvent() {
        int n2 = this.currentEvent();
        return n2 > 4 && n2 < 10 || n2 == 13 || n2 == 15;
    }

    @Override
    public VolatileCData documentTextValue(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        assert (this.currentEvent() == 1);
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            switch (this.nextScannerEvent()) {
                case 5: 
                case 6: 
                case 7: {
                    if (this.fMTOMID != null) {
                        stringBuilder.append(this.getMTOMText());
                        this.fMTOMID = null;
                        break;
                    }
                    stringBuilder.append(this.content.toString());
                    break;
                }
                case 8: 
                case 9: {
                    int n2 = this.singleCh;
                    if (n2 < 65536) {
                        stringBuilder.append((char)n2);
                        break;
                    }
                    int n3 = n2 - 65536;
                    stringBuilder.append((char)(55296 + (n3 >> 10)));
                    stringBuilder.append((char)(56320 + (n3 & 0x3FF)));
                    break;
                }
                case 18: {
                    return this.sharedResources.createCDataFromType(stringBuilder.toString(), xSSimpleTypeDefinition);
                }
            }
        }
    }

    private VolatileCData getXMLStringCData(XMLString xMLString, XSSimpleTypeDefinition xSSimpleTypeDefinition, int n2) {
        return this.cdataFactory.createXMLStringCData(xMLString, xSSimpleTypeDefinition, this, n2, true);
    }

    @Override
    public OffsetData makeSubtreeOffsetData() {
        return null;
    }

    @Override
    public Scanner createSubtreeScanner() {
        if (this.isSimpleSubtree()) {
            return null;
        }
        return this.breadCrumbScanner();
    }

    private boolean isSimpleSubtree() {
        if (this.currentEvent() == 3) {
            return true;
        }
        XSTypeDefinition xSTypeDefinition = this.getTypeDefinition();
        return xSTypeDefinition != null && xSTypeDefinition.getTypeCategory() == 16;
    }

    private Scanner breadCrumbScanner() {
        XMLString xMLString = this.getSubtreeContent();
        if (xMLString == null) {
            return null;
        }
        XCIScannerFragment xCIScannerFragment = (XCIScannerFragment)this.saveFragment();
        this.nextEvent();
        DelegatingSubtreeScanner delegatingSubtreeScanner = new DelegatingSubtreeScanner(this.sharedResources, xCIScannerFragment, xMLString, this.features, this.fIsXML10, this.fCurrentEntity.lineBreaksNormalized, this.fMTOMAU);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "breadCrumbScanner", "skipping the subtree:" + xMLString.toString());
        }
        return delegatingSubtreeScanner;
    }

    private XMLString getSubtreeContent() {
        assert (this.currentEvent() == 2);
        XMLString xMLString = new XMLString();
        if (this.skipContent(xMLString, false)) {
            return xMLString;
        }
        xMLString.unregister();
        return null;
    }

    @Override
    public Object saveFragment() {
        XCIScannerFragment xCIScannerFragment = new XCIScannerFragment();
        xCIScannerFragment.sDTDGrammar = this.fDTDScanner != null ? this.fDTDScanner.getDTDGrammar() : null;
        xCIScannerFragment.sStandalone = this.fDTDSupport.isStandalone();
        xCIScannerFragment.sVMContextFragment = (VMContext.VMContextFragment)super.saveFragment();
        return xCIScannerFragment;
    }

    @Override
    public boolean loadFragment(Object object2) {
        XCIScannerFragment xCIScannerFragment = (XCIScannerFragment)object2;
        if (this.fDTDGrammarSupport == null) {
            this.fDTDGrammarSupport = new XCIDTDGrammarSupport(this);
        }
        this.fDTDGrammarSupport.setDTDGrammar(xCIScannerFragment.sDTDGrammar, xCIScannerFragment.sStandalone);
        this.setDTDSupport(this.fDTDGrammarSupport);
        super.loadFragment(xCIScannerFragment.sVMContextFragment);
        return true;
    }

    public void loadFragment(XCIScannerFragment xCIScannerFragment, ParsedEntity parsedEntity) {
        xCIScannerFragment.sVMContextFragment.sDocumentScannerFragment.sFragmentEntity = parsedEntity;
        this.loadFragment(xCIScannerFragment);
    }

    @Override
    public boolean fastSerializationAllowed() {
        return this.fDTDSupport.entityDepth() <= 1;
    }

    @Override
    public int getLineNumber() {
        return this.fDocumentPosition.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.fDocumentPosition.columnNumber;
    }

    @Override
    public int getCharacterOffset() {
        return this.fDocumentPosition.byteOffset;
    }

    @Override
    public String getPublicId() {
        return this.sharedResources.getDocumentInfo().getPublicId();
    }

    @Override
    public String getSystemId() {
        return this.sharedResources.getDocumentInfo().getSystemId();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this;
    }

    @Override
    public TypeValidator getXLXPType(int n2) {
        if (n2 != -1) {
            return this.aDecls[n2].type;
        }
        return this.eType.dv;
    }

    @Override
    public TypeValidator validate(TypeValidator typeValidator, XMLString xMLString) {
        ValidatedInfo validatedInfo = new ValidatedInfo();
        typeValidator.validate(xMLString, null, this.dvContext, validatedInfo);
        if (validatedInfo.errorCode == 0) {
            typeValidator = validatedInfo.typeValidator;
        }
        return typeValidator;
    }

    @Override
    public String getNamespaceURI(String string2) {
        return this.prefixMapping(string2.intern());
    }

    @Override
    public String getPrefix(String string2) {
        return this.prefixForNamespaceURI(string2.intern());
    }

    public Iterator getPrefixes(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("namespaceURI is null!");
        }
        int n2 = this.totalMappingsCount();
        String[] stringArray = new String[n2];
        int n3 = this.prefixesForNamespaceURI(stringArray, string2.intern());
        return Arrays.asList(stringArray).subList(0, n3).iterator();
    }

    @Override
    public Iterator<String> getInScopeNamespaces() {
        int n2 = this.totalMappingsCount();
        String[] stringArray = new String[n2 * 2];
        int n3 = this.inScopeNamespaces(stringArray);
        return Arrays.asList(stringArray).subList(0, n3 * 2).iterator();
    }

    @Override
    public ExtendedNamespaceContext constantENS(boolean bl) {
        int n2 = this.totalMappingsCount();
        String[] stringArray = new String[n2 * 2];
        int n3 = this.inScopeNamespaces(stringArray);
        return new PersistedNamespaceContextAdapter(stringArray, n3);
    }

    public short getDocumentReferenceIndex() {
        return this.getDocumentResources().getDocumentReferenceIndex();
    }

    public void setDocumentReferenceIndex(short s) {
        this.getDocumentResources().setDocumentReferenceIndex(s);
    }

    @Override
    public void manualRelease() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "attemptToRecycle", "manually released a XCIScanner");
        }
        this.getDocumentResources().unregisterResource(this);
    }

    @Override
    public void recycle() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "recycle", "Recycling the following scanner: " + this.toString());
        }
        this.unregisterReferrer();
        this.release(true);
    }

    private void release(boolean bl) {
        this.reset(bl);
        this.setBufferFactory(null);
        this.setParsedEntityFactory(null);
        this.cdataFactory = null;
        this.sharedResources.getResourceManager().returnScanner(this);
        this.sharedResources = null;
    }

    @Override
    public final void reset(boolean bl) {
        super.reset(bl);
        this.fCurrentEvent = 0;
        if (this.fDTDScanner != null) {
            this.fDTDScanner.reset(bl);
        }
        this.fSymbolTable.reset(bl);
        this.fProcessingText = false;
    }

    @Override
    public void describe(StringBuilder stringBuilder) {
        stringBuilder.append(" id=[");
        stringBuilder.append(LoggerUtil.getUniqueString(this));
        stringBuilder.append(']');
    }

    @Override
    public XLXPResourceManager.DocumentResources getDocumentResources() {
        return this.sharedResources;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class PersistedNamespaceContextAdapter
    implements ExtendedNamespaceContext {
        final String[] mappings;
        final int mappingsCount;

        public PersistedNamespaceContextAdapter(String[] stringArray, int n2) {
            this.mappings = stringArray;
            this.mappingsCount = n2;
        }

        @Override
        public String getNamespaceURI(String string2) {
            string2 = string2.intern();
            for (int i = this.mappingsCount - 1; i >= 0; --i) {
                if (string2 != this.mappings[i * 2]) continue;
                return this.mappings[i * 2 + 1];
            }
            return null;
        }

        @Override
        public String getPrefix(String string2) {
            string2 = string2.intern();
            for (int i = this.mappingsCount - 1; i >= 0; --i) {
                if (string2 != this.mappings[i * 2 + 1]) continue;
                return this.mappings[i * 2];
            }
            return null;
        }

        public Iterator getPrefixes(String string2) {
            string2 = string2.intern();
            String[] stringArray = new String[this.mappingsCount];
            int n2 = 0;
            for (int i = this.mappingsCount - 1; i >= 0; --i) {
                if (string2 != this.mappings[i * 2 + 1]) continue;
                stringArray[n2] = this.mappings[i * 2];
                ++n2;
            }
            return Arrays.asList(stringArray).subList(0, n2).iterator();
        }

        @Override
        public Iterator<String> getInScopeNamespaces() {
            return Arrays.asList(this.mappings).subList(0, this.mappingsCount * 2).iterator();
        }

        @Override
        public ExtendedNamespaceContext constantENS(boolean bl) {
            return this;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class XCIScannerFragment {
        public VMContext.VMContextFragment sVMContextFragment;
        public DTDGrammar sDTDGrammar;
        public boolean sStandalone;

        public void reset() {
            this.sVMContextFragment.reset();
        }

        public String getElementName() {
            return this.sVMContextFragment.sDocumentScannerFragment.sElementQName.rawName;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class XCIScannerReferrer
    extends DataBufferReferrer {
        final DataBuffer firstBuffer;

        XCIScannerReferrer(DataBuffer dataBuffer) {
            this.firstBuffer = dataBuffer;
            dataBuffer.factory.addReferrer(this);
            this.active = true;
        }

        public boolean hasReferenceTo(DataBuffer dataBuffer) {
            if (this.firstBuffer == dataBuffer) {
                return true;
            }
            if (this.firstBuffer.next == null) {
                return false;
            }
            DataBuffer dataBuffer2 = this.firstBuffer.next;
            while (dataBuffer2 != dataBuffer) {
                if (dataBuffer2 == null) {
                    return false;
                }
                dataBuffer2 = dataBuffer2.next;
            }
            return true;
        }

        public void removeReferencesAndUnregister() {
            this.active = false;
            if (this.factory != null) {
                this.factory.removeReferrer(this);
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class XCIDTDGrammarSupport
    extends DTDSupport {
        private DTDGrammar fDTDGrammar;

        XCIDTDGrammarSupport(DocumentScanner documentScanner) {
            super(documentScanner);
        }

        void setDTDGrammar(DTDGrammar dTDGrammar, boolean bl) {
            this.fDTDGrammar = dTDGrammar;
            this.fStandalone = bl;
        }

        public void setDocumentEntity(ParsedEntity parsedEntity) {
        }

        public boolean hasElementContentElements() {
            return this.fDTDGrammar != null && this.fDTDGrammar.hasElementContentElements();
        }

        public boolean hasElementContent(String string2) {
            return this.fDTDGrammar != null && this.fDTDGrammar.hasElementContent(string2);
        }

        public boolean hasDefaultAttributes() {
            return this.fDTDGrammar != null && this.fDTDGrammar.hasAttDefs();
        }

        public boolean addDefaultAttributes(boolean bl) {
            if (this.fDTDGrammar == null || !this.fDTDGrammar.hasAttDefs()) {
                return true;
            }
            return this.fDTDGrammar.addDefaultAttributes(this.fScanner, bl, this.fStandalone);
        }

        public final boolean scanDoctypeDecl() {
            throw new IllegalStateException("scanDoctypeDecl");
        }

        public boolean scanInternalDTDSubset() {
            throw new IllegalStateException("scanInternalDTDSubset");
        }

        public boolean scanExternalDTDSubset() {
            throw new IllegalStateException("scanExternalDTDSubset");
        }

        public void setStandalone() {
            throw new IllegalStateException("setStandalone");
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class XCIDTDScanner
    extends DTDScanner {
        XCIDTDScanner(DocumentScanner documentScanner, SymbolTable symbolTable, ParsedEntityFactory parsedEntityFactory) {
            super(documentScanner, symbolTable, parsedEntityFactory);
        }

        EntityDeclPool.EntityDecl lookupEntity(XMLString xMLString) {
            return this.fEntityManager.lookupEntity(xMLString);
        }

        protected void unparsedEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, XMLString xMLString4) {
            EntityDeclPool.EntityDecl entityDecl = this.lookupEntity(xMLString);
            super.unparsedEntityDecl(xMLString, xMLString2, xMLString3, xMLString4);
            if (entityDecl == null) {
                ((XCIScanner)this.fScanner).addUnparsedEntity(xMLString.toString(), xMLString2 == null ? null : xMLString2.toString(), xMLString3.toString(), xMLString4.toString());
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private final class XCIDTDSupport
    extends DTDSupport {
        private ParsedEntity fDocumentEntity;

        XCIDTDSupport(XCIScanner xCIScanner2) {
            super(xCIScanner2);
        }

        public boolean scanDoctypeDecl() {
            XCIScanner.this.fDTDScanner = new XCIDTDScanner(this.fScanner, XCIScanner.this.fSymbolTable, XCIScanner.this.fDelegatingParsedEntityFactory);
            XCIScanner.this.setDTDSupport(XCIScanner.this.fDTDScanner);
            XCIScanner.this.fDTDScanner.setDocumentEntity(this.fDocumentEntity);
            if (this.fStandalone) {
                XCIScanner.this.fDTDScanner.setStandalone();
            }
            return XCIScanner.this.fDTDScanner.scanDoctypeDecl();
        }

        public void setDocumentEntity(ParsedEntity parsedEntity) {
            this.fDocumentEntity = parsedEntity;
            this.fStandalone = false;
        }
    }
}

