/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.scanner;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xlxp.internal.s1.api.util.ImmutableArrayList;
import com.ibm.xml.xlxp.internal.s1.api.util.URI;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.DOMErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XLXPDocumentInfo
extends DocumentInfo {
    private TypeRegistry fTypeRegistry;
    private DOMErrorHandler fDOMErrorHandler;
    private DocumentInfo.VersionInfo fVersionInfo;
    private String fEncoding;
    private String fURI;
    private String fPublicId;
    private String fSystemId;
    private boolean fURINeedsResolution;
    private UnparsedEntity fUnparsedEntity;
    private static final Logger logger = LoggerUtil.getLogger(XLXPDocumentInfo.class);

    public void initialize(TypeRegistry typeRegistry, DOMErrorHandler dOMErrorHandler) {
        this.fTypeRegistry = typeRegistry;
        this.fDOMErrorHandler = dOMErrorHandler;
        this.fVersionInfo = null;
        this.fEncoding = null;
        this.fURI = null;
        this.fURINeedsResolution = false;
        this.fUnparsedEntity = null;
    }

    public void setXMLVersion(boolean bl) {
        this.fVersionInfo = bl ? DocumentInfo.VersionInfo.ONEZERO : DocumentInfo.VersionInfo.ONEONE;
    }

    public void setXMLEncoding(String string2) {
        this.fEncoding = string2;
    }

    private void setURI(String string2) {
        this.fURI = string2;
        this.fURINeedsResolution = string2 != null;
    }

    public void addUnparsedEntity(String string2, String string3, String string4, String string5) {
        this.fUnparsedEntity = new UnparsedEntity(string2, string3, string4, string5, this.fUnparsedEntity);
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.fTypeRegistry;
    }

    @Override
    public DOMErrorHandler getErrorHandler() {
        return this.fDOMErrorHandler;
    }

    @Override
    public String getURI() {
        if (this.fURINeedsResolution) {
            this.fURI = XLXPDocumentInfo.resolveURI(this.fURI);
            this.fURINeedsResolution = false;
        }
        return this.fURI;
    }

    @Override
    public String getUnparsedEntityPublicId(String string2) {
        UnparsedEntity unparsedEntity = this.fUnparsedEntity;
        while (unparsedEntity != null) {
            if (unparsedEntity.entityName.equals(string2)) {
                return unparsedEntity.publicID;
            }
            unparsedEntity = unparsedEntity.next;
        }
        return null;
    }

    @Override
    public String getUnparsedEntitySystemId(String string2) {
        UnparsedEntity unparsedEntity = this.fUnparsedEntity;
        while (unparsedEntity != null) {
            if (unparsedEntity.entityName.equals(string2)) {
                return unparsedEntity.systemID;
            }
            unparsedEntity = unparsedEntity.next;
        }
        return null;
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        if (this.fUnparsedEntity != null) {
            return new Iterator<String>(){
                private UnparsedEntity currentEntity;
                {
                    this.currentEntity = XLXPDocumentInfo.this.fUnparsedEntity;
                }

                @Override
                public boolean hasNext() {
                    return this.currentEntity != null;
                }

                @Override
                public String next() {
                    if (this.currentEntity != null) {
                        String string2 = this.currentEntity.entityName;
                        this.currentEntity = this.currentEntity.next;
                        return string2;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        List list = ImmutableArrayList.emptyList();
        return list.iterator();
    }

    @Override
    public DocumentInfo.VersionInfo getXMLVersionInfo() {
        return this.fVersionInfo;
    }

    @Override
    public String getXMLEncoding() {
        return this.fEncoding;
    }

    private static String resolveURI(final String string2) {
        block4: {
            if (URI.isAbsolute(string2)) {
                return string2;
            }
            java.net.URI uRI = AccessController.doPrivileged(new PrivilegedAction<java.net.URI>(){

                @Override
                public java.net.URI run() {
                    try {
                        return new File("").toURI();
                    }
                    catch (SecurityException securityException) {
                        if (LoggerUtil.isFineLoggable(logger)) {
                            logger.logp(Level.FINE, logger.getName(), "resolveURI", "Exception resolving URI: " + string2, securityException);
                        }
                        return null;
                    }
                }
            });
            if (uRI != null) {
                try {
                    return uRI.resolve(string2).toString();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!LoggerUtil.isFineLoggable(logger)) break block4;
                    logger.logp(Level.FINE, logger.getName(), "resolveURI", "Exception resolving URI: " + string2, illegalArgumentException);
                }
            }
        }
        return string2;
    }

    void setPublicId(String string2) {
        this.fPublicId = string2;
    }

    String getPublicId() {
        return this.fPublicId;
    }

    void setSystemId(String string2) {
        this.fSystemId = string2;
        this.setURI(string2);
    }

    String getSystemId() {
        return this.fSystemId;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class UnparsedEntity {
        public final String entityName;
        public final String publicID;
        public final String systemID;
        public final String notationName;
        public final UnparsedEntity next;

        public UnparsedEntity(String string2, String string3, String string4, String string5, UnparsedEntity unparsedEntity) {
            this.entityName = string2;
            this.publicID = string3;
            this.systemID = string4;
            this.notationName = string5;
            this.next = unparsedEntity;
        }
    }
}

