/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.util;

import com.ibm.xml.xci.adapters.xlxp.scanner.XCIScanner;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Stack;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ScannerPool {
    private static final short DEFAULT_POOL_LIMIT = 10;
    private static final short POOL_LIMIT;
    private final Stack<XCIScanner> scannerStack = new Stack();

    public final synchronized XCIScanner getScanner() {
        if (!this.scannerStack.empty()) {
            return this.scannerStack.pop();
        }
        return null;
    }

    public synchronized void returnScanner(XCIScanner xCIScanner) {
        if (this.scannerStack.size() + 1 <= POOL_LIMIT) {
            this.scannerStack.push(xCIScanner);
        }
    }

    static {
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("com.ibm.xml.xci.adapters.xlxp.util.ScannerPool.poolLimit");
            }
        });
        POOL_LIMIT = string2 != null ? Short.parseShort(string2) : (short)10;
    }
}

