/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.util;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.adapters.xlxp.util.DocumentWeakReference;
import com.ibm.xml.xci.adapters.xlxp.util.XLXPResourceManager;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class WeakReferenceManager {
    private static final Logger logger = LoggerUtil.getLogger(WeakReferenceManager.class);
    private static final short DOCUMENT_ARRAY_SIZE_DEFAULT = 0;
    protected static final short DOCUMENT_ARRAY_SIZE;
    private final ReferenceQueue<Object> myQueue = new ReferenceQueue();
    private DocumentWeakReference[] documentReferenceArray = new DocumentWeakReference[DOCUMENT_ARRAY_SIZE];
    private short[] freeIndexArray = new short[DOCUMENT_ARRAY_SIZE];
    private short freeIndexPointer = (short)-1;
    private short documentCounter;

    protected WeakReferenceManager() {
        this.initArrays();
    }

    private void initArrays() {
        for (short s = (short)(DOCUMENT_ARRAY_SIZE - 1); s >= 0; s = (short)(s - 1)) {
            this.freeIndexArray[WeakReferenceManager.DOCUMENT_ARRAY_SIZE - 1 - s] = s;
            this.freeIndexPointer = (short)(this.freeIndexPointer + 1);
        }
    }

    public synchronized Object registerDocument(XLXPResourceManager.DocumentResources documentResources) {
        DocumentWeakReference documentWeakReference;
        if (this.documentCounter >= DOCUMENT_ARRAY_SIZE && !this.compareAndCleanup(documentResources)) {
            documentResources.setDocumentReferenceIndex((short)-1);
            return null;
        }
        short s = this.popFreeIndex();
        assert (s != -1) : "the compareAndCleanup should have ensured we have room for this document!";
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, logger.getName(), "registerDocument", "registering a new Document Reference into index:" + s);
        }
        Object object2 = new Object();
        this.documentReferenceArray[s] = documentWeakReference = new DocumentWeakReference(object2, documentResources, s, this.myQueue);
        this.documentCounter = (short)(this.documentCounter + 1);
        documentResources.setDocumentReferenceIndex(s);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder();
            this.dumpWeakReferenceArray(stringBuilder);
            logger.logp(Level.FINEST, logger.getName(), "registerDocument", "WeakReferenceManager Details: " + stringBuilder.toString());
        }
        return object2;
    }

    private boolean compareAndCleanup(XLXPResourceManager.DocumentResources documentResources) {
        if (this.checkQueue()) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "compareAndCleanup", "We were able to clear some room by recycling out-of-scope documents!");
            }
            return true;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "compareAndCleanup", "incoming new document wasn't able to evict any of the other documents being tracked");
        }
        return false;
    }

    public synchronized boolean checkQueue() {
        Reference<Object> reference = this.myQueue.poll();
        boolean bl = false;
        while (reference != null) {
            DocumentWeakReference documentWeakReference = (DocumentWeakReference)reference;
            if (!documentWeakReference.wasRecycled()) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, logger.getName(), "checkQueue", "Reclaiming resources for document index: " + documentWeakReference.getIndex());
                }
                documentWeakReference.recycleDocument();
                bl = true;
            }
            reference = this.myQueue.poll();
        }
        return bl;
    }

    public synchronized void unregisterDocument(short s) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, logger.getName(), "unregisterDocument", "unregistering document at index [" + s + "]");
        }
        this.documentReferenceArray[s].clearDocumentReference();
        this.pushFreeIndex(s);
    }

    private short popFreeIndex() {
        if (this.freeIndexPointer == -1) {
            return -1;
        }
        short s = this.freeIndexPointer;
        this.freeIndexPointer = (short)(s - 1);
        return this.freeIndexArray[s];
    }

    private void pushFreeIndex(short s) {
        this.documentCounter = (short)(this.documentCounter - 1);
        this.documentReferenceArray[s] = null;
        this.freeIndexPointer = (short)(this.freeIndexPointer + 1);
        this.freeIndexArray[this.freeIndexPointer] = s;
    }

    private void dumpWeakReferenceArray(StringBuilder stringBuilder) {
        for (int i = 0; i < DOCUMENT_ARRAY_SIZE; ++i) {
            stringBuilder.append('\n');
            stringBuilder.append("Document");
            stringBuilder.append('[');
            stringBuilder.append(i);
            stringBuilder.append(']');
            DocumentWeakReference documentWeakReference = this.documentReferenceArray[i];
            if (documentWeakReference != null) {
                assert (documentWeakReference.wasRecycled()) : "found an entry that was maually released but wasn't removed from the array!";
                documentWeakReference.describeDocument(stringBuilder);
                continue;
            }
            stringBuilder.append("null cell");
        }
    }

    static {
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("com.ibm.xml.xci.adapters.xlxp.util.WeakReferenceManager.documentLimit");
            }
        });
        DOCUMENT_ARRAY_SIZE = string2 != null ? Short.parseShort(string2) : (short)0;
    }
}

