/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.util;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.adapters.xlxp.msg.XLXPXCIAdapterMessageProvider;
import com.ibm.xml.xci.adapters.xlxp.scanner.Scanner;
import com.ibm.xml.xci.adapters.xlxp.scanner.XCIScanner;
import com.ibm.xml.xci.adapters.xlxp.util.ScannerPool;
import com.ibm.xml.xci.adapters.xlxp.util.WeakReferenceManager;
import com.ibm.xml.xci.adapters.xlxp.util.XLXPSharedResources;
import com.ibm.xml.xci.dp.util.RequestInfoUtil;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.spi.config.XMLAttachmentUnmarshaller;
import com.ibm.xml.xci.type.SchemaResolver;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xlxp.internal.s1.grammar.Grammar;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xml4j.api.s1.xs.XSModel;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import javax.xml.transform.Source;
import org.w3c.dom.DOMErrorHandler;
import org.xml.sax.InputSource;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XLXPResourceManager {
    private static final String NON_VALIDATING_MERGER_CONTEXT_KEY = "com.ibm.xml.xci.adapters.xlxp.util.XLXPResourceManager.MergerContext.NON_VALIDATING";
    private static final String VALIDATING_MERGER_CONTEXT_KEY = "com.ibm.xml.xci.adapters.xlxp.util.XLXPResourceManager.MergerContext.VALIDATING";
    private final ScannerPool scannerPool = new ScannerPool();
    private final WeakReferenceManager weakReferenceManager = WeakReferenceManager.DOCUMENT_ARRAY_SIZE <= 0 ? null : new WeakReferenceManager();
    public Stack<XLXPSharedResources> smallBufferSharedResources;
    public Stack<XLXPSharedResources> largeBufferSharedResources;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MergerContext getGrammars(SessionContext sessionContext, TypeRegistry typeRegistry, boolean bl) {
        if (typeRegistry == null) {
            return null;
        }
        TypeRegistry typeRegistry2 = typeRegistry;
        synchronized (typeRegistry2) {
            String string2 = bl ? VALIDATING_MERGER_CONTEXT_KEY : NON_VALIDATING_MERGER_CONTEXT_KEY;
            MergerContext mergerContext = (MergerContext)sessionContext.getUserData(string2);
            if (mergerContext == null) {
                mergerContext = new MergerContext(typeRegistry, bl);
                sessionContext.setUserData(string2, mergerContext);
            }
            mergerContext.convertGrammar();
            return mergerContext;
        }
    }

    public void returnScanner(XCIScanner xCIScanner) {
        this.scannerPool.returnScanner(xCIScanner);
    }

    public String debugScannerPool() {
        return this.scannerPool.toString();
    }

    public Scanner setupScanner(InputSource inputSource, RequestInfo requestInfo, DOMErrorHandler dOMErrorHandler, SessionContext sessionContext) throws IOException {
        TypeRegistry typeRegistry = sessionContext.getTypeRegistry();
        MergerContext mergerContext = this.getGrammars(sessionContext, typeRegistry, false);
        Boolean bl = (Boolean)RequestInfoUtil.getParameter(requestInfo, "http://www.ibm.com/xml/xci/instance/lax-assessment");
        if (bl == null) {
            bl = (Boolean)sessionContext.getOption("http://www.ibm.com/xml/xci/instance/lax-assessment");
        }
        boolean bl2 = bl != null && bl != false;
        Boolean bl3 = (Boolean)sessionContext.getOption("http://www.ibm.com/xml/xci/bo/bo-bc-mode");
        boolean bl4 = bl3 != null && bl3 != false;
        Boolean bl5 = (Boolean)RequestInfoUtil.getParameter(requestInfo, "http://www.ibm.com/xml/xci/schema/disallow-unknown-items");
        boolean bl6 = bl4 && bl5 != null && bl5 != false;
        boolean bl7 = RequestInfoUtil.hasHint(requestInfo, "ENCODING_DECL");
        boolean bl8 = RequestInfoUtil.hasHint(requestInfo, "EAGER_BUFFER_LOAD");
        boolean bl9 = RequestInfoUtil.hasHint(requestInfo, "LARGE DOC");
        int n2 = 1 | (bl2 ? 64 : 0) | (bl4 ? 128 : 0) | (bl6 ? 256 : 0) | 0x20 | 8;
        XMLAttachmentUnmarshaller xMLAttachmentUnmarshaller = (XMLAttachmentUnmarshaller)RequestInfoUtil.getParameter(requestInfo, "http://www.ibm.com/xml/xci/attachment-unmarshaller");
        XCIScanner xCIScanner = this.getScanner(n2, null, bl9, xMLAttachmentUnmarshaller);
        if (mergerContext != null) {
            xCIScanner.setGrammar(mergerContext.getGrammar());
            mergerContext.setDynamicSchemaResolverOnScanner(xCIScanner.getSchemaProcessor());
        } else {
            xCIScanner.setGrammar(null);
        }
        xCIScanner.setupDocument(inputSource, typeRegistry, dOMErrorHandler, bl7);
        if (bl8) {
            xCIScanner.loadRemainingBuffers(null);
        }
        return xCIScanner;
    }

    public XCIScanner getScanner(int n2, XLXPSharedResources xLXPSharedResources, boolean bl, XMLAttachmentUnmarshaller xMLAttachmentUnmarshaller) {
        XCIScanner xCIScanner;
        if (xLXPSharedResources == null) {
            xLXPSharedResources = this.fetchSharedResources(bl);
            assert (!xLXPSharedResources.isDocumentReferenced());
        }
        if (this.weakReferenceManager != null) {
            this.weakReferenceManager.checkQueue();
        }
        if ((xCIScanner = this.scannerPool.getScanner()) == null || xCIScanner.features() != n2) {
            xCIScanner = new XCIScanner(xLXPSharedResources, n2);
        } else {
            xCIScanner.setSharedResources(xLXPSharedResources);
        }
        xCIScanner.setAttachmentUnmarshaller(xMLAttachmentUnmarshaller);
        return xCIScanner;
    }

    public synchronized XLXPSharedResources fetchSharedResources(boolean bl) {
        Stack<XLXPSharedResources> stack;
        Stack<XLXPSharedResources> stack2 = stack = bl ? this.largeBufferSharedResources : this.smallBufferSharedResources;
        if (stack == null || stack.isEmpty()) {
            return new XLXPSharedResources(this, bl);
        }
        XLXPSharedResources xLXPSharedResources = stack.pop();
        xLXPSharedResources.getBufferFactory().reset(true);
        return xLXPSharedResources;
    }

    public synchronized void returnSharedResources(XLXPSharedResources xLXPSharedResources) {
        if (xLXPSharedResources.supportsLargeDocuments()) {
            if (this.largeBufferSharedResources == null) {
                this.largeBufferSharedResources = new Stack();
            }
            this.largeBufferSharedResources.push(xLXPSharedResources);
        } else {
            if (this.smallBufferSharedResources == null) {
                this.smallBufferSharedResources = new Stack();
            }
            this.smallBufferSharedResources.push(xLXPSharedResources);
        }
    }

    public void unregisterDocument(short s) {
        if (this.weakReferenceManager != null && s != -1) {
            this.weakReferenceManager.unregisterDocument(s);
        }
    }

    public void registerChild(Referent referent, Object object2) {
        if (this.weakReferenceManager != null) {
            referent.setSharedDocumentObject(object2);
        }
        Resource resource = referent.getResource();
        resource.getDocumentResources().registerResource(resource);
    }

    public void registerDocument(Referent referent) {
        Object object2 = null;
        if (this.weakReferenceManager != null) {
            object2 = this.weakReferenceManager.registerDocument(referent.getResource().getDocumentResources());
        }
        this.registerChild(referent, object2);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static interface Referent {
        public Resource getResource();

        public void setSharedDocumentObject(Object var1);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static interface Resource {
        public void describe(StringBuilder var1);

        public void recycle();

        public DocumentResources getDocumentResources();
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static interface DocumentResources {
        public void recycleDocument();

        public void setDocumentReferenceIndex(short var1);

        public short getDocumentReferenceIndex();

        public void registerResource(Resource var1);

        public void unregisterResource(Resource var1);

        public void describeDocument(StringBuilder var1);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class MergerContext
    extends com.ibm.xml.xlxp.internal.s1.converter.MergerContext {
        private final TypeRegistry tr;

        public MergerContext(TypeRegistry typeRegistry, boolean bl) {
            super(bl);
            this.tr = typeRegistry;
        }

        public void setGrammarVersionOnScanner(VMContext vMContext, int n2) {
            vMContext.setGrammarVersion(n2);
        }

        public int getGrammarVersionFromScanner(VMContext vMContext) {
            return vMContext.getGrammarVersion();
        }

        public void setDynamicSchemaResolverOnScanner(VMContext vMContext) {
            vMContext.setDynamicSchemaResolver(this.merger);
        }

        public Grammar getGrammar() {
            return this.grammar;
        }

        public XSModel getXSModel() {
            if (this.tr == null) {
                XCIIllegalArgumentException xCIIllegalArgumentException = new XCIIllegalArgumentException(XLXPXCIAdapterMessageProvider.createMessage(null, 3));
                FFDCUtil.log(xCIIllegalArgumentException, this);
                throw xCIIllegalArgumentException;
            }
            return this.tr.getXSModel();
        }

        private boolean dynamicallyLoadSchemas(String string2, String string3, short s, TypeRegistry typeRegistry) {
            SchemaResolver schemaResolver = typeRegistry.getSchemaResolver();
            if (schemaResolver == null) {
                return false;
            }
            SchemaResolver.SchemaComponentType schemaComponentType = null;
            switch (s) {
                case 2: {
                    schemaComponentType = SchemaResolver.SchemaComponentType.ELEMENT;
                    break;
                }
                case 1: {
                    schemaComponentType = SchemaResolver.SchemaComponentType.ATTRIBUTE;
                    break;
                }
                case 3: {
                    schemaComponentType = SchemaResolver.SchemaComponentType.TYPE;
                }
            }
            List list = Collections.EMPTY_LIST;
            List<? extends Source> list2 = schemaResolver.resolve(TypeRegistry.createSchemaIdentifier(string2, string3, schemaComponentType, list, null));
            if (list2 == null || list2.size() == 0) {
                return false;
            }
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder("*** Returning schema documents from SchemaResolver. ***\n");
                for (Source source : list2) {
                    stringBuilder.append(source.getSystemId());
                    stringBuilder.append('\n');
                }
                logger.logp(Level.FINEST, logger.getName(), "dynamicallyLoadSchemas", stringBuilder.toString());
            }
            typeRegistry.load(list2);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleUnknownComponent(VMContext vMContext, String string2, String string3, short s) {
            if (this.tr == null) {
                return false;
            }
            TypeRegistry typeRegistry = this.tr;
            synchronized (typeRegistry) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, this.getClass().getName(), "handleUnknownComponent", "received lock");
                }
                if (this.knownComponent(string2, string3, s)) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, this.getClass().getName(), "handleUnknownComponent", "component is already known. returning true.");
                    }
                    return true;
                }
                if (!this.dynamicallyLoadSchemas(string2, string3, s, this.tr)) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, this.getClass().getName(), "handleUnknownComponent", "failed dynamicallyLoadSchemas. returning false.");
                    }
                    return false;
                }
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, this.getClass().getName(), "handleUnknownComponent", "mergeGrammar about to be called");
                }
                boolean bl = this.mergeGrammar(vMContext);
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, this.getClass().getName(), "handleUnknownComponent", "returning " + bl);
                }
                return bl;
            }
        }

        private final boolean knownComponent(String string2, String string3, int n2) {
            String string4 = string2 != "" ? string2 : null;
            switch (n2) {
                case 2: {
                    return this.grammar.xsModel.getElementDeclaration(string3, string4) != null;
                }
                case 1: {
                    return this.grammar.xsModel.getAttributeDeclaration(string3, string4) != null;
                }
                case 3: {
                    return this.grammar.xsModel.getTypeDefinition(string3, string4) != null;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilUpdateComplete() {
            if (this.tr != null) {
                TypeRegistry typeRegistry = this.tr;
                synchronized (typeRegistry) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, this.getClass().getName(), "waitUntilUpdateComplete", "waiting for update completion");
                    }
                }
            }
        }
    }
}

