/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.util;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.adapters.xlxp.scanner.XLXPDocumentInfo;
import com.ibm.xml.xci.adapters.xlxp.util.XLXPResourceManager;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.EmptyCData;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.BaseCDataWithChars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.values.MTOMCData;
import com.ibm.xml.xci.internal.values.QNameCData;
import com.ibm.xml.xci.internal.values.StoredCharsCData;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.spi.config.XMLAttachmentUnmarshaller;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xlxp.internal.s1.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.SimpleDataBufferFactory;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XLXPSharedResources
implements XLXPResourceManager.DocumentResources {
    private static final Logger logger = LoggerUtil.getLogger(XLXPSharedResources.class);
    private static final int DEFAULT_SMALL_BUFFER_SIZE = 8192;
    private static final int DEFAULT_LARGE_BUFFER_SIZE = 65536;
    private static final int BUFFER_RECLAIM_LIMIT = Integer.MAX_VALUE;
    private static final int SMALL_BUFFER_SIZE = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            try {
                return Integer.getInteger("com.ibm.xml.xci.adapters.xlxp.util.XLXPSharedResources.smallBufferSize", 8192);
            }
            catch (SecurityException securityException) {
                return 8192;
            }
        }
    });
    private static final int LARGE_BUFFER_SIZE = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            try {
                return Integer.getInteger("com.ibm.xml.xci.adapters.xlxp.util.XLXPSharedResources.largeBufferSize", 65536);
            }
            catch (SecurityException securityException) {
                return 65536;
            }
        }
    });
    private final XLXPResourceManager resourceManager;
    private final DataBufferFactory bufferFactory;
    private final SAX2ParsedEntityFactory entityFactory;
    private XLXPDocumentInfo documentInfo;
    private short referenceCount;
    private short weakReferenceIndex;
    private final boolean largeDocumentSupport;
    private ArrayList<XLXPResourceManager.Resource> resources;

    public XLXPSharedResources(XLXPResourceManager xLXPResourceManager, boolean bl) {
        this.resourceManager = xLXPResourceManager;
        this.bufferFactory = new SimpleDataBufferFactory();
        this.bufferFactory.setReclaimLimit(Integer.MAX_VALUE);
        this.entityFactory = new SAX2ParsedEntityFactory(this.bufferFactory);
        this.largeDocumentSupport = bl;
        this.referenceCount = 0;
        this.weakReferenceIndex = (short)-1;
        this.setBufferLength();
    }

    private void setBufferLength() {
        this.entityFactory.setBufferLength(this.largeDocumentSupport ? LARGE_BUFFER_SIZE : SMALL_BUFFER_SIZE);
    }

    public DataBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public SAX2ParsedEntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public XLXPResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public boolean supportsLargeDocuments() {
        return this.largeDocumentSupport;
    }

    public boolean isDocumentReferenced() {
        return this.referenceCount > 0;
    }

    private void decreaseDocReferenceCount() {
        this.referenceCount = (short)(this.referenceCount - 1);
        if (this.referenceCount < 0) {
            XCIDynamicErrorException xCIDynamicErrorException = XCIErrorHelper.createInternalException("Sahred Resource's references are below zero, check internals.");
            FFDCUtil.log(xCIDynamicErrorException, this);
            throw xCIDynamicErrorException;
        }
    }

    private boolean canRecycleDocument() {
        return this.referenceCount == 0;
    }

    private void increaseDocReferenceCount() {
        this.referenceCount = (short)(this.referenceCount + 1);
    }

    protected void reset() {
        this.getBufferFactory().unregisterReferrers();
        this.referenceCount = 0;
        this.weakReferenceIndex = (short)-1;
        this.documentInfo = null;
        if (this.resources != null) {
            this.resources.clear();
        }
    }

    public XLXPDocumentInfo getDocumentInfo() {
        if (this.documentInfo == null) {
            this.documentInfo = new XLXPDocumentInfo();
        }
        return this.documentInfo;
    }

    public void release() {
        this.reset();
        this.resourceManager.returnSharedResources(this);
    }

    public short getDocumentReferenceIndex() {
        return this.weakReferenceIndex;
    }

    public void setDocumentReferenceIndex(short s) {
        this.weakReferenceIndex = s;
    }

    public VolatileCData createQNameCData(String string2) {
        if (string2 == null) {
            return new EmptyCData(TypeRegistry.XSQNAME);
        }
        return new QNameCData(new QName(string2), TypeRegistry.XSQNAME);
    }

    public VolatileCData createCDataFromType(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        if (TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSSTRING)) {
            return new StringCData(string2, xSSimpleTypeDefinition);
        }
        if (xSSimpleTypeDefinition.getBuiltInKind() == 50) {
            return new StoredCharsCData(CharsBase.toChars(string2), xSSimpleTypeDefinition);
        }
        return new BaseCDataWithChars(xSSimpleTypeDefinition, CharsBase.toChars(string2).constant(true));
    }

    public VolatileCData createMTOMCData(XMLAttachmentUnmarshaller xMLAttachmentUnmarshaller, String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return new MTOMCData(xMLAttachmentUnmarshaller, string2, xSSimpleTypeDefinition);
    }

    public void registerResource(XLXPResourceManager.Resource resource) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        this.resources.add(resource);
        this.increaseDocReferenceCount();
    }

    public void unregisterResource(XLXPResourceManager.Resource resource) {
        this.decreaseDocReferenceCount();
        if (this.canRecycleDocument()) {
            this.recycleDocument();
        } else if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "unregisterResource", "The # of reference remaining is: " + this.referenceCount);
        }
    }

    public void recycleDocument() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "recycleDocument", "Going to recycle the document!");
        }
        if (this.resources != null) {
            for (int i = 0; i < this.resources.size(); ++i) {
                this.resources.get(i).recycle();
            }
        }
        this.resourceManager.unregisterDocument(this.getDocumentReferenceIndex());
        this.release();
    }

    public void describeDocument(StringBuilder stringBuilder) {
        stringBuilder.append("Active # of references to this document= ");
        stringBuilder.append(this.referenceCount);
        if (this.resources != null) {
            for (int i = 0; i < this.resources.size(); ++i) {
                stringBuilder.append('\n');
                stringBuilder.append("   Resource[");
                stringBuilder.append(i);
                stringBuilder.append("]=");
                this.resources.get(i).describe(stringBuilder);
            }
        }
    }
}

