/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.bytes;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.NoBytes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

class ByteArraySubBytes
implements Bytes {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final byte[] subBytes;
    private final int subStart;
    private final int subEnd;

    public ByteArraySubBytes(byte[] byArray, int n2, int n3) {
        this.subBytes = byArray;
        int n4 = byArray.length;
        if (n2 <= n3 && 0 <= n2 && n3 <= n4) {
            this.subStart = n2;
            this.subEnd = n3;
        } else {
            int n5 = n2 < 0 ? 0 : (this.subStart = n2 > n4 ? n4 : n2);
            this.subEnd = n3 < this.subStart ? this.subStart : (n3 > n4 ? n4 : n3);
        }
    }

    public boolean hasByteAt(long l) {
        return 0L <= l + (long)this.subStart && l + (long)this.subStart < (long)this.subEnd;
    }

    public byte byteAt(long l) {
        return this.subBytes[(int)l + this.subStart];
    }

    public long byteLength() {
        return this.subEnd - this.subStart;
    }

    public void discardBytesUpto(long l) {
    }

    public Bytes byteSubSequence(long l, long l2) {
        int n2 = this.subBytes.length;
        if (l >= l2 || (long)this.subStart + l >= (long)n2) {
            return NoBytes.INSTANCE;
        }
        if ((long)this.subStart + l2 > (long)n2) {
            l2 = this.subBytes.length - this.subStart;
        }
        return new ByteArraySubBytes(this.subBytes, (int)((long)this.subStart + l), (int)((long)this.subStart + l2));
    }

    public boolean equals(Object object2) {
        if (object2 instanceof ByteArraySubBytes) {
            ByteArraySubBytes byteArraySubBytes = (ByteArraySubBytes)object2;
            int n2 = (int)this.byteLength();
            int n3 = (int)byteArraySubBytes.byteLength();
            byte[] byArray = new byte[n2];
            byte[] byArray2 = new byte[n3];
            this.writeBytesTo(this.subStart, byArray, 0, false);
            byteArraySubBytes.writeBytesTo(byteArraySubBytes.subStart, byArray2, 0, false);
            return Arrays.equals(byArray, byArray2);
        }
        if (object2 instanceof Bytes) {
            return Arrays.equals(this.toByteArray(false), ((Bytes)object2).toByteArray(false));
        }
        return false;
    }

    public Bytes byteSubSequence(long l) {
        return this.byteSubSequence(l, this.subEnd - this.subStart);
    }

    public void writeBytesTo(OutputStream outputStream, boolean bl) throws IOException {
        outputStream.write(this.subBytes, this.subStart, this.subEnd - this.subStart);
    }

    public int writeBytesTo(int n2, byte[] byArray, int n3, boolean bl) {
        int n4 = Math.min(this.subEnd - this.subStart - n2, byArray.length - n3);
        System.arraycopy(this.subBytes, this.subStart + n2, byArray, n3, n4);
        return n4;
    }

    public void writeBytesTo(ByteBuffer byteBuffer, boolean bl) {
        byteBuffer.put(this.subBytes, this.subStart, this.subEnd - this.subStart);
    }

    public InputStream toInputStream(boolean bl) {
        return new ByteArrayInputStream(this.subBytes, this.subStart, this.subEnd - this.subStart);
    }

    public byte[] toByteArray(boolean bl) {
        int n2 = this.subEnd - this.subStart;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.subBytes, this.subStart, byArray, 0, n2);
        return byArray;
    }

    public ByteBuffer toByteBuffer(boolean bl) {
        return ByteBuffer.wrap(this.subBytes, this.subStart, this.subEnd - this.subStart);
    }
}

