/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.bytes;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.NoBytes;
import com.ibm.xml.xci.res.XCIMessages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

final class ByteBufferBytes
implements Bytes {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private ByteBuffer buffer;
    private long discarded;
    private final int bufferLength;

    ByteBufferBytes(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.slice();
        this.bufferLength = byteBuffer.remaining();
    }

    ByteBufferBytes(ByteBuffer byteBuffer, long l, long l2) {
        if (l < 0L || l > l2 || l2 > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        byteBuffer.position((int)l);
        byteBuffer.limit((int)l2);
        this.buffer = byteBuffer.slice();
        this.bufferLength = this.buffer.remaining();
        byteBuffer.position(n2);
        byteBuffer.limit(n3);
    }

    public boolean hasByteAt(long l) {
        return 0L <= l && l < (long)this.bufferLength;
    }

    public byte byteAt(long l) {
        if (!this.hasByteAt(l) || l < this.discarded) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer.get((int)l);
    }

    public long byteLength() {
        return this.bufferLength;
    }

    public void discardBytesUpto(long l) {
        if (l > this.discarded) {
            this.discarded = l;
        }
        if (l >= (long)this.bufferLength) {
            this.buffer = null;
        }
    }

    public Bytes byteSubSequence(long l, long l2) {
        if (l < 0L || l2 > (long)this.bufferLength || l > l2 || l < this.discarded) {
            throw new IndexOutOfBoundsException();
        }
        if (l == l2) {
            return NoBytes.INSTANCE;
        }
        return new ByteBufferBytes(this.buffer, l, l2);
    }

    public Bytes byteSubSequence(long l) {
        if (l >= (long)this.bufferLength) {
            return NoBytes.INSTANCE;
        }
        return this.byteSubSequence(l, this.bufferLength);
    }

    public void writeBytesTo(OutputStream outputStream, boolean bl) throws IOException {
        if (this.discarded > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_WRITE_BYTES", null));
        }
        if (this.bufferLength > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_TOO_LONG_BUFFER", null));
        }
        if (this.buffer.hasArray()) {
            try {
                byte[] byArray = this.buffer.array();
                outputStream.write(byArray, this.buffer.arrayOffset(), this.bufferLength);
                if (bl) {
                    this.buffer = null;
                }
                return;
            }
            catch (ReadOnlyBufferException readOnlyBufferException) {
                // empty catch block
            }
        }
        for (long i = 0L; i < (long)this.bufferLength; ++i) {
            outputStream.write(this.buffer.get((int)i));
        }
        if (bl) {
            this.buffer = null;
        }
    }

    public int writeBytesTo(int n2, byte[] byArray, int n3, boolean bl) {
        if (this.discarded > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_WRITE_BYTES", null));
        }
        if (this.bufferLength > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_TOO_LONG_BUFFER", null));
        }
        this.buffer.position(n2);
        int n4 = Math.min(this.bufferLength - n2, byArray.length - n3);
        this.buffer.get(byArray, n3, n4);
        if (bl) {
            this.buffer = null;
        }
        return n4;
    }

    public void writeBytesTo(ByteBuffer byteBuffer, boolean bl) {
        if (this.discarded > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_WRITE_BYTES", null));
        }
        this.buffer.position(0);
        byteBuffer.put(this.buffer);
        if (bl) {
            this.buffer = null;
        }
    }

    public InputStream toInputStream(boolean bl) {
        if (this.discarded > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_REREAD_BYTES", null));
        }
        if (this.bufferLength > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_TOO_LONG_BUFFER", null));
        }
        if (this.buffer.hasArray()) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buffer.array(), this.buffer.arrayOffset(), this.bufferLength);
                if (bl) {
                    this.buffer = null;
                }
                return byteArrayInputStream;
            }
            catch (ReadOnlyBufferException readOnlyBufferException) {
                // empty catch block
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.bufferLength);
        try {
            this.writeBytesTo(byteArrayOutputStream, bl);
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            this.buffer = null;
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public byte[] toByteArray(boolean bl) {
        Object object2;
        if (this.discarded > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_REREAD_BYTES", null));
        }
        if (this.bufferLength > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_TOO_LONG_BUFFER", null));
        }
        if (this.buffer.hasArray() && this.buffer.arrayOffset() == 0) {
            try {
                object2 = this.buffer.array();
                if (((Object)object2).length == this.bufferLength) {
                    if (bl) {
                        this.buffer = null;
                    }
                    return object2;
                }
            }
            catch (ReadOnlyBufferException readOnlyBufferException) {
                // empty catch block
            }
        }
        object2 = new ByteArrayOutputStream(this.bufferLength);
        try {
            this.writeBytesTo((OutputStream)object2, bl);
            ((ByteArrayOutputStream)object2).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            this.buffer = null;
        }
        return ((ByteArrayOutputStream)object2).toByteArray();
    }

    public ByteBuffer toByteBuffer(boolean bl) {
        if (this.discarded > 0L) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_CANNOT_EXTRACT_BYTES", null));
        }
        if (bl) {
            ByteBuffer byteBuffer = this.buffer;
            this.buffer = null;
            return byteBuffer;
        }
        return this.buffer.duplicate();
    }

    public boolean equals(Object object2) {
        if (object2 instanceof ByteBufferBytes) {
            return ((ByteBufferBytes)object2).buffer.equals(this.buffer);
        }
        if (object2 instanceof Bytes) {
            Bytes bytes2 = (Bytes)object2;
            if ((long)this.bufferLength != bytes2.byteLength()) {
                return false;
            }
            for (long i = 0L; i < (long)this.bufferLength; ++i) {
                if (this.byteAt(i) == bytes2.byteAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }
}

