/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.bytes;

import com.ibm.xml.xci.bytes.ByteArrayBytes;
import com.ibm.xml.xci.bytes.ByteArraySubBytes;
import com.ibm.xml.xci.bytes.ByteBufferBytes;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.InputStreamBytes;
import com.ibm.xml.xci.bytes.NoBytes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class BytesUtils {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static Bytes make(byte[] byArray) {
        if (byArray.length == 0) {
            return NoBytes.INSTANCE;
        }
        return new ByteArrayBytes(byArray);
    }

    public static Bytes make(byte[] byArray, long l, long l2) {
        if (byArray.length == 0 || l >= l2) {
            return NoBytes.INSTANCE;
        }
        return new ByteArraySubBytes(byArray, (int)l, (int)l2);
    }

    public static Bytes make(ByteBuffer byteBuffer) {
        return new ByteBufferBytes(byteBuffer);
    }

    public static Bytes make(ByteBuffer byteBuffer, long l, long l2) {
        return new ByteBufferBytes(byteBuffer, l, l2);
    }

    public static Bytes make(InputStream inputStream) {
        return new InputStreamBytes(inputStream);
    }

    public static Bytes make(final File file) throws IOException {
        RandomAccessFile randomAccessFile = AccessController.doPrivileged(new PrivilegedAction<RandomAccessFile>(){

            @Override
            public RandomAccessFile run() {
                try {
                    return new RandomAccessFile(file, "r");
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        return new ByteBufferBytes(randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length()));
    }

    public static Bytes make(final File file, long l, long l2) throws IOException {
        RandomAccessFile randomAccessFile = AccessController.doPrivileged(new PrivilegedAction<RandomAccessFile>(){

            @Override
            public RandomAccessFile run() {
                try {
                    return new RandomAccessFile(file, "r");
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        if (l < 0L || l > l2 || l2 > randomAccessFile.length()) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteBufferBytes(randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, l, l2 - l));
    }
}

