/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheCursorFactory;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedComment;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedPI;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedText;
import com.ibm.xml.xci.dp.cache.dom.DummyCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.ds.DSStreamingCursorMediator;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.mediator.Mediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediatorStripSpace;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.RequestInfoUtil;
import com.ibm.xml.xci.wrappers.StripWhitespaceFilter;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheFactory {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = LoggerUtil.getLogger(CacheFactory.class);

    public static Cursor make(Cursor cursor2, RequestInfo requestInfo) {
        Map<String, Object> map2;
        boolean bl = Cursor.Profile.ALWAYS_VALID.containedIn(cursor2.profile()) ? MiscHelpers.isSchemaSpecialization(requestInfo.getParameters()) : false;
        if (requestInfo.getParameters() != null) {
            requestInfo.getParameters().put("schema-specialized", bl);
        }
        StreamingCursorMediator streamingCursorMediator = bl ? new DSStreamingCursorMediator(cursor2, requestInfo.getNeededFeatures()) : ((map2 = requestInfo.getParameters()) != null && (map2.get("http://www.ibm.com/xmlns/prod/xcij/strip-space") != null || map2.get("http://www.ibm.com/xmlns/prod/xcij/preserve-space") != null) ? new StreamingCursorMediatorStripSpace(cursor2, requestInfo.getNeededFeatures(), (StripWhitespaceFilter.PrioritizedNameTestList)map2.get("http://www.ibm.com/xmlns/prod/xcij/strip-space"), (StripWhitespaceFilter.PrioritizedNameTestList)map2.get("http://www.ibm.com/xmlns/prod/xcij/preserve-space")) : new StreamingCursorMediator(cursor2, requestInfo.getNeededFeatures()));
        return CacheFactory.make(streamingCursorMediator, requestInfo);
    }

    public static Cursor makeDummyCache(Mediator mediator) {
        return new DummyCacheCursor(mediator.factory(), mediator);
    }

    public static Cursor make(Mediator mediator, RequestInfo requestInfo) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "make", "Given mediator and requestInfo. Mediator =" + mediator);
        }
        CursorFactory cursorFactory = mediator.factory();
        mediator.setFactory(new CacheCursorFactory(cursorFactory));
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "make", "Given mediator and requestInfo. Factory that will be delegated to=" + cursorFactory);
        }
        CacheFactory.processLoadingParams(requestInfo);
        return CacheFactory.make(new CacheManager(mediator, null, requestInfo.getParameters()), requestInfo.getNeededFeatures());
    }

    public static Cursor make(CursorFactory cursorFactory, RequestInfo requestInfo) {
        CacheFactory.processLoadingParams(requestInfo);
        return CacheFactory.make(new CacheManager(cursorFactory, requestInfo.getParameters()), requestInfo.getNeededFeatures());
    }

    public static Cursor make(CacheManager cacheManager, Cursor.Profile profile) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, logger.getName(), "make", "Loading the first top item");
        }
        return cacheManager.loadCachedFirstTopItem(null, null).fork(false, profile, profile);
    }

    public static Cursor makeComment(CursorFactory cursorFactory, VolatileCData volatileCData, RequestInfo requestInfo) {
        CacheManager cacheManager = new CacheManager(cursorFactory, requestInfo.getParameters());
        return CacheFactory.makeComment(cacheManager, volatileCData, requestInfo);
    }

    public static Cursor makeComment(CacheManager cacheManager, VolatileCData volatileCData, RequestInfo requestInfo) {
        DOMCachedComment dOMCachedComment = cacheManager.makeCachedComment(volatileCData, null, null);
        cacheManager.setRootNode(dOMCachedComment);
        return dOMCachedComment.fork(false, requestInfo.getNeededFeatures(), requestInfo.getNeededFeatures());
    }

    public static Cursor makeElement(CursorFactory cursorFactory, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition, RequestInfo requestInfo) {
        CacheManager cacheManager = new CacheManager(cursorFactory, requestInfo.getParameters());
        return CacheFactory.makeElement(cacheManager, volatileCData, xSTypeDefinition, requestInfo);
    }

    public static Cursor makeElement(CacheManager cacheManager, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition, RequestInfo requestInfo) {
        DOMCachedElement dOMCachedElement = cacheManager.makeCachedElement(volatileCData, xSTypeDefinition, null, null, false, null, null);
        cacheManager.setRootNode(dOMCachedElement);
        return dOMCachedElement.fork(false, requestInfo.getNeededFeatures(), requestInfo.getNeededFeatures());
    }

    public static Cursor makeAttribute(CursorFactory cursorFactory, VolatileCData volatileCData, VolatileCData volatileCData2, RequestInfo requestInfo) {
        CacheManager cacheManager = new CacheManager(cursorFactory, requestInfo.getParameters());
        return CacheFactory.makeAttribute(cacheManager, volatileCData, volatileCData2, requestInfo);
    }

    public static Cursor makeAttribute(CacheManager cacheManager, VolatileCData volatileCData, VolatileCData volatileCData2, RequestInfo requestInfo) {
        DOMCachedAttribute dOMCachedAttribute = cacheManager.makeCachedAttribute(volatileCData, volatileCData2, null, null, null);
        cacheManager.setRootNode(dOMCachedAttribute);
        return dOMCachedAttribute.fork(false, requestInfo.getNeededFeatures(), requestInfo.getNeededFeatures());
    }

    public static Cursor makeNamespace(CursorFactory cursorFactory, VolatileCData volatileCData, VolatileCData volatileCData2, RequestInfo requestInfo) {
        CacheManager cacheManager = new CacheManager(cursorFactory, requestInfo.getParameters());
        return CacheFactory.makeNamespace(cacheManager, volatileCData, volatileCData2, requestInfo);
    }

    public static Cursor makeNamespace(CacheManager cacheManager, VolatileCData volatileCData, VolatileCData volatileCData2, RequestInfo requestInfo) {
        DOMCachedNamespace dOMCachedNamespace = cacheManager.makeCachedNamespaceNode(volatileCData, volatileCData2, null);
        cacheManager.setRootNode(dOMCachedNamespace);
        return dOMCachedNamespace.fork(false, requestInfo.getNeededFeatures(), requestInfo.getNeededFeatures());
    }

    public static Cursor makeProcessingInstruction(CursorFactory cursorFactory, VolatileCData volatileCData, VolatileCData volatileCData2, RequestInfo requestInfo) {
        CacheManager cacheManager = new CacheManager(cursorFactory, requestInfo.getParameters());
        return CacheFactory.makeProcessingInstruction(cacheManager, volatileCData, volatileCData2, requestInfo);
    }

    public static Cursor makeProcessingInstruction(CacheManager cacheManager, VolatileCData volatileCData, VolatileCData volatileCData2, RequestInfo requestInfo) {
        DOMCachedPI dOMCachedPI = cacheManager.makeCachedPI(volatileCData, volatileCData2, null, null);
        cacheManager.setRootNode(dOMCachedPI);
        return dOMCachedPI.fork(false, requestInfo.getNeededFeatures(), requestInfo.getNeededFeatures());
    }

    public static Cursor makeText(CursorFactory cursorFactory, VolatileCData volatileCData, RequestInfo requestInfo) {
        CacheManager cacheManager = new CacheManager(cursorFactory, requestInfo.getParameters());
        return CacheFactory.makeText(cacheManager, volatileCData, requestInfo);
    }

    public static Cursor makeText(CacheManager cacheManager, VolatileCData volatileCData, RequestInfo requestInfo) {
        DOMCachedText dOMCachedText = cacheManager.makeCachedText(volatileCData, false, false, null, null);
        cacheManager.setRootNode(dOMCachedText);
        return dOMCachedText.fork(false, requestInfo.getNeededFeatures(), requestInfo.getNeededFeatures());
    }

    public static void processLoadingParams(RequestInfo requestInfo) {
        Map<String, Object> map2;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "processLoadingParams", "Hints=" + requestInfo.getHints() + " | Profile=" + requestInfo.getNeededFeatures());
        }
        if (Cursor.Profile.ALWAYS_VALID.containedIn(requestInfo.getNeededFeatures())) {
            RequestInfoUtil.setParameter(requestInfo, "valid-loading", true);
        }
        if ((map2 = requestInfo.getParameters()) != null && map2.get("http://www.ibm.com/xmlns/prod/xcij/strip-space") != null) {
            RequestInfoUtil.setParameter(requestInfo, "eager-loading", true);
        }
        if (RequestInfoUtil.hasHint(requestInfo, "EAGER_ON_LOAD")) {
            RequestInfoUtil.setParameter(requestInfo, "eager-loading", true);
        }
    }

    public static void updateMediator(CacheManager cacheManager, boolean bl, Map<String, Object> map2) {
        Object object2;
        Cursor cursor2 = cacheManager.mediator().focus();
        if (cursor2 == null) {
            return;
        }
        DOMCachedNode dOMCachedNode = cacheManager.getBuiltRootNode();
        if (bl && LazyLoadingHelper.isFirstChildBuilt(dOMCachedNode.getState())) {
            for (object2 = dOMCachedNode.getBuiltFirstChild(); object2 != null && ((DOMCachedNode)object2).itemKind() != 1; object2 = ((DOMCachedNode)object2).getBuiltFollowingSibling()) {
            }
            if (object2 != null && LazyLoadingHelper.isFirstChildBuilt(((DOMCachedNode)object2).getState())) {
                bl = false;
            }
        }
        object2 = bl ? new StreamingCursorMediatorStripSpace(cursor2, cursor2.profile(), map2) : new StreamingCursorMediator(cursor2, cursor2.profile());
        cacheManager.setMediator((Mediator)object2);
    }
}

