/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheAxisSupport;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheNamespaceListCursor;
import com.ibm.xml.xci.dp.cache.dom.CopiedCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.FastAccessSupport;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.StaticContext;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheAxisExecutable
implements Executable {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected NodeTest fTest;
    private static final Logger logger = LoggerUtil.getLogger(CacheAxisExecutable.class);

    protected CacheAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
        this.fTest = nodeTest;
    }

    protected abstract Cursor toFirst(CacheAxisSupport var1);

    @Override
    public Cursor execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
        Cursor cursor3;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            if (cursor2 == null) {
                logger.logp(Level.FINER, logger.getName(), "execute", "Entering execute.  Warning: Focus is null.");
            } else if (cursor2.unwrap() instanceof DOMCachedNode) {
                logger.logp(Level.FINER, logger.getName(), "execute", "Entering execute, focus=" + ((DOMCachedNode)cursor2.unwrap()).toStringLazy());
            } else {
                logger.logp(Level.FINER, logger.getName(), "execute", "Entering execute, focus=" + cursor2);
            }
        }
        if (cursor2 == null) {
            return null;
        }
        CacheAxisSupport cacheAxisSupport = null;
        if (cursor2 instanceof AbstractDelegatingCursor && !(cursor2 instanceof CacheCursor)) {
            cursor2 = ((AbstractDelegatingCursor)cursor2).delegate();
        }
        if (cursor2 instanceof FastAccessSupport) {
            cacheAxisSupport = (CacheAxisSupport)cursor2.fork(false);
        } else {
            cursor3 = (DOMCachedNode)cursor2.unwrap();
            if (cursor2 instanceof CopiedCacheCursor) {
                cacheAxisSupport = new CopiedCacheCursor(((CopiedCacheCursor)cursor2).copiedManager, (DOMCachedNode)cursor3, profile, false);
            } else if (cursor2 instanceof CacheCursor) {
                cacheAxisSupport = cursor3.cache.popCacheCursor((DOMCachedNode)cursor3, profile, false);
            }
            if (cacheAxisSupport == null) {
                cacheAxisSupport = cursor3.cache.popCacheCursor((DOMCachedNode)cursor3, profile, false);
            }
        }
        if (cacheAxisSupport.unwrap() instanceof DOMCachedNode) {
            ((DOMCachedNode)cacheAxisSupport.unwrap()).getCache().setReadOnlyTransform(true);
        }
        if ((cursor3 = this.toFirst(cacheAxisSupport)) == null) {
            cacheAxisSupport.release();
            return null;
        }
        return cursor3;
    }

    @Override
    public void execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray, Result result2) {
        Cursor cursor3 = this.execute(cursor2, dynamicContext, profile, cursorArray);
        cursor3.copyToResult(result2, null, false, true);
    }

    @Override
    public void execute(Cursor cursor2, Cursor.Area area, Cursor cursor3, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            if (cursor2 == null) {
                logger.logp(Level.FINER, logger.getName(), "execute", "Entering execute.  Warning: Focus is null.");
            } else if (cursor2.unwrap() instanceof DOMCachedNode) {
                logger.logp(Level.FINER, logger.getName(), "execute", "Entering execute, focus=" + ((DOMCachedNode)cursor2.unwrap()).toStringLazy());
            } else {
                logger.logp(Level.FINER, logger.getName(), "execute", "Entering execute, focus=" + cursor2 + " result=" + cursor3);
            }
        }
        if (cursor3 == null) {
            throw XCIErrorHelper.createBadArgumentException("result", "null");
        }
        Cursor cursor4 = this.execute(cursor2, dynamicContext, profile, cursorArray);
        if (cursor4 != null) {
            cursor3.addCopy(area, cursor4);
            cursor4.release();
        }
    }

    public static Executable newInstance(Axis axis, NodeTest nodeTest, StaticContext staticContext) {
        switch (axis) {
            case SELF: {
                return new CacheSelfAxisExecutable(nodeTest, staticContext);
            }
            case CHILD: {
                return new CacheChildAxisExecutable(nodeTest, staticContext);
            }
            case ATTRIBUTECHILD: {
                return new CacheAttributeChildAxisExecutable(nodeTest, staticContext);
            }
            case PARENT: {
                return new CacheParentAxisExecutable(nodeTest, staticContext);
            }
            case ATTRIBUTE: {
                return new CacheAttributeAxisExecutable(nodeTest, staticContext);
            }
            case DESCENDANT: {
                return new CacheDescendantAxisExecutable(nodeTest, staticContext);
            }
            case DESCENDANTORSELF: {
                return new CacheDescendantOrSelfAxisExecutable(nodeTest, staticContext);
            }
            case FOLLOWINGSIBLING: {
                return new CacheFollowingSiblingAxisExecutable(nodeTest, staticContext);
            }
            case PRECEDINGSIBLING: {
                return new CachePrecedingSiblingAxisExecutable(nodeTest, staticContext);
            }
            case NAMESPACEDECLS: 
            case NAMESPACEWITHINELEMENT: {
                return new CacheNamespaceDeclsAxisExecutable(nodeTest, staticContext);
            }
            case NAMESPACE: {
                return new CacheNamespaceAxisExecutable(nodeTest, staticContext);
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> getProperties() {
        return null;
    }

    private static class CacheDescendantOrSelfAxisExecutable
    extends CacheAxisExecutable {
        public CacheDescendantOrSelfAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheAxisSupport cacheAxisSupport) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheDescendantOrSelfAxisExecutable.toFirst", "About to start walking the descendant or self axis");
            }
            return cacheAxisSupport.toDescendantsOrSelf(this.fTest) ? cacheAxisSupport : null;
        }
    }

    private static class CacheDescendantAxisExecutable
    extends CacheAxisExecutable {
        public CacheDescendantAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheAxisSupport cacheAxisSupport) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheDescendantAxisExecutable.toFirst", "About to start walking the descendant axis");
            }
            return cacheAxisSupport.toDescendants(this.fTest) ? cacheAxisSupport : null;
        }
    }

    private static class CacheNamespaceAxisExecutable
    extends CacheAxisExecutable {
        public CacheNamespaceAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheAxisSupport cacheAxisSupport) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheNamespaceAxisExecutable.toFirst", "About to start walking the namespace axis");
            }
            if (cacheAxisSupport.itemKind() != 1) {
                return null;
            }
            CacheNamespaceListCursor cacheNamespaceListCursor = new CacheNamespaceListCursor(cacheAxisSupport.factory(), cacheAxisSupport, this.fTest);
            return cacheNamespaceListCursor.contextSize() == 0L ? null : cacheNamespaceListCursor;
        }
    }

    private static class CacheNamespaceDeclsAxisExecutable
    extends CacheAxisExecutable {
        public CacheNamespaceDeclsAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheAxisSupport cacheAxisSupport) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheNamespaceDeclsAxisExecutable.toFirst", "About to start walking the namespace decl axis");
            }
            return cacheAxisSupport.toNamespaceDecls(this.fTest) ? cacheAxisSupport : null;
        }
    }

    private static class CacheAttributeAxisExecutable
    extends CacheAxisExecutable {
        public CacheAttributeAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheAxisSupport cacheAxisSupport) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheAttributeAxisExecutable.toFirst", "About to start walking the attribute axis");
            }
            if (cacheAxisSupport.toAttributes(this.fTest)) {
                return cacheAxisSupport;
            }
            return null;
        }

        public Cursor execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
            DOMCachedElement dOMCachedElement;
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                if (cursor2 == null) {
                    logger.logp(Level.FINER, logger.getName(), "execute", "Entering attribute axis execute.  Warning: Focus is null.");
                } else if (cursor2.unwrap() instanceof DOMCachedNode) {
                    logger.logp(Level.FINER, logger.getName(), "execute", "Entering attribute axis execute, focus=" + ((DOMCachedNode)cursor2.unwrap()).toStringLazy());
                } else {
                    logger.logp(Level.FINER, logger.getName(), "execute", "Entering attribute axis execute, focus=" + cursor2);
                }
            }
            if (cursor2 == null) {
                return null;
            }
            if (cursor2.itemKind() != 1) {
                return null;
            }
            if (cursor2.unwrap() instanceof DOMCachedElement && (dOMCachedElement = (DOMCachedElement)cursor2.unwrap()).getCachedFirstAttribute() == null) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "execute", "This element has no attributes.  Returning null");
                }
                return null;
            }
            return super.execute(cursor2, dynamicContext, profile, cursorArray);
        }
    }

    private static class CachePrecedingSiblingAxisExecutable
    extends CacheAxisExecutable {
        public CachePrecedingSiblingAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheAxisSupport cacheAxisSupport) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CachePrecedingSiblingAxisExecutable.toFirst", "About to start walking the preceding sibling axis");
            }
            return cacheAxisSupport.toPrecedingSiblings(this.fTest) ? cacheAxisSupport : null;
        }
    }

    private static class CacheFollowingSiblingAxisExecutable
    extends CacheAxisExecutable {
        public CacheFollowingSiblingAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheAxisSupport cacheAxisSupport) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheFollowingSiblingAxisExecutable.toFirst", "About to start walking the following sibling axis");
            }
            return cacheAxisSupport.toFollowingSiblings(this.fTest) ? cacheAxisSupport : null;
        }
    }

    private static class CacheParentAxisExecutable
    extends CacheAxisExecutable {
        public CacheParentAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheAxisSupport cacheAxisSupport) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CacheParentAxisExecutable.toFirst", "About to start walking the parent axis");
            }
            if (cacheAxisSupport.toParent() && (this.fTest == null || this.fTest.test(cacheAxisSupport))) {
                return cacheAxisSupport;
            }
            return null;
        }
    }

    private static class CacheAttributeChildAxisExecutable
    extends CacheAxisExecutable {
        public CacheAttributeChildAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheAxisSupport cacheAxisSupport) {
            return cacheAxisSupport.toAttributesAndChildren(this.fTest) ? cacheAxisSupport : null;
        }
    }

    private static class CacheChildAxisExecutable
    extends CacheAxisExecutable {
        public CacheChildAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheAxisSupport cacheAxisSupport) {
            return cacheAxisSupport.toChildren(this.fTest) ? cacheAxisSupport : null;
        }
    }

    private static class CacheSelfAxisExecutable
    extends CacheAxisExecutable {
        public CacheSelfAxisExecutable(NodeTest nodeTest, StaticContext staticContext) {
            super(nodeTest, staticContext);
        }

        protected Cursor toFirst(CacheAxisSupport cacheAxisSupport) {
            if (cacheAxisSupport.toSelf() && (this.fTest == null || this.fTest.test(cacheAxisSupport))) {
                return cacheAxisSupport;
            }
            return null;
        }
    }
}

