/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheAxisSupport;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.CacheNodeSequence;
import com.ibm.xml.xci.dp.cache.dom.CopiedCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.StreamingCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.mediator.Mediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediatorStripSpace;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.TypedValueHelper;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.equality.EqualityHelper;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.util.SimpleNameTest;
import com.ibm.xml.xci.wrappers.StripWhitespaceFilter;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSObject;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheCursor
extends AbstractDelegatingCursor
implements NodeList,
CacheAxisSupport {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = LoggerUtil.getLogger(CacheCursor.class);
    public static final Cursor.Profile FEATURES_LIMIT = Cursor.Profile.RANDOM_UPDATE.union(Cursor.Profile.SEQUENCE.union(Cursor.Profile.SET_NAME.union(Cursor.Profile.MOVE.union(Cursor.Profile.ALWAYS_VALID.union(Cursor.Profile.XSPSVINFO.union(Cursor.Profile.POSITION.union(Cursor.Profile.IS_DEEP_EQUAL_TO.union(Cursor.Profile.TO_FOLLOWING_SIBLINGS.union(Cursor.Profile.TO_PRECEDING_SIBLINGS.union(Cursor.Profile.ADD_COPY.union(Cursor.Profile.SET_PSVI.union(Cursor.Profile.SET_TYPE.union(Cursor.Profile.SET_BASE_URI.union(Cursor.Profile.NODE_IDENTITY.union(Cursor.Profile.SET_XSDECLARATION)))))))))))))));
    public static final Cursor.Profile UNSUPPORTED_FEATURES = Cursor.Profile.ALL.difference(FEATURES_LIMIT);
    protected static final short SEQUENCE_SINGLETON = 0;
    protected static final short SEQUENCE_OF_SIBLINGS = 1;
    protected static final short SEQUENCE_OF_ATTRIBUTES = 2;
    protected static final short SEQUENCE_OF_IDS = 3;
    protected static final short SEQUENCE_OF_IDS_ELEMENT = 12;
    protected static final short SEQUENCE_OF_NODES = 4;
    protected static final short SEQUENCE_OF_DESCENDANTS = 5;
    protected static final short SEQUENCE_OF_PREVIOUS_SIBLINGS = 6;
    protected static final short SEQUENCE_OF_INSCOPE_NAMESPACENODES = 7;
    protected static final short SEQUENCE_OF_NAMESPACE_DECLS = 8;
    protected static final short SEQUENCE_OF_IDREFS = 9;
    protected static final short SEQUENCE_OF_DESCENDANTS_OR_SELF = 10;
    protected static final short SEQUENCE_OF_NAMESPACE_AXIS = 11;
    protected static final short SEQUENCE_OF_ATTRCHILD_ATTR = 13;
    protected static final short SEQUENCE_OF_ATTRCHILD_CHILD = 14;
    protected short sequenceState;
    protected DOMCachedNode contextNode;
    protected NodeTest sequenceTest;
    protected CData idrefsOrIdsCDATA;
    protected int idrefsIndexOrDepth;
    protected short idrefsSubItem;
    protected DOMCachedNode rootSibling;
    private static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    private static final NodeTest xmlIDNameTest = SimpleNameTest.attribute("http://www.w3.org/XML/1998/namespace", "id");

    protected CacheCursor(DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl) {
        this(dOMCachedNode, profile, bl, null);
    }

    protected CacheCursor(DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl, NodeTest nodeTest) {
        assert (dOMCachedNode != null) : "Cannot refer to nothing in cache?!";
        this.loadState(dOMCachedNode, profile, bl, nodeTest);
    }

    protected CacheCursor(DOMCachedNode dOMCachedNode, boolean bl) {
        this(dOMCachedNode, FEATURES_LIMIT, bl, null);
    }

    protected CacheCursor(CacheCursor cacheCursor, Cursor.Profile profile, boolean bl) {
        this.loadFromOriginal(cacheCursor, profile, bl);
    }

    public void loadState(DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl, NodeTest nodeTest) {
        if (LoggerUtil.isAnyTracingEnabled()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "loadFromOriginal", "Created a new CacheCursor from a DOMCachedNode=" + dOMCachedNode.toStringLazy() + " | Self = " + bl + "\nNeeded Features=" + profile + "\nStack trace= " + XCIErrorHelper.getStackTrace(10));
            } else if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "loadFromOriginal", "Created a new CacheCursor from a DOMCachedNode. Self =" + bl);
            }
        }
        this.sequenceState = bl || dOMCachedNode.itemKind() == 9 ? (short)0 : 1;
        this.contextNode = dOMCachedNode.reference();
        this.rootSibling = null;
        this.sequenceTest = nodeTest;
    }

    public void loadFromOriginal(CacheCursor cacheCursor, Cursor.Profile profile, boolean bl) {
        if (LoggerUtil.isAnyTracingEnabled()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "loadFromOriginal", "Created a new CacheCursor from another CacheCursor=" + cacheCursor + " Self = " + bl + "\nStack trace= " + XCIErrorHelper.getStackTrace(10));
            } else if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "loadFromOriginal", "Created a new CacheCursor from another CacheCursor.  Self =" + bl);
            }
        }
        assert (cacheCursor != null) : "cannot clone a null cursor";
        this.sequenceState = bl ? (short)0 : cacheCursor.sequenceState;
        this.contextNode = cacheCursor.contextNode.reference();
        this.sequenceTest = cacheCursor.sequenceTest;
        if (this.sequenceState == 3 || this.sequenceState == 12 || this.sequenceState == 9) {
            this.idrefsOrIdsCDATA = cacheCursor.idrefsOrIdsCDATA;
            this.idrefsSubItem = cacheCursor.idrefsSubItem;
        }
        this.idrefsIndexOrDepth = cacheCursor.idrefsIndexOrDepth;
        this.rootSibling = cacheCursor.rootSibling;
    }

    protected void replaceContextNodeAndState(DOMCachedNode dOMCachedNode, short s) {
        this.replaceContextNode(dOMCachedNode);
        this.sequenceState = s;
        if (this.rootSibling != null) {
            this.rootSibling.dereference();
        }
        this.rootSibling = null;
    }

    protected void replaceContextNode(DOMCachedNode dOMCachedNode) {
        DOMCachedNode dOMCachedNode2 = dOMCachedNode.reference();
        this.contextNode.dereference();
        this.contextNode = dOMCachedNode2;
    }

    protected void makeSingleton(short s) {
        this.replaceContextNodeAndState(this.contextNode, s);
    }

    @Override
    public boolean toDescendants(NodeTest nodeTest) {
        if (this.contextNode.itemKind() == 1 || this.contextNode.itemKind() == 9) {
            int n2 = this.idrefsIndexOrDepth;
            this.idrefsIndexOrDepth = 0;
            DOMCachedNode dOMCachedNode = this.getNextDescendant(this.contextNode, nodeTest);
            if (dOMCachedNode != null) {
                this.replaceContextNodeAndState(dOMCachedNode, (short)5);
                this.sequenceTest = nodeTest;
                this.idrefsOrIdsCDATA = null;
                return true;
            }
            this.idrefsIndexOrDepth = n2;
        }
        return false;
    }

    @Override
    public boolean toDescendantsOrSelf(NodeTest nodeTest) {
        if (this.contextNode.itemKind() == 1 || this.contextNode.itemKind() == 9) {
            int n2 = this.idrefsIndexOrDepth;
            this.idrefsIndexOrDepth = 0;
            DOMCachedNode dOMCachedNode = nodeTest == null || nodeTest.test(this.contextNode) ? this.contextNode : this.getNextDescendant(this.contextNode, nodeTest);
            if (dOMCachedNode != null) {
                this.replaceContextNodeAndState(dOMCachedNode, (short)10);
                this.sequenceTest = nodeTest;
                this.idrefsOrIdsCDATA = null;
                return true;
            }
            this.idrefsIndexOrDepth = n2;
        } else if (nodeTest == null || nodeTest.test(this.contextNode)) {
            this.sequenceState = 0;
            this.replaceContextNodeAndState(this.contextNode, (short)0);
            return true;
        }
        return false;
    }

    protected DOMCachedNode getNextDescendant(DOMCachedNode dOMCachedNode) {
        if (dOMCachedNode.getCachedFirstChild() == null) {
            int n2 = this.idrefsIndexOrDepth;
            while (this.idrefsIndexOrDepth > 0 && dOMCachedNode != null) {
                if (dOMCachedNode.getCachedFollowingSibling() != null) {
                    return dOMCachedNode.getCachedFollowingSibling();
                }
                --this.idrefsIndexOrDepth;
                dOMCachedNode = dOMCachedNode.getCachedParent();
            }
            this.idrefsIndexOrDepth = n2;
            return null;
        }
        ++this.idrefsIndexOrDepth;
        return dOMCachedNode.getCachedFirstChild();
    }

    protected DOMCachedNode getPreviousDescendant(DOMCachedNode dOMCachedNode) {
        if (this.idrefsIndexOrDepth <= 0) {
            return null;
        }
        DOMCachedNode dOMCachedNode2 = dOMCachedNode.getCachedPrecedingSibling();
        if (dOMCachedNode2 != null) {
            while (dOMCachedNode2.getCachedLastChild() != null) {
                dOMCachedNode2 = dOMCachedNode2.getCachedLastChild();
                ++this.idrefsIndexOrDepth;
            }
        } else {
            dOMCachedNode2 = dOMCachedNode.getBuiltParent();
            if (dOMCachedNode2 != null) {
                if (this.sequenceState == 10 || this.idrefsIndexOrDepth > 1) {
                    --this.idrefsIndexOrDepth;
                } else {
                    dOMCachedNode2 = null;
                }
            }
        }
        return dOMCachedNode2;
    }

    protected DOMCachedNode getNextDescendant(DOMCachedNode dOMCachedNode, NodeTest nodeTest) {
        if (nodeTest == null) {
            return this.getNextDescendant(dOMCachedNode);
        }
        int n2 = this.idrefsIndexOrDepth;
        do {
            if ((dOMCachedNode = this.getNextDescendant(dOMCachedNode)) == null || !nodeTest.test(dOMCachedNode)) continue;
            return dOMCachedNode;
        } while (dOMCachedNode != null);
        this.idrefsIndexOrDepth = n2;
        return null;
    }

    protected DOMCachedNode getPreviousDescendant(DOMCachedNode dOMCachedNode, NodeTest nodeTest) {
        if (nodeTest == null) {
            return this.getPreviousDescendant(dOMCachedNode);
        }
        int n2 = this.idrefsIndexOrDepth;
        do {
            if ((dOMCachedNode = this.getPreviousDescendant(dOMCachedNode)) == null || !nodeTest.test(dOMCachedNode)) continue;
            return dOMCachedNode;
        } while (dOMCachedNode != null);
        this.idrefsIndexOrDepth = n2;
        return null;
    }

    @Override
    public Cursor getDelegate() {
        if (this.contextNode == null && LoggerUtil.isFineLoggable(logger)) {
            logger.logp(Level.FINER, logger.getName(), "getDelegate", "WARNING: context node is null \nStack trace= " + XCIErrorHelper.getStackTrace(20));
        }
        return this.contextNode;
    }

    @Override
    public Cursor.Profile profile() {
        return FEATURES_LIMIT;
    }

    @Override
    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public Cursor.Profile futureProfile() {
        return FEATURES_LIMIT;
    }

    @Override
    public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        Cursor cursor2;
        switch (this.sequenceState) {
            case 0: {
                cursor2 = AbstractCursor.ownTheCursor(this, true, bl);
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 14: {
                cursor2 = AbstractCursor.ownTheCursor(this, false, bl);
                break;
            }
            case 3: 
            case 12: {
                cursor2 = this.sortMe(bl);
                break;
            }
            case 4: {
                cursor2 = this.sortMe(bl);
                break;
            }
            case 5: {
                cursor2 = AbstractCursor.ownTheCursor(this, false, bl);
                break;
            }
            case 6: {
                cursor2 = this.reverseMe(bl);
                break;
            }
            case 7: 
            case 8: {
                cursor2 = AbstractCursor.ownTheCursor(this, false, bl);
                break;
            }
            case 9: {
                cursor2 = this.sortMe(bl);
                break;
            }
            case 10: 
            case 11: {
                cursor2 = AbstractCursor.ownTheCursor(this, false, bl);
                break;
            }
            default: {
                assert (false) : "unknown state!!!";
                cursor2 = null;
            }
        }
        return cursor2;
    }

    private Cursor reverseMe(boolean bl) {
        Cursor cursor2 = AbstractCursor.ownTheCursor(this, false, bl);
        CacheNodeSequence cacheNodeSequence = CacheNodeSequence.getNewSequence(cursor2, null, false, false);
        cursor2.release();
        cacheNodeSequence.reverse();
        return cacheNodeSequence;
    }

    private Cursor sortMe(boolean bl) {
        Cursor cursor2 = AbstractCursor.ownTheCursor(this, false, bl);
        CacheNodeSequence cacheNodeSequence = CacheNodeSequence.getNewSequence(cursor2, null, false, false);
        cacheNodeSequence.sortAndEliminateDups();
        cursor2.release();
        return cacheNodeSequence;
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        if (bl && profile.containedIn(this.contextNode.profile())) {
            DOMCachedNode dOMCachedNode = this.contextNode.reference();
            return dOMCachedNode;
        }
        boolean bl2 = bl = bl || this.sequenceState == 0;
        if (profile.containedIn(StreamingCacheCursor.PROFILE_LIMIT) && this.sequenceState != 1 && this.sequenceState != 6) {
            return new StreamingCacheCursor(this.contextNode, profile, bl);
        }
        return new CacheCursor(this, profile, bl);
    }

    @Override
    public void release() {
        boolean bl = LoggerUtil.isAnyTracingEnabled();
        if (bl && logger.isLoggable(Level.FINEST)) {
            if (this.contextNode != null) {
                logger.logp(Level.FINEST, logger.getName(), "release", "releasing a CacheCursor with contextNode " + this.contextNode.toStringLazy() + "\nStack trace= " + XCIErrorHelper.getStackTrace(10));
            } else {
                logger.logp(Level.FINEST, logger.getName(), "release", "releasing a CacheCursor with a NULL context node \nStack trace= " + XCIErrorHelper.getStackTrace(10));
            }
        } else if (bl && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "release", "releasing a CacheCursor");
        }
        if (this.rootSibling != null) {
            this.rootSibling.dereference();
        }
        this.rootSibling = null;
        this.sequenceTest = null;
        this.idrefsOrIdsCDATA = null;
        if (this.contextNode != null) {
            this.contextNode.dereference();
        }
        this.contextNode = null;
    }

    @Override
    public long contextPosition() {
        switch (this.sequenceState) {
            case 0: {
                return 1L;
            }
            case 1: 
            case 14: {
                DOMCachedNode dOMCachedNode;
                DOMCachedNode dOMCachedNode2;
                int n2 = 1;
                if (this.sequenceState == 14 && (dOMCachedNode2 = (dOMCachedNode = this.contextNode.parent).getCachedNamedAttribute(this.sequenceTest)) != null) {
                    ++n2;
                    for (DOMCachedAttribute dOMCachedAttribute = ((DOMCachedAttribute)dOMCachedNode2).getCachedFollowingAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
                        if (this.sequenceTest != null && !dOMCachedAttribute.satisfies(this.sequenceTest)) continue;
                        ++n2;
                    }
                }
                dOMCachedNode = this.contextNode.reference();
                dOMCachedNode2 = this.contextNode.getCachedPrecedingSibling(this.sequenceTest);
                while (dOMCachedNode != this.rootSibling && dOMCachedNode2 != null) {
                    if (dOMCachedNode != null) {
                        dOMCachedNode.dereference();
                    }
                    dOMCachedNode = dOMCachedNode2.reference();
                    dOMCachedNode2 = dOMCachedNode2.getCachedPrecedingSibling(this.sequenceTest);
                    ++n2;
                }
                return n2;
            }
            case 5: 
            case 10: {
                int n3 = 1;
                int n4 = this.idrefsIndexOrDepth;
                DOMCachedNode dOMCachedNode = this.getPreviousDescendant(this.contextNode, this.sequenceTest);
                while (dOMCachedNode != null) {
                    ++n3;
                    dOMCachedNode = this.getPreviousDescendant(dOMCachedNode, this.sequenceTest);
                }
                this.idrefsIndexOrDepth = n4;
                return n3;
            }
            case 2: 
            case 13: {
                int n5 = 1;
                for (DOMCachedAttribute dOMCachedAttribute = ((DOMCachedAttribute)this.contextNode).getCachedPrecedingAttribute(this.sequenceTest); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedPrecedingAttribute(this.sequenceTest)) {
                    ++n5;
                }
                return n5;
            }
            case 8: {
                int n6 = 1;
                for (DOMCachedNamespace dOMCachedNamespace = ((DOMCachedNamespace)this.contextNode).getCachedPrecedingNamespaceNode(this.sequenceTest); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedPrecedingNamespaceNode(this.sequenceTest)) {
                    ++n6;
                }
                return n6;
            }
            case 3: 
            case 12: {
                return this.idrefsIndexOrDepth;
            }
            case 9: {
                int n7 = 1;
                n7 += this.idrefsSubItem;
                if (this.idrefsIndexOrDepth == 1) {
                    return n7;
                }
                CacheManager cacheManager = this.contextNode.getCache();
                for (int i = this.idrefsIndexOrDepth - 1; i > 0; --i) {
                    List<DOMCachedAttribute> list = cacheManager.getCachedIdRefs(this.idrefsOrIdsCDATA, i);
                    n7 += list.size();
                }
                return n7;
            }
            case 11: {
                return this.idrefsIndexOrDepth + 1;
            }
            case 6: {
                int n8 = 1;
                DOMCachedNode dOMCachedNode = this.contextNode.reference();
                DOMCachedNode dOMCachedNode3 = this.contextNode.getCachedFollowingSibling(this.sequenceTest);
                while (dOMCachedNode != this.rootSibling && dOMCachedNode3 != null) {
                    if (dOMCachedNode != null) {
                        dOMCachedNode.dereference();
                    }
                    dOMCachedNode = dOMCachedNode3.reference();
                    dOMCachedNode3 = dOMCachedNode3.getCachedFollowingSibling(this.sequenceTest);
                    ++n8;
                }
                return n8;
            }
        }
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_ILLEGAL_INTERNAL_VALUE", new String[]{"sequenceState", Integer.toString(this.sequenceState)}));
    }

    @Override
    public long contextSize() {
        switch (this.sequenceState) {
            case 0: {
                return 1L;
            }
            case 1: 
            case 14: {
                long l = this.contextPosition();
                for (DOMCachedNode dOMCachedNode = this.contextNode.getCachedFollowingSibling(this.sequenceTest); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getCachedFollowingSibling(this.sequenceTest)) {
                    ++l;
                }
                return l;
            }
            case 6: {
                long l = this.contextPosition();
                for (DOMCachedNode dOMCachedNode = this.contextNode.getCachedPrecedingSibling(this.sequenceTest); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getCachedPrecedingSibling(this.sequenceTest)) {
                    ++l;
                }
                return l;
            }
            case 2: 
            case 13: {
                DOMCachedNode dOMCachedNode;
                DOMCachedNode dOMCachedNode2;
                long l = this.contextPosition();
                for (dOMCachedNode2 = ((DOMCachedAttribute)this.contextNode).getCachedFollowingAttribute(); dOMCachedNode2 != null; dOMCachedNode2 = ((DOMCachedAttribute)dOMCachedNode2).getCachedFollowingAttribute()) {
                    if (!((DOMCachedAttribute)dOMCachedNode2).satisfies(this.sequenceTest)) continue;
                    ++l;
                }
                if (this.sequenceState == 13 && (dOMCachedNode = (dOMCachedNode2 = this.contextNode.parent).getCachedFirstChild(this.sequenceTest)) != null) {
                    ++l;
                    for (DOMCachedNode dOMCachedNode3 = dOMCachedNode.getCachedFollowingSibling(this.sequenceTest); dOMCachedNode3 != null; dOMCachedNode3 = dOMCachedNode3.getCachedFollowingSibling(this.sequenceTest)) {
                        ++l;
                    }
                }
                return l;
            }
            case 8: {
                long l = this.contextPosition();
                for (DOMCachedNamespace dOMCachedNamespace = ((DOMCachedNamespace)this.contextNode).getCachedFollowingNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
                    if (!dOMCachedNamespace.satisfies(this.sequenceTest)) continue;
                    ++l;
                }
                return l;
            }
            case 3: 
            case 12: {
                long l = this.contextPosition();
                CacheManager cacheManager = this.contextNode.getCache();
                DOMCachedElement dOMCachedElement = null;
                for (int i = this.idrefsIndexOrDepth + 1; i <= this.idrefsOrIdsCDATA.getSize(); ++i) {
                    dOMCachedElement = cacheManager.getCachedId(this.idrefsOrIdsCDATA, i);
                    if (this.sequenceState == 12 && dOMCachedElement != null && DOMCachedElement.isElementIDTyped(dOMCachedElement.itemXSType())) {
                        dOMCachedElement = dOMCachedElement.parent != null && dOMCachedElement.parent.itemKind() == 1 ? (DOMCachedElement)dOMCachedElement.parent : null;
                    }
                    if (dOMCachedElement == null) continue;
                    ++l;
                }
                return l;
            }
            case 9: {
                CacheManager cacheManager = this.contextNode.getCache();
                long l = 0L;
                for (int i = 1; i <= this.idrefsOrIdsCDATA.getSize(); ++i) {
                    List<DOMCachedAttribute> list = cacheManager.getCachedIdRefs(this.idrefsOrIdsCDATA, i);
                    if (list == null) continue;
                    l += (long)list.size();
                }
                return l;
            }
            case 5: 
            case 10: {
                long l = this.contextPosition();
                int n2 = this.idrefsIndexOrDepth;
                DOMCachedNode dOMCachedNode = this.getNextDescendant(this.contextNode);
                while (dOMCachedNode != null) {
                    if (dOMCachedNode.satisfies(this.sequenceTest)) {
                        ++l;
                    }
                    dOMCachedNode = this.getNextDescendant(dOMCachedNode);
                }
                this.idrefsIndexOrDepth = n2;
                return l;
            }
        }
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_ILLEGAL_INTERNAL_VALUE", new String[]{"sequenceState", Integer.toString(this.sequenceState)}));
    }

    @Override
    public boolean contextIsOrdered(boolean bl) {
        switch (this.sequenceState) {
            case 0: 
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contextIsAtomsOnly() {
        return false;
    }

    @Override
    public boolean contextIsNodesOnly() {
        return true;
    }

    @Override
    public boolean contextIsSingleDoc() {
        return true;
    }

    @Override
    public boolean toIds(VolatileCData volatileCData) {
        return this.toIds(volatileCData, false);
    }

    @Override
    public boolean toIdrefs(VolatileCData volatileCData) {
        CacheManager cacheManager = this.contextNode.getCache();
        cacheManager.ensureStateResolved(cacheManager.getBuiltRootNode(), Cursor.Area.ALL);
        for (int i = 1; i <= volatileCData.getSize(); ++i) {
            List<DOMCachedAttribute> list = cacheManager.getCachedIdRefs(volatileCData, i);
            if (list == null) continue;
            this.sequenceState = (short)9;
            this.replaceContextNode(list.get(0));
            this.idrefsOrIdsCDATA = volatileCData.constant(true);
            this.sequenceTest = null;
            this.idrefsIndexOrDepth = i;
            this.idrefsSubItem = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean contextIsSingleton() {
        return this.contextPosition() == 1L && !this.hasNext();
    }

    public boolean hasNext() {
        switch (this.sequenceState) {
            case 0: {
                return false;
            }
            case 1: 
            case 14: {
                DOMCachedNode dOMCachedNode = this.contextNode.getCachedFollowingSibling(this.sequenceTest);
                return dOMCachedNode != null;
            }
            case 6: {
                DOMCachedNode dOMCachedNode = this.contextNode.getCachedPrecedingSibling(this.sequenceTest);
                return dOMCachedNode != null;
            }
            case 2: 
            case 13: {
                DOMCachedNode dOMCachedNode;
                DOMCachedNode dOMCachedNode2;
                for (dOMCachedNode2 = ((DOMCachedAttribute)this.contextNode).getCachedFollowingAttribute(); dOMCachedNode2 != null; dOMCachedNode2 = ((DOMCachedAttribute)dOMCachedNode2).getCachedFollowingAttribute()) {
                    if (this.sequenceTest != null && !((DOMCachedAttribute)dOMCachedNode2).satisfies(this.sequenceTest)) continue;
                    return true;
                }
                return this.sequenceState == 13 && (dOMCachedNode = (dOMCachedNode2 = this.contextNode.parent).getCachedFirstChild(this.sequenceTest)) != null;
            }
            case 8: {
                for (DOMCachedNamespace dOMCachedNamespace = ((DOMCachedNamespace)this.contextNode).getCachedFollowingNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
                    if (this.sequenceTest != null && !dOMCachedNamespace.satisfies(this.sequenceTest)) continue;
                    return true;
                }
                return false;
            }
            case 3: 
            case 12: {
                CacheManager cacheManager = this.contextNode.getCache();
                DOMCachedElement dOMCachedElement = null;
                for (int i = this.idrefsIndexOrDepth + 1; i <= this.idrefsOrIdsCDATA.getSize(); ++i) {
                    dOMCachedElement = cacheManager.getCachedId(this.idrefsOrIdsCDATA, i);
                    if (this.sequenceState == 12 && dOMCachedElement != null && DOMCachedElement.isElementIDTyped(dOMCachedElement.itemXSType())) {
                        dOMCachedElement = dOMCachedElement.parent != null && dOMCachedElement.parent.itemKind() == 1 ? (DOMCachedElement)dOMCachedElement.parent : null;
                    }
                    if (dOMCachedElement == null) continue;
                    return true;
                }
                return false;
            }
            case 9: {
                CacheManager cacheManager = this.contextNode.getCache();
                List<DOMCachedAttribute> list = cacheManager.getCachedIdRefs(this.idrefsOrIdsCDATA, this.idrefsIndexOrDepth);
                if (this.idrefsSubItem + 1 < list.size()) {
                    return true;
                }
                for (int i = this.idrefsIndexOrDepth + 1; i <= this.idrefsOrIdsCDATA.getSize(); ++i) {
                    list = cacheManager.getCachedIdRefs(this.idrefsOrIdsCDATA, i);
                    if (list == null) continue;
                    return true;
                }
                return false;
            }
            case 5: 
            case 10: {
                int n2 = this.idrefsIndexOrDepth;
                DOMCachedNode dOMCachedNode = this.getNextDescendant(this.contextNode, this.sequenceTest);
                this.idrefsIndexOrDepth = n2;
                return dOMCachedNode != null;
            }
        }
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_ILLEGAL_INTERNAL_VALUE", new String[]{"sequenceState", Integer.toString(this.sequenceState)}));
    }

    @Override
    public boolean contextIsLive() {
        return true;
    }

    @Override
    public boolean toNext() {
        switch (this.sequenceState) {
            case 0: {
                return false;
            }
            case 1: 
            case 14: {
                DOMCachedNode dOMCachedNode = this.contextNode.getCachedFollowingSibling(this.sequenceTest);
                if (dOMCachedNode != null) {
                    this.replaceContextNode(dOMCachedNode);
                    return true;
                }
                return false;
            }
            case 6: {
                DOMCachedNode dOMCachedNode = this.contextNode.getCachedPrecedingSibling(this.sequenceTest);
                if (dOMCachedNode != null) {
                    this.replaceContextNode(dOMCachedNode);
                    return true;
                }
                return false;
            }
            case 2: 
            case 13: {
                DOMCachedNode dOMCachedNode;
                DOMCachedNode dOMCachedNode2;
                for (dOMCachedNode2 = ((DOMCachedAttribute)this.contextNode).getCachedFollowingAttribute(); dOMCachedNode2 != null; dOMCachedNode2 = ((DOMCachedAttribute)dOMCachedNode2).getCachedFollowingAttribute()) {
                    if (this.sequenceTest != null && !((DOMCachedAttribute)dOMCachedNode2).satisfies(this.sequenceTest)) continue;
                    this.replaceContextNode(dOMCachedNode2);
                    return true;
                }
                if (this.sequenceState == 13 && (dOMCachedNode = (dOMCachedNode2 = this.contextNode.parent).getCachedFirstChild(this.sequenceTest)) != null) {
                    this.replaceContextNodeAndState(dOMCachedNode, (short)14);
                    return true;
                }
                return false;
            }
            case 8: {
                for (DOMCachedNamespace dOMCachedNamespace = ((DOMCachedNamespace)this.contextNode).getCachedFollowingNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
                    if (this.sequenceTest != null && !dOMCachedNamespace.satisfies(this.sequenceTest)) continue;
                    this.replaceContextNode(dOMCachedNamespace);
                    return true;
                }
                return false;
            }
            case 3: 
            case 12: {
                CacheManager cacheManager = this.contextNode.getCache();
                DOMCachedElement dOMCachedElement = null;
                for (int i = this.idrefsIndexOrDepth + 1; i <= this.idrefsOrIdsCDATA.getSize(); ++i) {
                    dOMCachedElement = cacheManager.getCachedId(this.idrefsOrIdsCDATA, i);
                    if (this.sequenceState == 12 && dOMCachedElement != null && DOMCachedElement.isElementIDTyped(dOMCachedElement.itemXSType())) {
                        dOMCachedElement = dOMCachedElement.parent != null && dOMCachedElement.parent.itemKind() == 1 ? (DOMCachedElement)dOMCachedElement.parent : null;
                    }
                    if (dOMCachedElement == null) continue;
                    this.replaceContextNode(dOMCachedElement);
                    this.idrefsIndexOrDepth = i;
                    return true;
                }
                return false;
            }
            case 9: {
                CacheManager cacheManager = this.contextNode.getCache();
                List<DOMCachedAttribute> list = cacheManager.getCachedIdRefs(this.idrefsOrIdsCDATA, this.idrefsIndexOrDepth);
                if (this.idrefsSubItem + 1 < list.size()) {
                    this.idrefsSubItem = (short)(this.idrefsSubItem + 1);
                    this.replaceContextNode(list.get(this.idrefsSubItem));
                    return true;
                }
                for (int i = this.idrefsIndexOrDepth + 1; i <= this.idrefsOrIdsCDATA.getSize(); ++i) {
                    list = cacheManager.getCachedIdRefs(this.idrefsOrIdsCDATA, i);
                    if (list == null) continue;
                    this.idrefsIndexOrDepth = i;
                    this.idrefsSubItem = 0;
                    this.replaceContextNode(list.get(0));
                    return true;
                }
                return false;
            }
            case 5: 
            case 10: {
                DOMCachedNode dOMCachedNode = this.getNextDescendant(this.contextNode, this.sequenceTest);
                if (dOMCachedNode != null) {
                    this.replaceContextNode(dOMCachedNode);
                    return true;
                }
                return false;
            }
        }
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_ILLEGAL_INTERNAL_VALUE", new String[]{"sequenceState", Integer.toString(this.sequenceState)}));
    }

    @Override
    public boolean toPrevious() {
        boolean bl = false;
        DOMCachedNode dOMCachedNode = null;
        if (this.contextPosition() == 1L) {
            return false;
        }
        block0 : switch (this.sequenceState) {
            case 0: {
                bl = false;
                break;
            }
            case 1: 
            case 14: {
                if (this.contextNode == this.rootSibling) {
                    bl = false;
                    break;
                }
                dOMCachedNode = this.contextNode.getCachedPrecedingSibling(this.sequenceTest);
                boolean bl2 = bl = dOMCachedNode != null;
                if (bl || this.sequenceState != 14) break;
                DOMCachedContainer dOMCachedContainer = this.contextNode.parent;
                DOMCachedAttribute dOMCachedAttribute = dOMCachedContainer.getCachedLastAttribute();
                do {
                    if (this.sequenceTest != null && !dOMCachedAttribute.satisfies(this.sequenceTest)) continue;
                    bl = true;
                    dOMCachedNode = dOMCachedAttribute;
                    this.sequenceState = (short)13;
                    break block0;
                } while ((dOMCachedAttribute = dOMCachedAttribute.getCachedPrecedingAttribute()) != null);
                break;
            }
            case 6: {
                if (this.contextNode == this.rootSibling) {
                    bl = false;
                    break;
                }
                dOMCachedNode = this.contextNode.getCachedFollowingSibling(this.sequenceTest);
                bl = dOMCachedNode != null;
                break;
            }
            case 2: 
            case 13: {
                for (DOMCachedAttribute dOMCachedAttribute = ((DOMCachedAttribute)this.contextNode).getCachedPrecedingAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedPrecedingAttribute()) {
                    if (this.sequenceTest != null && !dOMCachedAttribute.satisfies(this.sequenceTest)) continue;
                    bl = true;
                    dOMCachedNode = dOMCachedAttribute;
                    break block0;
                }
                break;
            }
            case 3: 
            case 12: {
                CacheManager cacheManager = this.contextNode.getCache();
                DOMCachedElement dOMCachedElement = null;
                for (int i = this.idrefsIndexOrDepth - 1; i > 0; --i) {
                    dOMCachedElement = cacheManager.getCachedId(this.idrefsOrIdsCDATA, i);
                    if (this.sequenceState == 12 && dOMCachedElement != null && DOMCachedElement.isElementIDTyped(((AbstractCursor)dOMCachedElement).itemXSType())) {
                        dOMCachedElement = dOMCachedElement.parent != null && dOMCachedElement.parent.itemKind() == 1 ? (DOMCachedElement)dOMCachedElement.parent : null;
                    }
                    if (dOMCachedElement == null) continue;
                    dOMCachedNode = dOMCachedElement;
                    bl = true;
                    this.idrefsIndexOrDepth = i;
                    break;
                }
                bl = false;
                break;
            }
            case 9: {
                CacheManager cacheManager = this.contextNode.getCache();
                List<DOMCachedAttribute> list = null;
                if (this.idrefsSubItem > 0) {
                    list = cacheManager.getCachedIdRefs(this.idrefsOrIdsCDATA, this.idrefsIndexOrDepth);
                    bl = true;
                    this.idrefsSubItem = (short)(this.idrefsSubItem - 1);
                    dOMCachedNode = list.get(this.idrefsSubItem);
                    break;
                }
                if (this.idrefsIndexOrDepth == 1) {
                    bl = false;
                    break;
                }
                for (int i = this.idrefsIndexOrDepth - 1; i > 0; --i) {
                    list = cacheManager.getCachedIdRefs(this.idrefsOrIdsCDATA, i);
                    if (list == null) continue;
                    bl = true;
                    this.idrefsIndexOrDepth = i;
                    this.idrefsSubItem = (short)(list.size() - 1);
                    dOMCachedNode = list.get(this.idrefsSubItem);
                    break;
                }
                bl = false;
                break;
            }
            case 8: {
                dOMCachedNode = this.contextNode.getCachedPrecedingSibling(this.sequenceTest);
                bl = dOMCachedNode != null;
                break;
            }
            case 5: 
            case 10: {
                DOMCachedNode dOMCachedNode2 = this.getPreviousDescendant(this.contextNode, this.sequenceTest);
                if (dOMCachedNode2 != null) {
                    this.replaceContextNode(dOMCachedNode2);
                    return true;
                }
                return false;
            }
            default: {
                assert (false) : "Unsupported sequenceState?";
                break;
            }
        }
        if (bl) {
            this.replaceContextNode(dOMCachedNode);
            return true;
        }
        return false;
    }

    @Override
    public boolean toPosition(long l) {
        switch (this.sequenceState) {
            case 0: {
                return l == 1L;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                DOMCachedNode dOMCachedNode = this.contextNode;
                short s = this.sequenceState;
                if (l <= 0L) {
                    return false;
                }
                if (l < this.contextPosition()) {
                    while (l < this.contextPosition()) {
                        if (this.toPrevious()) continue;
                        this.contextNode = dOMCachedNode;
                        return false;
                    }
                    return true;
                }
                if (l == this.contextPosition()) {
                    return true;
                }
                if (l > this.contextPosition()) {
                    while (l > this.contextPosition()) {
                        if (this.toNext()) continue;
                        this.contextNode = dOMCachedNode;
                        this.sequenceState = s;
                        return false;
                    }
                    return true;
                }
                this.contextNode = dOMCachedNode;
                return false;
            }
        }
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_ILLEGAL_INTERNAL_VALUE", new String[]{"sequenceState", Integer.toString(this.sequenceState)}));
    }

    @Override
    public boolean toSelf() {
        this.sequenceState = 0;
        return true;
    }

    @Override
    public boolean toAttributes(NodeTest nodeTest) {
        if (this.itemKind() != 1) {
            return false;
        }
        DOMCachedAttribute dOMCachedAttribute = this.contextNode.getCachedNamedAttribute(nodeTest);
        if (dOMCachedAttribute != null) {
            this.replaceContextNodeAndState(dOMCachedAttribute, (short)2);
            this.sequenceTest = nodeTest;
            this.idrefsOrIdsCDATA = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean toAttributesAndChildren(NodeTest nodeTest) {
        DOMCachedNode dOMCachedNode;
        short s = this.contextNode.itemKind();
        if (s != 1 && s != 9) {
            return false;
        }
        if (s != 9 && (dOMCachedNode = this.contextNode.getCachedNamedAttribute(nodeTest)) != null) {
            this.replaceContextNodeAndState(dOMCachedNode, (short)13);
            this.sequenceTest = nodeTest;
            this.idrefsOrIdsCDATA = null;
            return true;
        }
        dOMCachedNode = this.contextNode.getCachedFirstChild(nodeTest);
        if (dOMCachedNode != null) {
            this.replaceContextNodeAndState(dOMCachedNode, (short)14);
            this.sequenceTest = nodeTest;
            this.idrefsOrIdsCDATA = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean toNamespaceDecls() {
        return this.toNamespaceDecls(null);
    }

    @Override
    public boolean toNamespaceDecls(NodeTest nodeTest) {
        if (this.itemKind() != 1) {
            return false;
        }
        DOMCachedNamespace dOMCachedNamespace = ((DOMCachedElement)this.contextNode).getCachedNamedNamespace(nodeTest);
        if (dOMCachedNamespace != null) {
            this.replaceContextNodeAndState(dOMCachedNamespace, (short)8);
            this.sequenceTest = nodeTest;
            this.idrefsOrIdsCDATA = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean toChildren(NodeTest nodeTest) {
        short s = this.contextNode.itemKind();
        if (s != 1 && s != 9) {
            return false;
        }
        DOMCachedNode dOMCachedNode = this.contextNode.getCachedFirstChild(nodeTest);
        if (dOMCachedNode != null) {
            this.replaceContextNodeAndState(dOMCachedNode, (short)1);
            this.sequenceTest = nodeTest;
            this.idrefsOrIdsCDATA = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean toParent() {
        if (BitMaskHelper.stateContains(this.contextNode.state, 0x20000000)) {
            return this.toRoot();
        }
        DOMCachedContainer dOMCachedContainer = this.contextNode.getCachedParent();
        if (dOMCachedContainer == null) {
            return false;
        }
        if (this.contextNode.cache.rootNode instanceof CacheManager.ManufacturedRootNode) {
            DOMCachedNode dOMCachedNode = ((CacheManager.ManufacturedRootNode)this.contextNode.cache.rootNode).builtFirstChild;
            DOMCachedNode dOMCachedNode2 = this.contextNode;
            while (dOMCachedNode2.preceding != null) {
                dOMCachedNode2 = dOMCachedNode2.preceding;
            }
            if (dOMCachedNode2 == dOMCachedNode) {
                return this.toRoot();
            }
        }
        this.replaceContextNodeAndState(dOMCachedContainer, (short)0);
        this.sequenceTest = null;
        this.idrefsOrIdsCDATA = null;
        return true;
    }

    @Override
    public boolean toRoot() {
        DOMCachedNode dOMCachedNode = this.contextNode.getBuiltRoot();
        if (dOMCachedNode == null) {
            return false;
        }
        this.replaceContextNodeAndState(dOMCachedNode, (short)0);
        this.sequenceTest = null;
        this.idrefsOrIdsCDATA = null;
        return true;
    }

    @Override
    public boolean toPrecedingSiblings(NodeTest nodeTest) {
        if (this.contextNode.itemKind() == 2) {
            return false;
        }
        DOMCachedNode dOMCachedNode = this.contextNode.getCachedPrecedingSibling(nodeTest);
        if (dOMCachedNode == null) {
            return false;
        }
        this.replaceContextNodeAndState(dOMCachedNode, (short)6);
        this.rootSibling = this.contextNode.reference();
        this.sequenceTest = nodeTest;
        this.idrefsOrIdsCDATA = null;
        return true;
    }

    @Override
    public boolean isWrapped() {
        return true;
    }

    @Override
    public Cursor unwrap() {
        return this.contextNode;
    }

    @Override
    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        this.contextNode.addElement(area, volatileCData, xSTypeDefinition);
    }

    public void addAttributeWithTypeInfo(VolatileCData volatileCData, VolatileCData volatileCData2, XSTypeDefinition xSTypeDefinition, XSAttributeDeclaration xSAttributeDeclaration, AttributePSVI attributePSVI) {
        ((DOMCachedElement)this.contextNode).addAttributeWithTypeInfo(volatileCData, volatileCData2, xSTypeDefinition, xSAttributeDeclaration, attributePSVI);
    }

    @Override
    public Node item(int n2) {
        if (!this.toPosition(n2 + 1)) {
            return null;
        }
        return this.contextNode;
    }

    @Override
    public int getLength() {
        return (int)this.contextSize();
    }

    @Override
    public boolean toFollowingSiblings(NodeTest nodeTest) {
        if (this.contextNode.itemKind() == 2) {
            return false;
        }
        DOMCachedNode dOMCachedNode = this.contextNode.getCachedFollowingSibling(nodeTest);
        if (dOMCachedNode == null) {
            return false;
        }
        this.replaceContextNodeAndState(dOMCachedNode, (short)1);
        this.rootSibling = this.contextNode.reference();
        this.sequenceTest = nodeTest;
        this.idrefsOrIdsCDATA = null;
        return true;
    }

    @Override
    public String toString() {
        return this.contextNode.toStringLazy();
    }

    @Override
    public DocumentInfo itemDocumentInfo() {
        return this.contextNode.itemDocumentInfo();
    }

    @Override
    public boolean itemIsDeepEqualTo(Cursor cursor2, Map<String, Object> map2) {
        return EqualityHelper.isEquals(this, cursor2, map2);
    }

    @Override
    public int validate(int n2) {
        return this.validate(n2, null, null, null);
    }

    @Override
    public int validate(int n2, Locale locale, XSObject xSObject, Map<String, List<String>> map2) {
        Cursor cursor2 = this.fork(true, Cursor.Profile.RANDOM_ACCESS, Cursor.Profile.RANDOM_ACCESS);
        CacheManager.materializeDocument(cursor2);
        cursor2.release();
        TypeRegistry typeRegistry = this.factory().getSessionContext().getTypeRegistry();
        if (typeRegistry != null) {
            return typeRegistry.validate(this, n2, locale, xSObject, map2);
        }
        return 3;
    }

    @Override
    public String itemBaseUri() {
        return this.itemBaseURI();
    }

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        return this.contextNode.cache.serialize(this, map2);
    }

    @Override
    public void addCopy(Cursor.Area area, Cursor cursor2) {
        this.mutate();
        this.contextNode.addCopy(area, cursor2.fork(false, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION.union(Cursor.Profile.TO_NODE_TEST), Cursor.Profile.MINIMAL_STREAMING_NAVIGATION.union(Cursor.Profile.TO_NODE_TEST)));
    }

    @Override
    public Cursor sequenceConcat(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        assert (this != cursor2);
        if (cursor2 == null) {
            Cursor cursor3;
            if (this.sequenceState == 4) {
                cursor3 = AbstractCursor.ownTheCursor(this, bl, bl3);
            } else {
                Cursor cursor4 = AbstractCursor.ownTheCursor(this, bl, bl3);
                cursor3 = CacheNodeSequence.getNewSequence(cursor4, null, false, false);
                cursor4.release();
                assert (!(cursor3 instanceof CacheCursor) || ((CacheCursor)cursor3).sequenceState == 4);
            }
            return cursor3;
        }
        if (cursor2 instanceof CacheCursor && cursor2.unwrap() instanceof DOMCachedNode) {
            if (cursor2 instanceof CacheNodeSequence) {
                Cursor cursor5 = AbstractCursor.ownTheCursor(cursor2, bl2, bl4);
                if (cursor5 instanceof CacheNodeSequence) {
                    CacheNodeSequence cacheNodeSequence = (CacheNodeSequence)cursor5;
                    CacheNodeSequence.prependSequence(this, cacheNodeSequence, bl, bl2);
                    if (bl3) {
                        this.release();
                    }
                    return cacheNodeSequence;
                }
                Cursor cursor6 = AbstractCursor.defaultSequenceConcatWithMultidoc(this, cursor2, profile, profile2, bl, bl2, bl3, bl4);
                return cursor6;
            }
            Cursor cursor7 = AbstractCursor.ownTheCursorIfMightMove(this, bl, bl3);
            Cursor cursor8 = AbstractCursor.ownTheCursorIfMightMove(cursor2, bl2, bl4);
            CacheNodeSequence cacheNodeSequence = CacheNodeSequence.getNewSequence(cursor7, cursor8, bl, bl2);
            AbstractCursor.ownedCleanupIfMightMove(cursor7, bl, true);
            AbstractCursor.ownedCleanupIfMightMove(cursor8, bl2, true);
            return cacheNodeSequence;
        }
        Cursor cursor9 = AbstractCursor.defaultSequenceConcatWithMultidoc(this, cursor2, profile, profile2, bl, bl2, bl3, bl4);
        return cursor9;
    }

    @Override
    public void toLast() {
        while (this.toNext()) {
        }
    }

    @Override
    public Object exportAs(String string2, boolean bl) {
        if ("domNodeList2".equals(string2)) {
            if (bl) {
                return this;
            }
            return (NodeList)((Object)this.fork(false));
        }
        if ("expdom2".equals(string2) || "expdom1".equals(string2) || Node.class.getName().equals(string2)) {
            DOMCachedNode dOMCachedNode = this.contextNode;
            if (bl) {
                this.release();
            }
            return dOMCachedNode;
        }
        return super.exportAs(string2, bl);
    }

    @Override
    public boolean toIds(VolatileCData volatileCData, boolean bl) {
        CacheManager cacheManager = this.contextNode.getCache();
        CData cData = volatileCData.constant(true);
        for (int i = 1; i <= volatileCData.getSize(); ++i) {
            DOMCachedElement dOMCachedElement = cacheManager.getCachedId(cData, i);
            if (bl) {
                if (dOMCachedElement != null) {
                    if (DOMCachedElement.isElementIDTyped(dOMCachedElement.itemXSType())) {
                        if (dOMCachedElement.parent == null || dOMCachedElement.parent.itemKind() != 1) continue;
                        dOMCachedElement = (DOMCachedElement)dOMCachedElement.parent;
                    }
                    this.sequenceState = (short)12;
                    this.replaceContextNode(dOMCachedElement);
                    this.sequenceTest = null;
                    this.idrefsOrIdsCDATA = volatileCData.constant(true);
                    this.idrefsIndexOrDepth = i;
                    return true;
                }
                CacheCursor cacheCursor = (CacheCursor)this.fork(true);
                cacheCursor.toRoot();
                String string2 = volatileCData.getString(i);
                if (string2 == null) continue;
                string2 = ((Object)TypedValueHelper.trim(string2)).toString();
                if (!cacheCursor.toDescendants(null)) continue;
                do {
                    CacheCursor cacheCursor2;
                    if (!(cacheCursor2 = (CacheCursor)cacheCursor.fork(true)).toAttributes(null)) continue;
                    do {
                        Chars chars;
                        String string3;
                        if (!cacheCursor2.contextNode.satisfies(xmlIDNameTest) && !((DOMCachedAttribute)cacheCursor2.contextNode).isId() || !(string3 = ((Object)TypedValueHelper.trim(chars = cacheCursor2.itemStringValueAsChars())).toString()).equals(string2)) continue;
                        this.sequenceState = (short)12;
                        this.replaceContextNode(cacheCursor.contextNode);
                        this.sequenceTest = null;
                        this.idrefsOrIdsCDATA = volatileCData.constant(true);
                        this.idrefsIndexOrDepth = i;
                        return true;
                    } while (cacheCursor2.toNext());
                } while (cacheCursor.toNext());
                continue;
            }
            if (dOMCachedElement == null) continue;
            this.sequenceState = (short)3;
            this.replaceContextNode(dOMCachedElement);
            this.sequenceTest = null;
            this.idrefsOrIdsCDATA = cData;
            this.idrefsIndexOrDepth = i;
            return true;
        }
        return false;
    }

    @Override
    public StripWhitespaceFilter.PrioritizedNameTestList getXSLTPreserveSpaceList() {
        Mediator mediator = this.contextNode.cache.mediator(this.contextNode);
        if (mediator.getWrappedMediator() instanceof StreamingCursorMediatorStripSpace) {
            return ((StreamingCursorMediatorStripSpace)mediator.getWrappedMediator()).getPreserveSpaceRules();
        }
        return null;
    }

    @Override
    public StripWhitespaceFilter.PrioritizedNameTestList getXSLTStripSpaceList() {
        Mediator mediator = this.contextNode.cache.mediator(this.contextNode);
        if (mediator.getWrappedMediator() instanceof StreamingCursorMediatorStripSpace) {
            return ((StreamingCursorMediatorStripSpace)mediator.getWrappedMediator()).getStripSpaceRules();
        }
        return null;
    }

    @Override
    public boolean itemIsSameDocument(Cursor cursor2) {
        CopiedCacheCursor.handlePotentialCopy(cursor2);
        return this.getDelegate().itemIsSameDocument(cursor2);
    }

    @Override
    public boolean itemIsSameNode(Cursor cursor2) {
        CopiedCacheCursor.handlePotentialCopy(cursor2);
        return this.getDelegate().itemIsSameNode(cursor2);
    }

    @Override
    public boolean itemIsBeforeNode(Cursor cursor2) {
        CopiedCacheCursor.handlePotentialCopy(cursor2);
        return this.getDelegate().itemIsBeforeNode(cursor2);
    }

    @Override
    public boolean requiresRelease() {
        return true;
    }
}

