/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.ras.xci.XCICustomLoggers;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.XCIRegistry;
import com.ibm.xml.xci.dp.base.AbstractCursorFactory;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheCursorFactory;
import com.ibm.xml.xci.dp.cache.dom.CopiedCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCacheNodeFactory;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedComment;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedDocument;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedDocumentFragment;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedDocumentType;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedPI;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedText;
import com.ibm.xml.xci.dp.cache.dom.FastAccessSupport;
import com.ibm.xml.xci.dp.cache.dom.InternalNodeData;
import com.ibm.xml.xci.dp.cache.dom.InternalNodeDataFactory;
import com.ibm.xml.xci.dp.cache.dom.StreamingCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.mediator.CopiedCacheMediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.CopiedDataFactory;
import com.ibm.xml.xci.dp.cache.dom.mediator.Mediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.NoMediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.NullDataFactory;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediator;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.dp.util.copy.SerializerCDataLogger;
import com.ibm.xml.xci.dp.values.TypedValueHelper;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.internal.values.BooleanCData;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.util.SimpleKindTest;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.ElementPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager
implements DOMImplementation {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2011. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = LoggerUtil.getLogger(CacheManager.class);
    private static final Class GMSDOClass = XCIRegistry.getInstance().postGMSDORegistered();
    public static final String SDOX_WRAPPER = "SDOX_WRAPPER";
    public static final String FAST_ACCESS = "FAST_ACCESS";
    public static final String TEMP_TREE_PARAMETER = "TEMP_TREE";
    public static final CursorFactory DEFAULT_FACTORY = new CacheCursorFactory(new SessionContext());
    public static final Mediator DEFAULT_MEDIATOR = new NoMediator(DEFAULT_FACTORY);
    public static final CacheManager DEFAULT_CACHE_MANAGER = new CacheManager(DEFAULT_MEDIATOR, null, null);
    private static final short CONFIG_SWITCHED_MEDIATOR = 1;
    private static final short CONFIG_EAGER_LOADING = 2;
    private static final short CONFIG_VALIDATE_LOADING = 4;
    private static final short CONFIG_IS_WRAPPER = 8;
    private static final short CONFIG_ATTEMPT_FAST_SER = 16;
    private static final short CONFIG_IS_MUTATING = 32;
    private static final short CONFIG_CONTAINS_MOVED_COPY = 64;
    private static final short CONFIG_SCHEMA_SPECIALIZED = 128;
    private static final short CONFIG_IS_XDM_XSTAR = 256;
    private static final short CONFIG_NO_NOTIFICATIONS = 512;
    private static final short CONFIG_MTOM_ENABLED = 1024;
    protected static final int NODE_ID_NOT_NATIVELY_SUPPORTED = -2;
    protected static final int NODE_ID_NEEDS_RESET = -1;
    private short cacheManagerState;
    private Mediator mediator;
    private final CursorFactory cursorFactory;
    private final DOMCacheNodeFactory nodeFactory;
    private InternalNodeDataFactory internalNodeDataFactory;
    protected DOMCachedNode rootNode;
    private int globalID;
    private Map<CData, DOMCachedElement> id2elements;
    private Map<CData, List<DOMCachedAttribute>> id2ref;
    private ItemCopier itemCopier;
    protected DocumentInfo myDocumentInfo;
    private final long documentIdentity;
    protected final CopiedCacheMediator copyMediator;
    protected CopyReference firstCopy = null;
    private ReferenceQueue<CacheManager> copyQueue;
    private int namespaceVersion = 0;
    private byte mutationVersion = 0;

    public CacheManager() {
        this(DEFAULT_MEDIATOR, null, null);
    }

    public CacheManager(CursorFactory cursorFactory, Map map2) {
        this(cursorFactory, DOMCacheNodeFactory.DEFAULT_NODE_FACTORY, map2);
    }

    public CacheManager(CursorFactory cursorFactory, DOMCacheNodeFactory dOMCacheNodeFactory, Map map2) {
        this(new NoMediator(cursorFactory), dOMCacheNodeFactory, map2);
    }

    public CacheManager(Mediator mediator, DOMCacheNodeFactory dOMCacheNodeFactory, Map map2) {
        this(mediator, dOMCacheNodeFactory, map2, null);
    }

    protected CacheManager(Mediator mediator, DOMCacheNodeFactory dOMCacheNodeFactory, Map map2, CacheManager cacheManager) {
        if (cacheManager != null) {
            this.copyMediator = new CopiedCacheMediator(cacheManager, this);
            this.mediator = this.copyMediator;
            this.myDocumentInfo = cacheManager.myDocumentInfo;
            this.setAttemptFastSerialization(cacheManager.getAttemptFastSerialization());
            this.setContainsMovedCopy(cacheManager.getContainsMovedCopy());
            this.namespaceVersion = cacheManager.namespaceVersion;
            cacheManager.cleanCopies();
            cacheManager.addCopyReference(this);
        } else {
            this.mediator = mediator == null ? DEFAULT_MEDIATOR : mediator;
            this.copyMediator = null;
            this.setAttemptFastSerialization(this.mediator.fastSerializationEnabled());
        }
        this.documentIdentity = this.mediator.factory().getSessionContext().obtainUniqueDocumentIdentity();
        this.mediator.processParameters(map2);
        this.cursorFactory = this.mediator.factory();
        if (MiscHelpers.getBoolean(SDOX_WRAPPER, map2, false)) {
            this.setIsWrapper(true);
        }
        if (MiscHelpers.getBoolean(TEMP_TREE_PARAMETER, map2, false)) {
            this.setIsXDMXStar(true);
        }
        if (MiscHelpers.isEagerLoading(map2)) {
            this.setIsEagerLoading(true);
        }
        if (MiscHelpers.isValidLoading(map2)) {
            this.setIsValidateLoading(true);
        }
        this.nodeFactory = dOMCacheNodeFactory == null ? DOMCacheNodeFactory.DEFAULT_NODE_FACTORY : dOMCacheNodeFactory;
        this.globalID = 1;
        this.setInternalNodeDataFactory(this.mediator);
        this.itemCopier = null;
        if (map2 != null && map2.get("http://www.ibm.com/xml/xci/attachment-unmarshaller") != null) {
            this.setIsMTOMEnabled(true);
        }
    }

    public final CursorFactory factory() {
        return this.cursorFactory;
    }

    public Mediator mediator() {
        return this.mediator;
    }

    public Mediator mediator(DOMCachedNode dOMCachedNode) {
        return this.mediator(dOMCachedNode, true);
    }

    public Mediator mediator(DOMCachedNode dOMCachedNode, boolean bl) {
        Mediator mediator;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "mediator", "calling mediator for node=" + dOMCachedNode.toStringLazy() + "\nCache manager = " + this.toString() + " | Mediator (for node) = " + dOMCachedNode.getMediatorData() + " | setData = " + bl + " | switchedMediator=" + this.getSwitchedMediator());
        }
        if ((mediator = dOMCachedNode.getMediatorData()) != null) {
            if (bl) {
                this.setInternalNodeDataFactory(mediator);
                this.setSwitchedMediator(true);
            }
            return mediator;
        }
        if (this.getSwitchedMediator() && bl) {
            this.setInternalNodeDataFactory(this.mediator);
            this.setSwitchedMediator(false);
        }
        return this.mediator;
    }

    public final DOMCacheNodeFactory nodeFactory() {
        return this.nodeFactory;
    }

    public final InternalNodeData createUserData(DOMCachedNode dOMCachedNode) {
        return this.internalNodeDataFactory.create(dOMCachedNode);
    }

    public void release() {
    }

    protected CacheManager createCacheManager(Mediator mediator, DOMCacheNodeFactory dOMCacheNodeFactory, CacheManager cacheManager) {
        return new CacheManager(mediator, dOMCacheNodeFactory, null, cacheManager);
    }

    public Cursor copy(DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl, boolean bl2, int n2) {
        if (bl2) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "copy", "entered copy with original = " + dOMCachedNode.toStringLazy());
            }
            CacheManager cacheManager = this.createCacheManager(null, this.nodeFactory, this);
            cacheManager.copyMediator.setOptions(n2);
            DOMCachedNode dOMCachedNode2 = cacheManager.copySingleNode(dOMCachedNode, null, null, false, cacheManager.copyMediator, n2 != 0);
            dOMCachedNode2.getInternalNodeData().setOriginalNode(dOMCachedNode);
            cacheManager.rootNode = dOMCachedNode2;
            if (dOMCachedNode2.getMediatorData() == null) {
                dOMCachedNode2.setMediatorData(cacheManager.copyMediator);
            }
            if (dOMCachedNode.isCopy()) {
                DOMCachedNode dOMCachedNode3 = dOMCachedNode.getOriginalNode();
                while (dOMCachedNode3 != null && cacheManager.getCopiedNode(dOMCachedNode3) == null) {
                    cacheManager.setCopiedNode(dOMCachedNode3, dOMCachedNode2);
                    dOMCachedNode3 = dOMCachedNode3.isCopy() ? dOMCachedNode3.getOriginalNode() : null;
                }
                if (dOMCachedNode.getMediatorData() != null && dOMCachedNode.getMediatorData().getWrappedMediator() instanceof CopiedCacheMediator) {
                    ((CopiedCacheMediator)dOMCachedNode.getMediatorData().getWrappedMediator()).notifyCopyMediator(cacheManager.copyMediator, false);
                }
            }
            if (dOMCachedNode.itemKind() == 1) {
                ((DOMCachedElement)dOMCachedNode2).saveNSListFromOriginal((DOMCachedElement)dOMCachedNode);
            }
            dOMCachedNode2.setState(LazyLoadingHelper.markPrecedingFollowingParentResolved(dOMCachedNode2.state));
            return cacheManager.rootNode.fork(bl, profile, profile);
        }
        boolean bl3 = dOMCachedNode.itemKind() != 9;
        Cursor cursor2 = dOMCachedNode.fork(bl, Copier.SOURCE_FEATURES, Copier.SOURCE_FEATURES);
        Cursor cursor3 = this.document(new RequestInfo(profile.union(Copier.TARGET_FEATURES)));
        Copier.copy(cursor2, cursor3.fork(bl, Copier.TARGET_FEATURES, Copier.TARGET_FEATURES), Cursor.Area.FIRST_CHILD, n2 | 1 | 0x10);
        if (bl3) {
            cursor3.toChildren(null);
        }
        if (dOMCachedNode.itemKind() == 1 && cursor3.unwrap() instanceof DOMCachedElement) {
            ((DOMCachedElement)cursor3.unwrap()).saveNSListFromOriginal((DOMCachedElement)dOMCachedNode);
        }
        return cursor3;
    }

    public boolean containsFastAccess() {
        return false;
    }

    public DOMCachedNode copySingleNode(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2, DOMCachedNode dOMCachedNode3, boolean bl, CopiedCacheMediator copiedCacheMediator, boolean bl2) {
        InternalNodeDataFactory internalNodeDataFactory = this.getInternalNodeDataFactory();
        this.setInternalNodeDataFactory(NullDataFactory.INSTANCE);
        DOMCachedNode dOMCachedNode4 = MiscHelpers.makeNode(dOMCachedNode, this, dOMCachedNode2, dOMCachedNode3);
        this.setInternalNodeDataFactory(internalNodeDataFactory);
        copiedCacheMediator.internalSetCopiedNode(dOMCachedNode, dOMCachedNode4);
        this.processCopiedNode(dOMCachedNode4, bl, dOMCachedNode, copiedCacheMediator, bl2);
        copiedCacheMediator.setCopiedNode(dOMCachedNode, dOMCachedNode4);
        return dOMCachedNode4;
    }

    protected Cursor document(RequestInfo requestInfo) {
        return ((AbstractCursorFactory)this.factory()).document(requestInfo);
    }

    public final DOMCachedNode getCopiedNode(DOMCachedNode dOMCachedNode) {
        return this.copyMediator == null ? null : this.copyMediator.getCopiedNode(dOMCachedNode);
    }

    public final DOMCachedNode getCopiedNodeDeep(DOMCachedNode dOMCachedNode) {
        return this.copyMediator == null ? null : this.copyMediator.getCopiedNodeDeep(dOMCachedNode);
    }

    public final void setCopiedNode(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        if (this.copyMediator != null) {
            this.copyMediator.setCopiedNode(dOMCachedNode, dOMCachedNode2);
        }
    }

    protected void notifyNodeAboutToChangeToCopies(DOMCachedNode dOMCachedNode, Cursor.Area.ImmediateAreas immediateAreas) {
        this.notifyNodeAboutToChangeToCopies(dOMCachedNode, immediateAreas, false);
    }

    protected void notifyNodeAboutToChangeToCopies(DOMCachedNode dOMCachedNode, Cursor.Area.ImmediateAreas immediateAreas, boolean bl) {
        if (dOMCachedNode == null || this.disabledNotification()) {
            return;
        }
        boolean bl2 = LoggerUtil.isAnyTracingEnabled();
        if (bl2 && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "notifyNodeAboutToChangeToCopies", "About to mutate the node=" + dOMCachedNode.toStringLazy() + " in area=" + immediateAreas.toString() + "\nStack trace= " + XCIErrorHelper.getStackTrace(30));
        }
        this.setReadOnlyTransform(false);
        if (immediateAreas == Cursor.Area.FOLLOWING_SIBLING.immediateArea() && dOMCachedNode.following != null) {
            this.mediator.reportMutation(dOMCachedNode.following, true);
        } else {
            this.mediator.reportMutation(dOMCachedNode, bl);
        }
        CopyReference copyReference = this.firstCopy;
        if (copyReference != null) {
            Object object2;
            if (bl2 && logger.isLoggable(Level.FINEST)) {
                object2 = new StringBuilder();
                CopyReference copyReference2 = copyReference;
                while (copyReference2 != null) {
                    if (copyReference2.get() != null) {
                        ((StringBuilder)object2).append(((CacheManager)copyReference2.get()).copyMediator);
                        ((StringBuilder)object2).append('\n');
                    }
                    copyReference2 = copyReference2.nextReference;
                }
                if (this.copyMediator != null) {
                    ((StringBuilder)object2).append(this.copyMediator);
                }
                logger.logp(Level.FINEST, logger.getName(), "notifyNodeAboutToChangeToCopies", "Notification list= " + ((StringBuilder)object2).toString());
            }
            object2 = copyReference;
            while (object2 != null) {
                if (((Reference)object2).get() != null) {
                    ((CacheManager)((Reference)object2).get()).copyMediator.nodeAboutToChange(dOMCachedNode, immediateAreas);
                }
                object2 = ((CopyReference)object2).nextReference;
            }
        }
        if (this.copyMediator != null) {
            this.copyMediator.nodeAboutToChange(dOMCachedNode, immediateAreas);
        }
    }

    protected final void registerCopiedCursorWithOriginal(CopiedCacheCursor copiedCacheCursor) {
        this.copyMediator.registerCopiedCursorWithOriginal(copiedCacheCursor);
    }

    protected final void unregisterCopiedCursorWithOriginal(CopiedCacheCursor copiedCacheCursor) {
        this.copyMediator.unregisterCopiedCursorWithOriginal(copiedCacheCursor);
    }

    public final DOMCachedNode copyToOriginalNode(DOMCachedNode dOMCachedNode, boolean bl) {
        return this.copyMediator.copyToOriginalNode(dOMCachedNode, bl);
    }

    public final DOMCachedNode copyToOriginalNode(DOMCachedNode dOMCachedNode) {
        return this.copyMediator.copyToOriginalNode(dOMCachedNode);
    }

    public DOMCachedElement getBuiltElemById(CData cData) {
        this.ensureIDMapInitialized();
        return this.id2elements.get(cData);
    }

    public DOMCachedNode getBuiltId(CData cData, int n2) {
        this.ensureIDMapInitialized();
        return this.getBuiltElemById(cData.itemAt(n2));
    }

    public DOMCachedElement getCachedId(CData cData, int n2) {
        CData cData2 = cData.itemAt(n2);
        this.ensureIDMapInitialized();
        DOMCachedElement dOMCachedElement = this.id2elements.get(cData2);
        if (dOMCachedElement == null) {
            DOMCachedElement dOMCachedElement2 = (DOMCachedElement)(this.rootNode.itemKind() == 1 ? this.rootNode : this.rootNode.getCachedFirstChild(SimpleKindTest.ELEMENT));
            dOMCachedElement = this.searchElementForId(dOMCachedElement2, cData2);
        }
        return dOMCachedElement;
    }

    private DOMCachedElement searchElementForId(DOMCachedElement dOMCachedElement, CData cData) {
        if (dOMCachedElement == null) {
            return null;
        }
        dOMCachedElement.visitAttributes();
        if (this.id2elements.get(cData) != null) {
            return this.id2elements.get(cData);
        }
        for (DOMCachedElement dOMCachedElement2 = (DOMCachedElement)dOMCachedElement.getCachedFirstChild(SimpleKindTest.ELEMENT); dOMCachedElement2 != null; dOMCachedElement2 = (DOMCachedElement)dOMCachedElement2.getCachedFollowingSibling(SimpleKindTest.ELEMENT)) {
            if (this.searchElementForId(dOMCachedElement2, cData) == null) continue;
            return this.id2elements.get(cData);
        }
        return null;
    }

    public List<DOMCachedAttribute> getCachedIdRefs(VolatileCData volatileCData, int n2) {
        this.ensureIDREFMapInitialized();
        return this.id2ref.get(volatileCData.constant(true).itemAt(n2));
    }

    Iterator<DOMCachedAttribute> lookupID(CData cData) {
        return null;
    }

    public void addID(DOMCachedAttribute dOMCachedAttribute) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addID", "adding ID for attribute=" + dOMCachedAttribute.toStringLazy());
        }
        this.ensureIDMapInitialized();
        StringCData stringCData = new StringCData(((Object)TypedValueHelper.trim(dOMCachedAttribute.itemStringValueAsChars())).toString(), TypeRegistry.XSSTRING);
        DOMCachedElement dOMCachedElement = this.id2elements.get(stringCData);
        if (dOMCachedElement == null || dOMCachedAttribute.parent.itemIsBeforeNode(dOMCachedElement)) {
            this.id2elements.put(stringCData, (DOMCachedElement)dOMCachedAttribute.parent);
        }
    }

    private void ensureIDMapInitialized() {
        if (this.id2elements == null) {
            this.id2elements = new HashMap<CData, DOMCachedElement>();
        }
    }

    private void ensureIDREFMapInitialized() {
        if (this.id2ref == null) {
            this.id2ref = new HashMap<CData, List<DOMCachedAttribute>>();
        }
    }

    public void addID(DOMCachedElement dOMCachedElement) {
        StringCData stringCData;
        block3: {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "addID", "adding ID for element=" + dOMCachedElement.toStringLazy());
            }
            this.ensureIDMapInitialized();
            stringCData = null;
            try {
                stringCData = new StringCData(((Object)TypedValueHelper.trim(dOMCachedElement.itemStringValueAsChars())).toString(), TypeRegistry.XSSTRING);
            }
            catch (Exception exception) {
                if (!LoggerUtil.isAnyTracingEnabled() || !logger.isLoggable(Level.FINEST)) break block3;
                logger.logp(Level.FINEST, logger.getName(), "addID", "Got the following exception while trying to add an element as an ID: " + exception.getMessage() + "\n" + XCIErrorHelper.getStackTrace(20));
                return;
            }
        }
        this.id2elements.put(stringCData, dOMCachedElement);
    }

    public void addIDREF(DOMCachedAttribute dOMCachedAttribute) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addIDREF", "registering IDREF: " + dOMCachedAttribute.toStringLazy());
        }
        this.ensureIDREFMapInitialized();
        String[] stringArray = dOMCachedAttribute.itemTypedValue().constant(true).toString().split("\\s");
        for (int i = 0; i < stringArray.length; ++i) {
            CData cData = dOMCachedAttribute.factory().data((CharSequence)stringArray[i], null, false);
            List<DOMCachedAttribute> list = this.id2ref.get(cData);
            if (list == null) {
                list = new ArrayList<DOMCachedAttribute>();
            }
            for (int j = 0; j < list.size(); ++j) {
                if (list.get(j) != dOMCachedAttribute) continue;
                return;
            }
            list.add(dOMCachedAttribute);
            this.id2ref.put(cData, list);
        }
    }

    public void removeID(DOMCachedAttribute dOMCachedAttribute) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "removeID", "removing ID for attribute=" + dOMCachedAttribute.toStringLazy());
        }
        this.ensureIDMapInitialized();
        this.id2elements.remove(dOMCachedAttribute.itemTypedValue());
    }

    public void removeID(DOMCachedElement dOMCachedElement) {
        block3: {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "removeID", "removing ID for element =" + dOMCachedElement.toStringLazy());
            }
            this.ensureIDMapInitialized();
            try {
                this.id2elements.remove(dOMCachedElement.itemTypedValue());
            }
            catch (Exception exception) {
                if (!LoggerUtil.isAnyTracingEnabled() || !logger.isLoggable(Level.FINEST)) break block3;
                logger.logp(Level.FINEST, logger.getName(), "removeID", "Got the following exception while trying to remove an element as an ID: " + exception.getMessage() + "\n" + XCIErrorHelper.getStackTrace(20));
                return;
            }
        }
    }

    public void removeIDREF(DOMCachedAttribute dOMCachedAttribute) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "removeIDREF", "removing IDREF=" + dOMCachedAttribute.toStringLazy());
        }
        this.ensureIDREFMapInitialized();
        this.id2ref.remove(dOMCachedAttribute.itemTypedValue());
    }

    public boolean supportOrderedIDLabel() {
        return false;
    }

    public boolean supportIDLabel() {
        return false;
    }

    public final boolean isCopy() {
        return this.copyMediator != null;
    }

    public void referenced(DOMCachedNode dOMCachedNode) {
    }

    public void unreferenced(DOMCachedNode dOMCachedNode) {
    }

    public void addCursor(Cursor cursor2) {
    }

    public void removeCursor(Cursor cursor2) {
    }

    public DOMCachedNode getBuiltRootNode() {
        return this.rootNode;
    }

    public void setRootNode(DOMCachedNode dOMCachedNode) {
        this.rootNode = dOMCachedNode;
    }

    public void incrementMutationVersion() {
        if (this.mutationVersion != 127) {
            this.mutationVersion = (byte)(this.mutationVersion + 1);
        }
    }

    public byte getMutationVersion() {
        return this.mutationVersion;
    }

    public DOMCachedNode loadCachedFirstTopItem(String string2, String string3) {
        Cursor cursor2 = this.mediator.focus();
        if (cursor2 != null) {
            this.setDocumentInfo(cursor2.itemDocumentInfo());
        }
        this.rootNode = this.mediator.buildFirstTopItem(this, string2, string3);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "loadCachedFirstTopItem", "rootNode =" + this.rootNode.toStringLazy());
        }
        return this.rootNode;
    }

    public void ensureStateResolved(DOMCachedNode dOMCachedNode, Cursor.Area area) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "ensureStateResolved", "node=" + dOMCachedNode.toStringLazy() + " | area=" + area);
        }
        if (area == Cursor.Area.ALL) {
            if (dOMCachedNode.isCopy()) {
                Mediator mediator = dOMCachedNode.cache.mediator(dOMCachedNode, false);
                if (mediator != null && mediator.getWrappedMediator() instanceof CopiedCacheMediator) {
                    ((CopiedCacheMediator)mediator.getWrappedMediator()).copySubtreeEager(dOMCachedNode);
                    return;
                }
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, logger.getName(), "ensureStateResolved", "Could not populate the copied node because the mediator returned was: " + mediator);
                }
            }
            MiscHelpers.visitSubtree(dOMCachedNode);
            return;
        }
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                if (LazyLoadingHelper.isFirstChildBuilt(dOMCachedNode.state)) break;
                dOMCachedNode.getCachedFirstChild();
                break;
            }
            case LAST_CHILD: {
                if (LazyLoadingHelper.isChildrenResolved(dOMCachedNode.state)) break;
                MiscHelpers.visitChildren(dOMCachedNode);
                break;
            }
            case IMMEDIATE_FOLLOWING: 
            case SUBTREE: {
                if (LazyLoadingHelper.isFollowingBuilt(dOMCachedNode.state)) break;
                dOMCachedNode.getCachedFollowingSibling();
                break;
            }
            case ATTRIBUTE: {
                if (LazyLoadingHelper.isLastAttributeBuilt(dOMCachedNode.state)) break;
                dOMCachedNode.getCachedLastAttribute();
                break;
            }
            case NAMESPACE_DECLS: {
                if (LazyLoadingHelper.isLastNamespaceBuilt(dOMCachedNode.state)) break;
                dOMCachedNode.getCachedLastNamespaceNode();
                break;
            }
            case SELF: {
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
    }

    public DOMCachedDocument getCachedDocument() {
        return (DOMCachedDocument)(this.rootNode instanceof DOMCachedDocument ? this.rootNode : null);
    }

    public Cursor.Profile featuresLimit(DOMCachedNode dOMCachedNode) {
        return CacheCursor.FEATURES_LIMIT;
    }

    public Cursor fork(DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl, Cursor.Profile profile2) {
        if (LoggerUtil.isAnyTracingEnabled()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "fork", "forking from CacheManager\n\nStack trace= " + XCIErrorHelper.getStackTrace(15));
            } else if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "fork", "forking from CacheManager");
            }
        }
        if (dOMCachedNode.cache.isCopy()) {
            return new CopiedCacheCursor(dOMCachedNode.cache, dOMCachedNode, bl);
        }
        if (profile.containedIn(dOMCachedNode.profile())) {
            return dOMCachedNode.reference();
        }
        if (profile.containedIn(StreamingCacheCursor.PROFILE_LIMIT)) {
            return new StreamingCacheCursor(dOMCachedNode, profile, bl);
        }
        return this.popCacheCursor(dOMCachedNode, profile, bl);
    }

    public final void free(DOMCachedNode dOMCachedNode) {
    }

    public VolatileCData serialize(Cursor cursor2, Map<String, Object> map2) {
        CharSequence charSequence;
        CharSequence charSequence2;
        DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            charSequence2 = null;
            if (map2 != null) {
                charSequence = new StringBuilder(map2.size());
                Iterator<String> iterator = map2.keySet().iterator();
                ((StringBuilder)charSequence).append('{');
                while (iterator.hasNext()) {
                    String string2 = iterator.next();
                    ((StringBuilder)charSequence).append('(');
                    ((StringBuilder)charSequence).append(string2);
                    ((StringBuilder)charSequence).append(',');
                    ((StringBuilder)charSequence).append(map2.get(string2));
                    ((StringBuilder)charSequence).append(')');
                }
                ((StringBuilder)charSequence).append('}');
                charSequence2 = ((StringBuilder)charSequence).toString();
            }
            logger.logp(Level.FINEST, logger.getName(), "serialize", "serializing from CacheManager{" + this.toString() + "},\n for node={" + dOMCachedNode.toStringLazy() + "},\n  with parameters={" + (String)charSequence2 + "}");
        }
        if (this.isCopy() && LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "serialize", "serializing a copy from CacheManager, for node=" + dOMCachedNode.toStringLazy());
        }
        if (dOMCachedNode.itemKind() == 1) {
            if (cursor2 instanceof CopiedCacheCursor) {
                ((CopiedCacheCursor)cursor2).copyTo(Cursor.Area.NAMESPACE_DECLS);
                dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
            }
            if (dOMCachedNode.parent != null && dOMCachedNode.parent.itemKind() == 1) {
                ((DOMCachedElement)dOMCachedNode).saveNSList(false);
            }
            if (((DOMCachedElement)dOMCachedNode).hasPendingNSDecls()) {
                ((DOMCachedElement)dOMCachedNode).loadNSList(null);
            }
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "serialize", "about to call mediator().serialize for the following built tree: " + dOMCachedNode.toStringLazy(null, "", true));
            if (dOMCachedNode.itemKind() == 1) {
                charSequence2 = dOMCachedNode.itemName().getQNameNamespaceURI(1);
                charSequence = dOMCachedNode.itemName().getQNameLocalPart(1);
                logger.logp(Level.FINEST, logger.getName(), "serialize", "Qualified name = {" + (String)charSequence2 + "}" + (String)charSequence);
            }
        }
        charSequence2 = this.mediator().serialize(cursor2, map2);
        if (LoggerUtil.isAnyTracingEnabled() && XCICustomLoggers.serializationLogger.isLoggable(Level.FINER)) {
            XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "serialize", "serializer returned is: " + LoggerUtil.getUniqueString(charSequence2));
            charSequence2 = new SerializerCDataLogger(charSequence2.getXSTypeDefinition(), (VolatileCData)charSequence2);
        }
        return charSequence2;
    }

    public DOMCachedElement makeCachedElement(VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition, ElementPSVI elementPSVI, XSElementDeclaration xSElementDeclaration, boolean bl, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        return this.nodeFactory.makeCachedElement(this, volatileCData, xSTypeDefinition, elementPSVI, xSElementDeclaration, bl, dOMCachedContainer, dOMCachedNode);
    }

    public DOMCachedAttribute makeCachedAttribute(VolatileCData volatileCData, VolatileCData volatileCData2, AttributePSVI attributePSVI, XSAttributeDeclaration xSAttributeDeclaration, DOMCachedElement dOMCachedElement) {
        return this.nodeFactory.makeCachedAttribute(this, volatileCData, volatileCData2, attributePSVI, xSAttributeDeclaration, dOMCachedElement);
    }

    public DOMCachedComment makeCachedComment(VolatileCData volatileCData, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        return this.nodeFactory.makeCachedComment(this, volatileCData, dOMCachedContainer, dOMCachedNode);
    }

    public DOMCachedDocument makeCachedDocument(String string2, String string3) {
        return this.nodeFactory.makeCachedDocument(this, string2, string3);
    }

    public DOMCachedDocumentFragment makeCachedDocumenFragment() {
        return this.nodeFactory.makeCachedDocumentFragment(this);
    }

    public DOMCachedPI makeCachedPI(VolatileCData volatileCData, VolatileCData volatileCData2, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        return this.nodeFactory.makeCachedPI(this, volatileCData, volatileCData2, dOMCachedContainer, dOMCachedNode);
    }

    public DOMCachedText makeCachedText(VolatileCData volatileCData, boolean bl, boolean bl2, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        return this.nodeFactory.makeCachedText(this, volatileCData, bl, bl2, dOMCachedContainer, dOMCachedNode);
    }

    public DOMCachedNamespace makeCachedNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, DOMCachedElement dOMCachedElement) {
        return this.nodeFactory.makeCachedNamespaceNode(this, volatileCData, volatileCData2, dOMCachedElement);
    }

    @Override
    public boolean hasFeature(String string2, String string3) {
        if (string3 == null || string3.length() == 0 || string3.equals("1.0") || string3.equals("2.0")) {
            if ("Core".equals(string2)) {
                return true;
            }
            if ("XML".equals(string2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Document createDocument(String string2, String string3, DocumentType documentType) throws DOMException {
        if (this.rootNode != null) {
            return new CacheManager().createDocument(string2, string3, documentType);
        }
        DOMCachedDocument dOMCachedDocument = this.nodeFactory.makeCachedDocument(this, string2, string3);
        if (!(documentType instanceof DOMCachedDocumentType)) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        dOMCachedDocument.setDocumentType((DOMCachedDocumentType)documentType);
        return dOMCachedDocument;
    }

    @Override
    public DocumentType createDocumentType(String string2, String string3, String string4) throws DOMException {
        return new DOMCachedDocumentType(this, string2, string3, string4);
    }

    @Override
    public Object getFeature(String string2, String string3) {
        return null;
    }

    public DocumentInfo getDocumentInfo() {
        return this.myDocumentInfo;
    }

    public void setDocumentInfo(DocumentInfo documentInfo) {
        this.myDocumentInfo = documentInfo;
    }

    public CacheManager getNewInstance() {
        CacheManager cacheManager = new CacheManager(this.mediator, null, null);
        Cursor cursor2 = this.mediator().focus();
        if (cursor2 == null) {
            cacheManager.setMediator(new NoMediator(this.mediator().factory()));
        } else {
            cacheManager.setMediator(new StreamingCursorMediator(cursor2, cursor2.profile()));
        }
        return cacheManager;
    }

    public void registerNode(DOMCachedNode dOMCachedNode) {
        InternalNodeData internalNodeData = this.createUserData(dOMCachedNode);
        if (internalNodeData != null) {
            dOMCachedNode.setInternalNodeData(internalNodeData);
            if (dOMCachedNode.parent != null && dOMCachedNode.parent.getInternalNodeData() != null) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, logger.getName(), "registerNode", "setting a mediator data as the same as parent: " + dOMCachedNode.parent.getInternalNodeData().toString());
                }
                internalNodeData.setMediatorData(dOMCachedNode.parent.getInternalNodeData().cloneMediator(dOMCachedNode));
            } else if (dOMCachedNode.preceding != null && dOMCachedNode.preceding.getInternalNodeData() != null) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, logger.getName(), "registerNode", "setting a mediator data as the same as preceding sibling: " + dOMCachedNode.preceding.getInternalNodeData().toString());
                }
                internalNodeData.setMediatorData(dOMCachedNode.preceding.getInternalNodeData().cloneMediator(dOMCachedNode));
            }
        }
        if (dOMCachedNode.parent != null && dOMCachedNode.parent.getSubtreeID() != -1) {
            if (dOMCachedNode.preceding != null && dOMCachedNode.preceding.getSubtreeID() != -1) {
                dOMCachedNode.addSiblingID(dOMCachedNode.preceding.getSubtreeID());
            } else {
                DOMCachedAttribute dOMCachedAttribute = dOMCachedNode.parent.getBuiltLastAttribute();
                DOMCachedNamespace dOMCachedNamespace = dOMCachedNode.parent.getBuiltLastNamespace();
                if (dOMCachedAttribute != null && dOMCachedAttribute.getSubtreeID() != -1) {
                    dOMCachedNode.addSiblingID(dOMCachedAttribute.getSubtreeID());
                } else if (dOMCachedNamespace != null && dOMCachedNamespace.getSubtreeID() != -1) {
                    dOMCachedNode.addSiblingID(dOMCachedNamespace.getSubtreeID());
                } else {
                    dOMCachedNode.setSubtreeID((short)0);
                }
            }
        }
        if (dOMCachedNode.getNodeID() == 0) {
            this.assignGlobalID(dOMCachedNode);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "registerNode", "registered a node with nodeID=" + dOMCachedNode.getNodeID() + " and subtreeID=" + dOMCachedNode.getSubtreeIDAsString());
        }
    }

    private void assignGlobalID(DOMCachedNode dOMCachedNode) {
        dOMCachedNode.setNodeID(this.getNextGlobalID());
    }

    public int getNextGlobalID() {
        return ++this.globalID;
    }

    public void incrementNamespaceVersion() {
        ++this.namespaceVersion;
    }

    public boolean openMutation(DOMCachedNode dOMCachedNode, Cursor.Area area) {
        if (Cursor.Area.NAMESPACE_DECLS.containedIn(area)) {
            this.incrementNamespaceVersion();
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "openMutation", "opening a mutation for node: " + dOMCachedNode.toStringLazy());
        }
        return true;
    }

    public void closeMutation(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "closeMutation", "closing mutation for node: " + dOMCachedNode.toStringLazy());
        }
    }

    public long documentIdentify() {
        return this.documentIdentity;
    }

    public CacheCursor popCacheCursor(DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl) {
        return this.popCacheCursor(dOMCachedNode, profile, bl, null);
    }

    public CacheCursor popCacheCursor(DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl, NodeTest nodeTest) {
        if (dOMCachedNode.cache.isCopy()) {
            return new CopiedCacheCursor(dOMCachedNode.cache, dOMCachedNode, profile, bl, nodeTest);
        }
        return new CacheCursor(dOMCachedNode, profile, bl, nodeTest);
    }

    public CacheCursor popCacheCursor(CacheCursor cacheCursor, Cursor.Profile profile, boolean bl) {
        return null;
    }

    public ItemCopier getItemCopier() {
        return this.itemCopier;
    }

    public void setItemCopier(ItemCopier itemCopier) {
        this.itemCopier = itemCopier;
    }

    public int getNamespaceVersion() {
        return this.namespaceVersion;
    }

    public void setMediator(Mediator mediator) {
        this.mediator = mediator;
    }

    private void setInternalNodeDataFactory(Mediator mediator) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "setInternalNodeDataFactory", "About to use InternalNodeDataFactory from mediator: " + mediator.toString());
        }
        this.setInternalNodeDataFactory(mediator.getUserDataFactory());
    }

    public void setInternalNodeDataFactory(InternalNodeDataFactory internalNodeDataFactory) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "setInternalNodeDataFactory", "Changing InternalNodeDataFactory to be: " + internalNodeDataFactory + "\n Inside CacheManager: " + this.toString() + "\n Stack Trace: " + XCIErrorHelper.getStackTrace(20));
        }
        this.internalNodeDataFactory = internalNodeDataFactory;
    }

    public InternalNodeDataFactory getInternalNodeDataFactory() {
        return this.internalNodeDataFactory;
    }

    public static boolean materializeDocument(Cursor cursor2) {
        return CacheManager.materializeDocument(cursor2, null);
    }

    public static boolean materializeDocument(Cursor cursor2, Executable executable) {
        return true;
    }

    public static Cursor treatAsRoot(Cursor cursor2, Cursor.Area area, Cursor.Profile profile) {
        boolean bl = LoggerUtil.isFineLoggable(logger);
        if (cursor2 instanceof FastAccessSupport) {
            if (cursor2.exportAsClass("exportdatatobject") != null) {
                cursor2.exportAs("exportdatatobject", false);
            }
        } else if (cursor2.unwrap() instanceof FastAccessSupport && cursor2.unwrap().exportAsClass("exportdatatobject") != null) {
            cursor2.unwrap().exportAs("exportdatatobject", false);
        }
        if (!(cursor2.unwrap() instanceof DOMCachedNode)) {
            if (bl) {
                logger.logp(Level.FINE, logger.getName(), "treatAsRoot", "Cursor does not wrap a DOMCachedNode: " + cursor2.getClass().getName());
            }
            return null;
        }
        if (cursor2.itemKind() == 9) {
            if (bl) {
                logger.logp(Level.FINE, logger.getName(), "treatAsRoot", "Context item is already a document node.");
            }
            return cursor2;
        }
        Cursor cursor3 = cursor2.fork(true, profile, profile);
        if (cursor3 instanceof CopiedCacheCursor) {
            ((CopiedCacheCursor)cursor3).copyTo(Cursor.Area.SELF);
        }
        if (bl) {
            logger.logp(Level.FINE, logger.getName(), "treatAsRoot", "About to do treatAsRoot into area{" + area.toString() + "} for node=" + ((DOMCachedNode)cursor3.unwrap()).toStringLazy(null, "", true));
        }
        DOMCachedContainer dOMCachedContainer = (DOMCachedContainer)cursor3.unwrap();
        NodeSiblingSnapShot nodeSiblingSnapShot = null;
        if (area.equals(Cursor.Area.SELF)) {
            if (cursor3 instanceof CopiedCacheCursor) {
                ((CopiedCacheCursor)cursor3).copyTo(Cursor.Area.FOLLOWING_SIBLING);
            }
            nodeSiblingSnapShot = new NodeSiblingSnapShot(dOMCachedContainer);
        } else if (area.equals(Cursor.Area.CHILD)) {
            if (!cursor3.toChildren(null)) {
                if (bl) {
                    logger.logp(Level.FINE, logger.getName(), "treatAsRoot", "Area.CHILD was specified, but this Cursor has no children.  Creating empty ManufacturedRootNode");
                }
                ManufacturedRootNode manufacturedRootNode = new ManufacturedRootNode(dOMCachedContainer.cache.rootNode);
                manufacturedRootNode.cache.rootNode = manufacturedRootNode;
                if (cursor3 instanceof CopiedCacheCursor) {
                    return new CopiedCacheCursor(dOMCachedContainer.cache, manufacturedRootNode, profile, false);
                }
                return dOMCachedContainer.cache.popCacheCursor(manufacturedRootNode, profile, false);
            }
        } else {
            if (bl) {
                logger.logp(Level.FINE, logger.getName(), "treatAsRoot", "WARNING: Wrong Area argument passed in.  Must be Area.SELF or Area.CHILD.  It is: " + area.toString() + "\nStack=" + XCIErrorHelper.getStackTrace(15));
            }
            return null;
        }
        if (cursor3 instanceof CopiedCacheCursor) {
            ((CopiedCacheCursor)cursor3).copyTo(Cursor.Area.SELF);
        } else if (cursor3 instanceof FastAccessSupport) {
            if (cursor3.exportAsClass("exportdatatobject") != null) {
                cursor3.exportAs("exportdatatobject", false);
            }
        } else if (cursor3.unwrap() instanceof FastAccessSupport && cursor3.unwrap().exportAsClass("exportdatatobject") != null) {
            cursor3.unwrap().exportAs("exportdatatobject", false);
        }
        DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor3.unwrap();
        dOMCachedNode.setState(BitMaskHelper.stateSet(dOMCachedNode.state, 0x20000000));
        ManufacturedRootNode manufacturedRootNode = new ManufacturedRootNode(dOMCachedNode.cache.rootNode, dOMCachedNode, nodeSiblingSnapShot);
        dOMCachedNode.cache.rootNode = manufacturedRootNode;
        boolean bl2 = cursor3.toRoot();
        if (bl) {
            if (!bl2 || cursor3.unwrap() != manufacturedRootNode) {
                logger.logp(Level.FINE, logger.getName(), "treatAsRoot", "WARNING: something went wrong and we couldn't go toRoot.  Returning Cursor= " + cursor3);
            } else {
                logger.logp(Level.FINE, logger.getName(), "treatAsRoot", "Exiting with cursor=" + cursor3);
            }
        }
        return cursor3;
    }

    public static void resetRoot(Cursor cursor2, Cursor.Area area) {
        boolean bl = LoggerUtil.isFineLoggable(logger);
        if (bl) {
            logger.logp(Level.FINE, logger.getName(), "resetRoot", "Entering resetRoot with for area=" + area.toString() + " and cursor=" + cursor2);
        }
        if (cursor2 instanceof FastAccessSupport) {
            if (cursor2.exportAsClass("exportdatatobject") != null) {
                cursor2.exportAs("exportdatatobject", false);
            }
        } else if (cursor2.unwrap() instanceof FastAccessSupport && cursor2.unwrap().exportAsClass("exportdatatobject") != null) {
            cursor2.unwrap().exportAs("exportdatatobject", false);
        }
        if (!(cursor2.unwrap() instanceof DOMCachedNode)) {
            if (bl) {
                logger.logp(Level.FINE, logger.getName(), "resetRoot", "Cursor does not wrap a DOMCachedNode: " + cursor2.getClass().getName());
            }
            return;
        }
        if (cursor2.itemKind() == 9) {
            if (bl) {
                logger.logp(Level.FINE, logger.getName(), "resetRoot", "Context item is already a document node.");
            }
            return;
        }
        DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
        if (!(dOMCachedNode.cache.rootNode instanceof ManufacturedRootNode)) {
            if (bl) {
                logger.logp(Level.FINE, logger.getName(), "resetRoot", "The rootNode of the CacheManager governing the passed-in Cursor is not a ManufacturedRootNode...check usage.\nStack=" + XCIErrorHelper.getStackTrace(15));
            }
            return;
        }
        ManufacturedRootNode manufacturedRootNode = (ManufacturedRootNode)dOMCachedNode.cache.rootNode;
        if (area.equals(Cursor.Area.SELF)) {
            dOMCachedNode.setState(BitMaskHelper.stateUnset(dOMCachedNode.state, 0x20000000));
            if (manufacturedRootNode.getSiblingSnapShot() != null) {
                manufacturedRootNode.getSiblingSnapShot().restoreSiblingSnapShot(dOMCachedNode);
            }
            dOMCachedNode.cache.rootNode = manufacturedRootNode.getOriginalRoot();
        } else if (area.equals(Cursor.Area.CHILD)) {
            DOMCachedNode dOMCachedNode2 = dOMCachedNode.cache.rootNode.getBuiltFirstChild();
            if (dOMCachedNode2 == null) {
                if (bl) {
                    logger.logp(Level.FINE, logger.getName(), "resetRoot", "Resetting a CacheManager which didn't add any children during execution.  Check usage.\nStack=" + XCIErrorHelper.getStackTrace(15));
                }
                dOMCachedNode.cache.rootNode = manufacturedRootNode.getOriginalRoot();
                return;
            }
            if (dOMCachedNode2.parent == manufacturedRootNode) {
                dOMCachedNode2.setParent((DOMCachedContainer)dOMCachedNode);
                if (dOMCachedNode.getCachedFirstChild() != dOMCachedNode2) {
                    ((DOMCachedContainer)dOMCachedNode).setBuiltFirstChild(dOMCachedNode2);
                }
            }
            dOMCachedNode2.setState(BitMaskHelper.stateUnset(dOMCachedNode2.state, 0x20000000));
            while ((dOMCachedNode2 = dOMCachedNode2.getBuiltFollowingSibling()) != null) {
                if (dOMCachedNode2.parent == manufacturedRootNode) {
                    dOMCachedNode2.setParent((DOMCachedContainer)dOMCachedNode);
                }
                dOMCachedNode2.setState(BitMaskHelper.stateUnset(dOMCachedNode2.state, 0x20000000));
            }
            dOMCachedNode.cache.rootNode = manufacturedRootNode.getOriginalRoot();
        } else if (bl) {
            logger.logp(Level.FINE, logger.getName(), "resetRoot", "WARNING: Wrong Area argument passed in.  Must be Area.SELF or Area.CHILD.  It is: " + area.toString() + "\nStack=" + XCIErrorHelper.getStackTrace(15));
        }
    }

    private static boolean processWhitespaceOptions(Map<String, Object> map2) {
        return map2 != null && (map2.get("http://www.ibm.com/xmlns/prod/xcij/strip-space") != null || map2.get("http://www.ibm.com/xmlns/prod/xcij/preserve-space") != null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CacheManager class = ");
        stringBuilder.append(LoggerUtil.getUniqueString(this));
        stringBuilder.append("\n");
        stringBuilder.append("Copy Mediator=");
        stringBuilder.append(this.copyMediator);
        stringBuilder.append("\n");
        stringBuilder.append("Regular Mediator=");
        stringBuilder.append(this.mediator);
        stringBuilder.append("\n");
        stringBuilder.append("ReadOnlyTransform=");
        stringBuilder.append(this.isReadOnlyTransform());
        stringBuilder.append("\n");
        stringBuilder.append("ContainsMovedCopy=");
        stringBuilder.append(this.getContainsMovedCopy());
        return stringBuilder.toString();
    }

    private void setCacheManagerState(short s) {
        this.cacheManagerState = s;
    }

    public boolean getAttemptFastSerialization() {
        return BitMaskHelper.stateContainsShort(this.cacheManagerState, (short)16);
    }

    public void setAttemptFastSerialization(boolean bl) {
        if (bl) {
            this.setCacheManagerState(BitMaskHelper.stateSetShort(this.cacheManagerState, (short)16));
        } else {
            this.setCacheManagerState(BitMaskHelper.stateUnsetShort(this.cacheManagerState, (short)16));
        }
    }

    public void disableNotification(boolean bl) {
        if (bl) {
            this.setCacheManagerState(BitMaskHelper.stateSetShort(this.cacheManagerState, (short)512));
        } else {
            this.setCacheManagerState(BitMaskHelper.stateUnsetShort(this.cacheManagerState, (short)512));
        }
    }

    public boolean disabledNotification() {
        return BitMaskHelper.stateContainsShort(this.cacheManagerState, (short)512);
    }

    public boolean getContainsMovedCopy() {
        return BitMaskHelper.stateContainsShort(this.cacheManagerState, (short)64);
    }

    public void setContainsMovedCopy(boolean bl) {
        if (bl) {
            this.setCacheManagerState(BitMaskHelper.stateSetShort(this.cacheManagerState, (short)64));
        } else {
            this.setCacheManagerState(BitMaskHelper.stateUnsetShort(this.cacheManagerState, (short)64));
        }
    }

    public boolean getSwitchedMediator() {
        return BitMaskHelper.stateContainsShort(this.cacheManagerState, (short)1);
    }

    public void setSwitchedMediator(boolean bl) {
        if (bl) {
            this.setCacheManagerState(BitMaskHelper.stateSetShort(this.cacheManagerState, (short)1));
        } else {
            this.setCacheManagerState(BitMaskHelper.stateUnsetShort(this.cacheManagerState, (short)1));
        }
    }

    public boolean isWrapper() {
        return BitMaskHelper.stateContainsShort(this.cacheManagerState, (short)8);
    }

    public boolean isXDMXStar() {
        return BitMaskHelper.stateContainsShort(this.cacheManagerState, (short)256);
    }

    public void setIsWrapper(boolean bl) {
        if (bl) {
            this.setCacheManagerState(BitMaskHelper.stateSetShort(this.cacheManagerState, (short)8));
        } else {
            this.setCacheManagerState(BitMaskHelper.stateUnsetShort(this.cacheManagerState, (short)8));
        }
    }

    public void setIsXDMXStar(boolean bl) {
        if (bl) {
            this.setCacheManagerState(BitMaskHelper.stateSetShort(this.cacheManagerState, (short)256));
        } else {
            this.setCacheManagerState(BitMaskHelper.stateUnsetShort(this.cacheManagerState, (short)256));
        }
    }

    public boolean isEagerLoading() {
        return BitMaskHelper.stateContainsShort(this.cacheManagerState, (short)2);
    }

    public void setIsEagerLoading(boolean bl) {
        if (bl) {
            this.setCacheManagerState(BitMaskHelper.stateSetShort(this.cacheManagerState, (short)2));
        } else {
            this.setCacheManagerState(BitMaskHelper.stateUnsetShort(this.cacheManagerState, (short)2));
        }
    }

    public boolean isValidateLoading() {
        return BitMaskHelper.stateContainsShort(this.cacheManagerState, (short)4);
    }

    public void setIsValidateLoading(boolean bl) {
        if (bl) {
            this.setCacheManagerState(BitMaskHelper.stateSetShort(this.cacheManagerState, (short)4));
        } else {
            this.setCacheManagerState(BitMaskHelper.stateUnsetShort(this.cacheManagerState, (short)4));
        }
    }

    private void setIsMTOMEnabled(boolean bl) {
        if (bl) {
            this.setCacheManagerState(BitMaskHelper.stateSetShort(this.cacheManagerState, (short)1024));
        } else {
            this.setCacheManagerState(BitMaskHelper.stateUnsetShort(this.cacheManagerState, (short)1024));
        }
    }

    public boolean isMTOMEnabled() {
        return BitMaskHelper.stateContainsShort(this.cacheManagerState, (short)1024);
    }

    public boolean isMutating() {
        return BitMaskHelper.stateContainsShort(this.cacheManagerState, (short)32);
    }

    public void setIsMutating(boolean bl) {
        if (bl) {
            this.setCacheManagerState(BitMaskHelper.stateSetShort(this.cacheManagerState, (short)32));
        } else {
            this.setCacheManagerState(BitMaskHelper.stateUnsetShort(this.cacheManagerState, (short)32));
        }
    }

    static boolean needSDOGMCompatibility(Cursor cursor2) {
        return GMSDOClass != null && cursor2.factory().getClass() == GMSDOClass;
    }

    public CopyReference getCopiedManagers() {
        return this.firstCopy;
    }

    public CopiedCacheMediator getCopiedMediator() {
        return this.copyMediator;
    }

    static boolean needSDOGMCompatibility(CursorFactory cursorFactory) {
        return GMSDOClass != null && cursorFactory.getClass() == GMSDOClass;
    }

    protected void addCopyReference(CacheManager cacheManager) {
        if (cacheManager == null) {
            return;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "addCopyReference", "Adding a copy reference to: " + cacheManager.toString());
        }
        if (this.copyQueue == null) {
            this.copyQueue = new ReferenceQueue();
        }
        CopyReference copyReference = new CopyReference(cacheManager, this.copyQueue);
        copyReference.nextReference = this.firstCopy;
        this.firstCopy = copyReference;
    }

    protected void addAllReferences(CacheManager cacheManager) {
        CopyReference copyReference = cacheManager.firstCopy;
        while (copyReference != null) {
            this.addCopyReference((CacheManager)copyReference.get());
            copyReference = copyReference.nextReference;
        }
    }

    protected void cleanCopies() {
        if (this.copyQueue == null || this.copyQueue.poll() == null) {
            return;
        }
        while (this.copyQueue.poll() != null) {
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "cleanCopies", "Cleared references for the CacheManager: " + this.toString() + "\n Stack Trace: " + XCIErrorHelper.getStackTrace(30));
        }
        CopyReference copyReference = this.firstCopy;
        while (copyReference != null && copyReference.get() == null) {
            copyReference = this.firstCopy = copyReference.nextReference;
        }
        if (copyReference == null) {
            return;
        }
        while (copyReference != null && copyReference.nextReference != null) {
            if (copyReference.nextReference.get() == null) {
                copyReference.nextReference = copyReference.nextReference.nextReference;
            }
            copyReference = copyReference.nextReference;
        }
    }

    protected static void mergeReferencedCopies(CacheManager cacheManager, CacheManager cacheManager2) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "mergeReferencedCopies", "About to merge referenced copies from source [" + cacheManager.toString() + "] into target [" + cacheManager2.toString() + "] \nStack Trace=" + XCIErrorHelper.getStackTrace(30));
        }
        if (cacheManager.firstCopy != null) {
            cacheManager.cleanCopies();
            cacheManager2.cleanCopies();
            CopyReference copyReference = cacheManager.firstCopy;
            while (copyReference != null) {
                CopyReference copyReference2 = cacheManager2.firstCopy;
                while (copyReference2 != null && copyReference.get() != copyReference2.get()) {
                    copyReference2 = copyReference2.nextReference;
                }
                if (copyReference2 == null) {
                    if (copyReference == cacheManager.firstCopy) {
                        cacheManager2.addAllReferences(cacheManager);
                        break;
                    }
                    cacheManager2.addCopyReference((CacheManager)copyReference.get());
                }
                copyReference = copyReference.nextReference;
            }
        }
    }

    public void processCopiedNode(DOMCachedNode dOMCachedNode, boolean bl, DOMCachedNode dOMCachedNode2, CopiedCacheMediator copiedCacheMediator, boolean bl2) {
        InternalNodeData internalNodeData = CopiedDataFactory.INSTANCE.create(dOMCachedNode, bl2);
        dOMCachedNode.setInternalNodeData(internalNodeData);
        internalNodeData.setOriginalNode(dOMCachedNode2);
        internalNodeData.setMediatorData(copiedCacheMediator);
    }

    public static CData getBooleanCData(boolean bl) {
        if (bl) {
            return BooleanCData.XSTRUE;
        }
        return BooleanCData.XSFALSE;
    }

    public boolean isReadOnlyTransform() {
        return false;
    }

    public void setReadOnlyTransform(boolean bl) {
    }

    public static class ManufacturedRootNode
    extends DOMCachedDocument {
        private final DOMCachedNode originalRoot;
        private final NodeSiblingSnapShot snapShot;

        public ManufacturedRootNode(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2, NodeSiblingSnapShot nodeSiblingSnapShot) {
            super(dOMCachedNode.cache, "", "");
            this.originalRoot = dOMCachedNode;
            this.snapShot = nodeSiblingSnapShot;
            if (LoggerUtil.isFineLoggable(logger)) {
                String string2;
                String string3 = string2 = dOMCachedNode2 == null ? "null" : dOMCachedNode2.toStringLazy();
                if (dOMCachedNode != null) {
                    logger.logp(Level.FINE, logger.getName(), "ManufacturedRootNode", "original root: " + this.originalRoot.toStringLazy() + " treatAsRoot anchor: " + string2);
                } else {
                    logger.logp(Level.FINE, logger.getName(), "ManufacturedRootNode", "WARNING:  original root was null. Child is:" + string2 + "\nStack=" + XCIErrorHelper.getStackTrace(20));
                }
            }
            if (dOMCachedNode2 != null) {
                this.setBuiltFirstChild(dOMCachedNode2);
            }
            this.setState(LazyLoadingHelper.markFirstChildResolved(this.state));
        }

        public ManufacturedRootNode(DOMCachedNode dOMCachedNode) {
            super(dOMCachedNode.cache, "", "");
            this.originalRoot = dOMCachedNode;
            this.snapShot = null;
            if (LoggerUtil.isFineLoggable(logger)) {
                if (dOMCachedNode != null) {
                    logger.logp(Level.FINE, logger.getName(), "ManufacturedRootNode", "original root: " + this.originalRoot.toStringLazy() + " no first child");
                } else {
                    logger.logp(Level.FINE, logger.getName(), "ManufacturedRootNode", "WARNING:  original root was null.  \nStack=" + XCIErrorHelper.getStackTrace(20));
                }
            }
            this.setState(LazyLoadingHelper.markChildrenResolved(this.state));
        }

        DOMCachedNode getOriginalRoot() {
            return this.originalRoot;
        }

        NodeSiblingSnapShot getSiblingSnapShot() {
            return this.snapShot;
        }
    }

    public static class NodeSiblingSnapShot {
        private final DOMCachedNode oldPrevious;
        private final DOMCachedNode oldFollowing;
        private final int oldState;

        public NodeSiblingSnapShot(DOMCachedNode dOMCachedNode) {
            if (LoggerUtil.isFineLoggable(logger)) {
                logger.logp(Level.FINE, logger.getName(), "NodeSiblingSnapShot", "unlinking and building a snapshot for node=" + dOMCachedNode.toStringLazy() + " with preceding=" + dOMCachedNode.preceding + " and following=" + dOMCachedNode.following);
            }
            this.oldPrevious = dOMCachedNode.preceding;
            this.oldFollowing = dOMCachedNode.following;
            this.oldState = dOMCachedNode.state;
            dOMCachedNode.setState(dOMCachedNode.getState() | 0x80);
            dOMCachedNode.setState(dOMCachedNode.getState() | 0x200);
            dOMCachedNode.preceding = null;
            dOMCachedNode.following = null;
        }

        public void restoreSiblingSnapShot(DOMCachedNode dOMCachedNode) {
            dOMCachedNode.preceding = this.oldPrevious;
            dOMCachedNode.following = this.oldFollowing;
            if (!BitMaskHelper.stateContains(this.oldState, 128)) {
                dOMCachedNode.setState(BitMaskHelper.stateUnset(dOMCachedNode.getState(), 128));
            }
            if (!BitMaskHelper.stateContains(this.oldState, 512)) {
                dOMCachedNode.setState(BitMaskHelper.stateUnset(dOMCachedNode.getState(), 512));
            }
            if (LoggerUtil.isFineLoggable(logger)) {
                logger.logp(Level.FINE, logger.getName(), "restoreSiblingSnapShot", "restored sibling snapshot for node=" + dOMCachedNode.toStringLazy() + " with preceding=" + dOMCachedNode.preceding + " and following=" + dOMCachedNode.following);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CopyReference
    extends WeakReference<CacheManager> {
        public CopyReference nextReference;

        public CopyReference(CacheManager cacheManager, ReferenceQueue<CacheManager> referenceQueue) {
            super(cacheManager, referenceQueue);
        }
    }
}

