/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.CopiedCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSObject;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheNodeSequence
extends CacheCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00c2\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int BUCKET_SIZE = 20;
    private DOMCachedNode[] nodes;
    private int index;
    private int length;
    private boolean _isForwardOrderedAndUnique;
    private static final boolean _diagnoseSorting = false;
    private boolean exclusiveArrayOwnership = true;
    private static final Logger logger = LoggerUtil.getLogger(CacheNodeSequence.class);
    private static int sortCount = 0;
    private static int arrayCopyCount = 0;
    private static int uselessSorts = 0;

    public CacheNodeSequence(DOMCachedNode[] dOMCachedNodeArray, int n2, int n3, boolean bl) {
        this(dOMCachedNodeArray, n2, n3, n2 == 1, bl);
    }

    public CacheNodeSequence(DOMCachedNode[] dOMCachedNodeArray, int n2, int n3, boolean bl, boolean bl2) {
        super(dOMCachedNodeArray[n3], false);
        this.nodes = dOMCachedNodeArray;
        this._isForwardOrderedAndUnique = bl;
        this.exclusiveArrayOwnership = bl2;
        this.length = n2;
        this.index = n3;
        this.sequenceState = (short)4;
    }

    public CacheNodeSequence setValues(DOMCachedNode[] dOMCachedNodeArray, int n2, int n3) {
        this.nodes = dOMCachedNodeArray;
        this.length = n2;
        this.index = n3;
        this.replaceContextNode(dOMCachedNodeArray[n3]);
        return this;
    }

    @Override
    public boolean toPrevious() {
        if (this.isDeadSequence()) {
            if (this.index - 1 < 0) {
                return false;
            }
            --this.index;
            return true;
        }
        return super.toPrevious();
    }

    @Override
    public boolean toNext() {
        if (this.isDeadSequence()) {
            if (this.index + 1 >= this.length) {
                return false;
            }
            ++this.index;
            return true;
        }
        return super.toNext();
    }

    @Override
    public boolean hasNext() {
        if (this.isDeadSequence()) {
            return this.index + 1 < this.length;
        }
        return super.hasNext();
    }

    @Override
    public long contextSize() {
        if (this.isDeadSequence()) {
            return this.length;
        }
        return super.contextSize();
    }

    @Override
    public long contextPosition() {
        if (this.isDeadSequence()) {
            return this.index + 1;
        }
        return super.contextPosition();
    }

    @Override
    public boolean toPosition(long l) {
        if (this.isDeadSequence()) {
            if (l < 1L || l > (long)this.length) {
                return false;
            }
            this.index = (int)l - 1;
            return true;
        }
        return super.toPosition(l);
    }

    @Override
    public final Cursor getDelegate() {
        if (this.isDeadSequence()) {
            return this.nodes[this.index];
        }
        return super.getDelegate();
    }

    @Override
    public VolatileCData itemTypedValue() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemTypedValue();
    }

    @Override
    public VolatileCData itemName() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemName();
    }

    @Override
    public short itemKind() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemKind();
    }

    @Override
    public VolatileCData itemStringValue() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemStringValue();
    }

    @Override
    public QName itemTypeName() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemTypeName();
    }

    @Override
    public XSTypeDefinition itemXSType() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemXSType();
    }

    @Override
    public XSAttributeDeclaration itemXSAttributeDeclaration() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemXSAttributeDeclaration();
    }

    @Override
    public XSElementDeclaration itemXSElementDeclaration() {
        if (this.isDeadSequence()) {
            this.replaceContextNode(this.nodes[this.index]);
        }
        return super.itemXSElementDeclaration();
    }

    public final void switchToLiveSequence() {
        this.replaceContextNode(this.nodes[this.index]);
        this.nodes = null;
    }

    public final boolean isDeadSequence() {
        return this.nodes != null;
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        if (!this.isDeadSequence()) {
            return super.fork(bl, profile, profile2);
        }
        if (bl) {
            return new CacheCursor(this.nodes[this.index], true);
        }
        this.exclusiveArrayOwnership = false;
        return new CacheNodeSequence(this.nodes, this.length, this.index, this._isForwardOrderedAndUnique, false);
    }

    @Override
    public Cursor sequenceConcat(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        assert (this != cursor2);
        if (!this.isDeadSequence()) {
            return super.sequenceConcat(cursor2, profile, profile2, bl, bl2, bl3, bl4);
        }
        if (cursor2 == null) {
            Cursor cursor3 = AbstractCursor.ownTheCursor(this, bl, bl3);
            return cursor3;
        }
        if (cursor2.unwrap() instanceof DOMCachedNode) {
            if (cursor2 instanceof CacheNodeSequence) {
                CacheCursor cacheCursor = (CacheCursor)AbstractCursor.ownTheCursor(cursor2, bl2, bl4);
                CacheNodeSequence cacheNodeSequence = cacheCursor instanceof CacheNodeSequence ? (CacheNodeSequence)cacheCursor : CacheNodeSequence.getNewSequence(cacheCursor, null, false, false);
                int n2 = bl ? 1 : this.length;
                cacheNodeSequence.preprendArray(this.nodes, n2, bl2);
                if (bl3) {
                    this.release();
                }
                return cacheNodeSequence;
            }
            Cursor cursor4 = AbstractCursor.ownTheCursor(this, bl, bl3);
            if (cursor4 instanceof CacheNodeSequence) {
                CacheNodeSequence cacheNodeSequence = (CacheNodeSequence)cursor4;
                cursor2 = AbstractCursor.ownTheCursorIfMightMove(cursor2, bl2, bl4);
                int[] nArray = new int[1];
                if (bl) {
                    cacheNodeSequence.length = 1;
                    nArray[0] = 1;
                } else {
                    nArray[0] = cacheNodeSequence.length;
                }
                DOMCachedNode[] dOMCachedNodeArray = cacheNodeSequence.nodes;
                DOMCachedNode dOMCachedNode = cacheNodeSequence.nodes[cacheNodeSequence.length - 1];
                if (this.needCopyBeforeAppending(cacheNodeSequence)) {
                    cacheNodeSequence.exclusiveArrayOwnership = true;
                    DOMCachedNode[] dOMCachedNodeArray2 = new DOMCachedNode[dOMCachedNodeArray.length];
                    System.arraycopy(dOMCachedNodeArray, 0, dOMCachedNodeArray2, 0, cacheNodeSequence.length);
                    dOMCachedNodeArray = dOMCachedNodeArray2;
                }
                boolean bl5 = cursor2.contextIsOrdered(true);
                DOMCachedNode dOMCachedNode2 = (DOMCachedNode)cursor2.unwrap();
                dOMCachedNodeArray = CacheNodeSequence.appendSequence(cursor2, dOMCachedNodeArray, nArray, bl2);
                AbstractCursor.ownedCleanupIfMightMove(cursor2, bl2, true);
                cacheNodeSequence._isForwardOrderedAndUnique = cacheNodeSequence._isForwardOrderedAndUnique && bl5 && dOMCachedNode.itemIsBeforeNode(dOMCachedNode2);
                cacheNodeSequence.setValues(dOMCachedNodeArray, nArray[0], this.index);
                return cacheNodeSequence;
            }
            return super.sequenceConcat(cursor2, profile, profile2, bl, bl2, bl3, bl4);
        }
        return super.sequenceConcat(cursor2, profile, profile2, bl, bl2, bl3, bl4);
    }

    boolean needCopyBeforeAppending(CacheNodeSequence cacheNodeSequence) {
        if (cacheNodeSequence.exclusiveArrayOwnership) {
            return false;
        }
        DOMCachedNode[] dOMCachedNodeArray = cacheNodeSequence.nodes;
        if (dOMCachedNodeArray.length == cacheNodeSequence.length) {
            return false;
        }
        return dOMCachedNodeArray[cacheNodeSequence.length] != null;
    }

    @Override
    public boolean contextIsLive() {
        return !this.isDeadSequence();
    }

    @Override
    public boolean toAttributes(NodeTest nodeTest) {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toAttributes(nodeTest);
    }

    @Override
    public boolean toChildren(NodeTest nodeTest) {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toChildren(nodeTest);
    }

    @Override
    public boolean toRoot() {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toRoot();
    }

    @Override
    public boolean toFollowingSiblings(NodeTest nodeTest) {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toFollowingSiblings(nodeTest);
    }

    @Override
    public boolean toIdrefs(VolatileCData volatileCData) {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toIdrefs(volatileCData);
    }

    @Override
    public boolean toIds(VolatileCData volatileCData) {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toIds(volatileCData);
    }

    @Override
    public boolean toNamespaceDecls() {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toNamespaceDecls();
    }

    @Override
    public boolean toParent() {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toParent();
    }

    @Override
    public boolean toPrecedingSiblings(NodeTest nodeTest) {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toPrecedingSiblings(nodeTest);
    }

    @Override
    public boolean toSelf() {
        if (this.isDeadSequence()) {
            this.switchToLiveSequence();
        }
        return super.toSelf();
    }

    @Override
    public void release() {
        this.nodes = null;
        super.release();
    }

    @Override
    public int validate(int n2) {
        if (this.isDeadSequence()) {
            CacheCursor cacheCursor = new CacheCursor(this.nodes[this.index], false);
            return cacheCursor.validate(n2);
        }
        return super.validate(n2);
    }

    @Override
    public int validate(int n2, Locale locale, XSObject xSObject, Map<String, List<String>> map2) {
        if (this.isDeadSequence()) {
            CacheCursor cacheCursor = new CacheCursor(this.nodes[this.index], false);
            return cacheCursor.validate(n2, locale, xSObject, map2);
        }
        return super.validate(n2, locale, xSObject, map2);
    }

    @Override
    public void addCopy(Cursor.Area area, Cursor cursor2) {
        if (this.isDeadSequence()) {
            CacheCursor cacheCursor = new CacheCursor(this.nodes[this.index], false);
            cacheCursor.addCopy(area, cursor2);
        } else {
            super.addCopy(area, cursor2);
        }
    }

    @Override
    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        if (this.isDeadSequence()) {
            CacheCursor cacheCursor = new CacheCursor(this.nodes[this.index], false);
            cacheCursor.addElement(area, volatileCData, xSTypeDefinition);
        } else {
            super.addElement(area, volatileCData, xSTypeDefinition);
        }
    }

    private void preprendArray(DOMCachedNode[] dOMCachedNodeArray, int n2, boolean bl) {
        int n3 = dOMCachedNodeArray.length - (n2 + 1);
        int n4 = bl ? 1 : this.length;
        if (n3 >= n4) {
            System.arraycopy(this.nodes, 0, dOMCachedNodeArray, n2, n4);
        } else {
            DOMCachedNode[] dOMCachedNodeArray2 = new DOMCachedNode[dOMCachedNodeArray.length + n4];
            System.arraycopy(dOMCachedNodeArray, 0, dOMCachedNodeArray2, 0, n2);
            System.arraycopy(this.nodes, 0, dOMCachedNodeArray2, n2, n4);
            dOMCachedNodeArray = dOMCachedNodeArray2;
        }
        this._isForwardOrderedAndUnique = false;
        this.setValues(dOMCachedNodeArray, n4 + n2, 0);
    }

    public static CacheNodeSequence getNewSequence(Cursor cursor2, Cursor cursor3, boolean bl, boolean bl2) {
        DOMCachedNode[] dOMCachedNodeArray = new DOMCachedNode[20];
        int[] nArray = new int[]{0};
        dOMCachedNodeArray = CacheNodeSequence.appendSequence(cursor2, dOMCachedNodeArray, nArray, bl);
        int n2 = nArray[0];
        dOMCachedNodeArray = CacheNodeSequence.appendSequence(cursor3, dOMCachedNodeArray, nArray, bl2);
        CacheNodeSequence cacheNodeSequence = new CacheNodeSequence(dOMCachedNodeArray, nArray[0], 0, true);
        if (cursor3 == null && cursor2 != null) {
            cacheNodeSequence._isForwardOrderedAndUnique = cursor2.contextIsOrdered(true);
        } else if (cursor3 != null && cursor2 == null) {
            cacheNodeSequence._isForwardOrderedAndUnique = cursor3.contextIsOrdered(true);
        } else if (cursor2.contextIsOrdered(true) && cursor3.contextIsOrdered(true)) {
            DOMCachedNode dOMCachedNode = dOMCachedNodeArray[n2 - 1];
            DOMCachedNode dOMCachedNode2 = dOMCachedNodeArray[n2];
            cacheNodeSequence._isForwardOrderedAndUnique = dOMCachedNode.itemIsBeforeNode(dOMCachedNode2);
        }
        return cacheNodeSequence;
    }

    private static DOMCachedNode[] appendSequence(Cursor cursor2, DOMCachedNode[] dOMCachedNodeArray, int[] nArray, boolean bl) {
        if (cursor2 == null) {
            return dOMCachedNodeArray;
        }
        int n2 = nArray[0];
        do {
            if (dOMCachedNodeArray.length == n2) {
                dOMCachedNodeArray = CacheNodeSequence.expandArray(dOMCachedNodeArray);
            }
            CopiedCacheCursor.handlePotentialCopy(cursor2);
            dOMCachedNodeArray[n2++] = (DOMCachedNode)cursor2.unwrap();
        } while (!bl && cursor2.toNext());
        nArray[0] = n2;
        return dOMCachedNodeArray;
    }

    public static CacheNodeSequence prependSequence(Cursor cursor2, CacheNodeSequence cacheNodeSequence, boolean bl, boolean bl2) {
        if (cursor2 == null) {
            return cacheNodeSequence;
        }
        DOMCachedNode[] dOMCachedNodeArray = new DOMCachedNode[20];
        int[] nArray = new int[]{0};
        dOMCachedNodeArray = CacheNodeSequence.appendSequence(cursor2, dOMCachedNodeArray, nArray, bl);
        cacheNodeSequence.preprendArray(dOMCachedNodeArray, nArray[0], bl2);
        return cacheNodeSequence;
    }

    private static DOMCachedNode[] expandArray(DOMCachedNode[] dOMCachedNodeArray) {
        DOMCachedNode[] dOMCachedNodeArray2 = new DOMCachedNode[dOMCachedNodeArray.length + 20];
        System.arraycopy(dOMCachedNodeArray, 0, dOMCachedNodeArray2, 0, dOMCachedNodeArray.length);
        return dOMCachedNodeArray2;
    }

    protected void dumpSequence(StringBuilder stringBuilder) {
        for (int i = 0; i < this.length; ++i) {
            stringBuilder.append('[');
            stringBuilder.append(i);
            stringBuilder.append("] = ");
            stringBuilder.append(this.nodes[i].toStringLazy());
            stringBuilder.append('\n');
        }
    }

    @Override
    public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        Object object2;
        if (!this.isDeadSequence()) {
            return super.documentOrder(profile, profile2, bl);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            object2 = new StringBuilder();
            this.dumpSequence((StringBuilder)object2);
            logger.logp(Level.FINEST, logger.getName(), "documentOrder", "Before sorting:\n" + ((StringBuilder)object2).toString());
        }
        if (this.contextIsOrdered(true)) {
            return AbstractCursor.ownTheCursor(this, false, bl);
        }
        object2 = (CacheNodeSequence)AbstractCursor.ownTheCursor(this, false, bl);
        ((CacheNodeSequence)object2).sortAndEliminateDups();
        ((CacheNodeSequence)object2).setValues(((CacheNodeSequence)object2).nodes, ((CacheNodeSequence)object2).length, 0);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder();
            ((CacheNodeSequence)object2).dumpSequence(stringBuilder);
            logger.logp(Level.FINEST, logger.getName(), "documentOrder", "After sorting:\n" + stringBuilder.toString());
        }
        return object2;
    }

    public final void sortAndEliminateDups() {
        if (this.length == 1) {
            return;
        }
        if (!this._isForwardOrderedAndUnique) {
            DOMCachedNode[] dOMCachedNodeArray = this.nodes;
            this.quicksort(0, this.length - 1);
            int n2 = this.eliminateDupsFromSorted(this.nodes);
            this.length -= n2;
            this._isForwardOrderedAndUnique = true;
        }
    }

    private int eliminateDupsFromSorted(DOMCachedNode[] dOMCachedNodeArray) {
        int n2 = 0;
        for (int i = 1; i < this.length; ++i) {
            if (dOMCachedNodeArray[i - 1].isSameNode(dOMCachedNodeArray[i])) {
                ++n2;
            }
            if (n2 <= 0) continue;
            dOMCachedNodeArray[i - n2] = dOMCachedNodeArray[i];
        }
        return n2;
    }

    private void quicksort(int n2, int n3) {
        this.quicksort2(n2, n3);
    }

    private void quicksort2(int n2, int n3) {
        if (n2 < n3) {
            int n4 = this.partition(n2, n3);
            this.quicksort2(n2, n4);
            this.quicksort2(n4 + 1, n3);
        }
    }

    private int partition(int n2, int n3) {
        DOMCachedNode dOMCachedNode = this.nodes[n2 + n3 >>> 1];
        int n4 = n2 - 1;
        int n5 = n3 + 1;
        while (true) {
            short s;
            if (0 != ((s = CacheNodeSequence.compareDocumentPosition(dOMCachedNode, this.nodes[--n5])) & 4)) {
                continue;
            }
            while (0 != ((s = CacheNodeSequence.compareDocumentPosition(dOMCachedNode, this.nodes[++n4])) & 2)) {
            }
            if (n4 >= n5) break;
            DOMCachedNode dOMCachedNode2 = this.nodes[n4];
            DOMCachedNode dOMCachedNode3 = this.nodes[n5];
            if (dOMCachedNode2 == dOMCachedNode3) continue;
            if (!this.exclusiveArrayOwnership) {
                DOMCachedNode[] dOMCachedNodeArray = new DOMCachedNode[this.length];
                System.arraycopy(this.nodes, 0, dOMCachedNodeArray, 0, this.length);
                this.nodes = dOMCachedNodeArray;
                this.exclusiveArrayOwnership = true;
            }
            this.nodes[n4] = dOMCachedNode3;
            this.nodes[n5] = dOMCachedNode2;
        }
        return n5;
    }

    static short compareDocumentPosition(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        if (dOMCachedNode.itemIsSameNode(dOMCachedNode2)) {
            return 0;
        }
        if (dOMCachedNode.itemIsBeforeNode(dOMCachedNode2)) {
            return 4;
        }
        return 2;
    }

    @Override
    public Cursor unwrap() {
        if (this.isDeadSequence()) {
            return this.nodes[this.index];
        }
        return super.unwrap();
    }

    @Override
    public boolean contextIsAtomsOnly() {
        return false;
    }

    @Override
    public boolean contextIsNodesOnly() {
        return true;
    }

    @Override
    public boolean contextIsSingleDoc() {
        if (this.isDeadSequence()) {
            return true;
        }
        if (this.length == 1) {
            return true;
        }
        DOMCachedNode dOMCachedNode = this.nodes[0];
        for (int i = 1; i < this.length; ++i) {
            DOMCachedNode dOMCachedNode2 = this.nodes[i];
            if (dOMCachedNode.isSameNode(dOMCachedNode2) || dOMCachedNode.itemIsSameDocument(dOMCachedNode2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contextIsOrdered(boolean bl) {
        if (!this.isDeadSequence()) {
            return super.contextIsOrdered(bl);
        }
        if (this.length == 1) {
            return true;
        }
        return this._isForwardOrderedAndUnique;
    }

    @Override
    public Node item(int n2) {
        if (!this.toPosition(n2 + 1)) {
            return null;
        }
        return this.nodes[this.index];
    }

    void reverse() {
        CacheNodeSequence.reverse(this.nodes, this.length);
    }

    private static void reverse(DOMCachedNode[] dOMCachedNodeArray, int n2) {
        int n3 = 0;
        for (int i = n2 - 1; n3 < i; ++n3, --i) {
            DOMCachedNode dOMCachedNode = dOMCachedNodeArray[n3];
            dOMCachedNodeArray[n3] = dOMCachedNodeArray[i];
            dOMCachedNodeArray[i] = dOMCachedNode;
        }
    }
}

