/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xml4j.api.s1.xs.ItemPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopiedCacheCursor
extends CacheCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = LoggerUtil.getLogger(CopiedCacheCursor.class);
    public final CacheManager copiedManager;
    private Cursor.Profile neededFeatures = FEATURES_LIMIT;

    protected CopiedCacheCursor(CacheManager cacheManager, DOMCachedNode dOMCachedNode, boolean bl) {
        this(cacheManager, dOMCachedNode, FEATURES_LIMIT, bl, null);
    }

    protected CopiedCacheCursor(CacheManager cacheManager, DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl, NodeTest nodeTest) {
        super(dOMCachedNode, profile, bl, nodeTest);
        this.copiedManager = cacheManager;
        this.setToCopyMode();
    }

    protected CopiedCacheCursor(CacheManager cacheManager, DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl) {
        super(dOMCachedNode, profile, bl);
        this.copiedManager = cacheManager;
        if (!CacheManager.needSDOGMCompatibility(this)) {
            this.neededFeatures = profile.union(Cursor.Profile.RANDOM_ACCESS);
        }
        if (this.isOriginalNode() && Cursor.Profile.MUTATION_BITS.overlap(profile)) {
            this.copiedManager.registerCopiedCursorWithOriginal(this);
        }
    }

    protected CopiedCacheCursor(CopiedCacheCursor copiedCacheCursor, Cursor.Profile profile, boolean bl) {
        super(copiedCacheCursor, profile, bl);
        this.copiedManager = copiedCacheCursor.copiedManager;
        if (!CacheManager.needSDOGMCompatibility(this)) {
            this.neededFeatures = profile.union(Cursor.Profile.RANDOM_ACCESS);
        }
        if (this.isOriginalNode() && Cursor.Profile.MUTATION_BITS.overlap(profile)) {
            this.copiedManager.registerCopiedCursorWithOriginal(this);
        }
    }

    public Cursor.Profile profile() {
        return this.neededFeatures;
    }

    public Cursor.Profile futureProfile() {
        return this.neededFeatures;
    }

    public void notifyCopy(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        if (this.contextNode == dOMCachedNode) {
            this.contextNode = dOMCachedNode2;
            this.setToCopyMode();
        }
    }

    private final void setToOriginalMode() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setToOriginalMode", "context node=" + this.contextNode.toStringLazy() + "\nCopiedManager=" + this.copiedManager.toString() + "\ncontext node's manager=" + this.contextNode.getCache());
        }
        this.copiedManager.registerCopiedCursorWithOriginal(this);
    }

    private final void setToCopyMode() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setToCopyMode", "context node=" + this.contextNode.toStringLazy() + "\nCopiedManager=" + this.copiedManager.toString() + "\ncontext node's manager=" + this.contextNode.getCache());
        }
        if (this.rootSibling != null && this.contextNode.getOriginalNode() == this.rootSibling) {
            this.rootSibling = this.contextNode;
        }
        this.copiedManager.unregisterCopiedCursorWithOriginal(this);
    }

    final void copyTo(Cursor.Area area) {
        DOMCachedNode dOMCachedNode;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "copyTo", "Entering copyTo for node = " + this.contextNode.toStringLazy() + " area= " + area.toString() + " isOriginalNode= " + this.isOriginalNode());
        }
        if (this.isOriginalNode()) {
            dOMCachedNode = this.copiedManager.copyToOriginalNode(this.contextNode);
            if (dOMCachedNode != null) {
                this.contextNode = dOMCachedNode;
                this.setToCopyMode();
            } else if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "copyTo", "Could not copy contextNode { " + this.contextNode.toStringLazy() + "} from tree " + this.contextNode.cache.rootNode.toStringLazy(null, "", true));
            }
        }
        if (this.contextNode.getInternalNodeData() == null) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "copyTo", "UserData was null for about-to-be-mutated node " + this.contextNode.toStringLazy());
            }
            return;
        }
        dOMCachedNode = this.contextNode.getOriginalNode();
        if (dOMCachedNode == null) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "copyTo", "UserData.originalNode was null for about-to-be-mutated node " + this.contextNode.toStringLazy());
            }
            return;
        }
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                DOMCachedNode dOMCachedNode2;
                if (LazyLoadingHelper.isFirstChildBuilt(this.contextNode.getState()) || (dOMCachedNode2 = dOMCachedNode.getCachedFirstChild()) == null || dOMCachedNode2.cache == this.copiedManager) break;
                this.copiedManager.copyToOriginalNode(dOMCachedNode2);
                break;
            }
            case LAST_CHILD: {
                DOMCachedNode dOMCachedNode3;
                if (LazyLoadingHelper.isLastChildBuilt(this.contextNode.getState()) || (dOMCachedNode3 = dOMCachedNode.getCachedLastChild()) == null || dOMCachedNode3.cache == this.copiedManager) break;
                this.copiedManager.copyToOriginalNode(dOMCachedNode3);
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                DOMCachedNode dOMCachedNode4 = LazyLoadingHelper.isFollowingBuilt(this.contextNode.getState()) ? this.contextNode.getBuiltFollowingSibling() : dOMCachedNode.getCachedFollowingSibling();
                if (dOMCachedNode4 != null && dOMCachedNode4.getCachedFollowingSibling() != null) {
                    dOMCachedNode4 = dOMCachedNode4.getBuiltFollowingSibling();
                }
                if (dOMCachedNode4 == null || dOMCachedNode4.cache == this.copiedManager) break;
                this.copiedManager.copyToOriginalNode(dOMCachedNode4);
                break;
            }
            case SUBTREE: {
                DOMCachedNode dOMCachedNode5 = dOMCachedNode.getCachedFollowingSibling();
                if (dOMCachedNode5 == null || dOMCachedNode5.cache == this.copiedManager) break;
                this.copiedManager.copyToOriginalNode(dOMCachedNode5);
                break;
            }
            case ATTRIBUTE: {
                DOMCachedAttribute dOMCachedAttribute;
                if (LazyLoadingHelper.isLastAttributeBuilt(this.contextNode.getState()) || (dOMCachedAttribute = dOMCachedNode.getCachedLastAttribute()) == null || dOMCachedAttribute.cache == this.copiedManager) break;
                this.copiedManager.copyToOriginalNode(dOMCachedAttribute);
                break;
            }
            case NAMESPACE_DECLS: {
                DOMCachedNamespace dOMCachedNamespace;
                if (LazyLoadingHelper.isLastNamespaceBuilt(this.contextNode.getState()) || (dOMCachedNamespace = dOMCachedNode.getCachedLastNamespaceNode()) == null || dOMCachedNamespace.cache == this.copiedManager) break;
                this.copiedManager.copyToOriginalNode(dOMCachedNamespace);
            }
        }
    }

    public boolean toAttributes(NodeTest nodeTest) {
        if (!this.copiedManager.copyMediator.checkedThread) {
            // empty if block
        }
        if (this.isOriginalNode()) {
            return super.toAttributes(nodeTest);
        }
        if (super.toAttributes(nodeTest)) {
            if (this.contextNode.cache != this.copiedManager) {
                this.setToOriginalMode();
            }
            return true;
        }
        return false;
    }

    public boolean toChildren(NodeTest nodeTest) {
        if (!this.copiedManager.copyMediator.checkedThread) {
            // empty if block
        }
        if (this.isOriginalNode()) {
            return super.toChildren(nodeTest);
        }
        if (super.toChildren(nodeTest)) {
            if (this.contextNode.cache != this.copiedManager) {
                this.setToOriginalMode();
            }
            return true;
        }
        return false;
    }

    public boolean toParent() {
        DOMCachedNode dOMCachedNode;
        DOMCachedNode dOMCachedNode2;
        if (!this.isOriginalNode() && BitMaskHelper.stateContains(this.contextNode.state, 0x20000000)) {
            return this.toRoot();
        }
        if (this.copiedManager.rootNode instanceof CacheManager.ManufacturedRootNode) {
            dOMCachedNode2 = ((CacheManager.ManufacturedRootNode)this.copiedManager.rootNode).builtFirstChild;
            dOMCachedNode = this.contextNode;
            while (dOMCachedNode.preceding != null) {
                dOMCachedNode = dOMCachedNode.preceding;
            }
            if (dOMCachedNode.getCache() == this.copiedManager ? dOMCachedNode == dOMCachedNode2 : (dOMCachedNode = this.copiedManager.getCopiedNode(dOMCachedNode)) == dOMCachedNode2) {
                return this.toRoot();
            }
        }
        dOMCachedNode2 = this.contextNode.getCachedParent();
        if (this.isOriginalNode() && (dOMCachedNode = this.copiedManager.getCopiedNode(dOMCachedNode2)) != null) {
            dOMCachedNode2 = dOMCachedNode;
            this.setToCopyMode();
        }
        if (dOMCachedNode2 == null) {
            return false;
        }
        this.replaceContextNodeAndState(dOMCachedNode2, (short)0);
        this.sequenceTest = null;
        this.idrefsOrIdsCDATA = null;
        return true;
    }

    public boolean toFollowingSiblings(NodeTest nodeTest) {
        if (this.isOriginalNode()) {
            return super.toFollowingSiblings(nodeTest);
        }
        if (super.toFollowingSiblings(nodeTest)) {
            if (this.contextNode.cache != this.copiedManager) {
                this.setToOriginalMode();
            }
            return true;
        }
        return false;
    }

    public boolean toNamespaceDecls() {
        if (!this.copiedManager.copyMediator.checkedThread) {
            // empty if block
        }
        if (this.isOriginalNode()) {
            return super.toNamespaceDecls();
        }
        if (super.toNamespaceDecls()) {
            if (this.contextNode.cache != this.copiedManager) {
                this.setToOriginalMode();
            }
            return true;
        }
        return false;
    }

    public boolean toNext() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "toNext", "context node=" + this.contextNode.toStringLazy() + "\nCopiedManager=" + this.copiedManager.toString() + "\ncontext node's manager=" + this.contextNode.getCache() + "\ncontext node's mediator data=" + this.contextNode.getMediatorData());
        }
        if (this.isOriginalNode()) {
            return super.toNext();
        }
        if (super.toNext()) {
            if (this.contextNode.cache != this.copiedManager) {
                this.setToOriginalMode();
            }
            return true;
        }
        return false;
    }

    private boolean isOriginalNode() {
        return this.contextNode.cache != this.copiedManager;
    }

    public boolean toPrevious() {
        if (!this.isOriginalNode()) {
            return super.toPrevious();
        }
        if (super.toPrevious()) {
            DOMCachedNode dOMCachedNode = this.copiedManager.getCopiedNode(this.contextNode);
            if (dOMCachedNode != null) {
                this.contextNode = dOMCachedNode;
                this.setToCopyMode();
            }
            return true;
        }
        return false;
    }

    public boolean toRoot() {
        DOMCachedNode dOMCachedNode = this.copiedManager.rootNode;
        if (this.isOriginalNode()) {
            this.setToCopyMode();
        }
        this.replaceContextNodeAndState(dOMCachedNode, (short)0);
        this.sequenceTest = null;
        this.idrefsOrIdsCDATA = null;
        return true;
    }

    public boolean toPosition(long l) {
        block6: {
            long l2;
            block5: {
                if (this.sequenceState == 0) {
                    return l == 1L;
                }
                if (l < 1L) {
                    return false;
                }
                l2 = this.contextPosition() - l;
                if (l2 <= 0L) break block5;
                while (l2 > 0L) {
                    this.toPrevious();
                    --l2;
                }
                break block6;
            }
            if (l2 >= 0L) break block6;
            DOMCachedNode dOMCachedNode = this.contextNode;
            while (l2 < 0L) {
                if (!this.toNext()) {
                    this.contextNode = dOMCachedNode;
                    return false;
                }
                ++l2;
            }
        }
        return true;
    }

    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        return new CopiedCacheCursor(this, profile, bl);
    }

    public void release() {
        if (this.isOriginalNode()) {
            this.copiedManager.unregisterCopiedCursorWithOriginal(this);
        }
        super.release();
    }

    public Object exportAs(String string2, boolean bl) {
        if (this.isOriginalNode()) {
            DOMCachedNode dOMCachedNode = this.copiedManager.copyToOriginalNode(this.contextNode);
            if (dOMCachedNode != null) {
                this.contextNode = dOMCachedNode;
                this.setToCopyMode();
            } else if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "exportAs", "Could not copy contextNode { " + this.contextNode.toStringLazy() + "} from tree " + this.contextNode.cache.rootNode.toStringLazy(null, "", true));
            }
        }
        return super.exportAs(string2, bl);
    }

    public Cursor unwrap() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "unwrap", "Unwrapping a node from CopiedCacheCursor. Should ONLY be for instanceof checks. Node = " + this.contextNode.toStringLazy() + "\n Stack trace= " + XCIErrorHelper.getStackTrace(20));
        }
        return this.contextNode;
    }

    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        this.copyTo(area);
        super.addElement(area, volatileCData, xSTypeDefinition);
    }

    public ItemPSVI itemXSPSVInfo() {
        this.copyTo(Cursor.Area.SELF);
        return super.itemXSPSVInfo();
    }

    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        this.copyTo(Cursor.Area.ATTRIBUTES);
        super.addAttribute(volatileCData, volatileCData2);
    }

    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        this.copyTo(area);
        super.addComment(area, volatileCData);
    }

    public void addCopy(Cursor.Area area, Cursor cursor2) {
        this.copyTo(area);
        super.addCopy(area, cursor2);
    }

    public void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        this.copyTo(Cursor.Area.NAMESPACE_DECLS);
        super.addNamespaceNode(volatileCData, volatileCData2, bl);
    }

    public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        this.copyTo(area);
        super.addProcessingInstruction(area, volatileCData, volatileCData2);
    }

    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        this.copyTo(area);
        super.addText(area, volatileCData);
    }

    public void move(Cursor.Area area, Cursor cursor2) {
        this.copyTo(area);
        super.move(area, cursor2);
    }

    public boolean removeAttribute(VolatileCData volatileCData) {
        this.copyTo(Cursor.Area.ATTRIBUTES);
        return super.removeAttribute(volatileCData);
    }

    public boolean removeSubtree(Cursor.Area area) {
        if (area == null) {
            throw XCIErrorHelper.createBadArgumentException("where", "null");
        }
        if (area == Cursor.Area.SELF) {
            this.copyTo(Cursor.Area.SUBTREE);
        } else {
            this.copyTo(area);
        }
        return super.removeSubtree(area);
    }

    public void setItemName(VolatileCData volatileCData) {
        this.copyTo(Cursor.Area.NAMESPACE_DECLS);
        super.setItemName(volatileCData);
    }

    public void setItemPSVI(ItemPSVI itemPSVI) {
        this.copyTo(Cursor.Area.SELF);
        super.setItemPSVI(itemPSVI);
    }

    public void setItemValue(VolatileCData volatileCData) {
        this.copyTo(Cursor.Area.LAST_CHILD);
        super.setItemValue(volatileCData);
    }

    public long contextPosition() {
        this.copyTo(Cursor.Area.SELF);
        return super.contextPosition();
    }

    public long contextSize() {
        this.copyTo(Cursor.Area.SELF);
        return super.contextSize();
    }

    protected void copyToSiblings() {
        DOMCachedNode dOMCachedNode;
        DOMCachedNode dOMCachedNode2;
        if (this.isOriginalNode()) {
            dOMCachedNode2 = this.copiedManager.copyToOriginalNode(this.contextNode);
            if (dOMCachedNode2 != null) {
                this.contextNode = dOMCachedNode2;
                this.setToCopyMode();
            } else if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "copyToSiblings", "Could not copy contextNode { " + this.contextNode.toStringLazy() + "} from tree " + this.contextNode.cache.rootNode.toStringLazy(null, "", true));
            }
        }
        if ((dOMCachedNode2 = this.contextNode.parent) != null && dOMCachedNode2.isCopy() && !LazyLoadingHelper.isLastChildBuilt(dOMCachedNode2.getState()) && (dOMCachedNode = dOMCachedNode2.getOriginalNode().getCachedLastChild()) != null && dOMCachedNode.cache != this.copiedManager) {
            this.copiedManager.copyToOriginalNode(dOMCachedNode);
        }
    }

    public boolean toIds(VolatileCData volatileCData) {
        return this.toIds(volatileCData, false);
    }

    public boolean toIds(VolatileCData volatileCData, boolean bl) {
        if (this.isOriginalNode()) {
            DOMCachedNode dOMCachedNode = this.copiedManager.copyToOriginalNode(this.contextNode);
            if (dOMCachedNode != null) {
                this.contextNode = dOMCachedNode;
                this.setToCopyMode();
            } else if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "toIds", "Could not copy contextNode { " + this.contextNode.toStringLazy() + "} from tree " + this.contextNode.cache.rootNode.toStringLazy(null, "", true));
            }
        }
        this.copiedManager.copyMediator.copySubtreeLazy(this.copiedManager.rootNode, this.copiedManager);
        boolean bl2 = this.contextNode.cache.getContainsMovedCopy();
        this.contextNode.cache.setContainsMovedCopy(true);
        boolean bl3 = super.toIds(volatileCData, bl);
        this.contextNode.cache.setContainsMovedCopy(bl2);
        return bl3;
    }

    public boolean itemIsSameDocument(Cursor cursor2) {
        CacheManager cacheManager;
        CacheManager cacheManager2 = cacheManager = this.isOriginalNode() ? this.copiedManager : this.contextNode.cache;
        if (cursor2 instanceof CopiedCacheCursor) {
            CopiedCacheCursor copiedCacheCursor = (CopiedCacheCursor)cursor2;
            CacheManager cacheManager3 = copiedCacheCursor.isOriginalNode() ? copiedCacheCursor.copiedManager : copiedCacheCursor.contextNode.cache;
            return cacheManager == cacheManager3;
        }
        if (cursor2.unwrap() instanceof DOMCachedNode) {
            return cacheManager == ((DOMCachedNode)cursor2.unwrap()).cache;
        }
        return false;
    }

    public boolean itemIsSameNode(Cursor cursor2) {
        if (cursor2 instanceof CopiedCacheCursor) {
            return this.contextNode == cursor2.unwrap();
        }
        if (this.isOriginalNode()) {
            return false;
        }
        return this.contextNode.itemIsSameNode(cursor2);
    }

    public boolean itemIsBeforeNode(Cursor cursor2) {
        if (!(cursor2.unwrap() instanceof DOMCachedNode) || ((DOMCachedNode)cursor2.unwrap()).getCache() != this.contextNode.cache) {
            this.copyTo(Cursor.Area.SELF);
            CopiedCacheCursor.handlePotentialCopy(cursor2);
        }
        return this.contextNode.itemIsBeforeNode(cursor2);
    }

    public long itemDocumentIdentity() {
        return this.copiedManager.documentIdentify();
    }

    public long itemNodeIdentity() {
        this.copyTo(Cursor.Area.SELF);
        return this.contextNode.itemNodeIdentity();
    }

    public static void handlePotentialCopy(Cursor cursor2) {
        if (cursor2 instanceof CopiedCacheCursor) {
            ((CopiedCacheCursor)cursor2).copyTo(Cursor.Area.SELF);
        }
    }

    public DOMCachedNode ensureCopied(DOMCachedNode dOMCachedNode) {
        return dOMCachedNode.cache == this.copiedManager ? dOMCachedNode : this.copiedManager.copyToOriginalNode(dOMCachedNode);
    }

    public ExtendedNamespaceContext itemNamespaceContext() {
        return this.itemNamespaceContext(false);
    }

    public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
        if (this.isOriginalNode() && this.copiedManager.getNamespaceVersion() != this.contextNode.getCache().getNamespaceVersion()) {
            this.copyTo(Cursor.Area.SELF);
        }
        return this.getDelegate().itemNamespaceContext(bl);
    }

    public String itemBaseUri() {
        return this.itemBaseURI();
    }

    public String itemBaseURI() {
        this.copyTo(Cursor.Area.SELF);
        return super.itemBaseURI();
    }

    public void setItemBaseURI(String string2) {
        this.copyTo(Cursor.Area.SELF);
        super.setItemBaseURI(string2);
    }
}

