/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NameTest;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedSimple;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedText;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.CommonJAXPQNames;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.id.IDHelper;
import com.ibm.xml.xci.dp.values.BaseCDataWithChars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.util.SimpleNameTest;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.ItemPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.xs.AttributePSVImpl;
import com.ibm.xml.xml4j.internal.s1.impl.xs.ItemPSVI2;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class DOMCachedAttribute
extends DOMCachedSimple
implements Attr {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected CData name;
    protected XSTypeDefinition xstype;
    public Cursor.ItemValueOrigin itemValueOrigin;
    private static final Logger logger = LoggerUtil.getLogger(DOMCachedAttribute.class);

    public DOMCachedAttribute(CacheManager cacheManager, VolatileCData volatileCData, VolatileCData volatileCData2, AttributePSVI attributePSVI, DOMCachedElement dOMCachedElement) {
        this(cacheManager, volatileCData, volatileCData2, attributePSVI, null, dOMCachedElement);
    }

    public DOMCachedAttribute(CacheManager cacheManager, VolatileCData volatileCData, VolatileCData volatileCData2, AttributePSVI attributePSVI, XSAttributeDeclaration xSAttributeDeclaration, DOMCachedElement dOMCachedElement) {
        super(cacheManager, volatileCData2, dOMCachedElement, null);
        this.name = volatileCData.constant(true);
        if (xSAttributeDeclaration != null) {
            this.setItemXSAttributeDeclaration(xSAttributeDeclaration);
        }
        this.itemValueOrigin = Cursor.ItemValueOrigin.SPECIFIED;
        if (dOMCachedElement != null && CommonJAXPQNames.equalsXSINilQName(volatileCData)) {
            dOMCachedElement.updateXsiValue(this.data);
        }
        if (attributePSVI != null) {
            this.setItemPSVI(attributePSVI, false);
        }
        if (!this.itemIsID()) {
            this.setItemIsID(IDHelper.isAttributeID(volatileCData, volatileCData2.getXSTypeDefinition()));
            if (this.itemIsID()) {
                cacheManager.addID(this);
            }
        }
        if (!this.itemIsIDREFS()) {
            this.setItemIsIDREFS(IDHelper.isIDREF(volatileCData2.getXSTypeDefinition()));
            if (this.itemIsIDREFS()) {
                cacheManager.addIDREF(this);
            }
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "DOMCachedAttribute", "creating a new DOMCachedAttribute: " + this.toStringLazy() + "\nCache manager = " + this.getCache() + " | Mediator (default) = " + this.getCache().mediator() + " | Mediator (for node) = " + this.getMediatorData());
        }
        if (this.xstype == null && this.data != null) {
            this.xstype = this.data.getXSTypeDefinition();
        }
    }

    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        throw XCIErrorHelper.createBadContextItemException("addText", (short)2);
    }

    public DOMCachedAttribute getCachedFollowingAttribute() {
        if (this.following == null && !LazyLoadingHelper.isFollowingBuilt(this.state)) {
            if (!this.cache.mediator(this).buildNext(this)) {
                this.parent.setState(LazyLoadingHelper.markLastAttrResolved(this.parent.state));
                this.parent.setState(LazyLoadingHelper.markAttributesResolved(this.parent.state));
            }
            this.setState(LazyLoadingHelper.markFollowingResolved(this.state));
        }
        return (DOMCachedAttribute)this.following;
    }

    public DOMCachedAttribute getCachedPrecedingAttribute() {
        return this.getBuiltPrecedingAttribute();
    }

    public DOMCachedAttribute getCachedPrecedingAttribute(NodeTest nodeTest) {
        return this.getBuiltPrecedingAttribute(nodeTest);
    }

    public DOMCachedAttribute getBuiltFollowingAttribute() {
        return (DOMCachedAttribute)this.following;
    }

    public DOMCachedAttribute getBuiltPrecedingAttribute() {
        return (DOMCachedAttribute)this.preceding;
    }

    public DOMCachedAttribute getBuiltPrecedingAttribute(NodeTest nodeTest) {
        if (nodeTest == null) {
            return (DOMCachedAttribute)this.getBuiltPrecedingSibling();
        }
        for (DOMCachedAttribute dOMCachedAttribute = (DOMCachedAttribute)this.getBuiltPrecedingSibling(); dOMCachedAttribute != null; dOMCachedAttribute = (DOMCachedAttribute)dOMCachedAttribute.getBuiltPrecedingSibling()) {
            if (!dOMCachedAttribute.satisfies(nodeTest)) continue;
            return dOMCachedAttribute;
        }
        return null;
    }

    public boolean satisfies(NodeTest nodeTest) {
        return nodeTest == null || nodeTest.allowsAttribute(this.name);
    }

    public final short itemKind() {
        return 2;
    }

    public final VolatileCData itemName() {
        return this.name;
    }

    public XSTypeDefinition itemXSType() {
        XSTypeDefinition xSTypeDefinition;
        if (this.cache.isXDMXStar()) {
            ItemPSVI itemPSVI = this.itemXSPSVInfo();
            if (itemPSVI != null) {
                short s = itemPSVI.getValidity();
                short s2 = itemPSVI.getValidationAttempted();
                XSTypeDefinition xSTypeDefinition2 = itemPSVI.getTypeDefinition();
                xSTypeDefinition = s == 1 || s2 == 1 ? TypeRegistry.XSANYSIMPLETYPE : (s == 2 && s2 == 2 ? xSTypeDefinition2 : (this.xstype != null ? (this.xstype == TypeRegistry.XSANYSIMPLETYPE ? TypeRegistry.XSUNTYPEDATOMIC : this.xstype) : TypeRegistry.XSUNTYPEDATOMIC));
            } else {
                xSTypeDefinition = this.xstype != null ? (this.xstype == TypeRegistry.XSANYSIMPLETYPE ? TypeRegistry.XSUNTYPEDATOMIC : this.xstype) : TypeRegistry.XSUNTYPEDATOMIC;
            }
        } else {
            if (this.xstype != null) {
                return this.xstype;
            }
            ItemPSVI itemPSVI = this.itemXSPSVInfo();
            if (itemPSVI != null) {
                return itemPSVI.getTypeDefinition();
            }
            return super.itemXSType();
        }
        return xSTypeDefinition;
    }

    public VolatileCData itemTypedValue() {
        VolatileCData volatileCData = super.itemTypedValue();
        return volatileCData;
    }

    public ItemPSVI itemXSPSVInfo() {
        return (ItemPSVI)this.getField((byte)1);
    }

    public boolean itemIsID() {
        return BitMaskHelper.stateContains(this.state, 0x1000000);
    }

    public boolean itemIsIDREFS() {
        return BitMaskHelper.stateContains(this.state, 0x4000000);
    }

    protected void setItemIsID(boolean bl) {
        if (bl) {
            this.setState(BitMaskHelper.stateSet(this.state, 0x1000000));
        } else {
            this.setState(BitMaskHelper.stateUnset(this.state, 0x1000000));
        }
    }

    protected void setDirty(DOMCachedNode dOMCachedNode) {
        MiscHelpers.setDirty(dOMCachedNode, true);
    }

    protected void setItemIsIDREFS(boolean bl) {
        if (bl) {
            this.setState(BitMaskHelper.stateSet(this.state, 0x4000000));
        } else {
            this.setState(BitMaskHelper.stateUnset(this.state, 0x4000000));
        }
    }

    public void setItemValue(VolatileCData volatileCData) {
        if (CommonJAXPQNames.equalsXSINilQName(this.name)) {
            this.changeXsiValue(volatileCData);
        }
        if (this.itemIsID()) {
            this.cache.removeID(this);
        } else if (this.itemIsIDREFS()) {
            this.cache.removeIDREF(this);
        }
        super.setItemValue(volatileCData);
        this.xstype = volatileCData.getXSTypeDefinition();
        if (this.itemIsID()) {
            this.cache.addID(this);
        } else if (this.itemIsIDREFS()) {
            this.cache.addIDREF(this);
        }
    }

    private void changeXsiValue(VolatileCData volatileCData) {
        if (volatileCData.toString().toLowerCase(Locale.ENGLISH).equals("true")) {
            this.parent.setState(BitMaskHelper.stateSet(this.parent.state, 524288));
        } else {
            this.parent.setState(BitMaskHelper.stateUnset(this.parent.state, 524288));
        }
    }

    public void setItemName(VolatileCData volatileCData) {
        this.checkSetItemName(volatileCData);
        this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.SELF);
        this.name = volatileCData.constant(true);
        this.setDirty(this);
    }

    public void setItemPSVI(ItemPSVI itemPSVI, boolean bl) {
        if (itemPSVI == null) {
            throw XCIErrorHelper.createBadArgumentException("psvi", "null");
        }
        if (!(itemPSVI instanceof AttributePSVI)) {
            throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_PSVI_WRONG_INSTANCE", new String[]{"attributes", "AttributePSVI"}));
        }
        if (bl) {
            this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.SELF);
            this.setDirty(this);
        }
        itemPSVI = itemPSVI instanceof ItemPSVI2 ? ((ItemPSVI2)itemPSVI).constant() : new AttributePSVImpl(true, (AttributePSVI)itemPSVI);
        this.setField(itemPSVI, (byte)1);
        this.setItemXSAttributeDeclaration(((AttributePSVI)itemPSVI).getAttributeDeclaration());
        if (this.itemValueOrigin != Cursor.ItemValueOrigin.XSDDEFAULTED && this.itemValueOrigin != Cursor.ItemValueOrigin.DTDDEFAULTED) {
            this.itemValueOrigin = itemPSVI.getIsSchemaSpecified() ? Cursor.ItemValueOrigin.XSDDEFAULTED : Cursor.ItemValueOrigin.SPECIFIED;
        }
        boolean bl2 = this.itemIsID();
        boolean bl3 = this.itemIsIDREFS();
        XSTypeDefinition xSTypeDefinition = itemPSVI.getTypeDefinition();
        if (xSTypeDefinition != null) {
            this.setItemIsID(IDHelper.isAttributeID(this.name, xSTypeDefinition));
            this.setItemIsIDREFS(IDHelper.isIDREF(xSTypeDefinition));
        }
        if (bl2 != this.itemIsID()) {
            if (this.itemIsID()) {
                this.cache.addID(this);
            } else {
                this.cache.removeID(this);
            }
        }
        if (bl3 != this.itemIsIDREFS()) {
            if (this.itemIsIDREFS()) {
                this.cache.addIDREF(this);
            } else {
                this.cache.removeIDREF(this);
            }
        }
        this.retypeData();
    }

    public void setItemPSVI(ItemPSVI itemPSVI) {
        this.setItemPSVI(itemPSVI, true);
    }

    private void retypeData() {
        if (this.cache.isXDMXStar()) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)this.itemXSType();
            XSSimpleTypeDefinition xSSimpleTypeDefinition2 = this.data.getXSTypeDefinition();
            if (!(this.data == null || xSSimpleTypeDefinition.getBuiltInKind() == 1 && xSSimpleTypeDefinition2.getBuiltInKind() == 50 || xSSimpleTypeDefinition == xSSimpleTypeDefinition2 || TypeHelper.isEqual(xSSimpleTypeDefinition2, xSSimpleTypeDefinition))) {
                this.data = new BaseCDataWithChars(xSSimpleTypeDefinition, this.data.getOriginalLexicalValue() != null ? this.data.getOriginalLexicalValue() : this.sequenceConstructSimpleContent(" ", true, false));
            }
        }
    }

    public XSAttributeDeclaration itemXSAttributeDeclaration() {
        return (XSAttributeDeclaration)this.getField((byte)0);
    }

    public void setItemXSAttributeDeclaration(XSAttributeDeclaration xSAttributeDeclaration) {
        this.setField(xSAttributeDeclaration, (byte)0);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setXSAttributeDeclaration", "setting the schema declaration on an attribute");
        }
    }

    public void setItemXSType(XSTypeDefinition xSTypeDefinition) {
        this.xstype = xSTypeDefinition;
        if (this.xstype != this.data.getXSTypeDefinition()) {
            this.retypeData();
        }
    }

    public VolatileCData serialize(Map map2) {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"serialize", DOMCachedAttribute.class.getName()}));
    }

    public boolean test(Cursor cursor2) {
        return cursor2.itemKind() == 2 && this.name.equals(cursor2.itemName());
    }

    public boolean allowsAttribute(VolatileCData volatileCData) {
        return this.name.equals(volatileCData);
    }

    public NameTest theNameTest() {
        return SimpleNameTest.name(this.itemName());
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public short getNodeType() {
        return 2;
    }

    public DOMCachedNode getParentNode() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNamespaceURI() {
        return BitMaskHelper.stateContains(this.state, 65536) ? null : this.name.getQNameNamespaceURI(1);
    }

    public String getPrefix() {
        return BitMaskHelper.stateContains(this.state, 65536) ? null : this.name.getQNamePrefix(1);
    }

    public void setPrefix(String string2) throws DOMException {
    }

    public String getLocalName() {
        return BitMaskHelper.stateContains(this.state, 65536) ? null : this.name.getQNameLocalPart(1);
    }

    public String getName() {
        String string2 = this.name.getQNamePrefix(1);
        return (string2 == null || string2.length() == 0 ? "" : string2 + ":") + this.name.getQNameLocalPart(1);
    }

    public boolean getSpecified() {
        return true;
    }

    public String getValue() {
        return this.data == null ? "" : this.data.toString();
    }

    public void setValue(String string2) throws DOMException {
        this.setItemValue(this.factory.data((CharSequence)string2, TypeRegistry.XSSTRING, false));
    }

    public Element getOwnerElement() {
        if (this.parent == null) {
            return null;
        }
        assert (this.parent.itemKind() == 1) : "Attribute has  no parent?";
        return (Element)((Object)this.parent);
    }

    public boolean isId() {
        return this.itemIsID();
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    protected void printXQuery(Writer writer, String string2, boolean bl) throws IOException {
        if (this.data != null) {
            writer.write(string2 + " attribute " + this.printName() + this.printState() + " { " + CharsBase.toEncodedString(this.data));
        } else {
            writer.write(string2 + " attribute " + this.printName() + this.printState() + " { nulldata }");
        }
    }

    public Cursor.ItemValueOrigin itemAttributeValueOrigin() {
        return this.itemValueOrigin;
    }

    public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
        if (bl) {
            return this.parent == null ? null : this.parent.itemNamespaceContext();
        }
        return null;
    }

    public boolean hasChildNodes() {
        return true;
    }

    public final Node getFirstChild() {
        Node node2 = (Node)this.getField((byte)2);
        if (node2 == null) {
            node2 = new DOMCachedText(this.cache, this.data, false, false, null, null);
            this.setField(node2, (byte)2);
        }
        return node2;
    }

    public final Node getLastChild() {
        return this.getFirstChild();
    }

    public NodeList getChildNodes() {
        return new AttrChild();
    }

    class AttrChild
    implements NodeList {
        public int getLength() {
            return 1;
        }

        public Node item(int n2) {
            if (n2 < 0 || n2 >= this.getLength()) {
                return null;
            }
            return DOMCachedAttribute.this.getFirstChild();
        }
    }
}

