/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DOMCachedContainer
extends DOMCachedNode {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected DOMCachedNode builtFirstChild;
    private static final Logger logger = LoggerUtil.getLogger(DOMCachedContainer.class);

    protected DOMCachedContainer(CacheManager cacheManager) {
        super(cacheManager);
    }

    protected DOMCachedContainer(CacheManager cacheManager, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        super(cacheManager, dOMCachedContainer, dOMCachedNode);
    }

    public void unlinkChild(DOMCachedNode dOMCachedNode) {
        if (dOMCachedNode == null) {
            return;
        }
        if (dOMCachedNode.following != null && dOMCachedNode.isCopy() && dOMCachedNode.cache != dOMCachedNode.following.cache) {
            dOMCachedNode.makeCopy(dOMCachedNode.following);
        }
        if (dOMCachedNode == this.builtFirstChild) {
            this.setBuiltFirstChild(dOMCachedNode.following);
        }
        dOMCachedNode.unlink();
    }

    private final void importNode(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("this= " + this.toStringLazy());
            stringBuilder.append('\n');
            stringBuilder.append("new tree=" + this.getCache().getBuiltRootNode().toStringLazy(null, "", true));
            stringBuilder.append('\n');
            stringBuilder.append("child" + dOMCachedNode.toStringLazy());
            stringBuilder.append('\n');
            stringBuilder.append("old tree=" + dOMCachedNode.getCache().getBuiltRootNode().toStringLazy(null, "", true));
            logger.logp(Level.FINE, logger.getName(), "importNode", "went into import node:\n" + stringBuilder.toString() + "\nStack=" + XCIErrorHelper.getStackTrace(15));
        }
        dOMCachedNode.updateCacheLazy(this.getCache());
    }

    public final void addBuiltFirstChild(List<DOMCachedNode> list) {
        if (this.builtFirstChild == null) {
            this.setBuiltFirstChild(list.get(0));
        } else {
            if (this.builtFirstChild == list.get(0)) {
                return;
            }
            this.builtFirstChild.preceding = list.get(list.size() - 1);
            list.get(list.size() - 1).setBuiltFollowingSibling(this.builtFirstChild);
            this.checkAdjacent(list.get(list.size() - 1), this.builtFirstChild);
            this.setBuiltFirstChild(list.get(0));
        }
        if (this.indexed()) {
            this.setState(this.state & 0xFFFBFFFF);
        }
    }

    public final void addBuiltFirstChild(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addBuiltFirstChild", "adding first child to node");
        }
        if (this.builtFirstChild == null) {
            this.setBuiltFirstChild(dOMCachedNode);
        } else {
            this.builtFirstChild.preceding = dOMCachedNode;
            dOMCachedNode.setBuiltFollowingSibling(this.builtFirstChild);
            this.setBuiltFirstChild(dOMCachedNode);
        }
        if (this.indexed()) {
            this.setState(this.state & 0xFFFBFFFF);
        }
        if (dOMCachedNode.cache != this.cache) {
            this.importNode(dOMCachedNode);
        }
    }

    public void addBuiltFirstChildText(VolatileCData volatileCData, boolean bl) {
        this.addBuiltFirstChild(this.cache.makeCachedText(volatileCData, bl, false, this, null));
    }

    public void addBuiltLastChild(List<DOMCachedNode> list) {
        DOMCachedNode dOMCachedNode = this.getBuiltLastChild();
        if (dOMCachedNode == null) {
            this.addBuiltFirstChild(list);
        } else {
            this.addBuiltNextChild(list, dOMCachedNode);
        }
    }

    public void addBuiltLastChild(DOMCachedNode dOMCachedNode) {
        DOMCachedNode dOMCachedNode2;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addBuiltLastChild", "node=" + dOMCachedNode.toStringLazy());
        }
        if ((dOMCachedNode2 = this.getBuiltLastChild()) == null) {
            this.addBuiltFirstChild(dOMCachedNode);
        } else {
            this.addBuiltNextChild(dOMCachedNode, dOMCachedNode2);
        }
    }

    public void addBuiltNextChild(List<DOMCachedNode> list, DOMCachedNode dOMCachedNode) {
        DOMCachedNode dOMCachedNode2 = dOMCachedNode.following;
        if (dOMCachedNode2 == null) {
            dOMCachedNode.setBuiltFollowingSibling(list.get(0));
            list.get((int)0).preceding = dOMCachedNode;
        } else {
            if (dOMCachedNode2 == list.get(0)) {
                return;
            }
            dOMCachedNode.setBuiltFollowingSibling(list.get(0));
            list.get(list.size() - 1).setBuiltFollowingSibling(dOMCachedNode2);
            list.get((int)0).preceding = dOMCachedNode;
            dOMCachedNode2.preceding = list.get(list.size() - 1);
        }
        this.checkAdjacent(dOMCachedNode, list.get(0));
        this.checkAdjacent(list.get(list.size() - 1), dOMCachedNode2);
        if (this.indexed()) {
            this.setState(this.state & 0xFFFBFFFF);
        }
    }

    private DOMCachedNode getBuiltLastChild() {
        DOMCachedNode dOMCachedNode = this.getBuiltFirstChild();
        if (dOMCachedNode == null) {
            return null;
        }
        while (dOMCachedNode.getBuiltFollowingSibling() != null) {
            dOMCachedNode = dOMCachedNode.getBuiltFollowingSibling();
        }
        return dOMCachedNode;
    }

    public void addBuiltNextChild(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        DOMCachedNode dOMCachedNode3 = dOMCachedNode2.following;
        if (dOMCachedNode3 == null) {
            assert (this.getBuiltLastChild() == dOMCachedNode2) : "Indicated last sibling is not last for this parent?!?";
            dOMCachedNode2.setBuiltFollowingSibling(dOMCachedNode);
            dOMCachedNode.preceding = dOMCachedNode2;
        } else {
            dOMCachedNode2.setBuiltFollowingSibling(dOMCachedNode);
            dOMCachedNode.setBuiltFollowingSibling(dOMCachedNode3);
            dOMCachedNode.preceding = dOMCachedNode2;
            dOMCachedNode3.preceding = dOMCachedNode;
        }
        if (this.indexed()) {
            this.setState(this.state & 0xFFFBFFFF);
        }
        if (dOMCachedNode.cache != this.cache) {
            this.importNode(dOMCachedNode);
        }
    }

    public void addCachedFirstChild(DOMCachedNode dOMCachedNode) {
        assert (dOMCachedNode.getBuiltParent() == this);
        assert (dOMCachedNode.getBuiltPrecedingSibling() == null);
        assert (dOMCachedNode.getBuiltFollowingSibling() == null);
        DOMCachedNode dOMCachedNode2 = LazyLoadingHelper.isFirstChildBuilt(this.state) ? this.getBuiltFirstChild() : this.getCachedFirstChild();
        this.addBuiltFirstChild(dOMCachedNode);
        if (dOMCachedNode2 == null) {
            this.setState(LazyLoadingHelper.markFirstChildResolved(this.state));
            dOMCachedNode.setState(LazyLoadingHelper.markPrecedingParentResolved(dOMCachedNode.state));
        } else {
            dOMCachedNode2.setState(LazyLoadingHelper.markPrecedingResolved(dOMCachedNode2.state));
            dOMCachedNode.setState(LazyLoadingHelper.markPrecedingFollowingParentResolved(dOMCachedNode.state));
        }
    }

    public void addCachedLastChild(DOMCachedNode dOMCachedNode) {
        DOMCachedNode dOMCachedNode2 = this.getCachedLastChild();
        if (dOMCachedNode2 == null) {
            this.addCachedFirstChild(dOMCachedNode);
        } else {
            this.addCachedNextChild(dOMCachedNode, dOMCachedNode2);
        }
    }

    public void addCachedNextChild(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        DOMCachedNode dOMCachedNode3 = dOMCachedNode2.getBuiltFollowingSibling();
        this.addBuiltNextChild(dOMCachedNode, dOMCachedNode2);
        if (dOMCachedNode3 == null) {
            dOMCachedNode.setState(LazyLoadingHelper.markPrecedingParentResolved(dOMCachedNode.state));
        } else {
            dOMCachedNode.setState(LazyLoadingHelper.markPrecedingFollowingParentResolved(dOMCachedNode.state));
        }
    }

    @Override
    public final DOMCachedNode getBuiltFirstChild(NodeTest nodeTest) {
        if (nodeTest == null) {
            return this.getBuiltFirstChild();
        }
        DOMCachedNode dOMCachedNode = this.builtFirstChild;
        while (dOMCachedNode != null) {
            if (dOMCachedNode.satisfies(nodeTest)) {
                return dOMCachedNode;
            }
            dOMCachedNode = dOMCachedNode.following;
        }
        return null;
    }

    @Override
    public final DOMCachedNode getCachedFirstChild(NodeTest nodeTest) {
        if (LazyLoadingHelper.isChildrenResolved(this.state)) {
            return this.getBuiltFirstChild(nodeTest);
        }
        if (nodeTest == null) {
            return this.getCachedFirstChild();
        }
        for (DOMCachedNode dOMCachedNode = this.getCachedFirstChild(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getCachedFollowingSibling()) {
            if (!dOMCachedNode.satisfies(nodeTest)) continue;
            return dOMCachedNode;
        }
        return null;
    }

    public DOMCachedNode getBuiltChildAt(long l) {
        DOMCachedNode dOMCachedNode = this.builtFirstChild;
        while (dOMCachedNode != null) {
            if (--l == 0L) {
                return dOMCachedNode;
            }
            dOMCachedNode = dOMCachedNode.following;
        }
        return null;
    }

    public DOMCachedNode getCachedChildAt(long l) {
        if (LazyLoadingHelper.isChildrenResolved(this.state)) {
            return this.getBuiltChildAt(l);
        }
        for (DOMCachedNode dOMCachedNode = this.getCachedFirstChild(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getCachedFollowingSibling()) {
            if (--l != 0L) continue;
            return dOMCachedNode;
        }
        return null;
    }

    protected final boolean indexed() {
        return false;
    }

    protected final boolean isValidChildIndex() {
        return (this.state & 0x40000) != 0;
    }

    @Override
    public final DOMCachedNode getCachedFirstChild() {
        if (this.builtFirstChild == null && !LazyLoadingHelper.isFirstChildBuilt(this.state)) {
            if (this.cache.mediator(this).buildChildren(this, null)) {
                this.setState(LazyLoadingHelper.markFirstChildResolved(this.state));
                if (this.itemIsID()) {
                    this.getCache().addID((DOMCachedElement)this);
                }
            } else {
                this.setState(LazyLoadingHelper.markChildrenResolved(this.state));
            }
        }
        return this.builtFirstChild;
    }

    @Override
    public final DOMCachedNode getBuiltFirstChild() {
        return this.builtFirstChild;
    }

    public void setBuiltFirstChild(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            String string2 = dOMCachedNode == null ? "null" : dOMCachedNode.toStringLazy();
            logger.logp(Level.FINEST, logger.getName(), "setBuiltFirstChild", "this = " + this.toStringLazy() + "node passed in = " + string2 + "\nStack trace=" + XCIErrorHelper.getStackTrace(15));
        }
        this.builtFirstChild = dOMCachedNode;
    }

    @Override
    public final DOMCachedNode getCachedLastChild() {
        DOMCachedNode dOMCachedNode = this.getCachedFirstChild();
        if (dOMCachedNode == null) {
            return null;
        }
        while (dOMCachedNode.getCachedFollowingSibling() != null) {
            dOMCachedNode = dOMCachedNode.getCachedFollowingSibling();
        }
        return dOMCachedNode;
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public NodeList getChildNodes() {
        return new Children();
    }

    @Override
    public Node insertBefore(Node node2, Node node3) throws DOMException {
        DOMCachedNode dOMCachedNode;
        DOMCachedNode dOMCachedNode2;
        if (node3 == null) {
            this.appendChild(node2);
        }
        if (node3.getParentNode() != this) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        if (node2.getOwnerDocument() != this.getOwnerDocument()) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        for (dOMCachedNode2 = this.parent; dOMCachedNode2 != null; dOMCachedNode2 = dOMCachedNode2.getBuiltParent()) {
            if (this.parent != node2) continue;
            throw XCIErrorHelper.createDOMException((short)3);
        }
        dOMCachedNode2 = (DOMCachedNode)node3;
        DOMCachedNode dOMCachedNode3 = (DOMCachedNode)node2;
        assert (dOMCachedNode3.getCache() == dOMCachedNode2.getCache()) : "Cache inconsistency!";
        if (dOMCachedNode3.getBuiltParent() != null) {
            dOMCachedNode3.unlink();
        }
        if ((dOMCachedNode = dOMCachedNode2.getCachedPrecedingSibling()) == null) {
            this.addCachedFirstChild(dOMCachedNode3);
        } else {
            this.addCachedNextChild(dOMCachedNode3, dOMCachedNode);
        }
        return dOMCachedNode3;
    }

    @Override
    public Node replaceChild(Node node2, Node node3) throws DOMException {
        DOMCachedNode dOMCachedNode;
        if (node3.getParentNode() != this) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        if (node2.getOwnerDocument() != this.getOwnerDocument()) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        for (dOMCachedNode = this.parent; dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltParent()) {
            if (this.parent != node2) continue;
            throw XCIErrorHelper.createDOMException((short)3);
        }
        dOMCachedNode = (DOMCachedNode)node2;
        DOMCachedNode dOMCachedNode2 = (DOMCachedNode)node3;
        assert (dOMCachedNode.cache == dOMCachedNode2.cache) : "Cache inconsistency!";
        if (dOMCachedNode.parent != null) {
            dOMCachedNode.unlink();
        }
        dOMCachedNode.setParent(this);
        dOMCachedNode.setBuiltFollowingSibling(dOMCachedNode2.following);
        dOMCachedNode.preceding = dOMCachedNode2.preceding;
        dOMCachedNode2.unlink();
        return dOMCachedNode2;
    }

    @Override
    public Node removeChild(Node node2) throws DOMException {
        if (node2.getParentNode() != this) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        ((DOMCachedNode)node2).unlink();
        ((DOMCachedNode)node2).updateCacheEntire(this.cache.getNewInstance());
        return node2;
    }

    @Override
    public Node appendChild(Node node2) throws DOMException {
        DOMCachedNode dOMCachedNode;
        for (dOMCachedNode = this.parent; dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltParent()) {
            if (this.parent != node2) continue;
            throw XCIErrorHelper.createDOMException((short)3);
        }
        dOMCachedNode = (DOMCachedNode)node2;
        if (dOMCachedNode.parent != null) {
            dOMCachedNode.unlink();
        }
        dOMCachedNode.setParent(this);
        DOMCachedNode dOMCachedNode2 = this.getCachedLastChild();
        if (dOMCachedNode2 == null) {
            this.addCachedFirstChild(dOMCachedNode);
        } else {
            this.addCachedNextChild(dOMCachedNode, dOMCachedNode2);
        }
        return dOMCachedNode;
    }

    @Override
    public boolean hasChildNodes() {
        return this.getCachedFirstChild() != null;
    }

    class ElementDescendants
    extends Children {
        CacheCursor descendantWalker;

        ElementDescendants() {
            this.descendantWalker = null;
        }

        ElementDescendants(String string2, String string3) {
            super(string2, string3);
            this.descendantWalker = null;
        }

        protected DOMCachedNode next() {
            if (this.done) {
                return null;
            }
            DOMCachedNode dOMCachedNode = null;
            if (this.descendantWalker == null) {
                this.descendantWalker = DOMCachedContainer.this.cache.popCacheCursor(DOMCachedContainer.this, Cursor.Profile.RANDOM_ACCESS, false);
                dOMCachedNode = this.descendantWalker.toDescendants(null) ? this.descendantWalker.contextNode : null;
            } else {
                DOMCachedNode dOMCachedNode2 = dOMCachedNode = this.descendantWalker.toNext() ? this.descendantWalker.contextNode : null;
            }
            if (this.alsoNonElements && dOMCachedNode != null) {
                this.list.add(dOMCachedNode);
                return dOMCachedNode;
            }
            while (dOMCachedNode != null) {
                if (dOMCachedNode.itemKind() == 1) {
                    QName qName = dOMCachedNode.itemName().getQName(1, null);
                    if ((this.namespaceURI == null || this.namespaceURI.equals(qName.getNamespaceURI())) && (this.localPart == null || this.localPart.equals(qName.getLocalPart()))) {
                        this.list.add(dOMCachedNode);
                        return dOMCachedNode;
                    }
                }
                dOMCachedNode = this.descendantWalker.toNext() ? this.descendantWalker.contextNode : null;
            }
            this.done = true;
            return null;
        }
    }

    class Children
    implements NodeList {
        final boolean alsoNonElements;
        final String namespaceURI;
        final String localPart;
        final List<DOMCachedNode> list;
        boolean done;

        Children() {
            this.alsoNonElements = true;
            this.namespaceURI = null;
            this.localPart = null;
            this.list = new LinkedList<DOMCachedNode>();
        }

        Children(String string2, String string3) {
            this.alsoNonElements = false;
            this.namespaceURI = "*".equals(string2) ? null : string2;
            this.localPart = "*".equals(string3) ? null : string3;
            this.list = new LinkedList<DOMCachedNode>();
        }

        public int getLength() {
            if (!this.done) {
                while (this.next() != null) {
                }
            }
            assert (this.done) : "Could not get length!";
            return this.list.size();
        }

        public Node item(int n2) {
            if (n2 < 0) {
                return null;
            }
            if (!this.done) {
                for (int i = this.list.size(); i <= n2; ++i) {
                    DOMCachedNode dOMCachedNode = this.next();
                    if (dOMCachedNode != null) continue;
                    return null;
                }
            }
            if (n2 < this.list.size()) {
                return this.list.get(n2);
            }
            return null;
        }

        protected DOMCachedNode next() {
            DOMCachedNode dOMCachedNode;
            if (this.done) {
                return null;
            }
            DOMCachedNode dOMCachedNode2 = dOMCachedNode = this.list.isEmpty() ? DOMCachedContainer.this.getCachedFirstChild() : this.list.get(this.list.size() - 1).getCachedFollowingSibling();
            if (this.alsoNonElements && dOMCachedNode != null) {
                this.list.add(dOMCachedNode);
                return dOMCachedNode;
            }
            while (dOMCachedNode != null) {
                if (dOMCachedNode.itemKind() == 1) {
                    QName qName = dOMCachedNode.itemName().getQName(1, null);
                    if ((this.namespaceURI == null || this.namespaceURI.equals(qName.getNamespaceURI())) && (this.localPart == null || this.localPart.equals(qName.getLocalPart()))) {
                        this.list.add(dOMCachedNode);
                        return dOMCachedNode;
                    }
                }
                dOMCachedNode = dOMCachedNode.getCachedFollowingSibling();
            }
            this.done = true;
            return null;
        }
    }
}

