/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NameTest;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedSimple;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedText;
import com.ibm.xml.xci.dp.cache.dom.InternalNodeData;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.helpers.NSListIterator;
import com.ibm.xml.xci.dp.cache.dom.mediator.CopiedCacheMediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingDataFactory;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.BaseURIHelper;
import com.ibm.xml.xci.dp.util.CommonJAXPQNames;
import com.ibm.xml.xci.dp.util.StringCDataBuilder;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.BaseCDataWithChars;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.errors.XCIIllegalContextItemException;
import com.ibm.xml.xci.internal.cast.CastUtilities;
import com.ibm.xml.xci.internal.values.Base64BinaryCData;
import com.ibm.xml.xci.internal.values.HexBinaryCData;
import com.ibm.xml.xci.internal.values.InvalidEmptyCData;
import com.ibm.xml.xci.internal.values.QNameCData;
import com.ibm.xml.xci.internal.values.QNameCDataLocalOnly;
import com.ibm.xml.xci.internal.values.StoredCharsCData;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.util.SimpleNameTest;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.ElementPSVI;
import com.ibm.xml.xml4j.api.s1.xs.ItemPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import com.ibm.xml.xml4j.internal.s1.impl.xs.ElementPSVImpl;
import com.ibm.xml.xml4j.internal.s1.impl.xs.ItemPSVI2;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMCachedElement
extends DOMCachedContainer
implements Element,
NamedNodeMap,
ExtendedNamespaceContext {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private CData name;
    protected XSTypeDefinition xstype;
    protected DOMCachedAttribute builtFirstAttribute;
    protected DOMCachedNamespace builtFirstNamespace;
    private static final Logger logger = LoggerUtil.getLogger(DOMCachedElement.class);
    protected ElementNSContext nsContext;
    private List<String> originalNSList;
    byte mutationVersion = 0;

    public DOMCachedElement(CacheManager cacheManager) {
        super(cacheManager);
    }

    protected DOMCachedElement(CacheManager cacheManager, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition, ElementPSVI elementPSVI, boolean bl, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        this(cacheManager, volatileCData, xSTypeDefinition, elementPSVI, null, bl, dOMCachedContainer, dOMCachedNode);
    }

    protected DOMCachedElement(CacheManager cacheManager, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition, ElementPSVI elementPSVI, XSElementDeclaration xSElementDeclaration, boolean bl, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        super(cacheManager, dOMCachedContainer, dOMCachedNode);
        this.name = volatileCData.constant(true);
        this.setItemXSType(xSTypeDefinition);
        if (xSElementDeclaration != null) {
            this.setItemXSElementDeclaration(xSElementDeclaration);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "DOMCachedElement", "creating a new DOMCachedElement with name=" + this.name.getString(1));
        }
        if (elementPSVI != null) {
            this.setItemPSVI(elementPSVI, false);
        }
        if (bl) {
            this.setState(BitMaskHelper.stateSet(this.state, 524288));
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "DOMCachedElement", "creating a new DOMCachedElement: " + this.toStringLazy() + "\nCache manager = " + this.getCache() + " | Mediator (default) = " + this.getCache().mediator() + " | Mediator (for node) = " + this.getMediatorData());
        }
    }

    public static boolean isElementIDTyped(XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition == null) {
            return false;
        }
        return xSTypeDefinition.getTypeCategory() == 16 ? ((XSSimpleTypeDefinition)xSTypeDefinition).getBuiltInKind() == 27 : false;
    }

    protected void addBuiltAttribute(DOMCachedAttribute dOMCachedAttribute) {
        Object object2;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            object2 = "";
            String string2 = "";
            try {
                object2 = dOMCachedAttribute.itemName() == null ? "not set yet" : dOMCachedAttribute.itemName().getString(1);
                string2 = dOMCachedAttribute.itemStringValue() == null ? "" : dOMCachedAttribute.itemStringValue().getString(1);
                logger.logp(Level.FINEST, logger.getName(), "addBuiltAttribute", "name=" + (String)object2 + " | " + "value=" + string2 + "\nStack trace= " + XCIErrorHelper.getStackTrace(15));
            }
            catch (Exception exception) {
                logger.logp(Level.FINER, logger.getName(), "addAttributeWithTypeInfo", "Exception was thrown. name=" + (String)object2 + " | " + "value=" + string2, exception);
            }
        }
        dOMCachedAttribute.setParent(this);
        if (this.builtFirstAttribute == null) {
            this.builtFirstAttribute = dOMCachedAttribute;
            if (dOMCachedAttribute.name != null && !LazyLoadingHelper.isAttributesBuilt(this.state)) {
                dOMCachedAttribute.setState(BitMaskHelper.stateUnset(dOMCachedAttribute.state, 512));
                this.updateXCIDataOrClone(dOMCachedAttribute);
                this.setState(BitMaskHelper.stateSet(this.state, 1));
            }
        } else {
            object2 = this.getBuiltLastAttribute();
            if (dOMCachedAttribute == object2 || dOMCachedAttribute == this.builtFirstAttribute) {
                return;
            }
            dOMCachedAttribute.preceding = object2;
            ((DOMCachedNode)object2).setBuiltFollowingSibling(dOMCachedAttribute);
            dOMCachedAttribute.setBuiltFollowingSibling(null);
            int n2 = dOMCachedAttribute.preceding.state;
            if (dOMCachedAttribute.name != null && !BitMaskHelper.stateContains(n2, 512)) {
                this.updateXCIDataOrClone(dOMCachedAttribute);
                dOMCachedAttribute.setState(BitMaskHelper.stateUnset(dOMCachedAttribute.state, 512));
            }
        }
        if (dOMCachedAttribute.name != null && dOMCachedAttribute.cache != this.cache) {
            if (dOMCachedAttribute.itemIsID()) {
                dOMCachedAttribute.cache.removeID(dOMCachedAttribute);
                this.cache.addID(dOMCachedAttribute);
            } else if (dOMCachedAttribute.itemIsIDREFS()) {
                dOMCachedAttribute.cache.removeIDREF(dOMCachedAttribute);
                this.cache.addIDREF(dOMCachedAttribute);
            }
            dOMCachedAttribute.cache = this.cache;
        }
        if (dOMCachedAttribute.name != null && CommonJAXPQNames.equalsXSINilQName(dOMCachedAttribute.name)) {
            this.updateXsiValue(dOMCachedAttribute.data);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addBuiltAttribute", "Added a built attribute=" + dOMCachedAttribute.toStringLazy() + " | into parent=" + this.toStringLazy());
        }
    }

    private void updateXCIDataOrClone(DOMCachedNode dOMCachedNode) {
        if (dOMCachedNode.getInternalNodeData() == null) {
            InternalNodeData internalNodeData = this.getInternalNodeData();
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "updateXCIDataOrClone", "Built node did NOT have an UserData. Will attempt to clone parent's UserData which is: " + internalNodeData);
            }
            if (internalNodeData != null) {
                dOMCachedNode.setInternalNodeData(internalNodeData.cloneData());
            }
        } else if (this.getInternalNodeData() instanceof StreamingDataFactory.XCIData) {
            Cursor cursor2 = ((StreamingDataFactory.XCIData)((Object)this.getInternalNodeData())).getXCI();
            ((StreamingDataFactory.XCIData)((Object)dOMCachedNode.getInternalNodeData())).setXCI(cursor2);
        }
    }

    protected void addBuiltAttribute(List<DOMCachedNode> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addBuiltAttribute((DOMCachedAttribute)list.get(i));
        }
        list.clear();
    }

    protected void addBuiltNamespace(List<DOMCachedNode> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addBuiltNamespace((DOMCachedNamespace)list.get(i));
        }
        list.clear();
    }

    @Override
    public final boolean itemIsSameNode(Cursor cursor2) {
        return this == cursor2.unwrap();
    }

    @Override
    public boolean itemIsID() {
        return BitMaskHelper.stateContains(this.state, 0x1000000);
    }

    protected void updateXsiValue(VolatileCData volatileCData) {
        if (volatileCData.toString().toLowerCase(Locale.ENGLISH).equals("true")) {
            this.setState(BitMaskHelper.stateSet(this.state, 524288));
        } else {
            this.setState(BitMaskHelper.stateUnset(this.state, 524288));
        }
    }

    public void addBuiltNamespace(DOMCachedNamespace dOMCachedNamespace) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "addBuitNamespace", "adding built namespace = " + dOMCachedNamespace.toStringLazy() + " into element = " + this.toStringLazy() + "\n Stack trace = " + XCIErrorHelper.getStackTrace(20));
        }
        dOMCachedNamespace.setParent(this);
        if (this.builtFirstNamespace == null) {
            this.builtFirstNamespace = dOMCachedNamespace;
            if (dOMCachedNamespace.name != null && !LazyLoadingHelper.isNamespacesBuilt(this.state)) {
                dOMCachedNamespace.setState(BitMaskHelper.stateUnset(dOMCachedNamespace.state, 512));
                this.updateXCIDataOrClone(dOMCachedNamespace);
                this.setState(BitMaskHelper.stateSet(this.state, 2048));
            }
        } else {
            DOMCachedNamespace dOMCachedNamespace2 = this.getBuiltLastNamespace();
            dOMCachedNamespace.preceding = dOMCachedNamespace2;
            dOMCachedNamespace2.setBuiltFollowingSibling(dOMCachedNamespace);
            dOMCachedNamespace.setBuiltFollowingSibling(null);
            int n2 = dOMCachedNamespace.preceding.state;
            if (dOMCachedNamespace.name != null && !BitMaskHelper.stateContains(n2, 512)) {
                this.updateXCIDataOrClone(dOMCachedNamespace);
                dOMCachedNamespace.setState(BitMaskHelper.stateUnset(dOMCachedNamespace.state, 512));
            }
        }
        dOMCachedNamespace.cache = this.cache;
    }

    public void addBuiltAttribute(VolatileCData volatileCData, CData cData) {
        this.addBuiltAttribute(this.cache.makeCachedAttribute(volatileCData, cData, null, null, this));
    }

    public DOMCachedAttribute getCachedAttribute(VolatileCData volatileCData) {
        if (LazyLoadingHelper.isAttributesBuilt(this.state)) {
            return this.getBuiltAttribute(volatileCData);
        }
        for (DOMCachedAttribute dOMCachedAttribute = this.getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
            if (!dOMCachedAttribute.itemName().equals(volatileCData)) continue;
            return dOMCachedAttribute;
        }
        return null;
    }

    public DOMCachedAttribute getBuiltAttribute(VolatileCData volatileCData) {
        DOMCachedAttribute dOMCachedAttribute = this.builtFirstAttribute;
        while (dOMCachedAttribute != null) {
            if (dOMCachedAttribute.itemName().equals(volatileCData)) {
                return dOMCachedAttribute;
            }
            dOMCachedAttribute = (DOMCachedAttribute)dOMCachedAttribute.following;
        }
        return null;
    }

    @Override
    protected DOMCachedAttribute getBuiltNamedAttribute(NodeTest nodeTest) {
        if (nodeTest == null) {
            return this.getBuiltFirstAttribute();
        }
        if (!nodeTest.allowsAttribute(null)) {
            return null;
        }
        DOMCachedAttribute dOMCachedAttribute = this.builtFirstAttribute;
        while (dOMCachedAttribute != null) {
            if (nodeTest.test(dOMCachedAttribute)) {
                return dOMCachedAttribute;
            }
            dOMCachedAttribute = (DOMCachedAttribute)dOMCachedAttribute.following;
        }
        return null;
    }

    @Override
    public DOMCachedAttribute getCachedFirstAttribute() {
        if (this.builtFirstAttribute == null && !LazyLoadingHelper.isFirstAttributeBuilt(this.state)) {
            if (!this.cache.mediator(this).buildAttributes(this, null)) {
                this.setState(LazyLoadingHelper.markAttributesResolved(this.state));
            }
            this.setState(LazyLoadingHelper.markFirstAttributeResolved(this.state));
        }
        return this.builtFirstAttribute;
    }

    @Override
    public DOMCachedAttribute getCachedNamedAttribute(NodeTest nodeTest) {
        if (LazyLoadingHelper.isAttributesBuilt(this.state)) {
            return this.getBuiltNamedAttribute(nodeTest);
        }
        if (nodeTest == null) {
            return this.getCachedFirstAttribute();
        }
        if (!nodeTest.allowsAttribute(null)) {
            return null;
        }
        for (DOMCachedAttribute dOMCachedAttribute = this.getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
            if (!nodeTest.test(dOMCachedAttribute)) continue;
            return dOMCachedAttribute;
        }
        return null;
    }

    @Override
    public DOMCachedNamespace getCachedNamedNamespace(NodeTest nodeTest) {
        if (nodeTest == null) {
            return this.getCachedFirstNamespaceNode();
        }
        for (DOMCachedNamespace dOMCachedNamespace = this.getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
            if (!nodeTest.test(dOMCachedNamespace)) continue;
            return dOMCachedNamespace;
        }
        return null;
    }

    @Override
    public DOMCachedAttribute getCachedLastAttribute() {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedFirstAttribute();
        if (dOMCachedAttribute == null) {
            return null;
        }
        while (dOMCachedAttribute.getCachedFollowingAttribute() != null) {
            dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute();
        }
        return dOMCachedAttribute;
    }

    @Override
    public DOMCachedNamespace getCachedFirstNamespaceNode() {
        if (this.builtFirstNamespace == null && !LazyLoadingHelper.isFirstNamespaceBuilt(this.state)) {
            if (!this.cache.mediator(this).buildNamespaceNodes(this, null)) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "getCachedFirstNamespaceNode", "going to set namespace resolved !!!");
                }
                this.setState(LazyLoadingHelper.markNamespacesResolved(this.state));
            }
            this.setState(LazyLoadingHelper.markFirstNamespaceResolved(this.state));
        }
        return this.builtFirstNamespace;
    }

    @Override
    public DOMCachedNamespace getCachedLastNamespaceNode() {
        DOMCachedNamespace dOMCachedNamespace = this.getCachedFirstNamespaceNode();
        if (dOMCachedNamespace == null) {
            return null;
        }
        while (dOMCachedNamespace.getCachedFollowingNamespaceNode() != null) {
            dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode();
        }
        return dOMCachedNamespace;
    }

    @Override
    public final DOMCachedAttribute getBuiltFirstAttribute() {
        return this.builtFirstAttribute;
    }

    @Override
    public final DOMCachedAttribute getBuiltLastAttribute() {
        DOMCachedAttribute dOMCachedAttribute = this.getBuiltFirstAttribute();
        if (dOMCachedAttribute == null) {
            return null;
        }
        while (dOMCachedAttribute.getBuiltFollowingAttribute() != null) {
            dOMCachedAttribute = dOMCachedAttribute.getBuiltFollowingAttribute();
        }
        return dOMCachedAttribute;
    }

    public void setBuiltFirstAttribute(DOMCachedAttribute dOMCachedAttribute) {
        this.builtFirstAttribute = dOMCachedAttribute;
    }

    @Override
    public boolean satisfies(NodeTest nodeTest) {
        return nodeTest == null || nodeTest.allowsElement(this.itemName());
    }

    @Override
    public DOMCachedNamespace getBuiltFirstNamespace() {
        return this.builtFirstNamespace;
    }

    public void setBuiltFirstNamespace(DOMCachedNamespace dOMCachedNamespace) {
        this.builtFirstNamespace = dOMCachedNamespace;
    }

    @Override
    public DOMCachedNamespace getBuiltLastNamespace() {
        DOMCachedNamespace dOMCachedNamespace = this.getBuiltFirstNamespace();
        if (dOMCachedNamespace == null) {
            return null;
        }
        while (dOMCachedNamespace.getBuiltFollowingNamespaceNode() != null) {
            dOMCachedNamespace = dOMCachedNamespace.getBuiltFollowingNamespaceNode();
        }
        return dOMCachedNamespace;
    }

    @Override
    public final short itemKind() {
        return 1;
    }

    @Override
    public final VolatileCData itemName() {
        return this.name;
    }

    @Override
    public XSTypeDefinition itemXSType() {
        XSTypeDefinition xSTypeDefinition;
        if (this.cache.isXDMXStar()) {
            ItemPSVI itemPSVI = this.itemXSPSVInfo();
            if (itemPSVI != null) {
                short s = itemPSVI.getValidity();
                short s2 = itemPSVI.getValidationAttempted();
                XSTypeDefinition xSTypeDefinition2 = itemPSVI.getTypeDefinition();
                xSTypeDefinition = s == 1 || s2 == 1 ? TypeRegistry.XSANYTYPE : (s == 2 && s2 == 2 ? xSTypeDefinition2 : (null != this.xstype ? (this.xstype == TypeRegistry.XSANYTYPE ? TypeRegistry.XSUNTYPED : this.xstype) : TypeRegistry.XSUNTYPED));
            } else if (this.xstype != null) {
                xSTypeDefinition = this.xstype;
            } else {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    XSElementDeclaration xSElementDeclaration = this.itemXSElementDeclaration();
                    if (this.xstype == null && xSElementDeclaration != null) {
                        String string2 = xSElementDeclaration.getName();
                        String string3 = xSElementDeclaration.getNamespace();
                        String string4 = (string3 != null ? "{" + string3 + "}" : "") + (string2 != null ? string2 : "");
                        logger.logp(Level.FINER, logger.getName(), "itemXSType", "xstype is null, but element declaration is not. Type: " + string4 + ", Name: " + this.itemName());
                    }
                }
                xSTypeDefinition = TypeRegistry.XSUNTYPED;
            }
        } else {
            xSTypeDefinition = this.xstype;
        }
        return xSTypeDefinition;
    }

    @Override
    public void setItemXSType(XSTypeDefinition xSTypeDefinition) {
        this.xstype = xSTypeDefinition;
        if (DOMCachedElement.isElementIDTyped(xSTypeDefinition)) {
            this.setItemIsID(true);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setItemXSType", "setting the item value on an element");
        }
    }

    @Override
    public ItemPSVI itemXSPSVInfo() {
        return (ItemPSVI)this.getField((byte)1);
    }

    @Override
    public VolatileCData itemValue() {
        DOMCachedText dOMCachedText;
        Object object2;
        VolatileCData volatileCData = null;
        ItemPSVI itemPSVI = this.itemXSPSVInfo();
        if (itemPSVI != null) {
            if (TypeHelper.isSimple(this.itemXSType())) {
                object2 = TypeHelper.getSimpleType(this.itemXSType());
                dOMCachedText = this.getTextNodeChild();
                if (dOMCachedText == null) {
                    this.getCachedLastAttribute();
                    volatileCData = this.itemNilled() ? this.factory.data((XSSimpleTypeDefinition)object2) : (XCIErrorHelper.allowEmptyValue((XSTypeDefinition)object2) ? this.createCData(itemPSVI, null) : new InvalidEmptyCData((XSSimpleTypeDefinition)object2));
                } else {
                    volatileCData = this.createCData(itemPSVI, StringChars.toString(((AbstractCursor)dOMCachedText).itemStringValueAsChars()));
                }
            } else {
                if (((XSComplexTypeDefinition)this.itemXSType()).getContentType() == 2) {
                    throw new XCIIllegalContextItemException("ER_ELEMCONTENT_VALUE", new String[0]);
                }
                Chars chars = this.itemStringValueAsChars();
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "itemValue", "Returning complex value [" + chars + "] for element: " + this.toStringLazy());
                }
                return new StoredCharsCData(chars, TypeRegistry.XSUNTYPEDATOMIC);
            }
        }
        if (volatileCData == null) {
            if (TypeHelper.isSimple(this.itemXSType())) {
                object2 = TypeHelper.getSimpleType(this.itemXSType());
                dOMCachedText = this.getTextNodeChild();
                if (dOMCachedText == null) {
                    this.getCachedLastAttribute();
                    if (this.itemNilled()) {
                        volatileCData = this.factory.data((XSSimpleTypeDefinition)object2);
                    } else if (XCIErrorHelper.allowEmptyValue((XSTypeDefinition)object2)) {
                        switch (object2.getBuiltInKind()) {
                            case 17: {
                                volatileCData = new BaseCDataWithChars((XSSimpleTypeDefinition)object2, "", new Base64BinaryCData("", (XSSimpleTypeDefinition)object2));
                                break;
                            }
                            case 16: {
                                volatileCData = new BaseCDataWithChars((XSSimpleTypeDefinition)object2, "", new HexBinaryCData("", (XSSimpleTypeDefinition)object2));
                                break;
                            }
                            default: {
                                volatileCData = CData.EMPTY_STRING;
                                break;
                            }
                        }
                    } else {
                        volatileCData = new InvalidEmptyCData((XSSimpleTypeDefinition)object2);
                    }
                } else {
                    volatileCData = ((DOMCachedNode)dOMCachedText).itemValue();
                }
                if (volatileCData.getXSTypeDefinition() == TypeRegistry.XSUNTYPEDATOMIC) {
                    CharSequence charSequence = this.getString(volatileCData);
                    XSSimpleTypeDefinition xSSimpleTypeDefinition = this.getSimpleType(charSequence);
                    volatileCData = xSSimpleTypeDefinition.getBuiltInKind() != 19 ? new BaseCDataWithChars(xSSimpleTypeDefinition, charSequence) : this.factory.data(charSequence, xSSimpleTypeDefinition, this.itemNamespaceContext(), false);
                }
            } else if (!this.itemNilled()) {
                object2 = new StringCDataBuilder(TypeRegistry.XSUNTYPEDATOMIC);
                this.string((StringCDataBuilder)object2, this);
                volatileCData = ((StringCDataBuilder)object2).toCData();
            } else {
                volatileCData = this.factory.data(TypeRegistry.XSUNTYPEDATOMIC);
            }
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "itemValue", "Returning value [" + volatileCData + "] for element: " + this.toStringLazy());
        }
        return volatileCData;
    }

    @Override
    public Chars itemSValue() {
        Object object2;
        Object object3;
        if (this.itemXSType() != null && TypeHelper.isSimple(this.itemXSType()) && (object3 = this.getCachedFirstChild()) != null && ((DOMCachedNode)object3).itemKind() == 3 && ((DOMCachedNode)object3).getCachedFollowingSibling() == null && (object2 = ((DOMCachedNode)object3).itemSValue()) != null) {
            return object2;
        }
        object3 = null;
        object2 = this.itemXSPSVInfo();
        if (object2 != null) {
            object3 = object2.getSchemaNormalizedValue();
        }
        if (object3 == null) {
            return this.string(this);
        }
        return new StringChars((String)object3);
    }

    private XSSimpleTypeDefinition getSimpleType(CharSequence charSequence) {
        XSSimpleTypeDefinition xSSimpleTypeDefinition = null;
        if (this.xstype instanceof XSSimpleTypeDefinition) {
            xSSimpleTypeDefinition = (XSSimpleTypeDefinition)this.xstype;
        } else if (((XSComplexTypeDefinition)this.xstype).getContentType() == 1) {
            XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)this.xstype;
            xSSimpleTypeDefinition = xSComplexTypeDefinition.getSimpleType();
        }
        assert (xSSimpleTypeDefinition != null) : "Element type was not simple: " + this.xstype.toString();
        if (xSSimpleTypeDefinition.getVariety() == 3) {
            xSSimpleTypeDefinition = this.processUnion(xSSimpleTypeDefinition, charSequence);
        }
        if (xSSimpleTypeDefinition == TypeRegistry.XSANYSIMPLETYPE) {
            return TypeRegistry.XSUNTYPEDATOMIC;
        }
        return xSSimpleTypeDefinition;
    }

    private XSSimpleTypeDefinition processUnion(XSSimpleTypeDefinition xSSimpleTypeDefinition, CharSequence charSequence) {
        try {
            CastUtilities.validate(((Object)charSequence).toString(), xSSimpleTypeDefinition);
            return CastUtilities.validatedInfos.get().memberType;
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            return null;
        }
    }

    @Override
    public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
        return this;
    }

    @Override
    public boolean itemNilled() {
        if (this.cache.isXDMXStar()) {
            ElementPSVI elementPSVI = (ElementPSVI)this.itemXSPSVInfo();
            return elementPSVI != null && elementPSVI.getNil();
        }
        return BitMaskHelper.stateContains(this.state, 524288);
    }

    @Override
    public void setItemValue(VolatileCData volatileCData) {
        XSTypeDefinition xSTypeDefinition;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setItemValue", "setting the item value on an element");
        }
        if ((xSTypeDefinition = this.itemXSType()) != null && (xSTypeDefinition.getTypeCategory() == 16 || xSTypeDefinition == TypeRegistry.XSUNTYPED)) {
            DOMCachedNode dOMCachedNode = this.getCachedFirstChild();
            if (dOMCachedNode == null) {
                this.addText(Cursor.Area.FIRST_CHILD, volatileCData);
            } else {
                assert (dOMCachedNode.itemKind() == 3) : "Simply typed element must contain only a single text child!?";
                if (this.itemIsID()) {
                    this.cache.removeID(this);
                }
                dOMCachedNode.setItemValue(volatileCData);
            }
        } else {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                if (xSTypeDefinition == null) {
                    logger.logp(Level.FINER, logger.getName(), "setItemValue", "Failed to set itemValue because type is null: " + this.itemName());
                } else {
                    String string2 = xSTypeDefinition.getClass().getName();
                    String string3 = xSTypeDefinition.toString();
                    logger.logp(Level.FINER, logger.getName(), "setItemValue", "Failed to set itemValue because type is not simple. Type: " + (xSTypeDefinition.getAnonymous() ? "Anonymous " : "") + TypeHelper.prettyPrint(xSTypeDefinition) + ", Name: " + this.itemName());
                    logger.logp(Level.FINER, logger.getName(), "setItemValue", "Class: " + string2 + " toString: " + string3);
                }
            }
            throw XCIErrorHelper.createBadContextItemException("setItemValue", this.itemKind());
        }
    }

    @Override
    public void setItemName(VolatileCData volatileCData) {
        CharSequence charSequence;
        Object object2;
        String string2;
        String string3;
        this.checkSetItemName(volatileCData);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            try {
                string3 = volatileCData.getQNameLocalPart(1);
                string2 = volatileCData.getQNamePrefix(1);
                object2 = volatileCData.getQNameNamespaceURI(1);
                logger.logp(Level.FINEST, logger.getName(), "setItemName", "Setting a new name with nsURI=[" + (String)object2 + "], prefix=[" + string2 + "], localName=[" + string3 + "] into element = " + this.toStringLazy() + "\n Stack Trace=" + XCIErrorHelper.getStackTrace(15));
            }
            catch (Exception exception) {
                logger.logp(Level.FINEST, logger.getName(), "setItemName", "Got an exception while logging entry into setItemName");
            }
        }
        this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.SELF);
        string3 = volatileCData.getQNamePrefix(1);
        if (string3 == null || string3.length() == 0) {
            if (this.hasPendingNSDecls()) {
                this.loadNSList(null);
            }
            string2 = volatileCData.getQNameNamespaceURI(1);
            for (object2 = this.getCachedFirstNamespaceNode(); object2 != null && (!"".equals(((DOMCachedNamespace)object2).itemName().getQNameLocalPart(1)) || string2.equals(((AbstractCursor)object2).itemStringValue().getString(1))); object2 = ((DOMCachedNamespace)object2).getCachedFollowingNamespaceNode()) {
            }
            if (object2 != null) {
                if (!string2.equals("")) {
                    string3 = this.getPrefix(string2);
                    if (string3 == null) {
                        int n2 = 0;
                        while (this.getNamespaceURI(string3 = "ns" + n2++, false) != null) {
                        }
                        charSequence = new StringCData(string2, TypeRegistry.XSSTRING);
                        this.internalAddNamespaceNode(new QName("", string3, ""), (VolatileCData)charSequence);
                    }
                    assert (string3 != null);
                    volatileCData = new QNameCData(new QName(string2, volatileCData.getQNameLocalPart(1), string3), TypeRegistry.XSQNAME);
                } else {
                    StringCData stringCData = new StringCData("", TypeRegistry.XSSTRING);
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, logger.getName(), "setItemName", "About to change the default namespace from {" + ((AbstractCursor)object2).itemStringValue().getString(1) + "} to {" + "" + "}");
                    }
                    ((DOMCachedNamespace)object2).data = stringCData.constant(true);
                }
            }
        }
        this.name = volatileCData.constant(true);
        this.setDirty(this);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            try {
                String string4;
                string2 = volatileCData.getQNameNamespaceURI(1);
                object2 = volatileCData.getQNamePrefix(1);
                if (object2 == null) {
                    object2 = "";
                }
                if ((string4 = this.itemNamespaceContext().getNamespaceURI((String)object2)) != null && string2 != null && !string4.equals(string2)) {
                    charSequence = new StringBuilder();
                    String string5 = null;
                    String string6 = null;
                    for (DOMCachedNamespace dOMCachedNamespace = this.getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
                        VolatileCData volatileCData2 = dOMCachedNamespace.itemName();
                        string5 = volatileCData2.getSize() == 0 ? "" : volatileCData2.getQNameLocalPart(1);
                        string6 = dOMCachedNamespace.itemStringValue().toString();
                        ((StringBuilder)charSequence).append("prefix: " + string5);
                        ((StringBuilder)charSequence).append(" uri: " + string6);
                        ((StringBuilder)charSequence).append("\n");
                    }
                    if ("".equals(object2)) {
                        logger.logp(Level.FINE, logger.getName(), "setItemName", "WARNING: Namespace conflict between new element name: {" + string2 + "}" + volatileCData.getQNameLocalPart(1) + " and namespace declaration, xmlns=\"" + string4 + "\"\n Decls on this element: " + ((StringBuilder)charSequence).toString() + "\n" + this.toStringLazy() + "\n" + XCIErrorHelper.getStackTrace(30));
                    } else {
                        logger.logp(Level.FINE, logger.getName(), "setItemName", "WARNING: Namespace conflict between new element name: {" + string2 + "}" + volatileCData.getQNameLocalPart(1) + " and namespace declaration, xmlns:" + (String)object2 + "=\"" + string4 + "\"\n Decls on this element: " + ((StringBuilder)charSequence).toString() + "\n" + this.toStringLazy() + "\n" + XCIErrorHelper.getStackTrace(30));
                    }
                }
            }
            catch (Exception exception) {
                logger.logp(Level.FINE, logger.getName(), "setItemName", "WARNING: Unexpected exception during logging.", exception);
            }
        }
    }

    @Override
    public void setItemPSVI(ItemPSVI itemPSVI, boolean bl) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setItemPSVI", "setting PSVI on an element", XCIErrorHelper.getStackTrace(30));
        }
        if (itemPSVI == null) {
            throw XCIErrorHelper.createBadArgumentException("psvi", "null");
        }
        if (!(itemPSVI instanceof ElementPSVI)) {
            throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_PSVI_WRONG_INSTANCE", new String[]{"elements", "ElementPSVI"}));
        }
        if (bl) {
            this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.SELF);
            this.setDirty(this);
        }
        itemPSVI = itemPSVI instanceof ItemPSVI2 ? (ElementPSVI)((ItemPSVI2)itemPSVI).constant() : new ElementPSVImpl(true, (ElementPSVI)itemPSVI);
        this.setField(itemPSVI, (byte)1);
        this.setItemXSElementDeclaration(((ElementPSVI)itemPSVI).getElementDeclaration());
        this.setItemXSType(itemPSVI.getTypeDefinition());
    }

    @Override
    public void setItemPSVI(ItemPSVI itemPSVI) {
        this.setItemPSVI(itemPSVI, true);
    }

    protected void clearPSVI() {
        if (this.getField((byte)1) != null) {
            this.setField(null, (byte)1);
        }
    }

    @Override
    public XSElementDeclaration itemXSElementDeclaration() {
        return (XSElementDeclaration)this.getField((byte)0);
    }

    @Override
    public void setItemXSElementDeclaration(XSElementDeclaration xSElementDeclaration) {
        this.setField(xSElementDeclaration, (byte)0);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setXSElementDeclaration", "setting the schema declaration on an element");
        }
    }

    @Override
    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        this.addAttributeWithTypeInfo(volatileCData, volatileCData2, null, null, null);
    }

    public void addAttributeWithTypeInfo(VolatileCData volatileCData, VolatileCData volatileCData2, XSTypeDefinition xSTypeDefinition, XSAttributeDeclaration xSAttributeDeclaration, AttributePSVI attributePSVI) {
        String string2;
        Object object2;
        if (volatileCData == null) {
            throw XCIErrorHelper.createBadArgumentException("name", "null");
        }
        if (volatileCData2 == null) {
            throw XCIErrorHelper.createBadArgumentException("value", "null");
        }
        try {
            volatileCData.getQNameNamespaceURI(1);
        }
        catch (XCIDynamicErrorException xCIDynamicErrorException) {
            throw XCIErrorHelper.createBadArgumentException("name", volatileCData.toString());
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            object2 = "";
            string2 = "";
            try {
                object2 = volatileCData.getString(1);
                string2 = volatileCData2.getString(1);
                logger.logp(Level.FINER, logger.getName(), "addAttributeWithTypeInfo", "name=" + (String)object2 + " | " + "value=" + string2);
            }
            catch (Exception exception) {
                logger.logp(Level.FINER, logger.getName(), "addAttributeWithTypeInfo", "Exception was thrown. name=" + (String)object2 + " | " + "value=" + string2, exception);
            }
        }
        if (!LazyLoadingHelper.isLastAttributeBuilt(this.state)) {
            MiscHelpers.visitAttributes(this);
        }
        this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.ATTRIBUTE);
        object2 = this.cache.makeCachedAttribute(volatileCData, volatileCData2, null, null, this);
        ((DOMCachedNode)object2).setState(((DOMCachedNode)object2).getState() | LazyLoadingHelper.markAllResolved());
        if (xSTypeDefinition != null) {
            ((DOMCachedAttribute)object2).xstype = xSTypeDefinition;
        }
        if (xSAttributeDeclaration != null) {
            ((DOMCachedAttribute)object2).setItemXSAttributeDeclaration(xSAttributeDeclaration);
        }
        if (attributePSVI != null) {
            ((DOMCachedAttribute)object2).setItemPSVI(attributePSVI, false);
        }
        ((DOMCachedNode)object2).setState(BitMaskHelper.stateSet(((DOMCachedNode)object2).getState(), 0x400000));
        if (CommonJAXPQNames.equalsXSINilQName(volatileCData)) {
            this.updateXsiValue(volatileCData2);
        } else if (CommonJAXPQNames.equalsXMLBaseQName(volatileCData)) {
            try {
                string2 = volatileCData2.getString(1);
                URI uRI = new URI(string2);
                if (uRI.isAbsolute()) {
                    this.setItemBaseURI(string2);
                } else {
                    this.setItemBaseURI(new URI(this.itemBaseURI()).resolve(uRI).toString());
                }
            }
            catch (Exception exception) {
                throw new XCIDynamicErrorException(exception);
            }
        }
        this.setDirty(this);
    }

    @Override
    public void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "addNamespaceNode", "\n localPart= " + volatileCData + " | uri = " + volatileCData2);
        }
        if (!LazyLoadingHelper.isLastNamespaceBuilt(this.state)) {
            MiscHelpers.visitNamespaceNodes(this);
        }
        QName qName = new QName("", volatileCData == null ? "" : volatileCData.toString(), "");
        this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.NAMESPACE_DECLS);
        boolean bl2 = true;
        for (DOMCachedNamespace dOMCachedNamespace = this.builtFirstNamespace; dOMCachedNamespace != null; dOMCachedNamespace = (DOMCachedNamespace)dOMCachedNamespace.getBuiltFollowingSibling()) {
            if (!dOMCachedNamespace.name.getQNameLocalPart(1).equals(qName.getLocalPart())) continue;
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "addNamespaceNode", "\nFound a namespace with the same local name!, so updating uri");
            }
            dOMCachedNamespace.data = volatileCData2.constant(true);
            bl2 = false;
            break;
        }
        if (bl2) {
            this.internalAddNamespaceNode(qName, volatileCData2);
        }
        this.setDirty(this);
    }

    public void internalAddNamespaceNode(QName qName, VolatileCData volatileCData) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "internalAddNamespaceNode", "Adding namespace decl xmlns:" + qName.getLocalPart() + "=\"" + volatileCData.toString() + "\" to element " + this.toStringLazy());
        }
        this.cache.incrementNamespaceVersion();
        DOMCachedNamespace dOMCachedNamespace = this.cache.makeCachedNamespaceNode(this.factory.data(qName, null, false), volatileCData, this);
        dOMCachedNamespace.setState(LazyLoadingHelper.markAllResolved());
        dOMCachedNamespace.setState(BitMaskHelper.stateSet(dOMCachedNamespace.getState(), 0x400000));
    }

    @Override
    public boolean removeAttribute(VolatileCData volatileCData) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "removeAttribute", "\n name of attribute=" + volatileCData.getString(1) + "\n parent node=" + this.toStringLazy());
        }
        if (volatileCData == null) {
            throw XCIErrorHelper.createBadArgumentException("name", "null");
        }
        try {
            volatileCData.getQNameNamespaceURI(1);
        }
        catch (XCIDynamicErrorException xCIDynamicErrorException) {
            throw XCIErrorHelper.createBadArgumentException("name", volatileCData.toString());
        }
        DOMCachedAttribute dOMCachedAttribute = this.getCachedAttribute(volatileCData);
        if (dOMCachedAttribute != null) {
            this.internalRemoveAttribute(dOMCachedAttribute);
            return true;
        }
        return false;
    }

    public void internalRemoveAttribute(DOMCachedAttribute dOMCachedAttribute) {
        this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.ATTRIBUTE, true);
        if (dOMCachedAttribute == this.builtFirstAttribute) {
            this.builtFirstAttribute = dOMCachedAttribute.getCachedFollowingAttribute();
        }
        dOMCachedAttribute.unlink();
        dOMCachedAttribute.updateCacheEntire(this.cache.getNewInstance());
        if (CommonJAXPQNames.equalsXSINilQName(dOMCachedAttribute.itemName())) {
            this.setState(BitMaskHelper.stateUnset(this.state, 524288));
        }
    }

    @Override
    public boolean test(Cursor cursor2) {
        return cursor2.itemKind() == 1 && this.name.equals(cursor2.itemName());
    }

    @Override
    public boolean allowsElement(VolatileCData volatileCData) {
        return this.name.equals(volatileCData);
    }

    @Override
    public NameTest theNameTest() {
        return SimpleNameTest.name(this.itemName());
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public boolean hasAttributes() {
        return this.getCachedFirstAttribute() != null;
    }

    @Override
    public String getNamespaceURI() {
        if (BitMaskHelper.stateContains(this.state, 65536)) {
            return null;
        }
        String string2 = this.name.getQNameNamespaceURI(1);
        return "".equals(string2) ? null : string2;
    }

    @Override
    public String getPrefix() {
        if (BitMaskHelper.stateContains(this.state, 65536)) {
            return null;
        }
        String string2 = this.name.getQNamePrefix(1);
        return "".equals(string2) ? null : string2;
    }

    @Override
    public void setPrefix(String string2) throws DOMException {
    }

    @Override
    public String getLocalName() {
        return BitMaskHelper.stateContains(this.state, 65536) ? null : this.name.getQNameLocalPart(1);
    }

    @Override
    public NamedNodeMap getAttributes() {
        DOMCachedSimple dOMCachedSimple;
        ArrayList<DOMCachedSimple> arrayList = new ArrayList<DOMCachedSimple>();
        for (dOMCachedSimple = this.getCachedFirstNamespaceNode(); dOMCachedSimple != null; dOMCachedSimple = ((DOMCachedNamespace)dOMCachedSimple).getCachedFollowingNamespaceNode()) {
            arrayList.add(dOMCachedSimple);
        }
        for (dOMCachedSimple = this.getCachedFirstAttribute(); dOMCachedSimple != null; dOMCachedSimple = ((DOMCachedAttribute)dOMCachedSimple).getCachedFollowingAttribute()) {
            arrayList.add(dOMCachedSimple);
        }
        return new AttrList(arrayList);
    }

    @Override
    public String getAttribute(String string2) {
        return this.getAttributeNS(null, string2);
    }

    @Override
    public String getAttributeNS(String string2, String string3) {
        Attr attr2 = this.getAttributeNodeNS(string2, string3);
        return attr2 == null ? null : attr2.getValue();
    }

    @Override
    public Attr getAttributeNode(String string2) {
        for (DOMCachedAttribute dOMCachedAttribute = this.getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
            if (!dOMCachedAttribute.getNodeName().equals(string2)) continue;
            return dOMCachedAttribute;
        }
        return null;
    }

    @Override
    public Attr getAttributeNodeNS(String string2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        for (DOMCachedAttribute dOMCachedAttribute = this.getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
            CData cData = dOMCachedAttribute.name;
            if (!cData.getQNameNamespaceURI(1).equals(string2) || !cData.getQNameLocalPart(1).equals(string3)) continue;
            return dOMCachedAttribute;
        }
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String string2) {
        return new DOMCachedContainer.ElementDescendants(null, string2);
    }

    @Override
    public NodeList getElementsByTagNameNS(String string2, String string3) {
        return new DOMCachedContainer.ElementDescendants(string2, string3);
    }

    @Override
    public String getTagName() {
        String string2 = this.getPrefix();
        return (string2 == null || string2.length() == 0 ? "" : string2 + ":") + this.name.getQNameLocalPart(1);
    }

    @Override
    public boolean hasAttribute(String string2) {
        return this.getAttributeNode(string2) != null;
    }

    @Override
    public boolean hasAttributeNS(String string2, String string3) {
        return this.getAttributeNodeNS(string2, string3) != null;
    }

    @Override
    public void removeAttribute(String string2) throws DOMException {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedNamedAttribute(null, string2);
        if (dOMCachedAttribute == null) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        this.removeCachedAttribute(dOMCachedAttribute);
    }

    @Override
    public void removeAttributeNS(String string2, String string3) throws DOMException {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedNamedAttribute(string2, string3);
        if (dOMCachedAttribute == null) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        this.removeCachedAttribute(dOMCachedAttribute);
    }

    @Override
    public Attr removeAttributeNode(Attr attr2) throws DOMException {
        if (!(attr2 instanceof DOMCachedAttribute)) {
            throw XCIErrorHelper.createDOMException((short)3);
        }
        this.removeCachedAttribute((DOMCachedAttribute)attr2);
        return attr2;
    }

    @Override
    public void setAttribute(String string2, String string3) throws DOMException {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedNamedAttribute(null, string2);
        if (dOMCachedAttribute == null) {
            dOMCachedAttribute = (DOMCachedAttribute)this.getOwnerDocument().createAttribute(string2);
        }
        dOMCachedAttribute.setValue(string3);
    }

    @Override
    public void setAttributeNS(String string2, String string3, String string4) throws DOMException {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedNamedAttribute(string2, string3);
        if (dOMCachedAttribute == null) {
            dOMCachedAttribute = (DOMCachedAttribute)this.getOwnerDocument().createAttributeNS(string2, string3);
        }
        dOMCachedAttribute.setValue(string4);
    }

    @Override
    public Attr setAttributeNode(Attr attr2) throws DOMException {
        if (!(attr2 instanceof DOMCachedAttribute)) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        DOMCachedAttribute dOMCachedAttribute = (DOMCachedAttribute)attr2;
        if (dOMCachedAttribute.parent != null) {
            throw XCIErrorHelper.createDOMException((short)10);
        }
        if (dOMCachedAttribute.getOwnerDocument() != this.getOwnerDocument()) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        DOMCachedAttribute dOMCachedAttribute2 = this.getCachedNamedAttribute(null, attr2.getName());
        if (dOMCachedAttribute2 == null) {
            this.addCachedAttribute(dOMCachedAttribute);
        } else {
            this.replaceCachedAttribute(dOMCachedAttribute2, dOMCachedAttribute);
        }
        return dOMCachedAttribute2;
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr2) throws DOMException {
        if (!(attr2 instanceof DOMCachedAttribute)) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        DOMCachedAttribute dOMCachedAttribute = (DOMCachedAttribute)attr2;
        if (dOMCachedAttribute.parent != null) {
            throw XCIErrorHelper.createDOMException((short)10);
        }
        if (dOMCachedAttribute.getOwnerDocument() != this.getOwnerDocument()) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        DOMCachedAttribute dOMCachedAttribute2 = this.getCachedNamedAttribute(attr2.getNamespaceURI(), attr2.getLocalName());
        if (dOMCachedAttribute2 == null) {
            this.addCachedAttribute(dOMCachedAttribute);
        } else {
            this.replaceCachedAttribute(dOMCachedAttribute2, dOMCachedAttribute);
        }
        return dOMCachedAttribute2;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"getSchemaTypeInfo", DOMCachedElement.class.getName()}));
    }

    @Override
    public void setIdAttribute(String string2, boolean bl) throws DOMException {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"setIdAttribute", DOMCachedElement.class.getName()}));
    }

    @Override
    public void setIdAttributeNode(Attr attr2, boolean bl) throws DOMException {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"setIdAttributeNode", DOMCachedElement.class.getName()}));
    }

    @Override
    public void setIdAttributeNS(String string2, String string3, boolean bl) throws DOMException {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"setIdAttributeNS", DOMCachedElement.class.getName()}));
    }

    @Override
    public int getLength() {
        DOMCachedSimple dOMCachedSimple;
        int n2 = 0;
        for (dOMCachedSimple = this.getCachedFirstNamespaceNode(); dOMCachedSimple != null; dOMCachedSimple = ((DOMCachedNamespace)dOMCachedSimple).getCachedFollowingNamespaceNode()) {
            ++n2;
        }
        for (dOMCachedSimple = this.getCachedFirstAttribute(); dOMCachedSimple != null; dOMCachedSimple = ((DOMCachedAttribute)dOMCachedSimple).getCachedFollowingAttribute()) {
            ++n2;
        }
        return n2;
    }

    @Override
    public Node getNamedItem(String string2) {
        return this.getNamedItemNS("", string2);
    }

    @Override
    public Node getNamedItemNS(String string2, String string3) throws DOMException {
        DOMCachedSimple dOMCachedSimple = this.getCachedNamedNamespace(string2, string3);
        if (dOMCachedSimple == null) {
            dOMCachedSimple = this.getCachedNamedAttribute(string2, string3);
        }
        return dOMCachedSimple;
    }

    @Override
    public Node item(int n2) {
        DOMCachedSimple dOMCachedSimple;
        for (dOMCachedSimple = this.getCachedFirstNamespaceNode(); dOMCachedSimple != null; dOMCachedSimple = ((DOMCachedNamespace)dOMCachedSimple).getCachedFollowingNamespaceNode()) {
            if (n2-- != 0) continue;
            return dOMCachedSimple;
        }
        for (dOMCachedSimple = this.getCachedFirstAttribute(); dOMCachedSimple != null; dOMCachedSimple = ((DOMCachedAttribute)dOMCachedSimple).getCachedFollowingAttribute()) {
            if (n2-- != 0) continue;
            return dOMCachedSimple;
        }
        return null;
    }

    @Override
    public Node removeNamedItem(String string2) throws DOMException {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedNamedAttribute(null, string2);
        if (dOMCachedAttribute == null) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        this.removeCachedAttribute(dOMCachedAttribute);
        return dOMCachedAttribute;
    }

    @Override
    public Node removeNamedItemNS(String string2, String string3) throws DOMException {
        DOMCachedAttribute dOMCachedAttribute = this.getCachedNamedAttribute(string2, string3);
        if (dOMCachedAttribute == null) {
            throw XCIErrorHelper.createDOMException((short)8);
        }
        this.removeCachedAttribute(dOMCachedAttribute);
        return dOMCachedAttribute;
    }

    @Override
    public Node setNamedItem(Node node2) throws DOMException {
        if (!(node2 instanceof DOMCachedAttribute)) {
            throw XCIErrorHelper.createDOMException((short)3);
        }
        DOMCachedAttribute dOMCachedAttribute = (DOMCachedAttribute)node2;
        if (dOMCachedAttribute.parent != null) {
            throw XCIErrorHelper.createDOMException((short)10);
        }
        DOMCachedAttribute dOMCachedAttribute2 = this.getCachedNamedAttribute(null, node2.getNodeName());
        if (dOMCachedAttribute2 == null) {
            this.addCachedAttribute(dOMCachedAttribute);
        } else {
            this.replaceCachedAttribute(dOMCachedAttribute2, dOMCachedAttribute);
        }
        return dOMCachedAttribute2;
    }

    @Override
    public Node setNamedItemNS(Node node2) throws DOMException {
        Document document2 = node2.getOwnerDocument();
        if (document2 != null && document2 != this.getOwnerDocument()) {
            throw XCIErrorHelper.createDOMException((short)4);
        }
        if (!(node2 instanceof DOMCachedAttribute)) {
            throw XCIErrorHelper.createDOMException((short)3);
        }
        DOMCachedAttribute dOMCachedAttribute = (DOMCachedAttribute)node2;
        if (dOMCachedAttribute.parent != null) {
            throw new DOMException(10, "XXDOM0011");
        }
        DOMCachedAttribute dOMCachedAttribute2 = this.getCachedNamedAttribute(dOMCachedAttribute.getNamespaceURI(), dOMCachedAttribute.getLocalName());
        if (dOMCachedAttribute2 == null) {
            this.addCachedAttribute(dOMCachedAttribute);
        } else {
            this.replaceCachedAttribute(dOMCachedAttribute2, dOMCachedAttribute);
        }
        return dOMCachedAttribute2;
    }

    protected void replaceCachedAttribute(DOMCachedAttribute dOMCachedAttribute, DOMCachedAttribute dOMCachedAttribute2) {
        dOMCachedAttribute.setState(dOMCachedAttribute2.getState());
        dOMCachedAttribute.setState(dOMCachedAttribute.getState() | 0);
        dOMCachedAttribute2.setParent(this);
        dOMCachedAttribute.setParent(null);
        if (dOMCachedAttribute.preceding != null) {
            dOMCachedAttribute.preceding.setBuiltFollowingSibling(dOMCachedAttribute2);
        }
        dOMCachedAttribute2.preceding = dOMCachedAttribute.preceding;
        dOMCachedAttribute.preceding = null;
        if (dOMCachedAttribute.following != null) {
            dOMCachedAttribute.following.preceding = dOMCachedAttribute2;
        }
        dOMCachedAttribute2.setBuiltFollowingSibling(dOMCachedAttribute.following);
        dOMCachedAttribute.setBuiltFollowingSibling(null);
    }

    protected void removeCachedAttribute(DOMCachedAttribute dOMCachedAttribute) {
        assert (dOMCachedAttribute.parent == this) : "Can only remove attribute that are already owned by this element.";
        dOMCachedAttribute.setParent(null);
        if (dOMCachedAttribute.preceding != null) {
            if (BitMaskHelper.stateContains(dOMCachedAttribute.preceding.state, 128)) {
                dOMCachedAttribute.setState(BitMaskHelper.stateSet(dOMCachedAttribute.state, 128));
            }
            dOMCachedAttribute.preceding.setBuiltFollowingSibling(dOMCachedAttribute.following);
        }
        if (dOMCachedAttribute.following != null) {
            if (BitMaskHelper.stateContains(dOMCachedAttribute.following.state, 512)) {
                dOMCachedAttribute.setState(BitMaskHelper.stateSet(dOMCachedAttribute.state, 512));
            }
            dOMCachedAttribute.following.preceding = dOMCachedAttribute.preceding;
        }
        dOMCachedAttribute.preceding = null;
        dOMCachedAttribute.setBuiltFollowingSibling(null);
    }

    public void addCachedAttribute(DOMCachedAttribute dOMCachedAttribute) {
        dOMCachedAttribute.setParent(this);
        if (this.builtFirstAttribute == null) {
            this.builtFirstAttribute = dOMCachedAttribute;
            this.setState(BitMaskHelper.stateSet(this.state, 1));
        } else {
            DOMCachedAttribute dOMCachedAttribute2 = this.getCachedLastAttribute();
            if (dOMCachedAttribute == dOMCachedAttribute2 || dOMCachedAttribute == this.builtFirstAttribute) {
                return;
            }
            dOMCachedAttribute.preceding = dOMCachedAttribute2;
            dOMCachedAttribute2.setBuiltFollowingSibling(dOMCachedAttribute);
            dOMCachedAttribute.preceding.setState(BitMaskHelper.stateSet(dOMCachedAttribute.preceding.state, 512));
        }
        dOMCachedAttribute.setState(BitMaskHelper.stateSet(dOMCachedAttribute.state, 160));
        dOMCachedAttribute.cache = this.cache;
    }

    @Override
    public DOMCachedAttribute getCachedNamedAttribute(String string2, String string3) throws DOMException {
        for (DOMCachedAttribute dOMCachedAttribute = this.getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
            if (string2 != dOMCachedAttribute.getNamespaceURI() && (string2 == null || !string2.equals(dOMCachedAttribute.getNamespaceURI())) || !string3.equals(dOMCachedAttribute.getLocalName())) continue;
            return dOMCachedAttribute;
        }
        return null;
    }

    @Override
    public DOMCachedNamespace getCachedNamedNamespace(String string2, String string3) throws DOMException {
        for (DOMCachedNamespace dOMCachedNamespace = this.getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
            if (string2 != dOMCachedNamespace.getNamespaceURI() && (string2 == null || !string2.equals(dOMCachedNamespace.getNamespaceURI())) || !string3.equals(dOMCachedNamespace.getLocalName())) continue;
            return dOMCachedNamespace;
        }
        return null;
    }

    @Override
    public Iterator<String> getInScopeNamespaces() {
        return new NSListIterator<String>(this.getInScopeNamespacesList());
    }

    @Override
    public String lookupNamespaceURI(String string2) {
        return this.getNamespaceURI(string2);
    }

    @Override
    public String getNamespaceURI(String string2) {
        return this.getNamespaceURI(string2, true);
    }

    public String getNamespaceURI(String string2, boolean bl) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if (string2.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string2.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this.unguardedGetNamespaceURI(string2, bl);
    }

    @Override
    public String lookupPrefix(String string2) {
        return this.getPrefix(string2);
    }

    @Override
    public String getPrefix(String string2) {
        return this.getPrefix(string2, true);
    }

    public String getPrefix(String string2, boolean bl) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string2)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string2)) {
            return "xmlns";
        }
        String string3 = null;
        String string4 = null;
        DOMCachedContainer dOMCachedContainer = this;
        do {
            DOMCachedNamespace dOMCachedNamespace;
            if (dOMCachedContainer.getNamespaceURI() != null) {
                string3 = this.getPrefix();
                string4 = this.getNamespaceURI();
                if (string3 == null && string4 != null && string4.equals(string2)) {
                    String string5 = null;
                    for (dOMCachedNamespace = this.getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
                        VolatileCData volatileCData;
                        if (!string4.equals(dOMCachedNamespace.itemStringValue().getString(1)) || (volatileCData = dOMCachedNamespace.itemName()).getSize() == 0 || (string5 = volatileCData.getQNameLocalPart(1)).isEmpty()) continue;
                        string3 = string5;
                        break;
                    }
                }
                if (string4 != null && string4.equals(string2)) {
                    return string3 == null ? "" : string3;
                }
            }
            if (((DOMCachedElement)dOMCachedContainer).hasPendingNSDecls()) {
                ((DOMCachedElement)dOMCachedContainer).loadNSList(null);
            }
            for (dOMCachedNamespace = dOMCachedContainer.getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
                string3 = dOMCachedNamespace.itemName().getQNameLocalPart(1);
                string4 = dOMCachedNamespace.itemTypedValue().toString();
                if (string4 == null || !string4.equals(string2)) continue;
                return string3;
            }
            if (!bl) {
                return null;
            }
            if (dOMCachedContainer.parent != dOMCachedContainer && dOMCachedContainer.parent != this) continue;
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "getPrefix", "Internal Warning: found a parent/child cycle for node= " + dOMCachedContainer.toStringLazy());
            }
            return null;
        } while ((dOMCachedContainer = dOMCachedContainer.parent) != null && dOMCachedContainer.itemKind() == 1);
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ("http://www.w3.org/XML/1998/namespace".equals(string2)) {
            arrayList.add("xml");
        } else if ("http://www.w3.org/2000/xmlns/".equals(string2)) {
            arrayList.add("xmlns");
        } else {
            String string3 = null;
            String string4 = null;
            for (DOMCachedContainer dOMCachedContainer = this; dOMCachedContainer != null && ((DOMCachedNode)dOMCachedContainer).itemKind() == 1; dOMCachedContainer = dOMCachedContainer.getBuiltParent()) {
                if (dOMCachedContainer.hasPendingNSDecls()) {
                    dOMCachedContainer.loadNSList(null);
                }
                if (((DOMCachedNode)dOMCachedContainer).getNamespaceURI() != null) {
                    string3 = this.getPrefix();
                }
                if ((string4 = this.getNamespaceURI()) != null && string4.equals(string2)) {
                    String string5 = string3 = string3 == null ? "" : string3;
                    if (!arrayList.contains(string3)) {
                        arrayList.add(string3);
                    }
                }
                for (DOMCachedNamespace dOMCachedNamespace = ((DOMCachedNode)dOMCachedContainer).getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
                    string3 = dOMCachedNamespace.itemName().getQNameLocalPart(1);
                    string4 = dOMCachedNamespace.itemTypedValue().toString();
                    if (string4 == null || !string4.equals(string2) || arrayList.contains(string3)) continue;
                    arrayList.add(string3);
                }
            }
        }
        return arrayList.iterator();
    }

    public ExtendedNamespaceContext constant(boolean bl) {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"constant", DOMCachedElement.class.getName()}));
    }

    private final String unguardedGetNamespaceURI(String string2, boolean bl) {
        Object object2;
        if (this.hasPendingNSDecls()) {
            this.loadNSList(null);
        }
        for (object2 = this.getCachedFirstNamespaceNode(); object2 != null; object2 = ((DOMCachedNamespace)object2).getCachedFollowingNamespaceNode()) {
            String string3;
            String string4 = string3 = ((DOMCachedNamespace)object2).itemName().getSize() == 0 ? "" : ((DOMCachedNamespace)object2).itemName().getQNameLocalPart(1);
            if (!string3.equals(string2)) continue;
            return ((AbstractCursor)object2).itemStringValue().toString();
        }
        if (!bl) {
            return null;
        }
        if (this.parent != null && this != this.parent && this.parent.itemKind() == 1 && (object2 = ((DOMCachedElement)this.parent).unguardedGetNamespaceURI(string2, true)) != null) {
            return object2;
        }
        if (string2.equals(this.itemName().getQNamePrefix(1))) {
            return this.itemName().getQNameNamespaceURI(1);
        }
        return null;
    }

    private final String unguardedGetPrefix(String string2) {
        Object object2;
        for (object2 = this.getCachedFirstNamespaceNode(); object2 != null; object2 = ((DOMCachedNamespace)object2).getCachedFollowingNamespaceNode()) {
            if (!string2.equals(((AbstractCursor)object2).itemStringValue().toString())) continue;
            return ((DOMCachedNamespace)object2).itemName().getSize() == 0 ? "" : ((DOMCachedNamespace)object2).itemName().getQNameLocalPart(1);
        }
        if (this.parent != null && this.parent.itemKind() == 1 && (object2 = ((DOMCachedElement)this.parent).getPrefix(string2)) != null) {
            return object2;
        }
        return null;
    }

    protected CData string(DOMCachedNode dOMCachedNode) {
        StringCDataBuilder stringCDataBuilder = new StringCDataBuilder(TypeRegistry.XSSTRING);
        this.string(stringCDataBuilder, dOMCachedNode);
        return stringCDataBuilder.toCData();
    }

    private void string(StringCDataBuilder stringCDataBuilder, DOMCachedNode dOMCachedNode) {
        switch (dOMCachedNode.itemKind()) {
            case 3: {
                stringCDataBuilder.append(dOMCachedNode.itemTypedValue().constant(true));
                break;
            }
            case 1: 
            case 9: {
                for (DOMCachedNode dOMCachedNode2 = ((DOMCachedContainer)dOMCachedNode).getCachedFirstChild(); dOMCachedNode2 != null; dOMCachedNode2 = dOMCachedNode2.getCachedFollowingSibling()) {
                    this.string(stringCDataBuilder, dOMCachedNode2);
                }
                break;
            }
        }
    }

    @Override
    protected void printXQuery(Writer writer, String string2, boolean bl) throws IOException {
        writer.write(string2 + " element " + this.printName() + this.printState() + this.printUserData());
        if (bl) {
            DOMCachedNode dOMCachedNode;
            writer.write(" {\n");
            for (dOMCachedNode = this.getBuiltFirstNamespace(); dOMCachedNode != null; dOMCachedNode = ((DOMCachedNamespace)dOMCachedNode).getBuiltFollowingNamespaceNode()) {
                dOMCachedNode.toStringLazy(writer, string2 + "\t", true);
            }
            for (dOMCachedNode = this.getBuiltFirstAttribute(); dOMCachedNode != null; dOMCachedNode = ((DOMCachedAttribute)dOMCachedNode).getBuiltFollowingAttribute()) {
                dOMCachedNode.toStringLazy(writer, string2 + "\t", true);
            }
            for (dOMCachedNode = this.getBuiltFirstChild(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltFollowingSibling()) {
                dOMCachedNode.toStringLazy(writer, string2 + "\t", bl);
            }
            writer.write(string2 + "}\n");
        }
    }

    protected List<String> getInScopeNamespacesList() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "getInScopeNamespacesList", "nsContext:" + this.nsContext);
        }
        if (this.nsContext == null) {
            if (this.hasPendingNSDecls()) {
                this.loadNSList(null);
            }
            if (this.getCachedFirstNamespaceNode() == null) {
                DOMCachedContainer dOMCachedContainer = this.getBuiltParent();
                if (dOMCachedContainer != null && dOMCachedContainer.itemKind() == 1) {
                    if (((DOMCachedElement)dOMCachedContainer).nsContext == null) {
                        return ((DOMCachedElement)dOMCachedContainer).getInScopeNamespacesList();
                    }
                    this.nsContext = ((DOMCachedElement)dOMCachedContainer).nsContext;
                } else {
                    this.nsContext = new ElementNSContext();
                }
            } else {
                this.nsContext = new ElementNSContext();
            }
        }
        return this.nsContext.getNSList();
    }

    public void saveNSList() {
        this.saveNSList(true);
    }

    public static String getPrefixFromNSList(List<String> list, String string2) {
        int n2 = list.size();
        for (int i = 1; i < n2; i += 2) {
            if (!string2.equals(list.get(i))) continue;
            return list.get(i - 1);
        }
        return null;
    }

    public static boolean isPrefixInUse(List<String> list, String string2) {
        int n2 = list.size();
        for (int i = 0; i < n2; i += 2) {
            if (!string2.equals(list.get(i))) continue;
            return true;
        }
        return false;
    }

    public void saveNSList(boolean bl) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "saveNSList", "originalNSList=" + this.originalNSList + " for node " + this.toStringLazy());
        }
        if (this.originalNSList == null || this.originalNSList.isEmpty()) {
            int n2;
            DOMCachedContainer dOMCachedContainer = this.parent;
            while (dOMCachedContainer != null && dOMCachedContainer.itemKind() == 1) {
                if (((DOMCachedElement)dOMCachedContainer).hasPendingNSDecls()) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, logger.getName(), "saveNSList", "Found a parent that had lingering namespaces.  Parent = " + dOMCachedContainer.toStringLazy());
                    }
                    ((DOMCachedElement)dOMCachedContainer).loadNSList(null);
                }
                dOMCachedContainer = dOMCachedContainer.parent;
            }
            this.originalNSList = this.getInScopeNamespacesList();
            if (bl && !TypeHelper.isSimple(this.itemXSType())) {
                boolean bl2 = false;
                for (n2 = 0; n2 < this.originalNSList.size(); n2 += 2) {
                    if (!"".equals(this.originalNSList.get(n2))) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    String string2;
                    this.originalNSList.add("");
                    this.originalNSList.add("");
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, logger.getName(), "saveNSList", "Adding an explicit empty default namespace declaration");
                    }
                    if ("".equals(this.name.getQNamePrefix(1)) && (string2 = this.name.getQNameNamespaceURI(1)) != null && !"".equals(string2)) {
                        String string3 = DOMCachedElement.getPrefixFromNSList(this.originalNSList, string2);
                        int n3 = 0;
                        if (string3 == null) {
                            while (DOMCachedElement.isPrefixInUse(this.originalNSList, string3 = "xci" + n3++)) {
                            }
                        }
                        QName qName = new QName(string2, this.name.getQNameLocalPart(1), string3);
                        this.name = this.factory().data(qName, null, false);
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, logger.getName(), "saveNSList", "Changed name to " + this.name.toString());
                        }
                        if (n3 > 0) {
                            StringCData stringCData = new StringCData(string2, TypeRegistry.XSSTRING);
                            this.internalAddNamespaceNode(new QName("", string3, ""), stringCData);
                            this.originalNSList.add(string3);
                            this.originalNSList.add(string2);
                        }
                    }
                }
            }
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST) && this.originalNSList != null) {
                StringBuilder stringBuilder = new StringBuilder(this.originalNSList.size());
                stringBuilder.append('{');
                for (n2 = 0; n2 < this.originalNSList.size(); ++n2) {
                    if (n2 != 0) {
                        stringBuilder.append(" , ");
                    }
                    stringBuilder.append(this.originalNSList.get(n2));
                }
                stringBuilder.append('}');
                logger.logp(Level.FINEST, logger.getName(), "saveNSList", "List copied: " + stringBuilder.toString());
            }
        }
    }

    public void saveNSListFromOriginal(DOMCachedElement dOMCachedElement) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "saveNSListFromOriginal", "About to copy namespaces list from original node: " + dOMCachedElement.toStringLazy() + " into copied node " + this.toStringLazy());
        }
        boolean bl = dOMCachedElement.hasPendingNSDecls();
        dOMCachedElement.saveNSList(true);
        this.originalNSList = dOMCachedElement.originalNSList;
        if (!bl) {
            dOMCachedElement.originalNSList = null;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST) && this.originalNSList != null) {
            StringBuilder stringBuilder = new StringBuilder(this.originalNSList.size());
            stringBuilder.append('{');
            for (int i = 0; i < this.originalNSList.size(); ++i) {
                if (i != 0) {
                    stringBuilder.append(" , ");
                }
                stringBuilder.append(this.originalNSList.get(i));
            }
            stringBuilder.append('}');
            logger.logp(Level.FINEST, logger.getName(), "saveNSListFromOriginal", "List copied: " + stringBuilder.toString());
        }
    }

    public String getNamespaces() {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        String string3 = null;
        for (DOMCachedNamespace dOMCachedNamespace = this.getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
            VolatileCData volatileCData = dOMCachedNamespace.itemName();
            string2 = volatileCData.getSize() == 0 ? "" : volatileCData.getQNameLocalPart(1);
            string3 = dOMCachedNamespace.itemStringValue().toString();
            stringBuilder.append("prefix: " + string2);
            stringBuilder.append(" uri: " + string3);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void loadNSList(DOMCachedNode dOMCachedNode) {
        String string2;
        String string3;
        Object object2;
        boolean bl;
        Object object3;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "loadNSList", "About to copy namespaces lists for the node : " + this.toStringLazy());
            if (this.originalNSList != null) {
                object3 = new StringBuilder(this.originalNSList.size());
                ((StringBuilder)object3).append('{');
                for (int i = 0; i < this.originalNSList.size(); ++i) {
                    if (i != 0) {
                        ((StringBuilder)object3).append(" , ");
                    }
                    ((StringBuilder)object3).append(this.originalNSList.get(i));
                }
                ((StringBuilder)object3).append('}');
                logger.logp(Level.FINEST, logger.getName(), "loadNSList", "Currently stored list: " + ((StringBuilder)object3).toString());
            }
        }
        object3 = dOMCachedNode != null && dOMCachedNode instanceof DOMCachedElement ? (DOMCachedElement)dOMCachedNode : null;
        if (this.originalNSList == null || this.originalNSList.isEmpty()) {
            return;
        }
        List<String> list = this.originalNSList;
        List<String> list2 = object3 == null ? null : ((DOMCachedElement)object3).getInScopeNamespacesList();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = bl = this.isCopy() && this.getMediatorData() != null && this.getMediatorData().getWrappedMediator() instanceof CopiedCacheMediator;
        if (!bl && LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST) && this.isCopy() && this.getMediatorData() != null && !(this.getMediatorData().getWrappedMediator() instanceof CopiedCacheMediator)) {
            object2 = this.parent == null ? "no parent" : this.parent.toStringLazy();
            logger.logp(Level.FINEST, logger.getName(), "loadNSList", "The following element is a copy with a mediator other than CopiedCacheMediator: " + this.toStringLazy(null, "", true) + "\nAnd its parent is: " + (String)object2);
        }
        for (object2 = this.getCachedFirstNamespaceNode(); object2 != null; object2 = ((DOMCachedNamespace)object2).getCachedFollowingNamespaceNode()) {
            VolatileCData volatileCData = ((DOMCachedNamespace)object2).itemName();
            string3 = volatileCData.getSize() == 0 ? "" : volatileCData.getQNameLocalPart(1);
            string2 = ((AbstractCursor)object2).itemStringValue().getString(1);
            arrayList.add(string3);
            arrayList.add(string2);
            if (!bl) continue;
            ((CopiedCacheMediator)this.getMediatorData().getWrappedMediator()).copyToOriginalNode((DOMCachedNode)object2);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            if (list != null) {
                object2 = new StringBuilder(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    ((StringBuilder)object2).append(list.get(i));
                    ((StringBuilder)object2).append(" , ");
                }
                logger.logp(Level.FINEST, logger.getName(), "loadNSList", "Original list of namespaces: " + ((StringBuilder)object2).toString());
            }
            if (arrayList != null) {
                object2 = new StringBuilder(arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    ((StringBuilder)object2).append((String)arrayList.get(i));
                    ((StringBuilder)object2).append(" , ");
                }
                logger.logp(Level.FINEST, logger.getName(), "loadNSList", "Our built namespace list: " + ((StringBuilder)object2).toString());
            }
            if (list2 != null) {
                object2 = new StringBuilder(list2.size());
                for (int i = 0; i < list2.size(); ++i) {
                    ((StringBuilder)object2).append(list2.get(i));
                    ((StringBuilder)object2).append(" , ");
                }
                logger.logp(Level.FINEST, logger.getName(), "loadNSList", "New parent's list: " + ((StringBuilder)object2).toString());
            }
        }
        int n2 = list.size();
        boolean bl3 = false;
        for (int i = 0; i < n2; i += 2) {
            string3 = list.get(i);
            if (this.nsInScope(string3, string2 = list.get(i + 1), arrayList, true) || this.nsInScope(string3, string2, list2, false)) continue;
            QNameCDataLocalOnly qNameCDataLocalOnly = new QNameCDataLocalOnly(string3);
            StringCData stringCData = new StringCData(string2, TypeRegistry.XSSTRING);
            if (!bl3) {
                this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.NAMESPACE_DECLS.immediateArea());
                this.setDirty();
                bl3 = true;
            }
            DOMCachedNamespace dOMCachedNamespace = this.getCache().makeCachedNamespaceNode(qNameCDataLocalOnly, stringCData, this);
            dOMCachedNamespace.setState(LazyLoadingHelper.markAllResolved());
        }
        this.setState(LazyLoadingHelper.markNamespacesResolved(this.state));
        this.originalNSList = null;
        this.nsContext = null;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "loadNSList", "Finished copying nsDecls into ourselves : " + this.toStringLazy() + "\n Namespaces:" + this.getNamespaces());
        }
    }

    private boolean nsInScope(String string2, String string3, List<String> list, boolean bl) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); i += 2) {
            if (!string2.equals(list.get(i))) continue;
            if (string3.equals(list.get(i + 1))) {
                return true;
            }
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "nsInScopeParent", "While copying the namespace decl {" + string2 + "," + string3 + "} we found that " + "the new scope already has a namespace decl {" + list.get(i) + "," + list.get(i + 1) + "} which " + "will conflict with this insertion.");
            }
            return bl;
        }
        return false;
    }

    public boolean hasPendingNSDecls() {
        return this.originalNSList != null;
    }

    protected void setItemIsID(boolean bl) {
        if (bl) {
            this.setState(BitMaskHelper.stateSet(this.state, 0x1000000));
        } else {
            this.setState(BitMaskHelper.stateUnset(this.state, 0x1000000));
        }
    }

    public final DOMCachedText getTextNodeChild() {
        DOMCachedNode dOMCachedNode;
        for (dOMCachedNode = this.getCachedFirstChild(); dOMCachedNode != null && dOMCachedNode.itemKind() != 3; dOMCachedNode = dOMCachedNode.getCachedFollowingSibling()) {
        }
        return (DOMCachedText)dOMCachedNode;
    }

    @Override
    public void setItemBaseURI(String string2) {
        this.setField(string2, (byte)2);
    }

    @Override
    public String itemBaseURI() {
        String string2 = (String)this.getField((byte)2);
        if (string2 == null) {
            string2 = BaseURIHelper.computeBaseURI(this);
            if (string2 != null) {
                this.setField(string2, (byte)2);
                return string2;
            }
            string2 = this.parent == null ? null : this.parent.itemBaseURI();
        }
        this.setField(string2, (byte)2);
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ElementNSContext {
        private List<String> nsList = new ArrayList<String>();
        private int listVersion;

        public ElementNSContext() {
            this.updateNSList();
        }

        public boolean isUpToDate() {
            return this.listVersion == DOMCachedElement.this.cache.getNamespaceVersion();
        }

        public List<String> getNSList() {
            if (!this.isUpToDate()) {
                this.nsList = new ArrayList<String>();
                this.updateNSList();
            }
            return this.nsList;
        }

        private void updateNSList() {
            DOMCachedNode dOMCachedNode;
            this.listVersion = DOMCachedElement.this.cache.getNamespaceVersion();
            String string2 = null;
            String string3 = null;
            if (DOMCachedElement.this.hasPendingNSDecls()) {
                DOMCachedElement.this.loadNSList(null);
            }
            for (dOMCachedNode = DOMCachedElement.this.getCachedFirstNamespaceNode(); dOMCachedNode != null; dOMCachedNode = ((DOMCachedNamespace)dOMCachedNode).getCachedFollowingNamespaceNode()) {
                VolatileCData volatileCData = ((DOMCachedNamespace)dOMCachedNode).itemName();
                string2 = volatileCData.getSize() == 0 ? "" : volatileCData.getQNameLocalPart(1);
                string3 = dOMCachedNode.itemStringValue().toString();
                this.nsList.add(string2);
                this.nsList.add(string3);
            }
            dOMCachedNode = DOMCachedElement.this.getBuiltParent();
            if (dOMCachedNode != null && dOMCachedNode.itemKind() == 1) {
                int n2 = this.nsList.size();
                ArrayList arrayList = (ArrayList)((DOMCachedElement)dOMCachedNode).getInScopeNamespacesList();
                int n3 = arrayList.size();
                boolean bl = false;
                int n4 = 0;
                while (n4 + 1 < n3) {
                    string2 = (String)arrayList.get(n4);
                    string3 = (String)arrayList.get(n4 + 1);
                    for (int i = 0; i < n2; i += 2) {
                        if (!this.nsList.get(i).equals(string2)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.nsList.add(string2);
                        this.nsList.add(string3);
                    }
                    bl = false;
                    n4 += 2;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AttrList
    implements NamedNodeMap {
        private List<DOMCachedSimple> attrList;
        private int length;

        public AttrList(List<DOMCachedSimple> list) {
            this.attrList = list;
            this.length = list.size();
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public Node getNamedItem(String string2) {
            return this.getNamedItemNS("", string2);
        }

        @Override
        public Node getNamedItemNS(String string2, String string3) throws DOMException {
            for (int i = 0; i < this.length; ++i) {
                DOMCachedSimple dOMCachedSimple = this.attrList.get(i);
                if (string2 != dOMCachedSimple.getNamespaceURI() && (string2 == null || !string2.equals(dOMCachedSimple.getNamespaceURI())) || !string3.equals(dOMCachedSimple.getLocalName())) continue;
                return dOMCachedSimple;
            }
            return null;
        }

        @Override
        public Node item(int n2) {
            if (n2 > this.length - 1 || n2 < 0) {
                return null;
            }
            return this.attrList.get(n2);
        }

        @Override
        public Node removeNamedItem(String string2) throws DOMException {
            return this.removeNamedItemNS("", string2);
        }

        @Override
        public Node removeNamedItemNS(String string2, String string3) throws DOMException {
            int n2 = this.findNode(string2, string3);
            Node node2 = null;
            if (n2 != -1) {
                node2 = this.attrList.get(n2);
                this.attrList.remove(n2);
            }
            return node2;
        }

        private int findNode(String string2, String string3) {
            for (int i = 0; i < this.length; ++i) {
                DOMCachedSimple dOMCachedSimple = this.attrList.get(i);
                if (string2 != dOMCachedSimple.getNamespaceURI() && (string2 == null || !string2.equals(dOMCachedSimple.getNamespaceURI())) || !string3.equals(dOMCachedSimple.getLocalName())) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Node setNamedItem(Node node2) throws DOMException {
            return this.setNamedItem(node2, false);
        }

        @Override
        public Node setNamedItemNS(Node node2) throws DOMException {
            return this.setNamedItem(node2, true);
        }

        private Node setNamedItem(Node node2, boolean bl) {
            String string2;
            if (!(node2 instanceof DOMCachedSimple)) {
                return null;
            }
            String string3 = bl ? node2.getNamespaceURI() : "";
            int n2 = this.findNode(string3, string2 = node2.getLocalName());
            if (n2 == -1) {
                this.attrList.add((DOMCachedSimple)node2);
                return null;
            }
            Node node3 = this.attrList.get(n2);
            this.attrList.set(n2, (DOMCachedSimple)node2);
            return node3;
        }
    }
}

