/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NameTest;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedSimple;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.util.SimpleNameTest;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMCachedNamespace
extends DOMCachedSimple
implements Attr {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = LoggerUtil.getLogger(DOMCachedNamespace.class);
    protected CData name;

    public DOMCachedNamespace(CacheManager cacheManager, VolatileCData volatileCData, VolatileCData volatileCData2, DOMCachedElement dOMCachedElement) {
        super(cacheManager, volatileCData2, dOMCachedElement, null);
        this.name = volatileCData.constant(true);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "DOMCachedNamespace", "creating a new DOMCachedNamespace: " + this.toStringLazy() + "\nCache manager = " + this.getCache() + " | Mediator (default) = " + this.getCache().mediator() + " | Mediator (for node) = " + this.getMediatorData());
        }
    }

    public DOMCachedNamespace getCachedFollowingNamespaceNode() {
        if (this.following == null && !LazyLoadingHelper.isFollowingBuilt(this.state)) {
            if (!this.cache.mediator(this).buildNext(this)) {
                this.parent.setState(LazyLoadingHelper.markNamespacesResolved(this.parent.state));
            }
            this.setState(LazyLoadingHelper.markFollowingResolved(this.state));
        }
        return (DOMCachedNamespace)this.following;
    }

    public DOMCachedNamespace getCachedPrecedingNamespaceNode() {
        return this.getBuiltPrecedingNamespaceNode();
    }

    public DOMCachedNamespace getCachedPrecedingNamespaceNode(NodeTest nodeTest) {
        return this.getBuiltPrecedingNamespaceNode(nodeTest);
    }

    public DOMCachedNamespace getBuiltFollowingNamespaceNode() {
        return (DOMCachedNamespace)this.following;
    }

    public DOMCachedNamespace getBuiltPrecedingNamespaceNode() {
        return (DOMCachedNamespace)this.preceding;
    }

    public DOMCachedNamespace getBuiltPrecedingNamespaceNode(NodeTest nodeTest) {
        return (DOMCachedNamespace)this.getBuiltPrecedingSibling(nodeTest);
    }

    @Override
    protected void setDirty(DOMCachedNode dOMCachedNode) {
        MiscHelpers.setDirty(dOMCachedNode, true);
    }

    @Override
    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        throw XCIErrorHelper.createBadContextItemException("addText", (short)4);
    }

    @Override
    public boolean satisfies(NodeTest nodeTest) {
        return nodeTest == null || nodeTest.allowsAttribute(this.itemName());
    }

    @Override
    public short itemKind() {
        return 4;
    }

    @Override
    public VolatileCData itemName() {
        return this.name;
    }

    @Override
    public void setItemName(VolatileCData volatileCData) {
        this.checkSetItemName(volatileCData);
        this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.SELF);
        this.name = volatileCData.constant(true);
        this.setDirty(this);
    }

    public VolatileCData serialize(Map map2) {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"serialize", DOMCachedNamespace.class.getName()}));
    }

    @Override
    public boolean copyToResult(Result result2, Map<String, Object> map2, boolean bl, boolean bl2) {
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNIMPLEMENTED_METHOD", new String[]{"copyToResult", DOMCachedNamespace.class.getName()}));
    }

    @Override
    public boolean test(Cursor cursor2) {
        return cursor2.itemKind() == 2 && this.name.equals(cursor2.itemName());
    }

    @Override
    public boolean allowsNamespace(VolatileCData volatileCData) {
        return this.name.equals(volatileCData);
    }

    @Override
    public NameTest theNameTest() {
        return SimpleNameTest.name(this.itemName());
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2000/xmlns/";
    }

    @Override
    public String getPrefix() {
        return "xmlns";
    }

    @Override
    public void setPrefix(String string2) throws DOMException {
    }

    @Override
    public String getLocalName() {
        return this.name.getQNameLocalPart(1);
    }

    @Override
    public String getName() {
        String string2 = this.name.getQNamePrefix(1);
        return (string2 == null || string2.length() == 0 ? "" : string2 + ":") + this.name.getQNameLocalPart(1);
    }

    @Override
    public boolean getSpecified() {
        return true;
    }

    @Override
    public String getValue() {
        return this.data == null ? "" : this.data.toString();
    }

    @Override
    public void setValue(String string2) throws DOMException {
        this.setItemValue(this.factory.data((CharSequence)string2, TypeRegistry.XSSTRING, false));
    }

    @Override
    public Element getOwnerElement() {
        if (this.parent == null) {
            return null;
        }
        assert (this.parent.itemKind() == 1) : "Attribute has  no parent?";
        return (Element)((Object)this.parent);
    }

    @Override
    public boolean isId() {
        return this.itemIsID();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    protected void printXQuery(Writer writer, String string2, boolean bl) throws IOException {
        if (this.data != null) {
            writer.write(string2 + " namespace " + this.printName() + this.printState() + " { " + CharsBase.toEncodedString(this.data) + " }");
        } else {
            writer.write(string2 + " namespace " + this.printState() + this.printName() + " { nulldata }");
        }
    }

    @Override
    public String itemBaseURI() {
        return null;
    }

    @Override
    public final boolean itemIsSameNode(Cursor cursor2) {
        if (cursor2.itemKind() == 4 && cursor2.unwrap() instanceof DOMCachedNode) {
            return this.getBuiltParent() == ((DOMCachedNode)cursor2.unwrap()).getBuiltParent() && this.itemName().toString().equals(cursor2.itemName().toString());
        }
        return false;
    }
}

